<?php

class topic {

	public $id;
	public $pid;
	public $title;
	public $content;
	public $uid;
	public $posts;
	public $favs;
	public $views;
	public $created;
	public $lastupdated;
	public $flag;

	public $db;

	public $node;
	public $owner;
	public $user_topics;
	public $avatar;
	public $online;
	public $urlname;
	public $edit_enabled;
	public $delete_enabled;

	public function __construct($topic_id, $db) {
		$this->db = $db;

		$this->id = 0;
		$this->pid = 0;
		$this->title = '';
		$this->content = '';
		$this->uid = 0;
		$this->posts = 0;
		$this->favs = 0;
		$this->views = 0;
		$this->created = 0;
		$this->lastupdated = 0;
		$this->flag = 0;

		$this->node = 0;
		$this->owner = '';
		$this->user_topics = 0;
		$this->avatar = '';
		$this->online = 0;
		$this->urlname = '';
		$this->edit_enabled = false;
		$this->delete_enabled = false;

		if ($topic_id != 0) {
			$sql = "SELECT t.id, t.pid, t.title, t.content, t.uid, t.posts, t.favs, t.views, t.created, t.lastupdated, t.flag, n.name AS node, u.name AS owner, u.gender, u.useavatar, u.topics AS user_topics, o.id AS online FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id LEFT JOIN {$this->db->prefix}online AS o ON t.uid = o.id WHERE t.id = {$topic_id}";
			$rs = $this->db->query($sql);
			if ($O = $this->db->fetch($rs, 'OBJECT')) {
				$this->id = $O->id;
				$this->pid = $O->pid;
				$this->title = $O->title;
				$this->content = $O->content;
				$this->uid = $O->uid;
				$this->posts = $O->posts;
				$this->favs = $O->favs;
				$this->views = $O->views;
				$this->created = _desctime($O->created);
				$this->lastupdated = _time($O->lastupdated);
				$this->flag = $O->flag;

				$this->node = $O->node;
				$this->owner = $O->owner;
				$this->user_topics = $O->user_topics;
				$this->avatar = user::get_avatar($O->uid, $O->useavatar, $O->gender, 'b');
				$this->online = $O->online;
				$this->urlname = urlencode($O->owner);
				$descriptions = explode("\n", $O->content);
				$this->description = $descriptions[0];
				$time1 = time() - GF_EDIT;
				if ($O->created < $time1) {
					$this->edit_enabled = false;
				} else {
					$this->edit_enabled = true;
				}
				$time2 = time() - GF_DELETE;
				if ($O->created < $time2) {
					$this->delete_enabled = false;
				} else {
					$this->delete_enabled = true;
				}
			}
			$this->db->free($rs);
		}
	}

	public function list_single() {
		$time = time() - GF_SINGLE;
		$hot = GF_HOT;
		$sql = "SELECT t.id, t.pid, t.title, t.uid, t.posts, n.name AS node, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.posts >= {$hot} AND t.lastupdated > {$time} ORDER BY rand() LIMIT 1";
		$rs = $this->db->query($sql);
		$O = array();
		if ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['color'] = _multicolor($O['posts'], GF_COLOR);
		}
		$this->db->free($rs);
		return $O;
	}

	public function list_single_simple() {
		$time = time() - GF_SINGLE;
		$hot = GF_HOT;
		$sql = "SELECT id, title, posts FROM {$this->db->prefix}topic WHERE posts >= {$hot} AND lastupdated > {$time} ORDER BY rand() LIMIT 1";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_new($limit) {
		$sql = "SELECT t.id, t.pid, t.title, t.uid, t.posts, t.created, t.lastupdated, n.name AS node, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_NEW;
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['color'] = _multicolor($O['posts'], GF_COLOR);
			$O['size'] = _multisize($O['posts']);
			if ($O['created'] > $time) {
				$O['isnew'] = true;
			} else {
				$O['isnew'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_new_m($start, $limit) {
		$sql = "SELECT id, title, posts, views FROM {$this->db->prefix}topic ORDER BY lastupdated DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_user_m($uid, $limit) {
		$sql = "SELECT id, title, posts, views FROM {$this->db->prefix}topic WHERE uid = {$uid} ORDER BY lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_fresh($start, $limit) {
		$sql = "SELECT t.id, t.title, t.uid, t.views, t.created, t.lastupdated, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.posts = 0 ORDER BY t.lastupdated DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_NEW;
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			if ($O['created'] > $time) {
				$O['isnew'] = true;
			} else {
				$O['isnew'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function count_fresh() {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}topic WHERE posts = 0";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_new_all($start, $limit) {
		$sql = "SELECT t.id, t.title, t.uid, t.views, t.lastupdated, t.flag, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.posts = 0 ORDER BY t.lastupdated DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_hot($limit) {
		$hot = GF_HOT;
		$sql = "SELECT t.id, t.pid, t.title, t.uid, t.posts, n.name AS node, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.posts >= {$hot} ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			//$O['color'] = _multicolor($O['posts'], GF_COLOR);
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_top_reply($limit) {
		$sql = "SELECT id, title, posts, views FROM {$this->db->prefix}topic WHERE posts > 0 ORDER BY posts DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _multicolor($O['posts'], GF_COLOR);
			$O['size'] = _multisize($O['posts']);
			$O['isfav'] = false;
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_top_views($limit) {
		$sql = "SELECT id, title, posts, views FROM {$this->db->prefix}topic ORDER BY views DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _multicolor($O['posts'], GF_COLOR);
			$O['size'] = _multisize($O['posts']);
			$O['isfav'] = false;
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function ____________________________list_bunny($limit) {
		$sql = "SELECT t.id, t.pid, t.title, t.uid, t.posts, t.created, t.lastupdated, n.name AS node, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.posts = 0 ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_NEW;
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['color'] = _multicolor($O['posts'], GF_COLOR);
			$O['size'] = _multisize($O['posts']);
			if ($O['created'] > $time) {
				$O['isnew'] = true;
			} else {
				$O['isnew'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_channel_rand($channel_id, $limit) {
		$sql = "SELECT t.id, t.title AS name, t.posts, t.created FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id WHERE n.pid = {$channel_id} ORDER BY rand() LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_NEW;
		while ($O = $this->db->fetch($rs)) {
			$O['type'] = 'topic';
			$O['color'] = _multicolor($O['posts'], GF_COLOR);
			$O['size'] = _multisize($O['posts']);
			if ($O['created'] > $time) {
				$O['isnew'] = true;
			} else {
				$O['isnew'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_node($node_id, $start, $limit) {
		$sql = "SELECT t.id, t.title, t.uid, t.posts, t.views, t.created, t.lastupdated, t.flag, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.pid = {$node_id} ORDER BY t.lastupdated DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - GF_NEW;
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			//$O['paginate'] = _paginate(ceil($O['posts'] / GF_TOPICS_PAGE), 0, GF_URL . 'topic/view/' . $O['id'] . '-');
			if ($O['created'] > $time) {
				$O['isnew'] = true;
			} else {
				$O['isnew'] = false;
			}
			if ($O['posts'] >= GF_HOT) {
				$O['ishot'] = true;
			} else {
				$O['ishot'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_remix($limit) {
		$sql = "SELECT t.id, t.title, t.content, t.uid, t.posts, t.views, t.created, t.lastupdated, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['url'] = GF_URL . 'topic/view/' . $O['id'] . '.html';
			$O['urltitle'] = urlencode(htmlspecialchars_decode($O['title']));
			$O['content'] = _parsecontent($O['content']);
			$O['urlname'] = urlencode($O['owner']);
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_node_remix($node_id, $limit) {
		$sql = "SELECT t.id, t.title, t.content, t.uid, t.posts, t.views, t.created, t.lastupdated, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.pid = {$node_id} ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['url'] = GF_URL . 'topic/view/' . $O['id'] . '.html';
			$O['urltitle'] = urlencode(htmlspecialchars_decode($O['title']));
			$O['content'] = _parsecontent($O['content']);
			$O['urlname'] = urlencode($O['owner']);
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function feed_rss($node_id, $limit) {
		if ($node_id != 0) {
			$sql = "SELECT t.id, t.title, t.content, t.uid, t.posts, t.lastupdated, u.name AS owner, u.email FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.pid = {$node_id} ORDER BY t.lastupdated DESC LIMIT {$limit}";
		} else {
			$sql = "SELECT t.id, t.title, t.content, t.uid, t.posts, t.lastupdated, u.name AS owner, u.email FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id ORDER BY t.lastupdated DESC LIMIT {$limit}";
		}
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _cleanhtml(_parsecontent($O['content']));
			//$O['content'] = _substr($O['content'], 0, 100);
			$O['lastupdated'] = date('r', $O['lastupdated']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function feed_atom($node_id, $limit) {
		if ($node_id != 0) {
			$sql = "SELECT t.id, t.title, t.content, t.uid, t.posts, t.lastupdated, u.name AS owner, u.email FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE t.pid = {$node_id} ORDER BY t.lastupdated DESC LIMIT {$limit}";
		} else {
			$sql = "SELECT t.id, t.title, t.content, t.uid, t.posts, t.lastupdated, u.name AS owner, u.email FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id ORDER BY t.lastupdated DESC LIMIT {$limit}";
		}
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _cleanhtml(_parsecontent($O['content']));
			//$O['content'] = _substr($O['content'], 0, 100);
			$O['lastupdated'] = gmdate('Y-m-d\TH:i:s\Z', $O['lastupdated']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function feed_rss_by_user($name, $limit) {
		$sql = "SELECT t.id, t.title, t.content, t.posts, t.lastupdated, u.name AS owner, u.email FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE u.name = '{$this->db->escape($name)}' ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['content'] = _cleanhtml(_parsecontent($O['content']));
			$O['urlname'] = urlencode($O['owner']);
			//$O['content'] = _substr($O['content'], 0, 100);
			$O['lastupdated'] = gmdate('Y-m-d\TH:i:s\Z', $O['lastupdated']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_next_single($topic_id, $user_id) {
		$sql = "SELECT id, title FROM {$this->db->prefix}topic WHERE uid = {$user_id} AND id > {$topic_id} ORDER BY id ASC LIMIT 1";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_pre_single($topic_id, $user_id) {
		$sql = "SELECT id, title FROM {$this->db->prefix}topic WHERE uid = {$user_id} AND id < {$topic_id} ORDER BY id DESC LIMIT 1";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs);
		$this->db->free($rs);
		return $O;
	}

	public function act_create($pid, $title, $content, $uid) {
		$time = time();
		$sql = "INSERT INTO {$this->db->prefix}topic(id, pid, title, content, uid, posts, favs, views, created, lastupdated, flag) VALUES(NULL, {$pid}, '{$this->db->escape($title)}', '{$this->db->escape($content)}', {$uid}, 0, 0, 0, {$time}, {$time}, 0)";
		$this->db->query($sql);
		$topic_id = $this->db->insert_id();
		$sql = "UPDATE {$this->db->prefix}node SET topics = topics + 1, lastupdated = {$time} WHERE id = {$pid}";
		$this->db->query($sql);
		$sql = "UPDATE {$this->db->prefix}user SET topics = topics + 1 WHERE id = {$uid}";
		$this->db->query($sql);
		return $topic_id;
	}

	public function act_golast($id) {
		$sql = "SELECT posts FROM {$this->db->prefix}topic WHERE id = {$id}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		return ceil($O->posts / GF_POSTS_PAGE);
	}
	
	public function act_edit($id, $title, $content) {
		$sql = "UPDATE {$this->db->prefix}topic SET title = '{$this->db->escape($title)}', content = '{$this->db->escape($content)}' WHERE id = {$id}";
		$this->db->query($sql);
	}

	public function act_delete($id, $pid, $uid, $posts) {
		$sql = "SELECT topics, created FROM {$this->db->prefix}node WHERE id = {$pid}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		$sql = "SELECT id, created FROM {$this->db->prefix}topic WHERE pid = {$pid} ORDER BY created DESC LIMIT 1";
		$rs = $this->db->query($sql);
		$OO = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		if ($OO->id == $id) {
			if ($O->topics == 1) {
				$sql = "UPDATE {$this->db->prefix}node SET lastupdated = {$O->created} WHERE id = {$pid}";
				$this->db->query($sql);
			} else {
				$sql = "SELECT created FROM {$this->db->prefix}topic WHERE pid = {$pid} AND created < {$OO->created} ORDER BY created DESC LIMIT 1";
				$rs = $this->db->query($sql);
				$OOO = $this->db->fetch_one($rs);
				$this->db->free($rs);
				$sql = "UPDATE {$this->db->prefix}node SET lastupdated = {$OOO} WHERE id = {$pid}";
				$this->db->query($sql);
			}
		}
		$sql = "UPDATE {$this->db->prefix}node SET topics = topics - 1, posts = posts - {$posts} WHERE id = {$pid}";
		$this->db->query($sql);
		$sql = "UPDATE {$this->db->prefix}user SET topics = topics - 1 WHERE id = {$uid}";
		$this->db->query($sql);
		$sql = "DELETE FROM {$this->db->prefix}topic WHERE id = {$id}";
		$this->db->query($sql);
		$sql = "SELECT uid FROM {$this->db->prefix}post WHERE pid = {$id}";
		$rs = $this->db->query($sql);
		while ($OOOO = $this->db->fetch($rs, 'OBJECT')) {
			$sql = "UPDATE {$this->db->prefix}user SET posts = posts - 1 WHERE id = {$OOOO->uid}";
			$this->db->query($sql);
		}
		$this->db->free($rs);
		$sql = "DELETE FROM {$this->db->prefix}post WHERE pid = {$id}";
		$this->db->query($sql);
		$sql = "DELETE FROM {$this->db->prefix}favorite WHERE fid = {$id} AND ftype = 0";
		$this->db->query($sql);
	}

	public function act_move($id, $pid) {
		$sql = "SELECT pid, posts FROM {$this->db->prefix}topic WHERE id = {$id}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch($rs, 'OBJECT');
		$this->db->free($rs);
		if ($O->pid != $pid) {
			$sql = "UPDATE {$this->db->prefix}node SET topics = topics - 1, posts = posts - {$O->posts} WHERE id = {$O->pid}";
			$this->db->query($sql);
			$sql = "UPDATE {$this->db->prefix}node SET topics = topics + 1, posts = posts + {$O->posts} WHERE id = {$pid}";
			$this->db->query($sql);
			$sql = "UPDATE {$this->db->prefix}topic SET pid = {$pid} WHERE id = {$id}";
			$this->db->query($sql);
			$sql = "SELECT created FROM {$this->db->prefix}topic WHERE pid = {$O->pid} ORDER BY created DESC LIMIT 1";
			$rs = $this->db->query($sql);
			if ($this->db->num_rows($rs)) {
				$OO = $this->db->fetch_one($rs);
				$this->db->free($rs);
				$sql = "UPDATE {$this->db->prefix}node SET lastupdated = {$OO} WHERE id = {$O->pid}";
				$this->db->query($sql);
			} else {
				$sql = "SELECT created FROM {$this->db->prefix}node WHERE id = {$O->pid}";
				$rs = $this->db->query($sql);
				$OOO = $this->db->fetch_one($rs);
				$this->db->free($rs);
				$sql = "UPDATE {$this->db->prefix}node SET lastupdated = {$OOO} WHERE id = {$O->pid}";
				$this->db->query($sql);
			}
			$sql = "SELECT created FROM {$this->db->prefix}topic WHERE pid = {$pid} ORDER BY created DESC LIMIT 1";
			$rs = $this->db->query($sql);
			$OOOO = $this->db->fetch_one($rs);
			$this->db->free($rs);
			$sql = "UPDATE {$this->db->prefix}node SET lastupdated = {$OOOO} WHERE id = {$pid}";
			$this->db->query($sql);
		}
	}

	public function act_flag($id, $type) {
		if ($type == 'add') {
			$sql = "UPDATE {$this->db->prefix}topic SET flag = 1 WHERE id = {$id}";
		} else {
			$sql = "UPDATE {$this->db->prefix}topic SET flag = 0 WHERE id = {$id}";
		}
		$this->db->query($sql);
	}

	public function list_by_user($user_id, $limit) {
		$sql = "SELECT t.id, t.pid, t.title, t.posts, t.created, n.name AS node FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id WHERE t.uid = {$user_id} ORDER BY t.created DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['created'] = _desctime($O['created']);
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_by_channel($channel_id, $limit) {
		$sql = "SELECT t.id, t.pid, t.title, t.uid, t.posts, t.created, n.name AS node, n.topics, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}node AS n ON t.pid = n.id INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE n.pid = {$channel_id} ORDER BY t.lastupdated DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['created'] = date('M-j, H:i:s T', $O['created']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$O['urlname'] = urlencode($O['owner']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_flag() {
		$sql = "SELECT id, title FROM {$this->db->prefix}topic WHERE flag = 1 ORDER BY created DESC";
		$rs = $this->db->query($sql);
		$st = array();
		//$f = array('green', 'blue', 'orange', 'purple', 'pink');
		while ($O = $this->db->fetch($rs)) {
			$O['color'] = _randcolor();
			//$O['flag'] = $f[mt_rand(0, 4)];
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function act_addviews($id) {
		$sql = "UPDATE {$this->db->prefix}topic SET views = views + 1 WHERE id = {$id}";
		$this->db->query($sql);
	}

	public function list_by_user_all($name, $start, $limit) {
		$sql = "SELECT t.id, t.title, t.uid, t.posts, t.views, t.lastupdated, u.name AS owner, u.gender, u.useavatar FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id WHERE u.name = '{$this->db->escape($name)}' ORDER BY t.lastupdated DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['lastupdated'] = _desctime($O['lastupdated']);
			$O['avatar'] = user::get_avatar($O['uid'], $O['useavatar'], $O['gender'], 's');
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_search_result($keywords) {
		$keywords_array = explode(' ', $keywords);
		if (count($keywords_array) > 2) {
			array_splice($keywords_array, 2);
		}
		$q = '';
		while (list(, $cur_word) = @each($keywords_array)) {
			$cur_word = '%' . $cur_word . '%';
			$q .= "t.title LIKE '{$this->db->escape($cur_word)}' OR t.content LIKE '{$this->db->escape($cur_word)}' OR p.content LIKE '{$this->db->escape($cur_word)}' OR ";
		}
		$q = substr($q, 0, -3);
		$sql = "SELECT t.id, t.title, t.content, t.uid, u.name AS owner FROM {$this->db->prefix}topic AS t INNER JOIN {$this->db->prefix}user AS u ON t.uid = u.id LEFT JOIN {$this->db->prefix}post AS p ON t.id = p.pid WHERE " . $q . "GROUP BY t.id ORDER BY t.lastupdated DESC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['owner']);
			$O['content'] = _substr($O['content'], 0, 200);
			$ct = count($keywords_array);
			for ($i = 0; $i < $ct; $i++) {
				$O['title'] = str_ireplace($keywords_array[$i], '<span class="off">'.$keywords_array[$i].'</span>', $O['title']);
				$O['content'] = str_ireplace($keywords_array[$i], '<span class="off">'.$keywords_array[$i].'</span>', $O['content']);
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_title_by_id($topic_id) {
		$sql = "SELECT title FROM {$this->db->prefix}topic WHERE id = {$topic_id}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_sitemap() {
		$sql = "SELECT id, posts FROM {$this->db->prefix}topic ORDER BY id ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['p'] = ceil($O['posts'] / GF_POSTS_PAGE);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

}
