<?php

class user {

	public $id;
	public $name;
	public $password;
	public $gender;
	public $intro;
	public $useavatar;
	public $money;
	public $topics;
	public $posts;
	public $created;
	public $createdip;
	public $lastvisit;
	public $hits;
	public $logins;
	public $email;
	public $icq;
	public $msn;
	public $yahoo;
	public $skype;

	public $cookie;
	public $db;

	public $islogin;
	public $isadmin;
	public $avatar;
	public $online;
	public $gender_info;
	public $urlname;

	public function __construct($cookie, $db) {
		$this->cookie = $cookie;
		$this->db = $db;

		$this->id = 0;
		$this->name = '';
		$this->password = '';
		$this->gender = 0;
		$this->intro = '';
		$this->useavatar = 0;
		$this->money = 0;
		$this->topics = 0;
		$this->posts = 0;
		$this->created = 0;
		$this->createdip = '';
		$this->lastvisit = 0;
		$this->hits = 0;
		$this->logins = 0;
		$this->email = '';
		$this->icq = 0;
		$this->msn = '';
		$this->yahoo = '';
		$this->skype = '';

		$this->islogin = false;
		$this->isadmin = false;
		$this->avatar = '';
		$this->online = false;
		$this->gender_info = '';
		$this->urlname = '';

		if ($this->cookie != '') {
			if ($this->cookie->get_value()) {
				list($id, $hash) = @unserialize($this->cookie->get_value());
				$id = intval($id);
				if ($id > 0) {
					$sql = "SELECT u.id, u.name, u.password, u.gender, u.intro, u.useavatar, u.money, u.topics, u.posts, u.created, u.createdip, u.lastvisit, u.hits, u.logins, u.email, u.icq, u.msn, u.yahoo, u.skype, o.id AS online FROM {$this->db->prefix}user AS u LEFT JOIN {$this->db->prefix}online AS o ON u.id = o.id WHERE u.id = {$id}";
					$rs = $this->db->query($sql);
					if ($this->db->num_rows($rs) == 1) {
						$O = $this->db->fetch($rs, 'OBJECT');
						if ($hash == md5($this->cookie->seed . $O->password)) {
							$this->id = $O->id;
							$this->name = $O->name;
							$this->password = $O->password;
							$this->gender = $O->gender;
							$this->intro = $O->intro;
							$this->useavatar = $O->useavatar;
							$this->money = $O->money;
							$this->topics = $O->topics;
							$this->posts = $O->posts;
							$this->created = $O->created;
							//$this->created = _time($O->created);
							$this->createdip = $O->createdip;
							$this->lastvisit = _desctime($O->lastvisit);
							$this->hits = $O->hits;
							$this->logins = $O->logins;
							$this->email = $O->email;
							$this->icq = $O->icq;
							$this->msn = $O->msn;
							$this->yahoo = $O->yahoo;
							$this->skype = $O->skype;

							$this->islogin = true;
							$admins = explode(',', GF_ADMINS);
							if (in_array($O->id, $admins)) {
								$this->isadmin = true;
							} else {
								$this->isadmin = false;
							}
							$this->avatar = self::get_avatar($O->id, $O->useavatar, $O->gender);
							$this->online = $O->online;
							$this->gender_info = self::gender_info($O->gender);
							$this->urlname = urlencode($O->name);
						}
						$this->db->free($rs);
					}
				}
			}
		}
	}

	public function __destruct() {
	}

	public static function get_avatar($user_id, $useavatar, $gender, $return_type = '') {
		$avatar = array();
		if ($useavatar) {
			if (is_file(GF_ROOT . 'upload/avatar/' . $user_id . '.jpg')) {
				$avatar[0] = 'upload/avatar/' . $user_id . '.jpg';
				$avatar[1] = 'upload/avatar/m/' . $user_id . '_m.jpg';
				$avatar[2] = 'upload/avatar/s/' . $user_id . '_s.jpg';
			} elseif (is_file(GF_ROOT . 'upload/avatar/' . $user_id . '.gif')) {
				$avatar[0] = 'upload/avatar/' . $user_id . '.gif';
				$avatar[1] = 'upload/avatar/m/' . $user_id . '_m.gif';
				$avatar[2] = 'upload/avatar/s/' . $user_id . '_s.gif';
			} elseif (is_file(GF_ROOT . 'upload/avatar/' . $user_id . '.png')) {
				$avatar[0] = 'upload/avatar/' . $user_id . '.png';
				$avatar[1] = 'upload/avatar/m/' . $user_id . '_m.png';
				$avatar[2] = 'upload/avatar/s/' . $user_id . '_s.png';
			} else {
				$avatar[0] = 'image/avatar/' . $gender . '.gif';
				$avatar[1] = 'image/avatar/' . $gender . '_m.gif';
				$avatar[2] = 'image/avatar/' . $gender . '_s.gif';
			}
		} else {
			$avatar[0] = 'image/avatar/' . $gender . '.gif';
			$avatar[1] = 'image/avatar/' . $gender . '_m.gif';
			$avatar[2] = 'image/avatar/' . $gender . '_s.gif';
		}
		if ($return_type == 's') {
			return $avatar[2];
		} elseif ($return_type == 'm') {
			return $avatar[1];
		} elseif ($return_type == 'b') {
			return $avatar[0];
		} else {
			return $avatar;
		}
	}

	public function money_info($money) {
		if ($money >= 10000) {
			$gold = intval($money / (10000));
			$sur = $money % ($gold * 10000);
			if ($sur == 0) {
				return $gold . ' 金币';
			} else {
				if ($sur >= 100) {
					$silver = intval($sur / 100);
					$copper = $sur % ($silver * 100);
					if ($copper == 0) {
						return $gold . ' 金币 ' . $silver . ' 银币';
					} else {
						return $gold . ' 金币 ' . $silver . ' 银币 ' . $copper . ' 铜币';
					}
				} else {
					return $gold . ' 金币 ' . $sur . ' 铜币';
				}
			}
		} else {
			if ($money >= 100) {
				$silver = intval($money / 100);
				$copper = $money % ($silver * 100);
				if ($copper == 0) {
					return $silver . ' 银币';
				} else {
					return $silver . ' 银币 ' . $copper . ' 铜币';
				}
			} else {
				return $money . ' 铜币';
			}
		}
	}

	public function money_info_w($money) {
		if ($money > 10000) {
			$gold = intval($money / (10000));
			$sur = $money % ($gold * 10000);
			if ($sur == 0) {
				return $gold . ' <img src="'.GF_URL.'image/coin_g.gif" alt="" />';
			} else {
				if ($sur > 100) {
					$silver = intval($sur / 100);
					$copper = $sur % ($silver * 100);
					if ($copper == 0) {
						return $gold . ' <img src="'.GF_URL.'image/coin_g.gif" alt="" /> ' . $silver . ' <img src="'.GF_URL.'image/coin_s.gif" alt="" />';
					} else {
						return $gold . ' <img src="'.GF_URL.'image/coin_g.gif" alt="" /> ' . $silver . ' <img src="'.GF_URL.'image/coin_s.gif" alt="" /> ' . $copper . ' <img src="'.GF_URL.'image/coin_c.gif" alt="" />';
					}
				} else {
					return $gold . ' <img src="'.GF_URL.'image/coin_g.gif" alt="" /> ' . $sur . ' <img src="'.GF_URL.'image/coin_c.gif" alt="" />';
				}
			}
		} else {
			if ($money > 100) {
				$silver = intval($money / 100);
				$copper = $money % ($silver * 100);
				if ($copper == 0) {
					return $silver . ' <img src="'.GF_URL.'image/coin_s.gif" alt="" />';
				} else {
					return $silver . ' <img src="'.GF_URL.'image/coin_s.gif" alt="" /> ' . $copper . ' <img src="'.GF_URL.'image/coin_c.gif" alt="" />';
				}
			} else {
				return $money . ' <img src="'.GF_URL.'image/coin_c.gif" alt="" />';
			}
		}
	}

	public static function gender_info($gender) {
		if ($gender == 1) {
			return '男生';
		} elseif ($gender == 2) {
			return '女生';
		} else {
			return '未说明';
		}
	}

	public function list_avatar($limit) {
		$time = time() - GF_AVATAR;
		$sql = "SELECT id, name, gender, intro, useavatar FROM {$this->db->prefix}user WHERE useavatar <> 0 AND lastvisit > {$time} ORDER BY rand() LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender'], 'b');
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_new($limit) {
		$sql = "SELECT id, name, gender, useavatar, created FROM {$this->db->prefix}user ORDER BY created DESC LIMIT {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender'], 's');
			$O['created'] = __brieftime($O['created']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_all($start, $limit) {
		$sql = "SELECT id, name, gender, intro, useavatar, created FROM {$this->db->prefix}user ORDER BY created DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		$time = time() - 86400*3;
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			if ($O['useavatar'] == 1) {
				$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender'], 's');
			} else {
				$gender_info = self::gender_info($O['gender']);
				if ($gender_info == '男生') {
					$O['avatar'] = 'image/silk/male.gif';
				} elseif ($gender_info == '女生') {
					$O['avatar'] = 'image/silk/female.gif';
				} else {
					$O['avatar'] = 'image/silk/user_gray.gif';
				}
			}
			if ($O['created'] < $time) {
				$O['created'] = _time($O['created']);
			} else {
				$O['created'] = _desctime($O['created']);
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum() {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}user";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function act_logout() {
		$sql = "SELECT lastvisit FROM {$this->db->prefix}online WHERE id = {$this->id}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		$sql = "UPDATE {$this->db->prefix}user SET lastvisit = {$O} WHERE id = {$this->id}";
		$this->db->query($sql);
		$sql = "DELETE FROM {$this->db->prefix}online WHERE id = {$this->id}";
		$this->db->query($sql);
	}

	public function act_login($name, $password) {
		$password = md5($password);
		$sql = "SELECT id, password FROM {$this->db->prefix}user WHERE name = '{$this->db->escape($name)}' AND password = '{$password}'";
		$rs = $this->db->query($sql);
		if ($O = $this->db->fetch($rs, 'OBJECT')) {
			$ip = _getip();
			$sql = "DELETE FROM {$this->db->prefix}online WHERE id = 0 AND ip = '{$this->db->escape($ip)}'";
			$this->db->query($sql);
		}
		$this->db->free($rs);
		return $O;
	}

	public function act_useavatar() {
		$sql = "UPDATE {$this->db->prefix}user SET useavatar = 1 WHERE id = {$this->id}";
		$this->db->query($sql);
	}

	public function act_checkemail($email, $signup = false) {
		if ($signup == false) {
			$sql = "SELECT id FROM {$this->db->prefix}user WHERE id <> {$this->id} AND email = '{$this->db->escape($email)}'";
		} else {
			$sql = "SELECT id FROM {$this->db->prefix}user WHERE email = '{$this->db->escape($email)}'";
		}
		$rs = $this->db->query($sql);
		if ($this->db->num_rows($rs)) {
			return true;
		} else {
			return false;
		}
	}

	public function act_updateprofile($gender, $intro, $icq, $msn, $yahoo, $skype, $email, $password = '') {
		if ($password != '') {
			$password = md5($password);
			$sql = "UPDATE {$this->db->prefix}user SET password = '{$password}', gender = {$gender}, intro = '{$this->db->escape($intro)}', email = '{$this->db->escape($email)}', icq = '{$this->db->escape($icq)}', msn = '{$this->db->escape($msn)}', yahoo = '{$this->db->escape($yahoo)}', skype = '{$this->db->escape($skype)}' WHERE id = {$this->id}";
		} else {
			$sql = "UPDATE {$this->db->prefix}user SET gender = {$gender}, intro = '{$this->db->escape($intro)}', email = '{$this->db->escape($email)}', icq = '{$this->db->escape($icq)}', msn = '{$this->db->escape($msn)}', yahoo = '{$this->db->escape($yahoo)}', skype = '{$this->db->escape($skype)}' WHERE id = {$this->id}";
		}
		$this->db->query($sql);
	}

	public function act_checkname($name) {
		$sql = "SELECT id FROM {$this->db->prefix}user WHERE name = '{$this->db->escape($name)}'";
		$rs = $this->db->query($sql);
		if ($this->db->num_rows($rs)) {
			return true;
		} else {
			return false;
		}
	}

	public function __________act_checkid($id) {
		$sql = "SELECT id FROM {$this->db->prefix}user WHERE id = {$id}";
		$rs = $this->db->query($sql);
		if (!$this->db->num_rows($rs)) {
			return true;
		} else {
			return false;
		}
	}

	public function list_id_by_name($user_name) {
		$sql = "SELECT id FROM {$this->db->prefix}user WHERE name = '{$this->db->escape($user_name)}'";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_name_by_id($user_id) {
		$sql = "SELECT name FROM {$this->db->prefix}user WHERE id = {$user_id}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function list_ts($name) {
		$sql = "SELECT u.name, u.topics, SUM(t.views) AS views FROM {$this->db->prefix}user AS u LEFT JOIN {$this->db->prefix}topic AS t ON u.id = t.uid WHERE name = '{$this->db->escape($name)}' GROUP BY u.name";
		$rs = $this->db->query($sql);
		if ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			if ($O['views'] == null) {
				$O['views'] = 0;
			}
		}
		$this->db->free($rs);
		return $O;
	}

	public function act_create($name, $password, $gender, $email) {
		$password = md5($password);
		$time = time();
		$ip = _getip();
		$money = GF_EXP_SIGNUP;
		$sql = "DELETE FROM {$this->db->prefix}online WHERE id = 0 AND ip = '{$this->db->escape($ip)}'";
		$this->db->query($sql);
		$sql = "INSERT INTO {$this->db->prefix}user(id, name, password, gender, intro, useavatar, money, topics, posts, created, createdip, lastvisit, email, icq, msn, yahoo, skype) VALUES(NULL, '{$this->db->escape($name)}', '{$password}', {$gender}, NULL, 0, {$money}, 0, 0, {$time}, '{$this->db->escape($ip)}', {$time}, '{$this->db->escape($email)}', NULL, NULL, NULL, NULL)";
		$this->db->query($sql);
		return $this->db->insert_id();
	}

	public function list_single($name) {
		$sql = "SELECT u.id, u.name, u.gender, u.intro, u.useavatar, u.money, u.topics, u.posts, u.created, u.createdip, u.lastvisit, u.hits, u.logins, u.email, u.icq, u.msn, u.yahoo, u.skype, o.id AS online, o.position FROM {$this->db->prefix}user AS u LEFT JOIN {$this->db->prefix}online AS o ON u.id = o.id WHERE u.name = '{$this->db->escape($name)}'";
		$rs = $this->db->query($sql);
		$time = time() - 86400*3;
		if ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$O['posname'] = urldecode($O['position']);
			$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender']);
			$O['gender_info'] = self::gender_info($O['gender']);
			$O['created'] = _date($O['created']);
			if ($O['lastvisit'] < $time) {
				$O['lastvisit'] = _time($O['lastvisit']);
				//$O['lastvisit'] = _time($O['lastvisit']) . ' UTC+8';
			} else {
				$O['lastvisit'] = _desctime($O['lastvisit']);
			}
		}
		$this->db->free($rs);
		return $O;
	}

	public function list_single_m($name) {
		$sql = "SELECT u.id, u.name, u.gender, u.intro, u.useavatar, u.money, u.topics, u.posts, u.created, u.createdip, u.lastvisit, u.hits, u.logins, u.email, u.icq, u.msn, u.yahoo, u.skype, o.id AS online, o.position FROM {$this->db->prefix}user AS u LEFT JOIN {$this->db->prefix}online AS o ON u.id = o.id WHERE u.name = '{$this->db->escape($name)}'";
		$rs = $this->db->query($sql);
		$time = time() - 86400*3;
		if ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$O['posname'] = urldecode($O['position']);
			$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender'], 's');
			$O['gender_info'] = self::gender_info($O['gender']);
			$O['created'] = date('Y 年 m 月 d 日', $O['created']);
			if ($O['lastvisit'] < $time) {
				$O['lastvisit'] = date('Y 年 m 月 d 日 H:i:s', $O['lastvisit']);
			} else {
				$O['lastvisit'] = _desctime($O['lastvisit']);
			}
		}
		$this->db->free($rs);
		return $O;
	}

	public function act_addhits($uid) {
		$sql = "UPDATE {$this->db->prefix}user SET hits = hits + 1 WHERE id = {$uid}";
		$this->db->query($sql);
	}

	public function list_logins() {
		$time = time() - 86400;
		$sql = "SELECT u.id, u.name, u.gender, u.useavatar, u.lastvisit, u.logins, o.id AS online FROM {$this->db->prefix}user AS u LEFT JOIN {$this->db->prefix}online AS o ON u.id = o.id WHERE u.lastvisit > {$time}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['lastvisit'] = __brieftime($O['lastvisit']);
			$O['urlname'] = urlencode($O['name']);
			$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender'], 's');
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function sum_logins() {
		$time = time() - 86400;
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}user WHERE lastvisit > {$time}";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function ___________act_updateonline() {
		$timeout = time() - GF_TIMEOUT;
		$sql = "SELECT id, ip, lastvisit FROM {$this->db->prefix}online WHERE lastvisit < {$timeout}";
		$rs = $this->db->query($sql);
		while ($O = $this->db->fetch($rs)) {
			if ($O['id'] == 0) {
				$sql = "DELETE FROM {$this->db->prefix}online WHERE id = 0 AND ip = '{$this->db->escape($O['ip'])}' AND lastvisit < {$timeout}";
				$this->db->query($sql);
			} else {
				$sql = "UPDATE {$this->db->prefix}user SET lastvisit = {$O['lastvisit']} WHERE id = {$O['id']}";
				$this->db->query($sql);
				$sql = "DELETE FROM {$this->db->prefix}online WHERE id = {$O['id']}";
				$this->db->query($sql);
			}
		}
		$this->db->free($rs);
		$ip = _getip();
		$agent = _getagent();
		$position = $_SERVER['REQUEST_URI'];
		$time = time();
		if ($this->id > 0) {
			$sql = "SELECT id FROM {$this->db->prefix}online WHERE id = {$this->id}";
			$rs = $this->db->query($sql);
			if (!$this->db->num_rows($rs)) {
				$sql = "INSERT INTO {$this->db->prefix}online(id, name, ip, agent, position, lastvisit) VALUES({$this->id}, '{$this->db->escape($this->name)}', '{$this->db->escape($ip)}', '{$this->db->escape($agent)}', '{$this->db->escape($position)}', {$time})";
				$this->db->query($sql);
				$sql = "UPDATE {$this->db->prefix}user SET logins = logins + 1 WHERE id = {$this->id}";
				$this->db->query($sql);
			} else {
				$sql = "UPDATE {$this->db->prefix}online SET position = '{$this->db->escape($position)}', lastvisit = {$time} WHERE id = {$this->id}";
				$this->db->query($sql);
			}
			$this->db->free($rs);
		} else {
			$sql = "INSERT INTO {$this->db->prefix}online(id, name, ip, agent, position, lastvisit) VALUES(0, '', '{$this->db->escape($ip)}', '{$this->db->escape($agent)}', '{$this->db->escape($position)}', {$time})";
			$this->db->query($sql);
		}
	}

	public function act_updateonline() {
		$timeout = time() - GF_TIMEOUT;
		$sql = "SELECT id, ip, lastvisit FROM {$this->db->prefix}online WHERE lastvisit < {$timeout}";
		$rs = $this->db->query($sql);
		while ($O = $this->db->fetch($rs)) {
			if ($O['id'] == 0) {
				$sql = "DELETE FROM {$this->db->prefix}online WHERE id = 0 AND ip = '{$this->db->escape($O['ip'])}'";
				$this->db->query($sql);
			} else {
				$sql = "UPDATE {$this->db->prefix}user SET lastvisit = {$O['lastvisit']} WHERE id = {$O['id']}";
				$this->db->query($sql);
				$sql = "DELETE FROM {$this->db->prefix}online WHERE id = {$O['id']}";
				$this->db->query($sql);
			}
		}
		$this->db->free($rs);
		$ip = _getip();
		$agent = _getagent();
		$position = $_SERVER['REQUEST_URI'];
		$time = time();
		if ($this->id > 0) {
			$sql = "SELECT id FROM {$this->db->prefix}online WHERE id = {$this->id}";
			$rs = $this->db->query($sql);
			if (!$this->db->num_rows($rs)) {
				$sql = "INSERT INTO {$this->db->prefix}online(id, name, ip, agent, position, lastvisit) VALUES({$this->id}, '{$this->db->escape($this->name)}', '{$this->db->escape($ip)}', '{$this->db->escape($agent)}', '{$this->db->escape($position)}', {$time})";
				$this->db->query($sql);
				$sql = "UPDATE {$this->db->prefix}user SET logins = logins + 1 WHERE id = {$this->id}";
				$this->db->query($sql);
			} else {
				$sql = "UPDATE {$this->db->prefix}online SET position = '{$this->db->escape($position)}', lastvisit = {$time} WHERE id = {$this->id}";
				$this->db->query($sql);
			}
		} else {
			$sql = "SELECT id FROM {$this->db->prefix}online WHERE id = 0 AND ip = '{$this->db->escape($ip)}'";
			$rs = $this->db->query($sql);
			if (!$this->db->num_rows($rs)) {
				$sql = "INSERT INTO {$this->db->prefix}online(id, name, ip, agent, position, lastvisit) VALUES(0, '', '{$this->db->escape($ip)}', '{$this->db->escape($agent)}', '{$this->db->escape($position)}', {$time})";
				$this->db->query($sql);
			} else {
				$sql = "UPDATE {$this->db->prefix}online SET position = '{$this->db->escape($position)}', lastvisit = {$time} WHERE id = 0 AND ip = '{$this->db->escape($ip)}'";
				$this->db->query($sql);
			}
		}
		$this->db->free($rs);
	}

	public function sum_online() {
		$sql = "SELECT id FROM {$this->db->prefix}online ORDER BY id";
		$rs = $this->db->query($sql);
		$st = array();
		$st['all'] = $st['guests'] = $st['users'] = 0;
		while ($O = $this->db->fetch($rs)) {
			if ($O['id'] == 0) {
				$st['guests']++;
			} else {
				$st['users']++;
			}
		}
		$st['all'] = $st['guests'] + $st['users'];
		$this->db->free($rs);
		return $st;
	}

	public function list_online_user() {
		$sql = "SELECT name FROM {$this->db->prefix}online ORDER BY lastvisit DESC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$O['color'] = _randcolor();
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_online_all($start, $limit) {
		$sql = "SELECT id, name, ip, agent, position, lastvisit FROM {$this->db->prefix}online ORDER BY lastvisit DESC LIMIT {$start}, {$limit}";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['posname'] = urldecode($O['position']);
			$O['lastvisit'] = _desctime($O['lastvisit']);
			$O['agent'] = _substr($O['agent'], 0, 150);
			if ($O['id'] > 0) {
				$O['urlname'] = urlencode($O['name']);
				$O['ip'] = _hiddenip($O['ip']);
			} else {
				$O['urlname'] = '';
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_sitemap() {
		$sql = "SELECT name FROM {$this->db->prefix}user ORDER BY id ASC";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function list_wealth() {
		$sql = "SELECT money FROM {$this->db->prefix}user ORDER BY money DESC LIMIT 1";
		$rs = $this->db->query($sql);
		$width = $this->db->fetch_one($rs);
		$this->db->free($rs);
		$sql = "SELECT id, name, gender, useavatar, money FROM {$this->db->prefix}user WHERE money > 0 ORDER BY money DESC LIMIT 10";
		$rs = $this->db->query($sql);
		$st = array();
		while ($O = $this->db->fetch($rs)) {
			$O['urlname'] = urlencode($O['name']);
			$O['avatar'] = self::get_avatar($O['id'], $O['useavatar'], $O['gender'], 's');
			$O['width'] = ceil($O['money'] * 250 / $width);
			$O['color'] = _randcolor();
			$O['money_info'] = self::money_info_w($O['money']);
			if ($this->id == $O['id']) {
				$O['inlist'] = true;
			} else {
				$O['inlist'] = false;
			}
			$st[] = $O;
		}
		$this->db->free($rs);
		return $st;
	}

	public function act_getwealthrank($uid) {
		$sql = "SELECT COUNT(id) FROM {$this->db->prefix}user WHERE money >= (SELECT money FROM {$this->db->prefix}user WHERE id = {$uid})";
		$rs = $this->db->query($sql);
		$O = $this->db->fetch_one($rs);
		$this->db->free($rs);
		return $O;
	}

	public function act_updatemoney($uid, $cost) {
		$sql = "UPDATE {$this->db->prefix}user SET money = money + {$cost} WHERE id = {$uid}";
		$this->db->query($sql);
	}

}
