﻿var date_help = function(inp, divide){
		this.inp = document.getElementById(inp);
		this.divide = divide;
		this.format = 'YYYY'+divide+'MM'+divide+'DD';
		//显示字符样式
		this.styleH='<span style="font-weight:bold; color:green">';
		this.styleB='</span>'; 
		this.qj = [/０/g, /１/g, /２/g, /３/g, /４/g, /５/g, /６/g, /７/g, /８/g, /９/g, /－/g,]; //数字全角
		this.bj = [0,1,2,3,4,5,6,7,8,9,'-']; //数字
		this.load(); // 初始化
}
date_help.prototype={ 
	load: function(){
		// 创建一个用于显示提示的DIV并设置样式
		var div = document.createElement('div');
		div.setAttribute('style', 'height:21px; line-height:21px;font-family:verdana; font-size:13px; letter-spacing:1px; text-align:center; background:#fffff6; color:#f60; border:1px solid #ccc; border-top:0; position:absolute; visibility:hidden');
		div.style.cssText = 'height:21px; line-height:21px; font-family:verdana; font-size:13px; letter-spacing:1px; text-align:center; background:#fffff6; color:#f60; border:1px solid #ccc; border-top:0; position:absolute; visibility:hidden';
		div.innerHTML = this.format;
		this.div = div;
		document.body.appendChild(div);
		
		// 设置DIV的位置
		var inp = this.inp;
		var inpW = inp.offsetWidth, inpH = inp.offsetHeight;
		var left = 0, top = 0;
		while(inp != null){ // 计算输入框在页面里的坐标给提示框使用
			left += inp.offsetLeft;
			top += inp.offsetTop;
			inp = inp.offsetParent;
		}
		this.div.style.height = '21px';
		this.div.style.width = inpW-2 + 'px';
		this.div.style.left = left + 'px';
		this.div.style.top = inpH+top + 'px';
		
		// 加载输入框事件
		var oThis = this;
		this.inp.onfocus = function(){
			oThis.inp_v.call(oThis);
		}
		
		this.inp.onblur = function(){
			oThis.inp_h.call(oThis);
		}
        this.inp.onkeypress = function(e){ //键盘按下事件
			e?intKey=e.which:intKey=event.keyCode;
			return oThis.inp_press.call(oThis, intKey);
		}
		this.inp.onkeyup = function(e){
			e?intKey=e.which:intKey=event.keyCode; 
			oThis.inp_chk.call(oThis,intKey);
		}
		
	},
	inp_v: function(){ // 提示信息显示
		this.div.style.visibility = 'visible';
	},
	 inp_h: function(){ // 提示信息显示
		if(new RegExp('^\\d+'+this.divide+'\\d'+this.divide).test(this.inp.value)){ // 月数补0
			this.inp.value = this.inp.value.replace(new RegExp('^(\\d+'+this.divide+')(\\d)(?='+this.divide+')'),'$10$2');
			this.parseDate();
			this.parseFormat();
		}
		if(new RegExp('^\\d+'+this.divide+'\\d+'+this.divide+'\\d$').test(this.inp.value)){ // 天数补0
			this.inp.value = this.inp.value.replace(/(\d)$/,'0$1');
			this.parseDate();
			this.parseFormat();
		}
        this.div.style.visibility = 'hidden';
    },
	inp_press: function(intKey){ //键键按下事件 只接受数字和分隔符
			// return (new RegExp('[\\d'+this.divide+']').test(String.fromCharCode(intKey)) || (intKey==0||intKey==8));
			return (new RegExp('[\\d'+this.qj+this.divide+']').test(String.fromCharCode(intKey)) || (intKey==0||intKey==8));
	},
	inp_chk: function(intkey){ // 格式化日期及提示信息样式
		if(intKey==37||intKey==39)return; // 左右键不检测
		this.parseDate(intKey); // 格式化日期
		this.parseFormat(); // 格式化提示信息
	},
	
	parseDate: function(intKey){ // 格式化日期
		var intDate = this.inp.value.replace(/\s/g,'');
		for(var i=0; i<this.qj.length; i++)intDate=intDate.replace(this.qj[i],this.bj[i]); //　全角替换
		var divide=this.divide;
		var strDateArray = intDate.split(divide);
		strDateArray[0]?intYear = strDateArray[0].replace(/^(\d*).*$/,'$1'):intYear='';
		strDateArray[1]?intMonth = strDateArray[1].replace(/^(\d*).*$/,'$1'):intMonth='';
		strDateArray[2]?intDay = strDateArray[2].replace(/^(\d*).*$/,'$1'):intDay='';
		if((intKey==8 || intKey==46) && (!strDateArray[0]||strDateArray[0].length<5)&&(!strDateArray[1] || strDateArray[1].length<3) && (!strDateArray[2]||strDateArray[2].length<3))return intDate; // 退格键检测
		isNaN(intYear)?intYear='':intYear=intYear.slice(0,4);
		isNaN(intMonth)?intMonth='':intMonth=intMonth.slice(0,2);
		isNaN(intDay)?intDay='':intDay=intDay.slice(0,2);
		// 判断在修改阶段
		if(intYear.length<4 && (intMonth!='' || intDay!='')){
			if(strDateArray[1].length<3 && strDateArray[2].length<3)return intDate;
		}
		if(intMonth.length<2 && intDay!=''){
			if(strDateArray[0].length<5 && strDateArray[2].length<3)return intDate;
		}
		if(intMonth.slice(0,1)>1)intMonth='0'+intMonth.slice(0,1);
		
		
		if(intMonth>12){
			var m='0'+intMonth.slice(0,1);
			var d=intMonth.slice(1,2);
			intMonth = m;
			if(intDay=='')intDay=d;
		}
		var intM=Number(intMonth);
		if(intM == 1 || intM == 3 || intM == 5 || intM == 7 || intM == 8 || intM == 10 || intM == 12){
			if(intDay.slice(0,1)>3)intDay='0'+intDay.slice(0,1);
			intDay>31?intDay=intDay.slice(0,1):'';
		}
		if(intM == 4 || intM == 6 || intM == 9 || intM == 11){
			if(intDay.slice(0,1)>3)intDay='0'+intDay.slice(0,1);
			parseInt(intDay)>30?intDay=intDay.slice(0,1):'';
		}
		if(intM == 2){
			boolLeapYear = false;
			if ((intYear % 100) === 0) {
				if ((intYear % 400) === 0) {
					boolLeapYear = true;
				}
			} else {
				if ((intYear % 4) === 0) {
					boolLeapYear = true;
				}
			}
			if (boolLeapYear) {
				if(intDay.slice(0,1)>2)intDay='0'+intDay.slice(0,1);
			} else {
				if(intDay.slice(0,1)>2)intDay='0'+intDay.slice(0,1);
				if (intDay > 28)intDay=intDay.slice(0,1);
			}
		}
		//判断是否为00年
		if(intYear.length>3)if(intYear<1)intYear='000';
		//判断是否为00月
		if(intMonth.length>1)if(intMonth<1)intMonth='0';
		//判断是否为00日
		if(intDay.length>1)if(intDay<1)intDay='0';
		temDate = '';
		if(intYear!='')intYear.length==4 ? temDate = intYear + divide : temDate = intYear;
		if(intMonth!='')intMonth.length==2 ? temDate = intYear + divide + intMonth + divide : new RegExp('\\d+'+divide+'\\d+'+divide).test(intDate) ? intMonth>1 ? temDate=intYear+divide+'0'+intMonth+divide : temDate=intYear+divide+'0'+divide : temDate = intYear + divide + intMonth;
		if(intDay!='')temDate=intYear+divide+intMonth+divide+intDay;
		this.inp.value=temDate;
		return temDate;
	},
	
	parseFormat: function(){ //格式化提示信息
	    var intDate = this.inp.value;
		if(!intDate){
			this.div.innerHTML=this.format;
			return;
		}
		var format = this.format; // 提示字符
		var divide = this.divide;
		var uarr = intDate.split(divide), farr = format.split(divide) // 用户输入的字符分组
		var styleH = this.styleH, styleB = this.styleB;
		var y=farr[0], m=farr[1], d=farr[2]; // 年, 月, 日
		if(uarr!='')y=styleH+y.slice(0,uarr[0].length)+styleB+y.slice(uarr[0].length,y.length);
		if(uarr[1]!='' && uarr[1]!=null){
			m=styleH+divide+m.slice(0,uarr[1].length)+styleB+m.slice(uarr[1].length,m.length);
		}else{
			new RegExp('\\d*'+divide).test(intDate)?m=styleH+divide+styleB+m:m=divide+m;
		}
		if(uarr[2]!=''&&uarr[2]!=null){
			d=styleH+divide+d.slice(0,uarr[2].length)+styleB+d.slice(uarr[2].length,d.length);
		}else{
			new RegExp('\\d*?'+divide+'\\d*?'+divide).test(intDate)?d=styleH+divide+styleB+d:d=divide+d;
		}
		this.div.innerHTML= y+m+d;
	}
		
}
window.onload = function(){
new date_help('d01', '-');new date_help('d02', '-');
new date_help('d1', '-');new date_help('d2', '-');
new date_help('date1', '-');new date_help('date2', '-');
new date_help('date3', '-');new date_help('date4', '-');
new date_help('date5', '-');new date_help('date6', '-');
new date_help('date7', '-');new date_help('date8', '-');
new date_help('date9', '-');new date_help('date10', '-');
new date_help('date11', '-');new date_help('date12', '-');
new date_help('date13', '-');new date_help('date14', '-');
new date_help('date15', '-');new date_help('date16', '-');
}