<?php
include './db.php';
function real_ip()
{
    static $realip = NULL;
    if ($realip !== NULL)
    {
        return $realip;
    }
    if (isset($_SERVER))
    {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        {

            $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            foreach ($arr AS $ip)
            {
                $ip = trim($ip);
                if ($ip != 'unknown')
                {
                    $realip = $ip;
                    break;
                }
            }
        }
        elseif (isset($_SERVER['HTTP_CLIENT_IP']))
        {
            $realip = $_SERVER['HTTP_CLIENT_IP'];
        }
        else
        {
            if (isset($_SERVER['REMOTE_ADDR']))
            {
                $realip = $_SERVER['REMOTE_ADDR'];
            }
            else 
            {
                $realip = '0.0.0.0';
            }
        }
    }

    else
    {
 
        if (getenv('HTTP_X_FORWARDED_FOR'))
        {
            $realip = getenv('HTTP_X_FORWARDED_FOR');
        }
       
        elseif (getenv('HTTP_CLIENT_IP'))
        {
            $realip = getenv('HTTP_CLIENT_IP');
        }
       
        else
        {
            $realip = getenv('REMOTE_ADDR');
        }
    }

    preg_match("/[\d\.]{7,15}/", $realip, $onlineip);
    $realip = !empty($onlineip[0]) ? $onlineip[0] : '0.0.0.0';

    return $realip;
}



function GetCurUrl(){
$host = '';
if (!empty($_SERVER["HTTP_HOST"]))
{
$host = $_SERVER["HTTP_HOST"];
$host = "http://".$host;
} 



if(!empty($_SERVER["REQUEST_URI"])){
$scriptName = $_SERVER["REQUEST_URI"];
$nowurl = $host.$scriptName;
}else{
$scriptName = $_SERVER["PHP_SELF"];
if(empty($_SERVER["QUERY_STRING"])) $nowurl = $scriptName;
else $nowurl = $host.$scriptName.$_SERVER["QUERY_STRING"];
}
return $nowurl;
}


function is_bot()
{
	$botlist = array("Teoma", "alexa", "froogle", "Gigabot", "inktomi",
	"looksmart", "URL_Spider_SQL", "Firefly", "NationalDirectory",
	"Ask Jeeves", "TECNOSEEK", "InfoSeek", "WebFindBot", "girafabot",
	"crawler", "www.galaxy.com", "Googlebot", "Scooter", "Slurp",
	"msnbot", "appie", "FAST", "WebBug", "Spade", "ZyBorg", "rabaz",
	"Baiduspider", "Feedfetcher-Google", "TechnoratiSnoop", "Rankivabot",
	"Mediapartners-Google", "Sogou web spider", "WebAlta Crawler","TweetmemeBot",
	"Butterfly","Twitturls","Me.dium","Twiceler","soso");
 
	foreach($botlist as $bot)
	{
		if(stripos($_SERVER['HTTP_USER_AGENT'], $bot) !== false)
			return true;	
	}
	return false;
}



if (is_bot())
	{exit;}
else{
$visitor_referer = '';
$visitor_ip = real_ip();
$visitor_browser_info = $_SERVER["HTTP_USER_AGENT"];

 if (isset($_SERVER['HTTP_REFERER']))
        {

$visitor_referer = $_SERVER['HTTP_REFERER']; }


    $visitor_referer = parse_url($visitor_referer);
 if (isset($visitor_referer["host"]))
        {
    $visitor_host = $visitor_referer["host"];}


function getBrowser()
{
    $u_agent = $_SERVER['HTTP_USER_AGENT'];
    $bname = 'Unknown';
    $platform = 'Unknown';
    $version= "";

    //First get the platform?
    if (preg_match('/linux/i', $u_agent)) {
        $platform = 'linux';
    }
    elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
        $platform = 'mac';
    }
    elseif (preg_match('/windows|win32/i', $u_agent)) {
        $platform = 'windows';
    }
   
    // Next get the name of the useragent yes seperately and for good reason
    if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent))
    {
        $bname = 'Internet Explorer';
        $ub = "MSIE";
    }
    elseif(preg_match('/Firefox/i',$u_agent))
    {
        $bname = 'Mozilla Firefox';
        $ub = "Firefox";
    }
    elseif(preg_match('/Chrome/i',$u_agent))
    {
        $bname = 'Google Chrome';
        $ub = "Chrome";
    }
    elseif(preg_match('/Safari/i',$u_agent))
    {
        $bname = 'Apple Safari';
        $ub = "Safari";
    }
    elseif(preg_match('/Opera/i',$u_agent))
    {
        $bname = 'Opera';
        $ub = "Opera";
    }
    elseif(preg_match('/Netscape/i',$u_agent))
    {
        $bname = 'Netscape';
        $ub = "Netscape";
    }
   
    // finally get the correct version number
    $known = array('Version', $ub, 'other');
    $pattern = '#(?<browser>' . join('|', $known) .
    ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
    if (!preg_match_all($pattern, $u_agent, $matches)) {
        // we have no matching number just continue
    }
   
    // see how many we have
    $i = count($matches['browser']);
    if ($i != 1) {
        //we will have two since we are not using 'other' argument yet
        //see if version is before or after the name
        if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
            $version= $matches['version'][0];
        }
        else {
            $version= $matches['version'][1];
        }
    }
    else {
        $version= $matches['version'][0];
    }
   
    // check if we have a number
    if ($version==null || $version=="") {$version="?";}
   
    return array(
        'userAgent' => $u_agent,
        'name'      => $bname,
        'version'   => $version,
        'platform'  => $platform,
        'pattern'    => $pattern
    );
}

$ua=getBrowser();
$browser = $ua['name'].' '.$ua['version'];
$pv = GetCurUrl();
if(($pv == 'http://'.$_SERVER ['HTTP_HOST'].'/') || (is_string(stristr($pv,'?')))
)
{$url_this = 'Main';}
else{
$sev = 'http://'.$_SERVER ['HTTP_HOST'].'/';
$i = 14;
for (;;) {
   if (substr($pv,0,$i) == $sev) {
       break;
   }
   
   $i++;
}
$url_this = substr($pv, $i);}
$time = time();
$stmt = $a->prepare("select COUNT(*)  from visitors where ip_address = :ip ");  
$stmt->execute( array('ip' => $visitor_ip));if ($stmt->fetchColumn() <= 0) {
$stmt = $a->prepare("INSERT INTO visitors (ip_address,browsername,urlfrom,date_and_time,page,link) VALUES (:visitor_ip,:browser,:urlfrom,:time,:page,:link)");
$stmt->execute( array('visitor_ip' => $visitor_ip, 'browser' => $browser, 'urlfrom' => $visitor_host,  'time' => $time,  'page' => $url_this,  'link' => 0) );
}
else{
$stmt = $a->prepare("INSERT INTO pageview (ip,page,time) VALUES (:visitor_ip,:pv,:time) ");
$stmt->execute( array('visitor_ip' => $visitor_ip, 'pv' => $url_this, 'time' => $time) );

$a->exec("update visitors set link = '1'  where ip_address = '$visitor_ip' ");  
}
 }

?>