﻿/*
 * jQuery float it plugin
 * Version 1.0 (8-July-2010)
 * @requires jQuery v1.3 or later
 *
 * Copyright (c) 2009-2010 Tony ZHOU
 * Dual licensed under the MIT and GPL licenses:
 */
 
jQuery.fn.floatIt = function (options) { 
	//parameter like { location: "bottom" } or { location: "top" }
    	// define defaults and override with options, if available
    settings = jQuery.extend({ location: "bottom" }, options);

    var h = $(window).height();
    var w = $(window).width();

    var topLocation = 0;
    var leftLocation = w / 2 - $(this).width()/2;

    var currentId = $(this).attr("id");

    switch (settings["location"].toLowerCase()) {
        case ("bottom"):
            topLocation = h - $(this).width();
            $(window).scroll(function () {
                var topLocation = $(document).scrollTop() + $(window).height() - $("#" + currentId).height(); //closure
                $("#" + currentId).css({ position: "absolute", top: topLocation, left: leftLocation });
            });
            break;
        case ("top"):
            topLocation = 0;
            $(window).scroll(function () {
                var topLocation = $(document).scrollTop(); //closure
                $("#" + currentId).css({ position: "absolute", top: topLocation, left: leftLocation });
            });
            break;
        default:
            topLocation = h - $(this).width();
            break;
    }

    $(this).css({ position: "absolute", top: topLocation, left: leftLocation });
};