<?php
/*

Copyright (c) 2010 Zohaib Sibt-e-Hassan ( MaXPert )

MiMViC v0.9.10

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

*/
$uvicConfig = array();$uvicConfig['maps'] = array( );$uvicConfig['userData'] = array( );
$uvicConfig['bechmark'] = array( );
function store($name, &$value){
	global $uvicConfig;
	$uvicConfig['userData'][$name] = $value;
}
function retrieve($name){
	global $uvicConfig;
    if(!isset($uvicConfig['userData'][$name]))
        return null;
	return $uvicConfig['userData'][$name];
}
function uRemoveGetParams($url){
	$relUrl = explode('?', $url);
	return $relUrl[0];
}
function ugetURI(){
	$req=uRemoveGetParams($_SERVER['REQUEST_URI']);
	$page=$_SERVER['SCRIPT_NAME'];
	if( stripos($req, $page) === FALSE && isset( $_SERVER['REDIRECT_URL'] ) ){
		$page = explode('/', $page);
		$page = array_slice($page, 0, -1);
		if (count($page) > 1){
			$page = join('/', $page).'/';
		}else{
			$page = '';
		}
	}
	if(strlen($req)<strlen($page)){
		$req=$page;
	}
	$req=str_replace($page,'',$req);
	if(strlen($req)=== 0 || $req[0]!=='/'){
		$req = '/'.$req;
	}
	
	return $req;
}
function ugetReqMethod(){
	return strtolower( $_SERVER['REQUEST_METHOD'] );
}
function uescapeForRegex($str){
	$esc_syms = array('^','[','.','$','{','*','(',"\\",'/','+',')','|', '?', '>', '<');
	foreach($esc_syms as $sym)
		$str = str_replace($sym, "\\".$sym, $str);
	return $str;
}
function ucompileExpression($elms){
	$namedParamRex = '([^\/]+)';
	$anyParamRex = '(.*)';
	$exp = array();
	foreach($elms as $elm){
		//For named parameter
		$v = '';
		if(strlen($elm) && $elm[0] == ':')
			$v = $namedParamRex;
		elseif($elm === '*')
			$v = $anyParamRex;
		else
			$v = uescapeForRegex($elm);
		$exp[] = $v;
	}
	
	return '/^'.implode('\/', $exp).'$/i';
}
function uparseURIParams($pattern, $ur){
	$psegs = explode('/', $pattern); 
	$exp = ucompileExpression($psegs);
	$matches = array();
	$m = preg_match($exp, $ur, $matches);
	if(!$m){
		return false;
	}
	$ret = array('segments' => array());
	$i = 1;
	foreach($psegs as $pseg){
		if(strlen($pseg) && $pseg[0] == ':'){
			$ret[substr($pseg, 1)] = $matches[$i++];
		}elseif($pseg === '*'){
			$ret['segments'][] = explode('/', $matches[$i++]);
		}
	}
	return $ret;
}
function ucallIfCallable($obj, $params){
	$func_name = '';
	$isCallable = is_callable($obj, true, $func_name);
	if($isCallable){
		return call_user_func($obj, $params);
	}
	throw new NotCallableException();
}
function ucallNHandle($obj, $params){
	try{
		return ucallIfCallable($obj, $params);
	}catch(NotCallableException $e){
	}
}
function utriggerFunction($uri, $method){
	global $uvicConfig;
	$map = &$uvicConfig['maps'];
	
	foreach($map[$method] as $patrn => $info){		
		$cParams = uparseURIParams($patrn, $uri);
		$ret = false;
		if( is_array($cParams) )
		{
			foreach($info as $inf){
				if( $inf['agent'] === false || preg_match($inf['agent'], $_SERVER['HTTP_USER_AGENT']) > 0 ){
					if( is_array($inf['func']) ){
						if( count($inf['func']) == 2 && is_string($inf['func'][1]) ){
							$ret = ucallNHandle($inf['func'], $cParams);
						}else{
							$ret = array();
							foreach($inf['func'] as $arg){
								if( is_callable($arg) ){
									$ret[] = ucallNHandle($arg, $cParams);
								}
							}
						}
					}elseif( is_callable( $inf['func']) ){
						
						$ret = ucallNHandle($inf['func'], $cParams);
					}
					return $ret;}}}}return NULL;}
function dispatch($method, $uri, $func, $agent = false){
	global $uvicConfig;
	$map = &$uvicConfig['maps'];
    if($method == '*'){
        $method = array('get','post','put','delete');
	}
	if( is_array($method) ){
		foreach($method as $mthd){
			dispatch($mthd, $uri, $func, $agent = false);
		}
		return;
	}
	elseif( is_array($uri) ){
		foreach($uri as $one_url){
			dispatch($methd, $one_url, $func, $agent = false);
		}
		return;
	}
	
	if( !isset($map[$method]) ){
		$map[$method] = array();
	}
	
	if( !isset($map[$method][$uri]) ){
		$map[$method][$uri] = array();
	}
	
	$map[$method][$uri][] = array('method'=> $method, 'func'=> $func, 'agent' => $agent);
}
function get($uri, $func, $agent = false){
	dispatch('get', $uri, $func, $agent);
}
function post($uri, $func, $agent = false){
	dispatch('post', $uri, $func, $agent);
}
function put($uri, $func, $agent = false){
	dispatch('put', $uri, $func, $agent);
}
function delete($uri, $func, $agent = false){
	dispatch('delete', $uri, $func, $agent);
}
function Action($name, $clsObj = NULL){
	if($clsObj === NULL)
		$clsObj = new $name();
	return array(&$clsObj, 'exec');
}
function render($template_name,$_templateData=array()){
	if(stristr($template_name,'.php')===FALSE)
		$template_name=$template_name.'.php';
	extract($_templateData,EXTR_OVERWRITE);
	if(file_exists($template_name))
		require($template_name);
	else
		return NULL;		
	return true;
}
function startBenchmark($name){
	global $uvicConfig;
	
	$uvicConfig['benchmark'][$name] = microtime();
}
function calcBenchmark($name){
	global $uvicConfig;	
	if( !isset($uvicConfig['benchmark'][$name]) )
		return null;	
	list($startMic, $startSec) = explode(' ', $uvicConfig['benchmark'][$name]);
	list($endMic, $endSec) = explode(' ', microtime());
	
	return (float)($endMic + $endSec) - (float)($startMic + $startSec);}
function start(){
	$url = ugetURI();
	$ret = utriggerFunction( $url , ugetReqMethod() );
	return $ret;} ?>