<?php
/*
	[UCenter Home] (C) 2007-2008 Comsenz Inc.
	$Id: update.php 13233 2009-08-24 08:17:25Z liguode $
*/

if(!@include('./common.php')) {
	exit('請將本文件移到程序根目錄再運行!');
}

error_reporting(0);

//新SQL
$sqlfile = S_ROOT.'./data/install.sql';
if(!file_exists($sqlfile)) {
	show_msg('最新的SQL文件不存在,請先將最新的數據庫結構文件 install.sql 已經上傳到 ./data 目錄下面後，再運行本升級程序');
}

$lockfile = './data/update.lock';
if(file_exists($lockfile)) {
	show_msg('請您先登錄服務器ftp，手工刪除 data/update.lock 文件，再次運行本文件進行UCenter Home升級。');
}

$PHP_SELF = $_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME'];

//提交處理
if(submitcheck('delsubmit')) {
	//刪除表
	if(!empty($_POST['deltables'])) {
		foreach ($_POST['deltables'] as $tname => $value) {
			$_SGLOBAL['db']->query("DROP TABLE `".tname($tname)."`");
		}
	}
	//刪除字段
	if(!empty($_POST['delcols'])) {
		foreach ($_POST['delcols'] as $tname => $cols) {
			foreach ($cols as $col => $indexs) {
				if($col == 'PRIMARY') {
					$_SGLOBAL['db']->query("ALTER TABLE ".tname($tname)." DROP PRIMARY KEY", 'SILENT');//屏蔽錯誤
				} elseif($col == 'KEY') {
					foreach ($indexs as $index => $value) {
						$_SGLOBAL['db']->query("ALTER TABLE ".tname($tname)." DROP INDEX `$index`", 'SILENT');//屏蔽錯誤
					}
				} else {
					$_SGLOBAL['db']->query("ALTER TABLE ".tname($tname)." DROP `$col`");
				}
			}
		}
	}

	show_msg('刪除表和字段操作完成了', 'update.php?step=delete');
}

if(empty($_GET['step'])) $_GET['step'] = 'start';
//處理開始
if($_GET['step'] == 'start') {
	//開始
	show_msg('本升級程序會參照最新的SQL文件，對你的UCHome數據庫進行升級。<br><br>
		升級前請做好以下前期工作：<br><br>
		<b>第一步：</b><br>
		備份當前的數據庫，避免升級失敗，造成數據丟失而無法恢復；<br><br>
		<b>第二步：</b><br>
		將程序包 ./upload/ 目錄中，除 config.new.php 文件、./install/ 目錄以外的其他所有文件，全部上傳並覆蓋當前程序。<b>特別注意的是，最新數據庫結構 ./data/install.sql 文件不要忘記上傳，否則會導致升級失敗</b>；<br><br>
		<b>第三步：</b><br>
		確認已經將程序包 ./update 目錄中最新的 update.php 升級程序上傳到服務器程序根目錄中<br>
		<br><br><a href="update.php?step=check">已經做好以上工作，升級開始</a><br><br>
		特別提醒：為了數據安全，升級完畢後，不要忘記刪除本升級文件。');

} elseif ($_GET['step'] == 'check') {
	
	//UCenter_Client
	include_once S_ROOT.'./uc_client/client.php';
	if(!function_exists('uc_check_version')) {
		show_msg('請將UCHome程序包中最新版本的 ./upload/uc_client 上傳至程序根目錄覆蓋原有目錄和文件後，再嘗試升級。');
	}
	
	$uc_root = get_uc_root();
	$return = uc_check_version();
	if (empty($return)) {
		$upgrade_url = 'http://'.$_SERVER['HTTP_HOST'].$PHP_SELF.'?step=sql';
	} else {
		if($return['db'] == '1.5.0') {
			header("Location: update.php?step=sql");//UC升級完成
			exit();
		}
		$upgrade_url = 'http://'.$_SERVER['HTTP_HOST'].$PHP_SELF.'?step=check';
	}
	
	$ucupdate = UC_API."/upgrade/upgrade2.php?action=db&forward=".urlencode($upgrade_url);
	
	show_msg('<b>您的 UCenter 程序還沒有升級完成，請如下操作：</b><br>UCenter Home支持了最新版本的UCenter，請先升級您的UCenter。<br><br>
		1. <a href="http://download.comsenz.com/UCenter/1.5.0/" target="_blank">點擊這裡下載對應編碼的 UCenter 1.5.0 程序</a><br>
		2. 將解壓縮得到的 ./upload 目錄下的程序覆蓋到已安裝的UCenter目錄 <b>'.($uc_root ? $uc_root : UC_API).'</b><br>
		&nbsp;&nbsp;&nbsp; (確保其升級程序 <b>./upgrade/upgrade2.php</b> 也已經上傳到UCenter的 ./upgrade 目錄)<br><br>
		確認完成以上UCenter程序升級操作完成後，您才可以：<br>
		<a href="'.$ucupdate.'" target="_blank">新窗口中訪問 upgrade2.php 進行UCenter數據庫升級</a><br>
		在打開的新窗口中，如果UCenter升級成功，程序會自動進行下一步的升級。<br>這時，您關閉本窗口即可。
		<br><br>
		如果您無法通過上述UCenter升級步驟，請調查問題後，務必將UCenter正常升級後，再繼續本升級程序。<br>或者您可以：<br><a href="update.php?step=sql" style="color:#CCC;">跳過UCenter升級</a>，但這可能會帶來一些未知兼容問題。');

} elseif ($_GET['step'] == 'sql') {
	
	//關閉站點
	if(empty($_SCONFIG['close'])) {
		
		$datas[] = "('close', '1')";
		$datas[] = "('closereason', '更多驚喜，更多期待，站點升級中，請稍等...')";
		
		$_SGLOBAL['db']->query("REPLACE INTO ".tname('config')." (var, datavalue) VALUES ".implode(',', $datas));
		
		include_once(S_ROOT.'./source/function_cache.php');
		config_cache();//緩存
	}
	

	//新的SQL
	$sql = sreadfile($sqlfile);
	preg_match_all("/CREATE\s+TABLE\s+uchome\_(.+?)\s+\((.+?)\)\s+(TYPE|ENGINE)\=/is", $sql, $matches);
	$newtables = empty($matches[1])?array():$matches[1];
	$newsqls = empty($matches[0])?array():$matches[0];
	if(empty($newtables) || empty($newsqls)) {
		show_msg('最新的SQL不存在,請先將最新的數據庫結構文件 install.sql 已經上傳到 ./data 目錄下面後，再運行本升級程序');
	}

	//升級表
	$i = empty($_GET['i'])?0:intval($_GET['i']);
	$count_i = count($newtables);
	if($i>=$count_i) {
		//處理完畢
		show_msg('數據庫結構升級完畢，進入下一步數據升級操作', 'update.php?step=data', 1);
	}
	//當前處理表
	$newtable = $newtables[$i];
	$newcols = getcolumn($newsqls[$i]);

	//獲取當前SQL
	if(!$query = $_SGLOBAL['db']->query("SHOW CREATE TABLE ".tname($newtable), 'SILENT')) {
		//添加表
		preg_match("/(CREATE TABLE .+?)\s+[TYPE|ENGINE]+\=/is", $newsqls[$i], $maths);
		if(strpos($newtable, 'session')) {
			$type = mysql_get_server_info() > '4.1' ? " ENGINE=MEMORY".(empty($_SC['dbcharset'])?'':" DEFAULT CHARSET=$_SC[dbcharset]" ): " TYPE=HEAP";
		} else {
			$type = mysql_get_server_info() > '4.1' ? " ENGINE=MYISAM".(empty($_SC['dbcharset'])?'':" DEFAULT CHARSET=$_SC[dbcharset]" ): " TYPE=MYISAM";
		}
		$usql = $maths[1].$type;
		$usql = str_replace("CREATE TABLE uchome_", 'CREATE TABLE '.$_SC['tablepre'], $usql);
		if(!$_SGLOBAL['db']->query($usql, 'SILENT')) {
			show_msg('添加表 '.tname($newtable).' 出錯,請手工執行以下SQL語句後,再重新運行本升級程序:<br><br>'.shtmlspecialchars($usql));
		} else {
			$msg = '添加表 '.tname($newtable).' 完成';
		}
	} else {
		$value = $_SGLOBAL['db']->fetch_array($query);
		$oldcols = getcolumn($value['Create Table']);

		//獲取升級SQL文
		$updates = array();
		foreach ($newcols as $key => $value) {
			if($key == 'PRIMARY') {
				if($value != $oldcols[$key]) {
					if(!empty($oldcols[$key])) $updates[] = "DROP PRIMARY KEY";
					$updates[] = "ADD PRIMARY KEY $value";
				}
			} elseif ($key == 'KEY') {
				foreach ($value as $subkey => $subvalue) {
					if(!empty($oldcols['KEY'][$subkey])) {
						if($subvalue != $oldcols['KEY'][$subkey]) {
							$updates[] = "DROP INDEX `$subkey`";
							$updates[] = "ADD INDEX `$subkey` $subvalue";
						}
					} else {
						$updates[] = "ADD INDEX `$subkey` $subvalue";
					}
				}
			} else {
				if(!empty($oldcols[$key])) {
					if(str_replace('mediumtext', 'text', $value) != str_replace('mediumtext', 'text', $oldcols[$key])) {
						$updates[] = "CHANGE `$key` `$key` $value";
					}
				} else {
					$updates[] = "ADD `$key` $value";
				}
			}
		}

		//升級處理
		if(!empty($updates)) {
			$usql = "ALTER TABLE ".tname($newtable)." ".implode(', ', $updates);
			if(!$_SGLOBAL['db']->query($usql, 'SILENT')) {
				show_msg('升級表 '.tname($newtable).' 出錯,請手工執行以下升級語句後,再重新運行本升級程序:<br><br><b>升級SQL語句</b>:<div style=\"position:absolute;font-size:11px;font-family:verdana,arial;background:#EBEBEB;padding:0.5em;\">'.shtmlspecialchars($usql)."</div><br><b>Error</b>: ".$_SGLOBAL['db']->error()."<br><b>Errno.</b>: ".$_SGLOBAL['db']->errno());
			} else {
				$msg = '升級表 '.tname($newtable).' 完成';
			}
		} else {
			$msg = '檢查表 '.tname($newtable).' 完成，不需升級';
		}
	}

	//處理下一個
	$next = 'update.php?step=sql&i='.($_GET['i']+1);
	show_msg("[ $i / $count_i ] ".$msg, $next);

} elseif ($_GET['step'] == 'data') {
	
	if(empty($_GET['op'])) $_GET['op'] = 'threadnum';
	
	if($_GET['op'] == 'threadnum') {
		
		//1.5->2.0
		$nextop = 'postnum';
		
		//群組話題數
		$perpage = 100;
		$start = empty($_GET['start'])?0:intval($_GET['start']);
		
		include_once(S_ROOT.'./source/function_stat.php');
		if($_SCONFIG['update_release'] < '20090501' && mtag_threadnum_stat($start, $perpage)) {
			show_msg("[數據升級] 群組話題數 ( $start ) 完畢，繼續進入下一批", 'update.php?step=data&op='.$_GET['op'].'&start='.($start+$perpage));
		} else {
			show_msg("[數據升級] 群組話題數 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		}
		
	} elseif($_GET['op'] == 'postnum') {
		
		//1.5->2.0
		$nextop = 'trace';
		
		//群組回帖數
		$perpage = 100;
		$start = empty($_GET['start'])?0:intval($_GET['start']);
		
		include_once(S_ROOT.'./source/function_stat.php');
		if($_SCONFIG['update_release'] < '20090501' && mtag_postnum_stat($start, $perpage)) {
			show_msg("[數據升級] 群組回帖數 ( $start ) 完畢，繼續進入下一批", 'update.php?step=data&op='.$_GET['op'].'&start='.($start+$perpage));
		} else {
			show_msg("[數據升級] 群組回帖數 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		}
		
	} elseif($_GET['op'] == 'trace') {
		
		$nextop = 'userappfeild';
		
		//踩一腳升級數據
		//1.5->2.0
		$inserts = $uas = array();
		$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('trace')." LIMIT 0,1000", 'SILENT');
		while ($value = $_SGLOBAL['db']->fetch_array($query)) {
			$value = saddslashes($value);
			$uas[] = "{$value[uid]}-{$value[blogid]}";
			$inserts[] = "('$value[uid]','$value[username]','$value[blogid]','blogid','1','$value[dateline]')";
			$_SGLOBAL['db']->query("DELETE FROM ".tname('trace')." WHERE uid='$value[uid]' AND blogid='$value[blogid]'");
		}
		if($inserts) {
			$_SGLOBAL['db']->query("INSERT INTO ".tname('clickuser')." (uid,username,id,idtype,clickid,dateline) VALUES ".implode(',', $inserts));
			show_msg("[數據升級] 踩一腳 ( ".implode(',', $uas)." ) 完畢，繼續進入下一批", 'update.php?step=data&op='.$_GET['op']);
		} else {
			show_msg("[數據升級] 踩一腳 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		}
	
	} elseif($_GET['op'] == 'userappfeild') {
		
		$nextop = 'moderator';
		
		//用戶userappfeild處理
		//1.5->2.0
		$inserts = $uas = array();
		$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('userapp')." WHERE (profilelink !='' OR myml !='') LIMIT 0,100", 'SILENT');
		while ($value = $_SGLOBAL['db']->fetch_array($query)) {
			$value = saddslashes($value);
			$uas[] = "{$value[uid]}-{$value[appid]}";
			$inserts[] = "('$value[uid]','$value[appid]','$value[profilelink]','$value[myml]')";
			updatetable('userapp', array('profilelink'=>'', 'myml'=>''), array('uid'=>$value['uid'], 'appid'=>$value['appid']));
		}
		if($inserts) {
			$_SGLOBAL['db']->query("INSERT INTO ".tname('userappfield')." (uid,appid,profilelink,myml) VALUES ".implode(',', $inserts));
			//跳入下一個處理
			show_msg("[數據升級] 用戶應用 ( ".implode(',', $uas)." ) 完畢，繼續進入下一批", 'update.php?step=data&op='.$_GET['op']);
		} else {
			show_msg("[數據升級] 用戶應用 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		}
		
	} elseif($_GET['op'] == 'moderator') {
		
		$nextop = 'email';
		
		//數據處理
		//1.2->1.5 處理群主問題
		$query = $_SGLOBAL['db']->query("SELECT tagid,tagname,moderator FROM ".tname('mtag')." WHERE moderator!='' LIMIT 0,1", 'SILENT');
		if($value = $_SGLOBAL['db']->fetch_array($query)) {
			$moderatorarr = explode("\t", $value['moderator']);
			$moderatorarr = saddslashes($moderatorarr);
			$m_query = $_SGLOBAL['db']->query("SELECT uid,username FROM ".tname('space')." WHERE username IN (".simplode($moderatorarr).")");
			while ($m_value = $_SGLOBAL['db']->fetch_array($m_query)) {
				$grade = $moderatorarr[0] == $m_value['username'] ? 9 : 8;
				updatetable('tagspace', array('grade'=>$grade), array('tagid'=>$value['tagid'], 'uid'=>$m_value['uid']));
			}
			updatetable('mtag', array('moderator'=>''), array('tagid'=>$value['tagid']));
			//跳入下一個處理
			show_msg("[數據升級] 群組群主 ( $value[tagname] ) 完畢，繼續進入下一批", 'update.php?step=data&op='.$_GET['op']);
		} else {
			show_msg("[數據升級] 群組群主 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		}
		
	} elseif($_GET['op'] == 'email') {
		
		$nextop = 'tracenum';
		
		//郵件處理
		//1.5RC2->1.5正式版
		$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('mailqueue')." WHERE cid='0' LIMIT 0,1", 'SILENT');
		if($value = $_SGLOBAL['db']->fetch_array($query)) {
			if($value['email']) {
				//檢查
				$value['email'] = addslashes($value['email']);
				$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('mailcron')." WHERE email='$value[email]' LIMIT 1");
				if($v = $_SGLOBAL['db']->fetch_array($query)) {
					updatetable('mailqueue', array('cid'=>$v['cid']), array('email'=>$value['email']));
				}
			} elseif ($value['touid']) {
				$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('mailcron')." WHERE touid='$value[touid]' LIMIT 1");
				if($v = $_SGLOBAL['db']->fetch_array($query)) {
					$spacemail = getcount('spacefield', array('uid'=>$value['touid']), 'email');
					if($spacemail) {
						$spacemail = addslashes($spacemail);
						updatetable('mailcron', array('email'=>$spacemail), array('cid'=>$v['cid']));
						updatetable('mailqueue', array('cid'=>$v['cid']), array('touid'=>$value['touid']));
					}
				}
			}
			//跳入下一個處理
			show_msg("[數據升級] 郵件隊列 ( $value[email] $value[touid] ) 完畢，繼續進入下一批", 'update.php?step=data&op='.$_GET['op']);
		} else {
			show_msg("[數據升級] 郵件隊列 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		}
		
	} elseif($_GET['op'] == 'tracenum') {
		
		$nextop = 'cron';
		
		//更新踩一腳數據統計
		$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('blog')." WHERE click_1>0 LIMIT 1", 'SILENT');
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('blog')." SET click_1=tracenum", 'SILENT');
			$_SGLOBAL['db']->query("UPDATE ".tname('usergroup')." SET allowclick=allowtrace", 'SILENT');
		}
		
		show_msg("[數據升級] 踩一腳數據統計 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'cron') {
		
		$nextop = 'task';
		
		//1.0->1.2 計劃任務
		$datas = array();
		$query = $_SGLOBAL['db']->query("SELECT type FROM ".tname('cron')." WHERE filename='cleantrace.php' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$datas[] = "1, 'system', '清理腳印和最新訪客', 'cleantrace.php', $_SGLOBAL[timestamp], $_SGLOBAL[timestamp], -1, -1, 2, '3'";
		}
		if($datas) {
			$_SGLOBAL['db']->query("INSERT INTO ".tname('cron')." (available, type, name, filename, lastrun, nextrun, weekday, day, hour, minute) VALUES (".implode('),(', $datas).")");
		}
	
		//1.5RC1->1.5RC2 更改sendmail
		$_SGLOBAL['db']->query("DELETE FROM ".tname('cron')." WHERE filename='sendmail.php'");
		
		show_msg("[數據升級] 計劃任務 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'task') {
		
		$nextop = 'usergroup';
		
		//1.2->1.5 有獎活動
		$datas = $filenames = array();
		$query = $_SGLOBAL['db']->query("SELECT filename FROM ".tname('task'));
		while ($value = $_SGLOBAL['db']->fetch_array($query)) {
			$filenames[$value['filename']] = 1;
		}
		if(empty($filenames['avatar.php'])) $datas[] = "1, '更新一下自己的頭像', '頭像就是你在這裡的個人形象。<br>設置自己的頭像後，會讓更多的朋友記住您。', 'avatar.php', 1, '', 0, 20, 'image/task/avatar.gif'";
		if(empty($filenames['profile.php'])) $datas[] = "1, '將個人資料補充完整', '把自己的個人資料填寫完整吧。<br>這樣您會被更多的朋友找到的，系統也會幫您找到朋友。', 'profile.php', 2, '', 0, 20, 'image/task/profile.gif'";
		if(empty($filenames['blog.php'])) $datas[] = "1, '發表自己的第一篇日誌', '現在，就寫下自己的第一篇日誌吧。<br>與大家一起分享自己的生活感悟。', 'blog.php', 3, '', 0, 5, 'image/task/blog.gif'";
		if(empty($filenames['friend.php'])) $datas[] = "1, '尋找並添加五位好友', '有了好友，您發的日誌、圖片等會被好友及時看到並傳播出去；<br>您也會在首頁方便及時的看到好友的最新動態。', 'friend.php', 4, '', 0, 50, 'image/task/friend.gif'";
		if(empty($filenames['email.php'])) $datas[] = "1, '驗證激活自己的郵箱', '填寫自己真實的郵箱地址並驗證通過。<br>您可以在忘記密碼的時候使用該郵箱取回自己的密碼；<br>還可以及時接受站內的好友通知等等。', 'email.php', 5, '', 0, 10, 'image/task/email.gif'";
		if(empty($filenames['invite.php'])) $datas[] = "1, '邀請10個新朋友加入', '邀請一下自己的QQ好友或者郵箱聯繫人，讓親朋好友一起來加入我們吧。', 'invite.php', 6, '', 0, 100, 'image/task/friend.gif'";
		if(empty($filenames['gift.php'])) $datas[] = "1, '領取每日訪問大禮包', '每天登錄訪問自己的主頁，就可領取大禮包。', 'gift.php', 99, 'day', 0, 5, 'image/task/gift.gif'";
	
		if($datas) {
			$_SGLOBAL['db']->query("INSERT INTO ".tname('task')." (`available`, `name`, `note`, `filename`, `displayorder`, `nexttype`, `nexttime`, `credit`, `image`) VALUES (".implode('),(', $datas).")");
		}
		
		//更新每日禮包
		if($filenames['gift.php']['nexttype'] != 'day') {
			updatetable('task', array('nexttype'=>'day', 'nexttime'=>0), array('filename'=>'gift.php'));
		}
	
		show_msg("[數據升級] 有獎活動 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'usergroup') {
		
		$nextop = 'config';
		
		//1.2->1.5用戶組
		$query = $_SGLOBAL['db']->query("SELECT gid FROM ".tname('usergroup')." WHERE allowpoke='1' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('usergroup')." SET allowcss=allowhtml,allowpoke=allowpost,allowfriend=allowpost,allowtrace=allowpost");
		}
		//1.5rc2->1.5
		$query = $_SGLOBAL['db']->query("SELECT gid FROM ".tname('usergroup')." WHERE allowmtag='1' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('usergroup')." SET allowmtag=allowthread,managereport=manageconfig");
		}
		
		//1.5->2.0 用戶組數據升級
		$query = $_SGLOBAL['db']->query("SELECT gid FROM ".tname('usergroup')." WHERE managetopic='1' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('usergroup')." SET
				explower=creditlower,
				allowmagic=allowblog,
				allowpoll=allowblog,
				allowevent=allowblog,
				allowtopic=manageconfig,
				allowstat=manageconfig,
				spamignore=manageblog,
				managepoll=manageblog,
				manageevent=manageblog,
				manageeventclass=manageconfig,
				managemagic=manageconfig,
				managemagiclog=manageconfig,
				managetopic=manageconfig,
				managespacegroup=manageconfig,
				managespaceinfo=manageconfig,
				managespacecredit=manageconfig,
				managespacenote=manageconfig,
				manageip=manageconfig,
				managehotuser=manageconfig,
				videophotoignore=manageconfig,
				searchignore=manageconfig,
				allowpm=allowblog,
				allowclick=allowblog,
				allowviewvideopic=manageblog,
				allowmyop=allowblog,
				managebatch=manageblog,
				managedefaultuser=manageconfig,
				manageclick=manageconfig,
				managedelspace=manageconfig,
				managevideophoto=manageconfig,
				managelog=manageconfig");
			
			$datas = array();
			//增加禁止訪問用戶組
			$datas = array(
				'grouptitle' => '禁止訪問',
				'system' => -1,
				'banvisit' => 1
			);
			inserttable('usergroup', $datas);
		}
		
		//添加禁止發言用戶組
		$query = $_SGLOBAL['db']->query("SELECT gid FROM ".tname('usergroup')." WHERE system='-1' AND grouptitle='禁止發言' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$datas = array();
			//增加禁止訪問用戶組
			$datas = array(
				'grouptitle' => '禁止發言',
				'system' => -1,
				'maxattachsize' => 1,
				'maxfriendnum' => 1,
				'postinterval' => 9999,
				'searchinterval' => 9999,
				'domainlength' => 99,
				'seccode' => 1,
				'verifyevent' => 1
			);
			inserttable('usergroup', $datas);
		}

		//1.5->2.0 切換經驗值
		$query = $_SGLOBAL['db']->query("SELECT credit FROM ".tname('space')." WHERE experience > 0 LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('space')." SET experience=credit");
		}
		
		//1.5正式版，用戶組圖標
		$query = $_SGLOBAL['db']->query("SELECT gid FROM ".tname('usergroup')." WHERE icon!='' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('usergroup')." SET color='red',icon='image/group/admin.gif' WHERE manageconfig='1'");
		}

		show_msg("[數據升級] 用戶組 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'config') {
		
		$nextop = 'credit';
		
		//1.2->1.5rc2
		$datas = array();
		if(empty($_SCONFIG['feedfilternum'])) {
			$datas[] = "('feedfilternum', '10')";
		}
		
		//1.5->2.0 統計
		if(!isset($_SCONFIG['updatestat'])) {
			$datas[] = "('updatestat', '1')";
		}
		
		//1.5->2.0 熱點
		if(empty($_SCONFIG['feedhotday'])) {
			$datas[] = "('feedhiddenicon', 'friend,profile,task,wall')";
			$datas[] = "('maxreward', '10')";
			$datas[] = "('feedhotday', '2')";
			$datas[] = "('feedhotnum', '3')";
			$datas[] = "('feedhotmin', '3')";
		}
		
		//隱私
		//1.5->2.0
		if(!isset($_SCONFIG['privacy']['feed']['poll'])) {
			$newfeed = array('poll', 'joinpoll', 'event', 'join', 'show', 'credit', 'spaceopen', 'invite', 'task', 'profile', 'click');
			foreach($newfeed as $key => $val) {
				$_SCONFIG['privacy']['feed'][$val] = 1;
			}
			$newview = array('poll', 'event');
			foreach($newview as $key => $val) {
				$_SCONFIG['privacy']['view'][$val] = 0;
			}
			$datas[] = "('privacy', '".serialize($_SCONFIG['privacy'])."')";
		}
		
		//1.5->2.0 禮物
		if(!isset($_SCONFIG['my_showgift'])) {
			$datas[] = "('my_showgift', '1')";
		}
		
		//2.0alpha->2.0 最新成員
		if(!isset($_SCONFIG['newspacenum'])) {
			$datas[] = "('newspacenum', '3')";
		}
		//排行榜緩存
		if(!isset($_SCONFIG['topcachetime'])) {
			$datas[] = "('topcachetime', '60')";
		}
		
		if($datas) {
			$_SGLOBAL['db']->query("REPLACE INTO ".tname('config')." (var, datavalue) VALUES ".implode(',', $datas));
		}
		
		show_msg("[數據升級] 站點配置 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'credit') {
		
		$nextop = 'eventclass';
		
		//1.5->2.0 升級積分規則
		$ruls = array();
		$query = $_SGLOBAL['db']->query("SELECT * FROM ".tname('creditrule')." WHERE action='register' LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			//加積分
			$ruls[] = "('開通空間', 'register', '0', '0', '1', '1', '10', '0', '0')";
			$ruls[] = "('實名認證', 'realname', '0', '0', '1', '1', '20', '0', '20')";
			$ruls[] = "('郵箱認證', 'realemail', '0', '0', '1', '1', '40', '0', '40')";
			$ruls[] = "('成功邀請好友', 'invitefriend', '4', '0', '20', '1', '10', '0', '10')";
			$ruls[] = "('設置頭像', 'setavatar', '0', '0', '1', '1', '15', '0', '15')";
			$ruls[] = "('視頻認證', 'videophoto', '0', '0', '1', '1', '40', '0', '40')";
			$ruls[] = "('成功舉報', 'report', '4', '0', '0', '1', '2', '0', '2')";
			$ruls[] = "('更新心情', 'updatemood', '1', '0', '3', '1', '3', '0', '3')";
			$ruls[] = "('熱點信息', 'hotinfo', '4', '0', '0', '1', '10', '0', '10')";
			$ruls[] = "('每天登陸', 'daylogin', '1', '0', '1', '1', '15', '0', '15')";
			$ruls[] = "('訪問別人空間', 'visit', '1', '0', '10', '1', '1', '2', '1')";
			$ruls[] = "('打招呼', 'poke', '1', '0', '10', '1', '1', '2', '1')";
			$ruls[] = "('留言', 'guestbook', '1', '0', '20', '1', '2', '2', '2')";
			$ruls[] = "('被留言', 'getguestbook', '1', '0', '5', '1', '1', '2', '0')";
			$ruls[] = "('發表記錄', 'doing', '1', '0', '5', '1', '1', '0', '1')";
			$ruls[] = "('發表日誌', 'publishblog', '1', '0', '3', '1', '5', '0', '5')";
			$ruls[] = "('上傳圖片', 'uploadimage', '1', '0', '10', '1', '2', '0', '2')";
			$ruls[] = "('拍大頭貼', 'camera', '1', '0', '5', '1', '3', '0', '3')";
			$ruls[] = "('發表話題', 'publishthread', '1', '0', '5', '1', '5', '0', '5')";
			$ruls[] = "('回復話題', 'replythread', '1', '0', '10', '1', '1', '1', '1')";
			$ruls[] = "('創建投票', 'createpoll', '1', '0', '5', '1', '2', '0', '2')";
			$ruls[] = "('參與投票', 'joinpoll', '1', '0', '10', '1', '1', '1', '1')";
			$ruls[] = "('發起活動', 'createevent', '1', '0', '1', '1', '3', '0', '3')";
			$ruls[] = "('參與活動', 'joinevent', '1', '0', '1', '1', '1', '1', '1')";
			$ruls[] = "('推薦活動', 'recommendevent', '4', '0', '0', '1', '10', '0', '10')";
			$ruls[] = "('發起分享', 'createshare', '1', '0', '3', '1', '2', '0', '2')";
			$ruls[] = "('評論', 'comment', '1', '0', '40', '1', '1', '1', '1')";
			$ruls[] = "('被評論', 'getcomment', '1', '0', '20', '1', '1', '1', '0')";
			$ruls[] = "('安裝應用', 'installapp', '4', '0', '0', '1', '5', '3', '5')";
			$ruls[] = "('使用應用', 'useapp', '1', '0', '10', '1', '1', '3', '1')";
			$ruls[] = "('信息表態', 'click', '1', '0', '10', '1', '1', '1', '1')";
	
			//扣積分
			$ruls[] = "('修改實名', 'editrealname', '0', '0', '1', '0', '5', '0', '0')";
			$ruls[] = "('更改郵箱認證', 'editrealemail', '0', '0', '1', '0', '5', '0', '0')";
			$ruls[] = "('頭像被刪除', 'delavatar', '0', '0', '1', '0', '10', '0', '10')";
			$ruls[] = "('獲取邀請碼', 'invitecode', '0', '0', '1', '0', '0', '0', '0')";
			$ruls[] = "('搜索一次', 'search', '0', '0', '1', '0', '1', '0', '0')";
			$ruls[] = "('日誌導入', 'blogimport', '0', '0', '1', '0', '10', '0', '0')";
			$ruls[] = "('修改域名', 'modifydomain', '0', '0', '1', '0', '5', '0', '0')";
			$ruls[] = "('日誌被刪除', 'delblog', '0', '0', '1', '0', '10', '0', '10')";
			$ruls[] = "('記錄被刪除', 'deldoing', '0', '0', '1', '0', '2', '0', '2')";
			$ruls[] = "('圖片被刪除', 'delimage', '0', '0', '1', '0', '4', '0', '4')";
			$ruls[] = "('投票被刪除', 'delpoll', '0', '0', '1', '0', '4', '0', '4')";
			$ruls[] = "('話題被刪除', 'delthread', '0', '0', '1', '0', '4', '0', '4')";
			$ruls[] = "('活動被刪除', 'delevent', '0', '0', '1', '0', '6', '0', '6')";
			$ruls[] = "('分享被刪除', 'delshare', '0', '0', '1', '0', '4', '0', '4')";
			$ruls[] = "('留言被刪除', 'delguestbook', '0', '0', '1', '0', '4', '0', '4')";
			$ruls[] = "('評論被刪除', 'delcomment', '0', '0', '1', '0', '2', '0', '2')";
	
			$_SGLOBAL['db']->query("INSERT INTO ".tname('creditrule')." (`rulename`, `action`, `cycletype`, `cycletime`, `rewardnum`, `rewardtype`, `credit`, `norepeat`, `experience`) VALUES ".implode(',', $ruls));
		}
		
		show_msg("[數據升級] 積分規則 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'eventclass') {
		
		$nextop = 'report';
		
		//1.5->2.0 活動
		$query = $_SGLOBAL['db']->query("SELECT classid FROM ".tname('eventclass')." LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$datas = array(
				"1, '生活/聚會', 0, '費用說明：\r\n集合地點：\r\n著裝要求：\r\n聯繫方式：\r\n注意事項：', 1",
				"2, '出行/旅遊', 0, '路線說明:\r\n費用說明:\r\n裝備要求:\r\n交通工具:\r\n集合地點:\r\n聯繫方式:\r\n注意事項:', 2",
				"3, '比賽/運動', 0, '費用說明：\r\n集合地點：\r\n著裝要求：\r\n場地介紹：\r\n聯繫方式：\r\n注意事項：', 4",
				"4, '電影/演出', 0, '劇情介紹：\r\n費用說明：\r\n集合地點：\r\n聯繫方式：\r\n注意事項：', 3",
				"5, '教育/講座', 0, '主辦單位：\r\n活動主題：\r\n費用說明：\r\n集合地點：\r\n聯繫方式：\r\n注意事項：', 5",
				"6, '其它', 0, '', 6"
			);	
			$_SGLOBAL['db']->query("INSERT INTO ".tname('eventclass')." (classid, classname, poster, template, displayorder) VALUES (".implode('),(', $datas).")");
		}
		
		show_msg("[數據升級] 活動分類 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'report') {
		
		$nextop = 'click';
		
		//1.5->2.0 升級舉報
		$idtype = array(
			'albumid' => 'album',
			'blogid' => 'blog',
			'tagid' => 'mtag',
			'tid' => 'thread',
			'uid' => 'space',
			'pid' => 'poll',
			'eventid' => 'event',
			'sid' => 'share'
		);
		$count = $_SGLOBAL['db']->result($_SGLOBAL['db']->query("SELECT COUNT(*) FROM ".tname('report')." WHERE idtype IN(".simplode($idtype).")"), 0);
		if($count) {
			foreach($idtype as $key => $val) {
				$_SGLOBAL['db']->query("UPDATE ".tname('report')." SET idtype='$key' WHERE idtype='$val'");
			}
		}
		
		show_msg("[數據升級] 舉報 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'click') {
		
		$nextop = 'magic';
		
		//1.5->2.0 表態
		$query = $_SGLOBAL['db']->query("SELECT clickid FROM ".tname('click')." LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$datas = array(
				"'1', '路過', 'luguo.gif', 'blogid'",
				"'2', '雷人', 'leiren.gif', 'blogid'",
				"'3', '握手', 'woshou.gif', 'blogid'",
				"'4', '鮮花', 'xianhua.gif', 'blogid'",
				"'5', '雞蛋', 'jidan.gif', 'blogid'",
				
				"'6', '漂亮', 'piaoliang.gif', 'picid'",
				"'7', '酷斃', 'kubi.gif', 'picid'",
				"'8', '雷人', 'leiren.gif', 'picid'",
				"'9', '鮮花', 'xianhua.gif', 'picid'",
				"'10', '雞蛋', 'jidan.gif', 'picid'",
				
				"'11', '搞笑', 'gaoxiao.gif', 'tid'",
				"'12', '迷惑', 'mihuo.gif', 'tid'",
				"'13', '雷人', 'leiren.gif', 'tid'",
				"'14', '鮮花', 'xianhua.gif', 'tid'",
				"'15', '雞蛋', 'jidan.gif', 'tid'"
			);	
			$_SGLOBAL['db']->query("INSERT INTO ".tname('click')." (clickid, `name`, icon, idtype) VALUES (".implode('),(', $datas).")");
		}
		
		show_msg("[數據升級] 表態 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'magic') {
		
		$nextop = 'network';
		
		$datas = $magics = array();
		$query = $_SGLOBAL['db']->query("SELECT mid FROM ".tname('magic'));
		while ($value = $_SGLOBAL['db']->fetch_array($query)) {
			$magics[$value['mid']] = 1;
		}
		
		//1.5->2.0 道具
		if(empty($magics['invisible'])) $datas[] = "'invisible', '隱身草', '讓自己隱身登錄，不顯示在線，24小時內有效', '5', '50', '86400', '10', '86400', '1'";
		if(empty($magics['friendnum'])) $datas[] = "'friendnum', '好友增容卡', '在允許添加的最多好友數限制外，增加10個好友名額', '3', '30', '86400', '999', '0', '1'";
		if(empty($magics['attachsize'])) $datas[] = "'attachsize', '附件增容卡', '使用一次，可以給自己增加 10M 的附件空間', '3', '30', '86400', '999', '0', '1'";
		if(empty($magics['thunder'])) $datas[] = "'thunder', '雷鳴之聲', '發佈一條全站信息，讓大家知道自己上線了', '5', '500', '86400', '5', '86400', '1'";
		if(empty($magics['updateline'])) $datas[] = "'updateline', '救生圈', '把指定對象的發佈時間更新為當前時間', '5', '200', '86400', '999', '0', '1'";
		
		if(empty($magics['downdateline'])) $datas[] = "'downdateline', '時空機', '把指定對象的發佈時間修改為過去的時間', '5', '250', '86400', '999', '0', '1'";		
		if(empty($magics['color'])) $datas[] = "'color', '彩色燈', '把指定對象的標題變成彩色的', '5', '50', '86400', '999', '0', '1'";
		if(empty($magics['thunder'])) $datas[] = "'hot', '熱點燈', '把指定對象的熱度增加站點推薦的熱點值', '5', '50', '86400', '999', '0', '1'";
		if(empty($magics['visit'])) $datas[] = "'visit', '互訪卡', '隨機選擇10個好友，向其打招呼、留言或訪問空間', '2', '20', '86400', '999', '0', '1'";
		if(empty($magics['icon'])) $datas[] = "'icon', '彩虹蛋', '給指定對象的標題前面增加圖標（最多8個圖標）', '2', '20', '86400', '999', '0', '1'";
		
		if(empty($magics['flicker'])) $datas[] = "'flicker', '彩虹炫', '讓評論、留言的文字閃爍起來', '3', '30', '86400', '999', '0', '1'";
		if(empty($magics['gift'])) $datas[] = "'gift', '紅包卡', '在自己的空間埋下積分紅包送給來訪者', '2', '20', '86400', '999', '0', '1'";
		if(empty($magics['superstar'])) $datas[] = "'superstar', '超級明星', '在個人主頁，給自己的頭像增加超級明星標識', '3', '30', '86400', '999', '0', '1'";
		if(empty($magics['viewmagiclog'])) $datas[] = "'viewmagiclog', '八卦鏡', '查看指定用戶最近使用的道具記錄', '5', '100', '86400', '999', '0', '1'";
		if(empty($magics['viewmagic'])) $datas[] = "'viewmagic', '透視鏡', '查看指定用戶當前持有的道具', '5', '100', '86400', '999', '0', '1'";
		
		if(empty($magics['viewvisitor'])) $datas[] = "'viewvisitor', '偷窺鏡', '查看指定用戶最近訪問過的10個空間', '5', '100', '86400', '999', '0', '1'";
		if(empty($magics['call'])) $datas[] = "'call', '點名卡', '發通知給自己的好友，讓他們來查看指定的對象', '5', '50', '86400', '999', '0', '1'";
		if(empty($magics['coupon'])) $datas[] = "'coupon', '代金券','購買道具時折換一定量的積分', '0', '0', '0', '0', '0', '1'";
		if(empty($magics['frame'])) $datas[] = "'frame', '相框', '給自己的照片添上相框', '3', '30', '86400', '999', '0', '1'";
		if(empty($magics['bgimage'])) $datas[] = "'bgimage', '信紙', '給指定的對象添加信紙背景', '3', '30', '86400', '999', '0', '1'";
		
		if(empty($magics['doodle'])) $datas[] = "'doodle', '塗鴉板', '允許在留言、評論等操作時使用塗鴉板', '3', '30', '86400', '999', '0', '1'";
		if(empty($magics['anonymous'])) $datas[] = "'anonymous', '匿名卡', '在指定的地方，讓自己的名字顯示為匿名', '5', '50', '86400', '999', '0', '1'";
		if(empty($magics['reveal'])) $datas[] = "'reveal', '照妖鏡', '可以查看一次匿名用戶的真實身份', '5', '100', '86400', '999', '0', '1'";
		if(empty($magics['license'])) $datas[] = "'license', '道具轉讓許可證', '使用許可證，將道具贈送給指定好友', '1', '10', '3600', '999', '0', '1'";
		if(empty($magics['detector'])) $datas[] = "'detector', '探測器', '探測埋了紅包的空間', '1', '10', '86400', '999', '0', '1'";
		
		if($datas) {
			$_SGLOBAL['db']->query("INSERT INTO ".tname('magic')."(`mid`, `name`, `description`, `experience`, `charge`, `provideperoid`, `providecount`, `useperoid`, `usecount`) VALUES (".implode('),(', $datas).")");
		}

		show_msg("[數據升級] 道具 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'network') {
		
		$nextop = 'menuorder';
		
		//隨便看看
		@include_once(S_ROOT.'./data/data_network.php');
		if(empty($_SGLOBAL['network']['blog']['order'])) {
			$network = array(
				'blog' => array('hot1'=>3, 'cache'=>600),
				'pic' => array('hot1'=>3, 'cache'=>700),
				'thread' => array('hot1'=>3, 'cache'=>800),
				'event' => array('cache'=>900),
				'poll' => array('cache'=>500),
			);
			data_set('network', $network);
		}
		
		show_msg("[數據升級] 隨便看看配置 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} elseif($_GET['op'] == 'menuorder') {
		
		$nextop = 'end';
		
		//1.5->2.0 表態
		$query = $_SGLOBAL['db']->query("SELECT menuorder FROM ".tname('userapp')." WHERE menuorder>0 LIMIT 1");
		if(!$value = $_SGLOBAL['db']->fetch_array($query)) {
			$_SGLOBAL['db']->query("UPDATE ".tname('userapp')." SET menuorder=displayorder");
		}
		
		show_msg("[數據升級] 用戶應用菜單順序 全部結束，進入下一步", 'update.php?step=data&op='.$nextop);
		
	} else {
		//結束
		$next = 'update.php?step=delete';
		show_msg("數據庫數據升級完畢，進入下一步數據庫結構清理操作", $next);
	}
	
}elseif ($_GET['step'] == 'delete') {

	//檢查需要刪除的字段
	//老表集合
	$oldtables = array();
	$query = $_SGLOBAL['db']->query("SHOW TABLES LIKE '$_SC[tablepre]%'");
	while ($value = $_SGLOBAL['db']->fetch_array($query)) {
		$values = array_values($value);
		if(!strexists($values[0], 'cache')) {
			$oldtables[] = $values[0];//分表、緩存
		}
	}

	//新表集合
	$sql = sreadfile($sqlfile);
	preg_match_all("/CREATE\s+TABLE\s+uchome\_(.+?)\s+\((.+?)\)\s+(TYPE|ENGINE)\=/is", $sql, $matches);
	$newtables = empty($matches[1])?array():$matches[1];
	$newsqls = empty($matches[0])?array():$matches[0];

	//需要刪除的表
	$deltables = array();
	$delcolumns = array();

	//老的有，新的沒有
	foreach ($oldtables as $tname) {
		$tname = substr($tname, strlen($_SC['tablepre']));
		if(in_array($tname, $newtables)) {
			//比較字段是否多餘
			$query = $_SGLOBAL['db']->query("SHOW CREATE TABLE ".tname($tname));
			$cvalue = $_SGLOBAL['db']->fetch_array($query);
			$oldcolumns = getcolumn($cvalue['Create Table']);

			//新的
			$i = array_search($tname, $newtables);
			$newcolumns = getcolumn($newsqls[$i]);

			//老的有，新的沒有的字段
			foreach ($oldcolumns as $colname => $colstruct) {
				if(!strexists($colname, 'field_') && !strexists($colname, 'click_')) {
					if($colname == 'PRIMARY') {
						//關鍵字
						if(empty($newcolumns[$colname])) {
							$delcolumns[$tname][] = 'PRIMARY';
						}
					} elseif($colname == 'KEY') {
						//索引
						foreach ($colstruct as $key_index => $key_value) {
							if(empty($newcolumns[$colname][$key_index])) {
								$delcolumns[$tname]['KEY'][$key_index] = $key_value;
							}
						}
					} else {
						//普通字段
						if(empty($newcolumns[$colname])) {
							$delcolumns[$tname][] = $colname;
						}
					}
				}
			}
		} else {
			$deltables[] = $tname;
		}
	}

	//顯示
	show_header();
	echo '<form method="post" action="update.php?step=delete">';

	//刪除表
	$deltablehtml = '';
	if($deltables) {
		$deltablehtml .= '<table>';
		foreach ($deltables as $tablename) {
			$deltablehtml .= "<tr><td><input type=\"checkbox\" name=\"deltables[$tablename]\" value=\"1\"></td><td>{$_SC['tablepre']}$tablename</td></tr>";
		}
		$deltablehtml .= '</table>';
		echo "<p>以下 數據表 與標準數據庫相比是多餘的:<br>您可以根據需要自行決定是否刪除</p>$deltablehtml";
	}

	//刪除字段
	$delcolumnhtml = '';
	if($delcolumns) {
		$delcolumnhtml .= '<table>';
		foreach ($delcolumns as $tablename => $cols) {
			foreach ($cols as $col) {
				if (is_array($col)) {
					foreach ($col as $index => $indexvalue) {
						$delcolumnhtml .= "<tr><td><input type=\"checkbox\" name=\"delcols[$tablename][KEY][$index]\" value=\"1\"></td><td>{$_SC['tablepre']}$tablename</td><td>索引 $index $indexvalue</td></tr>";
					}
				} elseif($col == 'PRIMARY') {
					$delcolumnhtml .= "<tr><td><input type=\"checkbox\" name=\"delcols[$tablename][PRIMARY]\" value=\"1\"></td><td>{$_SC['tablepre']}$tablename</td><td>主鍵 PRIMARY</td></tr>";
				} else {
					$delcolumnhtml .= "<tr><td><input type=\"checkbox\" name=\"delcols[$tablename][$col]\" value=\"1\"></td><td>{$_SC['tablepre']}$tablename</td><td>字段 $col</td></tr>";
				}
			}
		}
		$delcolumnhtml .= '</table>';

		echo "<p>以下 字段 與標準數據庫相比是多餘的:<br>您可以根據需要自行決定是否刪除</p>$delcolumnhtml";
	}

	if(empty($deltables) && empty($delcolumns)) {
		echo "<p>與標準數據庫相比，沒有需要刪除的數據表和字段</p><a href=\"update.php?step=cache\">請點擊進入下一步站點緩存更新操作</a></p>";
	} else {
		echo "<p><input type=\"submit\" name=\"delsubmit\" value=\"提交刪除\"></p><p>您也可以忽略多餘的表和字段<br><a href=\"update.php?step=cache\">直接進入下一步站點緩存更新操作</a></p>";
	}
	echo '<input type="hidden" name="formhash" value="'.formhash().'"></form>';

	show_footer();
	exit();

}elseif ($_GET['step'] == 'cache') {
	
	//打開站點
	if($_SCONFIG['close']) {
		$_SGLOBAL['db']->query("REPLACE INTO ".tname('config')." (var, datavalue) VALUES ('close', '0')");
	}
	
	//更新此次升級數據庫ver
	$_SGLOBAL['db']->query("REPLACE INTO ".tname('config')." (var, datavalue) VALUES ('update_release', '".X_RELEASE."')");
	
	//更新緩存
	include_once(S_ROOT.'./source/function_cache.php');

	//配置緩存
	config_cache();
	usergroup_cache();
	profilefield_cache();
	profield_cache();
	censor_cache();
	block_cache();
	eventclass_cache();
	magic_cache();
	click_cache();
	task_cache();
	ad_cache();
	creditrule_cache();
	userapp_cache();
	//app_cache();
	network_cache();
	
	//模板
	tpl_cache();
	
	//模塊
	block_data_cache();
	
	//緩存文件
	$fiels = sreaddir(S_ROOT.'./data', array('txt'));
	foreach ($fiels as $value) {
		@unlink(S_ROOT.'./data/'.$value);
	}

	//寫log
	if(@$fp = fopen($lockfile, 'w')) {
		fwrite($fp, 'UCenter Home');
		fclose($fp);
	}

	show_msg('恭喜，升級完成！注意：為了您的數據安全，請立即登錄服務器FTP刪除本升級文件!');
}


//正則匹配,獲取字段/索引/關鍵字信息
function getcolumn($creatsql) {

	preg_match("/\((.+)\)/is", $creatsql, $matchs);

	$cols = explode("\n", $matchs[1]);
	$newcols = array();
	foreach ($cols as $value) {
		$value = trim($value);
		if(empty($value)) continue;
		$value = remakesql($value);//特使字符替換
		if(substr($value, -1) == ',') $value = substr($value, 0, -1);//去掉末尾逗號

		$vs = explode(' ', $value);
		$cname = $vs[0];

		if(strtoupper($cname) == 'KEY') {
			$subvalue = trim(substr($value, 3));
			$subvs = explode(' ', $subvalue);
			$subcname = $subvs[0];
			$newcols['KEY'][$subcname] = trim(substr($value, (5+strlen($subcname))));
		} elseif(strtoupper($cname) == 'INDEX') {
			$subvalue = trim(substr($value, 5));
			$subvs = explode(' ', $subvalue);
			$subcname = $subvs[0];
			$newcols['KEY'][$subcname] = trim(substr($value, (7+strlen($subcname))));
		} elseif(strtoupper($cname) == 'PRIMARY') {
			$newcols['PRIMARY'] = trim(substr($value, 11));
		} else {
			$newcols[$cname] = trim(substr($value, strlen($cname)));
		}
	}
	return $newcols;
}

//整理sql文
function remakesql($value) {
	$value = trim(preg_replace("/\s+/", ' ', $value));//空格標準化
	$value = str_replace(array('`',', ', ' ,', '( ' ,' )'), array('', ',', ',','(',')'), $value);//去掉無用符號
	$value = preg_replace('/(text NOT NULL) default \'\'/i',"\\1", $value);//去掉無用符號
	return $value;
}

//顯示
function show_msg($message, $url_forward='') {
	global $_SGLOBAL;

	obclean();

	if($url_forward) {
		$_SGLOBAL['extrahead'] = '<meta http-equiv="refresh" content="1; url='.$url_forward.'">';
		$message = "<a href=\"$url_forward\">$message(跳轉中...)</a>";
	} else {
		$_SGLOBAL['extrahead'] = '';
	}

	show_header();
	print<<<END
	<table>
	<tr><td>$message</td></tr>
	</table>
END;
	show_footer();
	exit();
}


//頁面頭部
function show_header() {
	global $_SGLOBAL, $_SC;

	$nowarr = array($_GET['step'] => ' class="current"');

	if(empty($_SGLOBAL['extrahead'])) $_SGLOBAL['extrahead'] = '';

	print<<<END
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<meta http-equiv="Content-Type" content="text/html; charset=$_SC[charset]" />
	$_SGLOBAL[extrahead]
	<title> UCenter Home 數據庫升級程序 </title>
	<style type="text/css">
	* {font-size:12px; font-family: Verdana, Arial, Helvetica, sans-serif; line-height: 1.5em; word-break: break-all; }
	body { text-align:center; margin: 0; padding: 0; background: #F5FBFF; }
	.bodydiv { margin: 40px auto 0; width:720px; text-align:left; border: solid #86B9D6; border-width: 5px 1px 1px; background: #FFF; }
	h1 { font-size: 18px; margin: 1px 0 0; line-height: 50px; height: 50px; background: #E8F7FC; color: #5086A5; padding-left: 10px; }
	#menu {width: 100%; margin: 10px auto; text-align: center; }
	#menu td { height: 30px; line-height: 30px; color: #999; border-bottom: 3px solid #EEE; }
	.current { font-weight: bold; color: #090 !important; border-bottom-color: #F90 !important; }
	.showtable { width:100%; border: solid; border-color:#86B9D6 #B2C9D3 #B2C9D3; border-width: 3px 1px 1px; margin: 10px auto; background: #F5FCFF; }
	.showtable td { padding: 3px; }
	.showtable strong { color: #5086A5; }
	.datatable { width: 100%; margin: 10px auto 25px; }
	.datatable td { padding: 5px 0; border-bottom: 1px solid #EEE; }
	input { border: 1px solid #B2C9D3; padding: 5px; background: #F5FCFF; }
	.button { margin: 10px auto 20px; width: 100%; }
	.button td { text-align: center; }
	.button input, .button button { border: solid; border-color:#F90; border-width: 1px 1px 3px; padding: 5px 10px; color: #090; background: #FFFAF0; cursor: pointer; }
	#footer { font-size: 10px; line-height: 40px; background: #E8F7FC; text-align: center; height: 38px; overflow: hidden; color: #5086A5; margin-top: 20px; }
	</style>
	<script src="source/script_ajax.js" type="text/javascript" language="javascript"></script>
	<script src="source/script_common.js" type="text/javascript" language="javascript"></script>
	</head>
	<body>
	<div class="bodydiv">
	<h1>UCenter Home 數據庫升級工具</h1>
	<div style="width:90%;margin:0 auto;">
	<table id="menu">
	<tr>
	<td{$nowarr[start]}>升級開始</td>
	<td{$nowarr[sql]}>數據庫結構升級</td>
	<td{$nowarr[data]}>數據升級</td>
	<td{$nowarr[delete]}>數據庫結構刪除</td>
	<td{$nowarr[cache]}>升級完成</td>
	</tr>
	</table>
	<br>
END;
}

//頁面頂部
function show_footer() {
	print<<<END
	</div>
	<div id="footer">&copy; Comsenz Inc. 2001-2009 http://u.discuz.net</div>
	</div>
	<br>
	</body>
	</html>
END;
}

function get_uc_root() {
	$uc_root = '';
	$uc = parse_url(UC_API);
	if($uc['host'] == $_SERVER['HTTP_HOST']) {
		$php_self_len = strlen($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);
		$uc_root = substr(__FILE__, 0, -$php_self_len).$uc['path'];
	}
	return $uc_root;
}


?>
