<?php
!defined('P_W') && exit('Forbidden');

class postModify {

	var $db;
	var $post;
	var $forum;
	var $postdata = null;

	var $type;
	var $data;
	var $att;

	var $tid;
	var $pid;

	var $atcdb = array();
	var $oldattach = array();
	var $delattach = array();
	var $alterattach = array();
	var $replacedb = array();

	function postModify($tid, $pid, &$post) {
		global $db;
		$this->tid = $tid;
		$this->pid = $pid;

		$this->db =& $db;
		$this->post =& $post;
		$this->forum =& $post->forum;
	}

	function init() {
		$this->atcdb = $this->getData();
		if ($this->atcdb['aid']) {
			$pw_attachs = L::loadDB('attachs');
			$this->atcdb['attachs'] = $pw_attachs->getByTid($this->tid,$this->pid);
		} else {
			$this->atcdb['attachs'] = array();
		}
		return $this->atcdb;
	}

	function hasAtt() {
		return !empty($this->atcdb['attachs']);
	}

	function initAttachs($keep, $oldatt_special, $oldatt_needrvrc, $oldatt_ctype, $oldatt_desc) {
		global $db_enhideset,$db_sellset,$db_attachnum;
		$keep = (array)$keep;
		$oldattach = $this->atcdb['attachs'];
		foreach ($oldattach as $key => $value) {
			if (!in_array($key, $keep)) {
				$this->delattach[$key] = $value;
			} else {
				$v = array(
					'special'	=> $oldatt_special[$key],		'ctype'		=> $oldatt_ctype[$key],
					'needrvrc'	=> $oldatt_needrvrc[$key],		'desc'		=> $oldatt_desc[$key]
				);
				if ($v['needrvrc'] > 0 && ($v['special'] == 1 && $this->post->allowencode && in_array($v['ctype'],$db_enhideset['type']) || $v['special'] == 2 && $this->post->allowsell && in_array($v['ctype'],$db_sellset['type']))) {

				} else {
					$v['needrvrc'] = $v['special'] = 0;
					$v['ctype'] = '';
				}
				$oldattach[$key] = array_merge($oldattach[$key], $v);

				if (array_key_exists('replace_'.$key, $_FILES)) {
					$db_attachnum++;
					$this->replacedb[$key] = $oldattach[$key];
				} elseif ($value['needrvrc'] <> $v['needrvrc'] || $value['special'] <> $v['special'] || $value['ctype'] <> $v['ctype'] || $value['descrip'] <> $v['desc']) {
					$this->alterattach[$key] = $v;
				}
				$this->oldattach[$key] = $oldattach[$key];
			}
		}
	}

	function alterinfo() {
		if ($this->post->groupid != 3 && $this->atcdb['postdate'] + 300 < $GLOBALS['timestamp']) {
			global $altername,$db_anonymousname,$timeofedit,$timestamp;
			$altername = ($this->data['anonymous'] && $this->post->uid == $this->atcdb['authorid']) ? $db_anonymousname : $this->post->username;
			$timeofedit = get_date($timestamp);
			$alterinfo = getLangInfo('post','edit_post');
		} else {
			$alterinfo = '';
		}
		return $alterinfo;
	}

	function setPostData(&$postdata) {
		$this->postdata =& $postdata;
		$this->att =& $postdata->att;
		$this->data = $postdata->getData();

		if (is_object($postdata->tag)) {
			if ($this->data['tags'] != $this->atcdb['tags']) {
				$postdata->tag->update($this->tid);
			}
			$this->data['tags'] .= "\t" . $postdata->tag->relate($this->data['title'], $this->data['content']);
		}
		if ($this->att) {
			global $credit,$timestamp;
			if (is_object($credit)) {
				$credit->runsql();
			}
			$pwSQL = array('uploadtime' => $timestamp, 'uploadnum' => $this->post->user['uploadnum']);
			$this->db->update("UPDATE pw_memberdata SET " . pwSqlSingle($pwSQL) . ' WHERE uid=' . pwEscape($this->post->uid));
		}
		$this->oldattach && $this->data['aid'] += count($this->oldattach);
		$this->data['alterinfo'] = $this->alterinfo();
		if (!$this->data['anonymous']) {
			$this->data['lastposter'] = $this->atcdb['author'];
		}
	}

	function execute(&$postdata) {
		$this->setPostData($postdata);
		$this->update();
		$this->updateAtt();
		$this->editlog();
		$this->afterModify();
		$this->editFilter();
	}

	function editFilter() {
		if ($this->postdata->filter->filter_weight > 1) {
			$this->postdata->filter->insert($this->tid, $this->pid, implode(',',$this->postdata->filter->filter_word),$this->postdata->filter->filter_weight);
		} elseif (!$this->atcdb['ifcheck'] || !$this->atcdb['ifwordsfb']) {
			$this->postdata->filter->delete($this->tid, $this->pid);
		}
	}

	function updateAtt() {
		if ($this->delattach) {
			require_once(R_P.'require/updateforum.php');
			delete_att($this->delattach);
			pwFtpClose($GLOBALS['ftp']);
		}
		if ($this->alterattach) {
			$pw_attachs = L::loadDB('attachs');
			foreach ($this->alterattach as $aid => $v) {
				$pw_attachs->updateById($aid, array(
					'needrvrc'	=> $v['needrvrc'],
					'descrip'	=> $v['desc'],
					'special'	=> $v['special'],
					'ctype'		=> $v['ctype']
				));
			}
		}
		if (is_object($this->att) && ($aids = $this->att->getAids())) {
			$pw_attachs = L::loadDB('attachs');
			$pw_attachs->updateById($aids, array('tid' => $this->tid, 'pid' => $this->pid));
		}
	}

	function editlog() {
		if ($this->post->uid != $this->atcdb['authorid'] && ($this->post->isGM || pwRights($this->post->isBM, 'deltpcs'))) {
			/**
			* Ա༭ӵİȫռ
			*/
			global $timestamp,$onlineip;
			require_once(R_P.'require/writelog.php');
			$log = array(
				'type'      => 'edit',
				'username1' => $this->atcdb['author'],
				'username2' => $this->post->username,
				'field1'    => $this->forum->fid,
				'field2'    => '',
				'field3'    => '',
				'descrip'   => 'edit_descrip',
				'timestamp' => $timestamp,
				'ip'        => $onlineip,
				'tid'		=> $this->tid,
				'forum'		=> $this->forum->name,
				'subject'	=> substrs($this->data['title'], 28),
				'reason'	=> 'edit article'
			);
			writelog($log);
		}
	}
}

class topicModify extends postModify {

	var $pw_tmsgs;

	function topicModify($tid, $pid, &$post) {
		parent::postModify($tid, $pid, $post);
		$this->type = 'topic';
		$this->pw_tmsgs = GetTtable($this->tid);
	}

	function getData() {
		return $this->db->get_one("SELECT t.*,tm.content,tm.aid,tm.ifsign,tm.tags,tm.ifwordsfb,tm.magic FROM pw_threads t LEFT JOIN $this->pw_tmsgs tm USING(tid) WHERE t.tid=" . pwEscape($this->tid));
	}

	function resetData() {
		return array(
			'aid'		=> $this->atcdb['aid'],
			'ifsign'	=> $this->atcdb['ifsign'],
			'tags'		=> $this->atcdb['tags'],
			'content'	=> $this->atcdb['content'],
			'magic'		=> $this->atcdb['magic'],
			'icon'		=> $this->atcdb['icon'],
			'title'		=> $this->atcdb['subject'],
			'w_type'	=> $this->atcdb['type'],
			'ifupload'	=> $this->atcdb['ifupload'],
			'ifmail'	=> $this->atcdb['ifmail'],
			'anonymous'	=> $this->atcdb['anonymous'],
			'ifmagic'	=> $this->atcdb['ifmagic'],
			'hideatt'	=> $this->atcdb['ifhide'],
			'tpcstatus'	=> $this->atcdb['tpcstatus']
		);
	}

	function update() {
		$pwSQL = array(
			'aid'		=> $this->data['aid'],
			'ifsign'	=> $this->data['ifsign'],
			'alterinfo'	=> $this->data['alterinfo'],
			'tags'		=> $this->data['tags'],
			'ifconvert'	=> $this->data['convert'],
			'ifwordsfb'	=> $this->data['ifwordsfb'],
			'content'	=> $this->data['content'],
			'magic'		=> $this->data['magic']
		);
		if ($this->post->uid == $this->atcdb['authorid']) {
			global $onlineip;
			$ipTable = L::loadClass('IPTable');
			$pwSQL['userip'] = $onlineip;
			$pwSQL['ipfrom'] = $ipTable->getIpFrom($onlineip);
		}
		$this->db->update("UPDATE $this->pw_tmsgs SET " . pwSqlSingle($pwSQL) . " WHERE tid=" . pwEscape($this->tid));

		$pwSQL = array(
			'icon'		=> $this->data['icon'],
			'subject'	=> $this->data['title'],
			'type'		=> $this->data['w_type'],
			'ifupload'	=> $this->data['ifupload'],
			'ifmail'	=> $this->data['ifmail'],
			'anonymous'	=> $this->data['anonymous'],
			'ifmagic'	=> $this->data['ifmagic'],
			'ifhide'	=> $this->data['hideatt'],
			'ifcheck'	=> $this->data['ifcheck'],
			'tpcstatus' => $this->data['tpcstatus'],
		);
		if ($this->data['anonymous'] != $this->atcdb['anonymous'] && $this->atcdb['postdate'] == $this->atcdb['lastpost']) {
			$pwSQL['lastposter'] = $this->data['lastposter'];
		}
		$this->db->update("UPDATE pw_threads SET " . pwSqlSingle($pwSQL) . " WHERE tid=" . pwEscape($this->tid));
	}

	function afterModify() {
		global $db_ifpwcache;

		if (($db_ifpwcache & 512) && $this->att && $this->att->elementpic) {
			$elementpic = $this->att->elementpic;
			require_once(R_P . 'lib/elementupdate.class.php');
			$elementupdate = new ElementUpdate($this->forum->fid);
			$elementupdate->newPicUpdate($elementpic['aid'], $this->forum->fid, $this->tid, $elementpic['attachurl'], '', $this->data['content']);
			$elementupdate->updateSQL();
		}
		//End elementupdate

		if ($this->data['ifcheck'] && $this->forum->foruminfo['allowhtm'] && !$this->forum->foruminfo['cms']) {
			$StaticPage = L::loadClass('StaticPage');
			$StaticPage->update($this->tid);
		}
		if ($this->data['ifcheck'] != $this->atcdb['ifcheck']) {
			$this->forum->lastinfo('topic', ($this->atcdb['ifcheck'] == 1 ? '-' : '+'));
		}
		$this->updateForumsextra();

		$threads = L::loadClass('Threads');
		$threads->delThreads($this->tid);
	}

	function updateForumsextra() {
		if ($this->forum->foruminfo['commend']) {
			$commend = $this->forum->foruminfo['commend'];
			$ifchange = 0;
			foreach ($commend as $key => $value) {
				if ($value['tid'] == $this->tid && $value['subject'] != $this->data['title']) {
					$commend[$key]['subject'] = $this->data['title'];
					$ifchange = 1;
				}
			}
			if ($ifchange) {
				$this->db->update("UPDATE pw_forumsextra SET commend = ".pwEscape(serialize($commend))." WHERE fid=" . $this->forum->fid);
				require_once(R_P.'admin/cache.php');
				updatecache_forums($this->forum->fid);
			}
		}
	}
}

class replyModify extends postModify {

	var $pw_tmsgs;
	var $pw_posts;

	function replyModify($tid, $pid, &$post) {
		parent::postModify($tid, $pid, $post);
		$this->type = 'reply';
		$this->pw_posts = GetPtable('N', $tid);
	}

	function getData() {
		return $this->db->get_one("SELECT * FROM $this->pw_posts WHERE pid=" . pwEscape($this->pid));
	}

	function resetData() {
		return array(
			'aid'		=> $this->atcdb['aid'],
			'ifsign'	=> $this->atcdb['ifsign'],
			'content'	=> $this->atcdb['content'],
			'icon'		=> $this->atcdb['icon'],
			'title'		=> $this->atcdb['subject'],
			'anonymous'	=> $this->atcdb['anonymous'],
			'hideatt'	=> $this->atcdb['ifhide']
		);
	}

	function update() {
		$pwSQL = array(
			'aid'		=> $this->data['aid'],
			'icon'		=> $this->data['icon'],
			'subject'	=> $this->data['title'],
			'ifsign'	=> $this->data['ifsign'],
			'alterinfo'	=> $this->data['alterinfo'],
			'ifconvert'	=> $this->data['convert'],
			'ifwordsfb'	=> $this->data['ifwordsfb'],
			'content'	=> $this->data['content'],
			'anonymous'	=> $this->data['anonymous'],
			'ifhide'	=> $this->data['hideatt'],
			'ifcheck'	=> $this->data['ifcheck']
		);
		if ($this->post->uid == $this->atcdb['authorid']) {
			global $onlineip;
			$ipTable = L::loadClass('IPTable');
			$pwSQL['userip'] = $onlineip;
			$pwSQL['ipfrom'] = $ipTable->getIpFrom($onlineip);
		}
		$this->db->update("UPDATE $this->pw_posts SET " . pwSqlSingle($pwSQL) . " WHERE pid=" . pwEscape($this->atcdb['pid']));
	}

	function afterModify() {
		global $page;
		$replies = '';
		$pwSQL = array();
		if ($this->data['anonymous'] != $this->atcdb['anonymous']) {
			$lt = $this->db->get_one("SELECT pid FROM $this->pw_posts WHERE tid=" . pwEscape($this->tid) . " ORDER BY postdate DESC LIMIT 1");
			if ($this->pid == $lt['pid']) {
				$pwSQL['lastposter'] = $this->data['lastposter'];
			}
		}
		$this->data['ifupload'] && $pwSQL['ifupload'] = $this->data['ifupload'];

		if ($this->data['ifcheck'] && $this->forum->foruminfo['allowhtm'] && !$this->forum->foruminfo['cms'] && $page == 1) {
			$StaticPage = L::loadClass('StaticPage');
			$StaticPage->update($this->tid);
		}
		if ($this->data['ifcheck'] != $this->atcdb['ifcheck']) {
			$action = ($this->atcdb['ifcheck'] == 1) ? '-' : '+';
			$this->forum->lastinfo('reply', $action);
			$replies = "replies=replies{$action}'1'";
		}
		if ($pwSQL || $replies) {
			$sql = trim(pwSqlSingle($pwSQL) . ',' . $replies, ',');
			$this->db->update("UPDATE pw_threads SET $sql WHERE tid=" . pwEscape($this->tid));
		}
	}
}
?>