<?php

// uc_client ĸĿ¼
define('UC_CLIENT_ROOT', dirname(__FILE__) . '/');
// uc_client ʹõ lib ڵĿ¼
// define('UC_LIB_ROOT', dirname(__FILE__) . '/../lib/');
// uc_client İ汾
define('UC_CLIENT_VERSION', '0.1.0');
// uc_client ʹõAPI淶
define('UC_CLIENT_API', '20090609');

/**
 û¼
  @param  string $username   - û
  @param  string $pwd        - (md5)
  @param  int $logintype     - ¼ 0,1,2ֱΪ û,uid,¼
  @param  boolean $checkques - ǷҪ֤ȫ
  @param  string $question   - ȫ
  @param  string $answer     - ȫش
  @return array ͬ¼Ĵ
*/
function uc_user_login($username, $password, $logintype, $checkques = 0, $question = '', $answer = '') {
	return uc_data_request('user', 'login', array($username, $password, $logintype, $checkques, $question, $answer));
}

/**
 ͬ˳
  @return string ͬ˳Ĵ
*/
function uc_user_synlogout() {
	return uc_data_request('user', 'synlogout');
}

/**
 ע
  @param  string $username - עû
  @param  string $password - ע(md5)
  @param  string $email	   - 
  @return int עûuid
*/
function uc_user_register($username, $password, $email) {
	$args = func_get_args();
	return uc_data_request('user', 'register', $args);
}
/**
 ȡûϢ
  @param  string $username - û
  @param  int $bytype - ȡʽ 0,1,2ֱΪ û,uid,
  @return array uid,û,
*/
function uc_user_get($username, $bytype = 0) {
	return uc_data_request('user', 'get', array($username, $bytype));
}

/**
 ֤
  @param  string $uid - û
  @checkstr string password - uc_key+passwrord
  @return array uid,û,,
*/
function uc_user_check($uid, $checkstr) {
	$args = func_get_args();
	return uc_data_request('user', 'check', $args);
}

/**
 ༭û
  @param  int $uid - ûuid
  @param  string $oldname - ԭû
  @param  string $newname - û
  @param  string $pwd - 
  @param  string $email - 
*/
function uc_user_edit($uid, $oldname, $newname, $pwd, $email) {
	return uc_data_request('user', 'edit', array($uid, $oldname, $newname, $pwd, $email));
}

/**
 ɾָ uid û
  @param  mixed $uids - ûuidУֵ֧uid,uidá,ַ
  @param  int $del
*/
function uc_user_delete($uids) {
	return uc_data_request('user', 'delete', array($uids));
}

/**
 * Ӻ
 *
 * @param  int    $uid      - ûid
 * @param  int    $friendid - id
 * @param  string $descrip  - 
 * @return boolean          - ɹ trueʧܷ false
 */
function uc_friend_add($uid, $friendid, $descrip) {
    $args = func_get_args();
    return uc_data_request('friend', 'add', $args);
}

/**
 * ɾ
 *
 * @param  int   $uid       - ûid
 * @param  array $friendids - Ҫɾĺidбá,
 * @return boolean          - ɹ trueʧܷ false
 */
function uc_friend_delete($uid, $friendids) {
    $args = func_get_args();
    return uc_data_request('friend', 'delete', $args);
}

/**
 * ȡѸ
 *
 * @param  int $uid    - ûid
 * @param  int $status - ״̬-1Ϊȫ0Ϊδ֤1Ϊ֤
 * @return int         - غѸ
 */
function uc_friend_totalnum($uid, $status = -1) {
    return uc_data_request('friend', 'totalnum', array($uid, $status));
}

/**
 * ȡб
 *
 * @param  int $uid     - ûid
 * @param  int $page    - ҳ
 * @param  int $perpage - ÿҳʾ
 * @param  int $status  - ״̬-1Ϊȫ0Ϊδ֤1Ϊ֤
 * @return array
 */
function uc_friend_list($uid, $page, $perpage, $status) {
    $args = func_get_args();
    return uc_data_request('friend', 'get_list', $args);
}

/**
 * Ӻѵĳ
 *
 * @param  int $ftid
 * @param  int $uid
 * @param  int $friendid
 * @return boolean
 */
function uc_friend_add_type($ftid, $uid, $friendid) {
    $args = func_get_args();
    return uc_data_request('friend', 'add_type', $args);
}

/**
 * ½ѷ
 *
 * @param  int $uid
 * @param  string $name
 * @return boolean
 */
function uc_friend_type_create($uid, $name) {
    $args = func_get_args();
    return uc_data_request('friend_type', 'create', $args);
}

/**
 * ɾѷ
 *
 * @param  int $uid
 * @param  int $ftid
 * @return boolean
 */
function uc_friend_type_delete($uid, $ftid) {
    $args = func_get_args();
    return uc_data_request('friend_type', 'delete', $args);
}

/***********
 * Ϣ *
 ***********/

/**
 * Ϣ
 *
 * @param  int    $fromuid  - id
 * @param  string $username - 
 * @param  int    $touid    - id
 * @param  string $title    - 
 * @param  string $content  - 
 * @param  bool   $save_to_sebox - Ƿ񱣴浽
 * @return boolean          - ɹ trueʧܷ false
 */
function uc_msg_send($fromuid, $username, $touid, $title, $content, $save_to_sebox) {
    $args = func_get_args();
    return uc_data_request('message', 'send', $args);
}

/**
 * ɾռϢ
 *
 * @param  string $id  - Ϣididʹá,磺3  1,2,3,4
 * @param  int $uid    - ûid
 * @return boolean     - ɹ trueʧܷ false
 */
function uc_msg_delete_rebox($ids, $uid) {
    $args = func_get_args();
    return uc_data_request('message', 'delete_rebox', $args);
}

/**
 * ɾϢ
 *
 * @param  string $id  - Ϣididʹá,磺3  1,2,3,4
 * @param  int $uid    - ûid
 * @return boolean     - ɹ trueʧܷ false
 */
function uc_msg_delete_sebox($ids, $uid) {
    $args = func_get_args();
    return uc_data_request('message', 'delete_sebox', $args);
}

/**
 * ȡռϢ
 *
 * @param  int $uid - ûid
 * @return int      - ռϢ
 */
function uc_msg_count_rebox($uid) {
    $args = func_get_args();
    return uc_data_request('message', 'count_rebox', $args);
}

/**
 * ȡϢ
 *
 * @param  int $uid - ûid
 * @return int      - Ϣ
 */
function uc_msg_count_sebox($uid) {
    $args = func_get_args();
    return uc_data_request('message', 'count_sebox', $args);
}

/**
 * ȡռϢб
 *
 * @param  int $uid          - ûid
 * @param  int $page         - ҳ
 * @param  int $num_per_page - ÿҳ¼
 * @return array|null        - ضӦҳĶά飬ҳû򷵻 null
 */
function uc_msg_rebox_list($uid, $page, $num_per_page) {
    $args = func_get_args();
    return uc_data_request('message', 'rebox_list', $args);
}

/**
 * ȡϢб
 *
 * @param  int $uid          - ûid
 * @param  int $page         - ҳ
 * @param  int $num_per_page - ÿҳ¼
 * @return array|null        - ضӦҳĶά飬ҳû򷵻 null
 */
function uc_msg_sebox_list($uid, $page, $num_per_page) {
    $args = func_get_args();
    return uc_data_request('message', 'sebox_list', $args);
}

/**
 * ȡռϢ
 *
 * @param  int $id    - Ϣid
 * @param  int $uid   - ûid
 * @return array|null - 飬Ϣڣ򷵻 null
 */
function uc_msg_get_rebox($id, $uid) {
    $args = func_get_args();
    return uc_data_request('message', 'get_rebox', $args);
}

/**
 * ȡϢ
 *
 * @param  int $id    - Ϣid
 * @param  int $uid   - ûid
 * @return array|null - 飬Ϣڣ򷵻 null
 */
function uc_msg_get_sebox($id, $uid) {
    $args = func_get_args();
    return uc_data_request('message', 'get_sebox', $args);
}

/**
 * ȺϢ
 *
 * @param  string $title   - 
 * @param  string $content - 
 * @return boolean         - ɹ trueʧܷ false
 */
function uc_msg_send_public($title, $content) {
    $args = func_get_args();
    return uc_data_request('message', 'send_public', $args);
}

/**
 * ɾȺϢ
 *
 * @param  string $ids
 * @param  int    $uid
 * @return boolean
 */
function uc_msg_delete_public($ids, $uid) {
    $args = func_get_args();
    return uc_data_request('message', 'delete_public', $args);
}

/**
 * ȡϢб
 *
 * @param  int $uid
 * @param  int $gid
 * @param  int $regdate
 * @return array|null
 */
function uc_msg_public_list($uid, $gid, $regdate) {
    $args = func_get_args();
    return uc_data_request('message', 'public_list', $args);
}

/**
 * ȡϢ
 *
 * @param  int $mid
 * @return array|null
 */
function uc_msg_get_public($mid) {
    $args = func_get_args();
    return uc_data_request('message', 'get_public', $args);
}

/**
 û
  @param  array $credit array($uid1 => array($ctype1 => $point1, $ctype2 => $point2), $uid2 => array())
  return array
 */
function uc_credit_add($credit, $isAdd = true) {
	return uc_data_request('credit', 'add', array($credit, $isAdd));
}

function uc_credit_get($uid) {
	return uc_data_request('credit', 'get', array($uid));
}

function uc_data_request($class,$method,$args = array()) {
	static $uc = null;
	if (empty($uc)) {
		require_once UC_CLIENT_ROOT . 'class_core.php';
		$uc = new UC();
	}
	$class = $uc->control($class);

	if (method_exists($class, $method)) {
		return call_user_func_array(array(&$class, $method), $args);
	} else {
		return 'error';
	}
}
?>