
/*Table structure for table `isns_admin` */

DROP TABLE IF EXISTS `isns_admin`;

CREATE TABLE `isns_admin` (
  `admin_id` tinyint(2) NOT NULL auto_increment,
  `admin_name` varchar(20) NOT NULL,
  `admin_password` varchar(50) NOT NULL,
  `admin_role` tinyint(2) NOT NULL,
  `active_time` datetime default NULL,
  PRIMARY KEY  (`admin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


/*Table structure for table `isns_album` */

DROP TABLE IF EXISTS `isns_album`;

CREATE TABLE `isns_album` (
  `album_id` int(10) NOT NULL auto_increment,
  `album_name` varchar(20) default NULL,
  `user_id` int(10) NOT NULL,
  `user_name` varchar(20) default NULL,
  `album_information` text,
  `add_time` datetime default NULL,
  `album_skin` varchar(150) default NULL,
  `album_secret` tinyint(2) default NULL,
  `photo_num` int(4) default '0',
  `album_pass` tinyint(2) default '1',
  `comments` int(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`album_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_album_comment` */

DROP TABLE IF EXISTS `isns_album_comment`;

CREATE TABLE `isns_album_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  `album_id` int(10) NOT NULL,
  `visitor_id` int(10) NOT NULL,
  `host_id` int(10) NOT NULL,
  `visitor_name` varchar(20) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `readed` tinyint(2) default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `album_id` (`album_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_blog` */

DROP TABLE IF EXISTS `isns_blog`;

CREATE TABLE `isns_blog` (
  `log_id` int(10) NOT NULL auto_increment,
  `user_id` int(10) default NULL,
  `user_name` varchar(20) default NULL,
  `user_ico` varchar(150) default NULL,
  `log_title` varchar(80) default NULL,
  `log_sort` int(10) NOT NULL default '0',
  `log_pass` tinyint(2) NOT NULL default '1',
  `log_sort_name` varchar(30) default NULL,
  `log_content` text,
  `add_time` datetime default NULL,
  `edit_time` datetime default NULL,
  `hits` int(10) default '0',
  `comments` int(5) unsigned NOT NULL default '0',
  `blog_limit` tinyint(2) default '0',
  PRIMARY KEY  (`log_id`),
  KEY `user_id` (`user_id`),
  KEY `log_sort` (`log_sort`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_blog_comment` */

DROP TABLE IF EXISTS `isns_blog_comment`;

CREATE TABLE `isns_blog_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  `visitor_id` int(10) NOT NULL,
  `log_id` int(10) NOT NULL,
  `host_id` int(10) NOT NULL,
  `visitor_name` varchar(20) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `readed` tinyint(2) default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `log_id` (`log_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_blog_sort` */

DROP TABLE IF EXISTS `isns_blog_sort`;

CREATE TABLE `isns_blog_sort` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(20) default NULL,
  `user_id` int(10) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_config` */

DROP TABLE IF EXISTS `isns_config`;

CREATE TABLE `isns_config` (
  `k` varchar(30) NOT NULL,
  `v` text,
  PRIMARY KEY  (`k`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `isns_config` */

insert  into `isns_config`(`k`,`v`) values ('title','聚易網'),('key_words','iwebSNS'),('desc','iwebSNS'),('copyright','2010版权所有www.jooyea.net'),('lp_settiing','ft'),('off_info','本網站目前正在維護中,請稍後再來訪問'),('offline','0'),('admin_email',''),('lib_path','iweb_mini_lib/'),('allow_refresh_time','1'),('delay_time','5'),('update_cache_time','0'),('min_year','1950'),('max_year','2000'),('perpage_num','20'),('manager_num','3'),('creat_group_limit','3'),('home_affair_num','10'),('index_affair_num','20'),('error_report','0'),('author',''),('templates','default'),('skin','default/jooyea'),('ctrl_cache','1'),('reg_info',''),('domain_remark',''),('site_domain','http://localhost/iweb_sns/'),('filtrate',''),('ctrl_filt','1'),('tpl_compile_type','serve'),('sess_prefix','isns_');

/*Table structure for table `isns_data_count` */

DROP TABLE IF EXISTS `isns_data_count`;

CREATE TABLE `isns_data_count` (
  `id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `blog_num` int(5) unsigned NOT NULL default '0',
  `group_num` int(5) unsigned NOT NULL default '0',
  `msg_num` int(5) unsigned NOT NULL default '0',
  `mood_num` int(5) unsigned NOT NULL default '0',
  `poll_num` int(5) unsigned NOT NULL default '0',
  `scrip_num` int(5) unsigned NOT NULL default '0',
  `photo_num` int(5) unsigned NOT NULL default '0',
  `share_num` int(5) unsigned NOT NULL default '0',
  `hi_num` int(5) unsigned NOT NULL default '0',
  `pals_num` int(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_group_members` */

DROP TABLE IF EXISTS `isns_group_members`;

CREATE TABLE `isns_group_members` (
  `id` int(10) NOT NULL auto_increment,
  `group_id` int(10) default NULL,
  `user_id` int(10) NOT NULL,
  `user_name` varchar(20) default NULL,
  `user_sex` tinyint(2) default NULL,
  `user_ico` varchar(150) default NULL,
  `state` tinyint(2) default NULL,
  `role` tinyint(2) default '2',
  `add_time` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_group_subject` */

DROP TABLE IF EXISTS `isns_group_subject`;

CREATE TABLE `isns_group_subject` (
  `subject_id` int(10) NOT NULL auto_increment,
  `group_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `user_name` varchar(20) default NULL,
  `user_ico` varchar(150) default NULL,
  `title` varchar(50) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `hits` int(10) default '0',
  `comments` int(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`subject_id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_group_subject_comment` */

DROP TABLE IF EXISTS `isns_group_subject_comment`;

CREATE TABLE `isns_group_subject_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  `group_id` int(10) NOT NULL,
  `host_id` int(10) NOT NULL,
  `subject_id` int(10) NOT NULL,
  `visitor_id` int(10) NOT NULL,
  `visitor_name` varchar(20) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `readed` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `subject_id` (`subject_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_group_type` */

DROP TABLE IF EXISTS `isns_group_type`;

CREATE TABLE `isns_group_type` (
  `id` int(10) NOT NULL auto_increment,
  `order_num` int(10) default NULL,
  `name` varchar(20) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_groups` */

DROP TABLE IF EXISTS `isns_groups`;

CREATE TABLE `isns_groups` (
  `group_id` int(10) NOT NULL auto_increment,
  `add_userid` int(10) NOT NULL,
  `group_pass` tinyint(2) NOT NULL default '1',
  `member_count` int(10) NOT NULL default '1',
  `group_name` varchar(50) default NULL,
  `group_resume` varchar(100) default NULL,
  `group_time` datetime default NULL,
  `group_manager_name` varchar(60) default NULL,
  `group_manager_id` varchar(20) default NULL,
  `group_req_id` varchar(800) default NULL,
  `group_creat_name` varchar(20) default NULL,
  `group_logo` varchar(150) default NULL,
  `group_join_type` tinyint(2) NOT NULL default '0',
  `group_type` varchar(20) default NULL,
  `group_type_id` int(10) default NULL,
  `affiche` varchar(200) default NULL,
  `group_tag` varchar(50) default NULL,
  `subjects_num` int(10) NOT NULL default '0',
  `comments` int(10) NOT NULL default '0',
  PRIMARY KEY  (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_guest` */

DROP TABLE IF EXISTS `isns_guest`;

CREATE TABLE `isns_guest` (
  `guest_id` int(10) NOT NULL auto_increment,
  `guest_user_id` int(10) NOT NULL,
  `guest_user_name` varchar(20) default NULL,
  `guest_user_ico` varchar(150) default NULL,
  `user_id` int(10) NOT NULL,
  `add_time` datetime default NULL,
  PRIMARY KEY  (`guest_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_hi` */

DROP TABLE IF EXISTS `isns_hi`;

CREATE TABLE `isns_hi` (
  `hi_id` int(10) NOT NULL auto_increment,
  `from_user_id` int(10) NOT NULL,
  `from_user_name` varchar(20) default NULL,
  `from_user_ico` varchar(150) default NULL,
  `hi` tinyint(2) default NULL,
  `to_user_id` int(10) NOT NULL,
  `add_time` datetime default NULL,
  `readed` tinyint(2) default '0',
  PRIMARY KEY  (`hi_id`),
  KEY `to_user_id` (`to_user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_integral` */

DROP TABLE IF EXISTS `isns_integral`;

CREATE TABLE `isns_integral` (
  `operation` char(20) default NULL,
  `integral` int(10) default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `isns_integral` */

insert  into `isns_integral`(`operation`,`integral`) values ('blog',2),('photo',1),('com_sub',1),('subject',2),('com_msg',1),('login',10),('invited',20),('one_ico',40),('del_blog',-2),('del_photo',-1),('del_subject',-2),('del_com_msg',-1),('del_com_sub',-1),('convert',100),('upgrade',5),('poll',2),('del_poll',-2),('share',2),('del_share',-2);

/*Table structure for table `isns_mood` */

DROP TABLE IF EXISTS `isns_mood`;

CREATE TABLE `isns_mood` (
  `mood_id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `mood` text,
  `comments` int(5) unsigned NOT NULL default '0',
  `add_time` datetime default NULL,
  PRIMARY KEY  (`mood_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_mood_comment` */

DROP TABLE IF EXISTS `isns_mood_comment`;

CREATE TABLE `isns_mood_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `mood_id` int(10) NOT NULL,
  `host_id` int(10) NOT NULL,
  `visitor_id` int(10) NOT NULL,
  `visitor_name` varchar(20) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `mood_id` (`mood_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_msg_inbox` */

DROP TABLE IF EXISTS `isns_msg_inbox`;

CREATE TABLE `isns_msg_inbox` (
  `mess_id` int(10) NOT NULL auto_increment,
  `mess_title` varchar(70) default NULL,
  `mess_content` varchar(500) default NULL,
  `from_user_id` int(10) NOT NULL,
  `from_user` varchar(20) default NULL,
  `from_user_ico` varchar(150) default NULL,
  `user_id` int(10) NOT NULL,
  `add_time` datetime default NULL,
  `mesinit_id` int(10) default NULL,
  `readed` tinyint(2) default '0',
  PRIMARY KEY  (`mess_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_msg_outbox` */

DROP TABLE IF EXISTS `isns_msg_outbox`;

CREATE TABLE `isns_msg_outbox` (
  `mess_id` int(10) NOT NULL auto_increment,
  `mess_title` varchar(70) default NULL,
  `mess_content` varchar(500) default NULL,
  `to_user_id` int(10) NOT NULL,
  `to_user` varchar(20) default NULL,
  `to_user_ico` varchar(150) default NULL,
  `user_id` int(10) NOT NULL,
  `state` tinyint(2) default '0',
  `add_time` datetime default NULL,
  PRIMARY KEY  (`mess_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_msgboard` */

DROP TABLE IF EXISTS `isns_msgboard`;

CREATE TABLE `isns_msgboard` (
  `mess_id` int(10) NOT NULL auto_increment,
  `from_user_id` int(10) NOT NULL,
  `from_user_name` varchar(20) default NULL,
  `from_user_ico` varchar(150) default NULL,
  `message` text,
  `to_user_id` int(10) NOT NULL,
  `add_time` datetime default NULL,
  `readed` tinyint(2) default '0',
  PRIMARY KEY  (`mess_id`),
  KEY `to_user_id` (`to_user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_online` */

DROP TABLE IF EXISTS `isns_online`;

CREATE TABLE `isns_online` (
  `online_id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `user_name` varchar(20) default NULL,
  `user_sex` tinyint(2) default NULL,
  `user_ico` varchar(150) default NULL,
  `birth_year` varchar(6) default NULL,
  `birth_province` varchar(50) default NULL,
  `birth_city` varchar(50) default NULL,
  `reside_province` varchar(50) default NULL,
  `reside_city` varchar(50) default NULL,
  `active_time` varchar(20) default NULL,
  `hidden` tinyint(2) NOT NULL default '0',
  `session_code` text,
  PRIMARY KEY  (`online_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_pals_def_sort` */

DROP TABLE IF EXISTS `isns_pals_def_sort`;

CREATE TABLE `isns_pals_def_sort` (
  `id` int(10) NOT NULL auto_increment,
  `order_num` int(10) default NULL,
  `name` varchar(20) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_pals_mine` */

DROP TABLE IF EXISTS `isns_pals_mine`;

CREATE TABLE `isns_pals_mine` (
  `id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `pals_id` int(10) NOT NULL,
  `pals_sort_id` int(10) NOT NULL default '0',
  `pals_sort_name` varchar(20) default NULL,
  `pals_name` varchar(20) default NULL,
  `pals_sex` tinyint(2) default NULL,
  `add_time` datetime default NULL,
  `pals_ico` varchar(150) default NULL,
  `accepted` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_pals_request` */

DROP TABLE IF EXISTS `isns_pals_request`;

CREATE TABLE `isns_pals_request` (
  `id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `req_id` int(10) NOT NULL,
  `req_name` varchar(20) default NULL,
  `req_sex` tinyint(2) default NULL,
  `add_time` datetime default NULL,
  `req_ico` varchar(150) default NULL,
  `from_id` int(10) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_pals_sort` */

DROP TABLE IF EXISTS `isns_pals_sort`;

CREATE TABLE `isns_pals_sort` (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(20) default NULL,
  `user_id` int(10) default NULL,
  `count` int(10) default '0',
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_photo` */

DROP TABLE IF EXISTS `isns_photo`;

CREATE TABLE `isns_photo` (
  `photo_id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `photo_name` varchar(20) default NULL,
  `photo_information` text,
  `add_time` datetime default NULL,
  `photo_src` varchar(150) default NULL,
  `photo_thumb_src` varchar(150) default NULL,
  `album_id` int(10) NOT NULL,
  `album_secret` tinyint(2) default '0',
  `photo_pass` tinyint(2) default '1',
  `comments` int(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`photo_id`),
  KEY `album_id` (`album_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_photo_comment` */

DROP TABLE IF EXISTS `isns_photo_comment`;

CREATE TABLE `isns_photo_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `photo_id` int(10) NOT NULL,
  `host_id` int(10) NOT NULL,
  `visitor_id` int(10) NOT NULL,
  `visitor_name` varchar(20) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `readed` tinyint(2) default '0',
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `photo_id` (`photo_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_poll` */

DROP TABLE IF EXISTS `isns_poll`;

CREATE TABLE `isns_poll` (
  `p_id` mediumint(8) unsigned NOT NULL auto_increment,
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `user_ico` varchar(150) default NULL,
  `subject` char(80) NOT NULL default '',
  `voternum` mediumint(8) unsigned NOT NULL default '0',
  `comments` int(5) unsigned NOT NULL default '0',
  `multiple` tinyint(2) NOT NULL default '0',
  `maxchoice` tinyint(3) NOT NULL default '0',
  `sex` tinyint(2) NOT NULL default '0',
  `noreply` tinyint(2) NOT NULL default '0',
  `credit` mediumint(8) unsigned NOT NULL default '0',
  `percredit` mediumint(8) unsigned NOT NULL default '0',
  `expiration` date default NULL,
  `lastvote` datetime default NULL,
  `dateline` datetime default NULL,
  `message` text,
  `summary` text,
  `option` text,
  `is_pass` tinyint(2) NOT NULL default '1',
  PRIMARY KEY  (`p_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_poll_comment` */

DROP TABLE IF EXISTS `isns_poll_comment`;

CREATE TABLE `isns_poll_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `visitor_id` int(10) default NULL,
  `visitor_name` varchar(20) default NULL,
  `p_id` int(10) default NULL,
  `host_id` int(10) default NULL,
  `add_time` datetime default NULL,
  `content` text,
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `p_id` (`p_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_polloption` */

DROP TABLE IF EXISTS `isns_polloption`;

CREATE TABLE `isns_polloption` (
  `oid` mediumint(8) unsigned NOT NULL auto_increment,
  `pid` mediumint(8) unsigned NOT NULL default '0',
  `votenum` mediumint(8) unsigned NOT NULL default '0',
  `option` varchar(100) default NULL,
  PRIMARY KEY  (`oid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_polluser` */

DROP TABLE IF EXISTS `isns_polluser`;

CREATE TABLE `isns_polluser` (
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `pid` mediumint(8) unsigned NOT NULL default '0',
  `option` text NOT NULL,
  `dateline` datetime default NULL,
  `anony` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`uid`,`pid`),
  KEY `pid` (`pid`,`dateline`),
  KEY `uid` (`uid`,`dateline`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `isns_recent_affair` */

DROP TABLE IF EXISTS `isns_recent_affair`;

CREATE TABLE `isns_recent_affair` (
  `id` int(10) NOT NULL auto_increment,
  `type_id` tinyint(2) default 0,
  `content` text,
  `user_id` int(10) NOT NULL,
  `user_name` varchar(20) default NULL,
  `user_ico` varchar(150) default NULL,
  `date_time` datetime default NULL,
  `update_time` datetime default NULL,
  `for_content_id` varchar(11) default 0,
  `mod_type` tinyint(2) default 0,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_recommend` */

DROP TABLE IF EXISTS `isns_recommend`;

CREATE TABLE `isns_recommend` (
  `recommend_id` int(10) NOT NULL auto_increment,
  `user_id` int(10) default NULL,
  `user_name` varchar(20) default NULL,
  `user_ico` varchar(150) default NULL,
  `user_pass` tinyint(2) default NULL,
  `guest_num` int(10) default NULL,
  `user_sex` tinyint(2) default NULL,
  `rec_class` tinyint(2) default '0',
  `rec_order` tinyint(2) default '0',
  `show_ico` varchar(150) default NULL,
  PRIMARY KEY  (`recommend_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_report` */

DROP TABLE IF EXISTS `isns_report`;

CREATE TABLE `isns_report` (
  `report_id` int(10) NOT NULL auto_increment,
  `user_id` int(10) default NULL,
  `reason` varchar(180) default NULL,
  `user_name` varchar(20) default NULL,
  `type` varchar(20) default NULL,
  `content` text,
  `add_time` datetime default NULL,
  `reported_id` int(10) default NULL,
  `ued_id` int(10) default NULL,
  `rep_num` int(6) default '1',
  PRIMARY KEY  (`report_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_share` */

DROP TABLE IF EXISTS `isns_share`;

CREATE TABLE `isns_share` (
  `s_id` int(10) NOT NULL auto_increment,
  `type_id` tinyint(2) default NULL,
  `user_id` int(10) default NULL,
  `user_name` varchar(20) default NULL,
  `user_ico` varchar(150) default NULL,
  `content` text,
  `s_title` varchar(150) default NULL,
  `out_link` varchar(255) default NULL,
  `add_time` datetime default NULL,
  `for_content_id` int(10) default NULL,
  `comments` int(10) NOT NULL default '0',
  `movie_thumb` varchar(255) default NULL,
  `movie_link` varchar(255) default NULL,
  `is_pass` tinyint(2) NOT NULL default '1',
  PRIMARY KEY  (`s_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_share_comment` */

DROP TABLE IF EXISTS `isns_share_comment`;

CREATE TABLE `isns_share_comment` (
  `comment_id` int(10) NOT NULL auto_increment,
  `visitor_id` int(10) default NULL,
  `visitor_name` varchar(20) default NULL,
  `s_id` int(10) default NULL,
  `host_id` int(10) default NULL,
  `add_time` datetime default NULL,
  `content` text,
  `visitor_ico` varchar(150) default NULL,
  `is_hidden` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`comment_id`),
  KEY `s_id` (`s_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_tmp_file` */

DROP TABLE IF EXISTS `isns_tmp_file`;

CREATE TABLE `isns_tmp_file` (
  `mod_id` int(10) NOT NULL,
  `mod_count` int(10) unsigned NOT NULL default '0',
  `affair_array` text,
  `data_array` text,
  PRIMARY KEY  (`mod_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `isns_tmp_file` */

/*Table structure for table `isns_uploadfile` */

DROP TABLE IF EXISTS `isns_uploadfile`;

CREATE TABLE `isns_uploadfile` (
  `id` int(10) NOT NULL auto_increment,
  `user_id` int(10) NOT NULL,
  `add_time` datetime default NULL,
  `file_src` varchar(150) default NULL,
  `file_name` varchar(80) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*Table structure for table `isns_users` */

DROP TABLE IF EXISTS `isns_users`;

CREATE TABLE `isns_users` (
  `user_id` int(10) NOT NULL auto_increment,
  `user_marry` tinyint(2) default NULL,
  `user_email` varchar(50) default NULL,
  `user_name` varchar(20) default NULL,
  `user_pws` varchar(50) default NULL,
  `user_sex` tinyint(2) default NULL,
  `user_call` varchar(30) default NULL,
  `birth_province` varchar(50) default NULL,
  `birth_city` varchar(50) default NULL,
  `reside_province` varchar(50) default NULL,
  `reside_city` varchar(50) default NULL,
  `user_ico` varchar(150) default NULL,
  `user_pass` tinyint(2) default '1',
  `user_add_time` datetime default NULL,
  `birth_year` char(6) default NULL,
  `birth_month` char(4) default NULL,
  `birth_day` char(4) default NULL,
  `user_blood` char(4) default NULL,
  `user_qq` varchar(15) default NULL,
  `creat_group` varchar(150) default NULL,
  `join_group` varchar(150) default NULL,
  `guest_num` int(10) default '0',
  `integral` int(7) default '10',
  `access_limit` tinyint(2) default '0',
  `access_questions` varchar(100) default NULL,
  `access_answers` varchar(100) default NULL,
  `inputmess_limit` tinyint(2) default '0',
  `palsreq_limit` tinyint(2) default '0',
  `lastlogin_datetime` datetime default NULL,
  `invite_from_uid` int(10) default NULL,
  `hidden_pals_id` text,
  `hidden_type_id` text,
  `is_recommend` tinyint(2) NOT NULL default '0',
  `dressup` VARCHAR( 20 ) default 0,
  `use_plugins` VARCHAR( 1000 ) default NULL,
  `use_apps` VARCHAR( 1000 ) default NULL,
  PRIMARY KEY  (`user_id`),
  UNIQUE KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `isns_remind`;

CREATE TABLE `isns_remind` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL,
  `type_id` tinyint(2) NOT NULL,
  `date` datetime NOT NULL,
  `content` varchar(200) DEFAULT NULL,
  `is_focus` tinyint(2) NOT NULL,
  `from_uid` int(10) NOT NULL,
  `from_uname` varchar(20) NOT NULL,
  `from_uico` varchar(150) NOT NULL,
  `link` varchar(150) NOT NULL,
  `count` int(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`is_focus`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `isns_plugins`;

CREATE TABLE `isns_plugins` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `csspath` varchar(255) DEFAULT NULL,
  `jspath` varchar(255) DEFAULT NULL,
  `valid` tinyint(2) DEFAULT '0',
  `callfunction` varchar(100) DEFAULT NULL,
  `autoorder` tinyint(2) DEFAULT '0',
  `type` tinyint(2) DEFAULT NULL,
  `inurl` varchar(255) DEFAULT NULL,
  `plugin_id` int(10) DEFAULT NULL,
  `reg_date` datetime NOT NULL,
  `image` varchar(150) NOT NULL,
  `comment_num` int(10) DEFAULT '0',
  `use_num` int(10) DEFAULT '0',
  `info` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

INSERT INTO `isns_group_type` (`id`, `order_num`, `name`) VALUES(1, 1, '时尚生活'),(2, 2, '影视天地'),(3, 3, '极品音乐'),(4, 4, '旅游天下'),(5, 5, '运动休闲'),(6, 6, '校园联盟'),(7, 7, '网络互联'),(8, 8, '至爱宠物'),(9, 9, '明星粉丝'),(10, 10, '文学艺术'),(11, 11, '同城同乡'),(12, 12, '两性情感'),(13, 13, '游戏动漫'),(14, 14, '投资理财'),(15, 15, '其他');

INSERT INTO `isns_pals_def_sort` (`id`, `order_num`, `name`) VALUES(1, 1, '同学'),(2, 2, '同事'),(3, 3, '亲人'),(4, 4, '好友');

INSERT INTO `isns_album` (`album_id`, `album_name`, `user_id`, `user_name`, `album_information`, `add_time`, `album_skin`, `album_secret`, `photo_num`, `album_pass`, `comments`) VALUES(1, '测试相册1', 1, '测试帐号1', '测试相册1', '2010-01-11 16:13:53', 'uploadfiles/album/2010/01/11/thumb_2010011104142239.jpg', 0, 1, 1, 0),(2, '测试相册2', 2, '测试帐号2', '测试相册2', '2010-01-11 16:15:44', 'uploadfiles/album/2010/01/11/thumb_2010011104155026.jpg', 0, 1, 1, 0);

INSERT INTO `isns_data_count` (`id`, `user_id`, `blog_num`, `group_num`, `msg_num`, `mood_num`, `poll_num`, `scrip_num`, `photo_num`, `share_num`, `hi_num`, `pals_num`) VALUES(1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),(2, 2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0);

INSERT INTO `isns_photo` (`photo_id`, `user_id`, `photo_name`, `photo_information`, `add_time`, `photo_src`, `photo_thumb_src`, `album_id`, `album_secret`, `photo_pass`, `comments`) VALUES(1, 1, '测试照片1', '测试照片1', '2010-01-11 16:14:23', 'uploadfiles/album/2010/01/11/2010011104142239.jpg', 'uploadfiles/album/2010/01/11/thumb_2010011104142239.jpg', 1, 0, 1, 0),(2, 2, '测试照片2', '测试照片2', '2010-01-11 16:15:50', 'uploadfiles/album/2010/01/11/2010011104155026.jpg', 'uploadfiles/album/2010/01/11/thumb_2010011104155026.jpg', 2, 0, 1, 0);

INSERT INTO `isns_recent_affair` (`id`, `type_id`, `content`, `user_id`, `user_name`, `user_ico`, `date_time`, `update_time`, `for_content_id`, `mod_type`) VALUES(1, 2, '在相册<a href="home.php?h=1&app=photo_list&album_id=1" target="_blank">测试相册1</a>中上传了图片</div>\r\n             <div class="listbody left"><span class="affair_photo"><a href="home.php?h=1&user_name=%E6%B5%8B%E8%AF%95%E6%95%B0%E6%8D%AE1&app=photo_view&photo_id=1&album_id=1" target="_blank"><img onerror=parent.pic_error(this) src="uploadfiles/album/2010/01/11/2010011104142239.jpg" width="100"></a></span><div class="listtime tool_2">{date_time}', 1, '测试帐号1', 'skin/default/jooyea/images/d_ico_0_small.gif', '2010-01-11 16:14:23', '2010-01-11 16:14:23', '1', 3),(2, 1, '头像更新为</div>\r\n<div class="listbody left"><img onerror=parent.pic_error(this) src="uploadfiles/album/2010/01/11/2010011104142239_ico.jpg" align="top"><div class="listtime tool_2">{date_time}', 1, '测试帐号1', 'uploadfiles/album/2010/01/11/2010011104142239_ico.jpg', '2010-01-11 16:14:53', '2010-01-11 16:14:53', '', 7),(3, 2, '在相册<a href="home.php?h=2&app=photo_list&album_id=2" target="_blank">测试相册2</a>中上传了图片</div>\r\n             <div class="listbody left"><span class="affair_photo"><a href="home.php?h=2&user_name=%E6%B5%8B%E8%AF%95%E5%B8%90%E5%8F%B72&app=photo_view&photo_id=2&album_id=2" target="_blank"><img onerror=parent.pic_error(this) src="uploadfiles/album/2010/01/11/2010011104155026.jpg" width="100"></a></span><div class="listtime tool_2">{date_time}', 2, '测试帐号2', 'skin/default/jooyea/images/d_ico_1_small.gif', '2010-01-11 16:15:50', '2010-01-11 16:15:50', '2', 3),(4, 1, '头像更新为</div>\r\n<div class="listbody left"><img onerror=parent.pic_error(this) src="uploadfiles/album/2010/01/11/2010011104155026_ico.jpg" align="top"><div class="listtime tool_2">{date_time}', 2, '测试帐号2', 'uploadfiles/album/2010/01/11/2010011104155026_ico.jpg', '2010-01-11 16:16:07', '2010-01-11 16:16:07', '', 7);

INSERT INTO `isns_users` (`user_id`, `user_marry`, `user_email`, `user_name`, `user_pws`, `user_sex`, `user_call`, `birth_province`, `birth_city`, `reside_province`, `reside_city`, `user_ico`, `user_pass`, `user_add_time`, `birth_year`, `birth_month`, `birth_day`, `user_blood`, `user_qq`, `creat_group`, `join_group`, `guest_num`, `integral`, `access_limit`, `access_questions`, `access_answers`, `inputmess_limit`, `palsreq_limit`, `lastlogin_datetime`, `invite_from_uid`, `hidden_pals_id`, `hidden_type_id`, `is_recommend`, `dressup`) VALUES(1, NULL, 'test1@jooyea.net', '测试帐号1', '96e79218965eb72c92a549dd5a330112', 0, NULL, NULL, NULL, NULL, NULL, 'uploadfiles/album/2010/01/11/2010011104142239_ico_small.jpg', 1, '2010-01-11 16:13:41', '', '', '', NULL, NULL, NULL, NULL, 0, 51, 0, NULL, NULL, 0, 0, '2010-01-11 16:13:41', 0, NULL, NULL, 1, '0'),(2, NULL, 'test2@jooyea.net', '测试帐号2', 'e3ceb5881a0a1fdaad01296d7554868d', 1, NULL, NULL, NULL, NULL, NULL, 'uploadfiles/album/2010/01/11/2010011104155026_ico_small.jpg', 1, '2010-01-11 16:15:35', '', '', '', NULL, NULL, NULL, NULL, 0, 51, 0, NULL, NULL, 0, 0, '2010-01-11 16:38:13', 0, NULL, NULL, 1, '0');

INSERT INTO `isns_recommend` (`recommend_id`, `user_id`, `user_name`, `user_ico`, `user_pass`, `guest_num`, `user_sex`, `rec_class`, `rec_order`, `show_ico`) VALUES(1, 2, '测试帐号2', 'uploadfiles/album/2010/01/11/2010011104155026_ico_small.jpg', 1, 0, 1, 1, 0, 'uploadfiles/album/2010/01/11/2010011104155026_index.jpg'),(2, 1, '测试帐号1', 'uploadfiles/album/2010/01/11/2010011104142239_ico_small.jpg', 1, 0, 0, 1, 0, 'uploadfiles/album/2010/01/11/2010011104142239_index.jpg');
