<?php
	require("session_check.php");	
	require("../foundation/fpages_bar.php");
	require("../foundation/fcontent_format.php");
	
	//数据表定义区
	$t_affair=$tablePreStr."recent_affair";

	$dbo = new dbex;
	dbtarget('w',$dbServs);
	
	//语言包引入
	$m_langpackage=new modulelp;
	
	//当前页面参数
	$page_num=trim(get_argg('page'));
	
	//变量区
	$c_uid=intval(short_check(get_argg('uid')));
	$c_aff_id=intval(short_check(get_argg('aff_id')));
	$c_uname=short_check(get_argg('uname'));
	$c_min_send_date=short_check(get_argg('min_send_date'));
	$c_max_send_date=short_check(get_argg('max_send_date'));
	$c_order_by=short_check(get_argg('order_by'));
	$c_order_sc=short_check(get_argg('order_sc'));
	$c_perpage=get_argg('perpage') ? intval(short_check(get_argg('perpage'))):20;

	$sql="select * from $t_affair where 1=1 ";
	
	if(!empty($c_uid)){
		$sql.=" and user_id = $c_uid ";
		}	
		
	if(!empty($c_aff_id)){
		$sql.=" and type_id = $c_aff_id ";
		}	
		
	if(!empty($c_uname)){
		$sql.=" and user_name = '$c_uname' ";
		}
		
	if(!empty($c_min_send_date)){
		$sql.=" and date(date_time) >= '$c_min_send_date' ";
		}	
		
	if(!empty($c_max_send_date)){
		$sql.=" and date(date_time) <= '$c_max_send_date' ";
		}	
		
	if(!empty($c_order_by)){
		$sql.=" order by $c_order_by ";
		}
		
	$sql.=" $c_order_sc ";
		
	//设置分页
	$dbo->setPages($c_perpage,$page_num);	
	
	//取得数据
	$affair_rs=$dbo->getRs($sql);	
	
	//分页总数
	$page_total=$dbo->totalPage;
	
	//按字段排序
	$o_def='';$o_time='';
	if(!get_argg('order_by')||get_argg('order_by')=="id"){$o_def="selected";}
	if(get_argg('order_by')=="date_time"){$o_time="selected";}	
		
	//排列方式
	$sc_desc='';$sc_asc='';
	if(!get_argg('order_sc')||get_argg('order_sc')=="asc"){$sc_asc="selected";}
	if(get_argg('order_sc')=="desc"){$sc_desc="selected";}
	
	//分页显示条数
	$p_20='';$p_50='';$p_100='';
	if(!get_argg('perpage')||get_argg('perpage')=="20"){$p_20="selected";}
	if(get_argg('perpage')=="50"){$p_50="selected";}
	if(get_argg('perpage')=="100"){$p_100="selected";}
	
	//显示控制
	$isset_data="";
	$none_data="content_none";
	$isNull=0;
	if(empty($affair_rs)){
		$isset_data="content_none";
		$none_data="";
		$isNull=1;
		}
?>

<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="stylesheet" type="text/css" href="css/right.css">
<link rel="stylesheet" type="text/css" href="css/start.css">
<link rel="stylesheet" type="text/css" href="css/iframe.css">
</head>
<script type='text/javascript' src='../servtools/calendar.js'></script>
<script type='text/javascript'>
function fixImage(i,w,h){
	return true;
}

function create_xmlhttp()
{
	if(window.ActiveXObject){
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
		}else{
			xmlhttp=new XMLHttpRequest();
			}
}

function del_affair(aff_id)
{
	create_xmlhttp();
	xmlhttp.open("GET","affair_del.action.php?aff_id="+aff_id,true);
	xmlhttp.onreadystatechange=function(){	 
		if(xmlhttp.readyState==4&&xmlhttp.status==200){
			var return_str=xmlhttp.responseText;
			var	return_text=return_str.replace(/[\s\n\r]/g,"");
			window.document.getElementById("operate_"+aff_id).innerHTML=return_text;
		}
	}
	xmlhttp.send(null);
}

function check_form()
	{
		var min_send_date=document.getElementById("min_send_date").value;
		var max_send_date=document.getElementById("max_send_date").value;
		var time_format=/\d{4}\-\d{2}\-\d{2}/;
		
		if(min_send_date){
			if(!time_format.test(min_send_date)){
				alert("<?php echo $m_langpackage->m_date_wrong;?>");
				return false;
				}
		}
		
		if(max_send_date){
			if(!time_format.test(max_send_date)){
				alert("<?php echo $m_langpackage->m_date_wrong;?>");
				return false;
				}
			}
		
	}

</script>

<body>
	
<div class="container">
	<div class="rs_head"><?php echo $m_langpackage->m_check_condition;?></div>
</div>

<form action="" method="GET" onSubmit="return check_form();">
	<TABLE class="main main_left">
  <TBODY>
  <TR>
    <TH><?php echo $m_langpackage->m_userid;?></TH>
    <TD><INPUT type='text' name=uid value="<?php echo get_argg('uid');?>"></TD>
    <TH><?php echo $m_langpackage->m_uname;?></TH>
    <TD><INPUT type='text' name=uname value="<?php echo get_argg('uname');?>"></TD></TR>
  <TR>
    <TH><?php echo $m_langpackage->m_feed_id;?></TH>
    <TD><INPUT type='text' name=aff_id value="<?php echo get_argg('aff_id');?>"></TD>
    <TH><?php echo $m_langpackage->m_issue_time;?></TH>
    <TD>
    	<INPUT size=10 type='text' id="min_send_date" AUTOCOMPLETE=off onclick='getDateString(this,oCalendarChs)' name="min_send_date" <?php echo get_argg('min_send_date');?>> ~ <INPUT size=10 name="max_send_date" AUTOCOMPLETE=off onclick='getDateString(this,oCalendarChs)' id="max_send_date" type='text' <?php echo get_argg('max_send_date');?>> (YYYY-MM-DD) 
    </TD>    
  </TR>
  <TR>
    <TH><?php echo $m_langpackage->m_result_order;?></TH>
    <TD colSpan=3>
    	<SELECT name=order_by> 
    		<OPTION value="id" <?php echo $o_def;?>><?php echo $m_langpackage->m_def_order;?></OPTION> 
    		<OPTION value="date_time" <?php echo $o_time;?>><?php echo $m_langpackage->m_issue_time;?></OPTION> 
    	</SELECT> 
    	<SELECT name=order_sc> 
    		<OPTION value='asc' <?php echo $sc_asc;?>><?php echo $m_langpackage->m_asc;?></OPTION>
    		<OPTION value='desc' <?php echo $sc_desc;?>><?php echo $m_langpackage->m_desc;?></OPTION>
    	</SELECT> 
    	<SELECT name=perpage> 
    		<OPTION value=20 <?php echo $p_20;?>><?php echo $m_langpackage->m_page_20;?></OPTION> 
    		<OPTION value=50 <?php echo $p_50;?>><?php echo $m_langpackage->m_page_50;?></OPTION>
    		<OPTION value=100 <?php echo $p_100;?>><?php echo $m_langpackage->m_page_100;?></OPTION>
    	</SELECT> 
    	<INPUT class="button" type=submit value="<?php echo $m_langpackage->m_search;?>" /> 
  </TD>
  </TR></TBODY></TABLE>
</form>
	
	
<div class="container">
	<div class="rs_head"><?php echo $m_langpackage->m_feed_list;?></div>
</div>

	<table class='main main_left <?php echo $isset_data;?>'>
	<?php foreach($affair_rs as $rs){?>
		<tr>
			
		  <td width='43' valign='top' style="padding-top:3px;padding-bottom:12px;">
				<div class='uico_photo_small'><a href="../home.php?h=<?php echo $rs["user_id"];?>" target="_blank" title="<?php echo $rf_langpackage->rf_v_home;?>"><span></span>
					<img src='../<?php echo $rs["user_ico"];?>' width=43 height=43></a>
				</div>
	    </td>
	    
			<td width='*' valign='top' style="padding-left:6px;">
				<div class='pals_ra'>
					<a href="../home.php?h=<?php echo $rs["user_id"];?>" target="_blank" title="<?php echo $m_langpackage->m_visitor_home;?>">
						<font color="#005782"><?php echo $rs["user_name"];?></font>
					</a>
					<?php
					$order=array();
					$replace=array();
					$content='';
					if(!preg_match("/$m_langpackage->m_preg_link/",$rs['content'])){
						$order = array("href=\"","src=\"","src=\"../http://");
						$replace = array("href=\"../","src=\"../","src=\"http://");
					}
					$content=str_replace('{date_time}',format_datetime_txt($rs["date_time"]),$rs["content"]);
					echo str_replace($order,$replace,$content);
					?>
					<br />
				</div>
			</td>
			<td width=10%>
				<div id="operate_<?php echo $rs['id'];?>">
					<a href="javascript:del_affair(<?php echo $rs['id'];?>);"><image src="images/del.png" title="<?php echo $m_langpackage->m_del;?>" alt="<?php echo $m_langpackage->m_del;?>" onclick="return confirm('<?php echo $m_langpackage->m_ask_del;?>');" /></a>					
				</div>
			</td>
    
		</tr>
		<tr><td class="dotted_line" colspan="10" style="line-height:100%;">&nbsp</td></tr>
	<?php
		}
	?>
		<tr>
			<td colspan=9 style="text-align:'right'">
			<?php
				page_show($isNull,$page_num,$page_total);
			?>
			</td>
		</tr>
	</table>
	
	<div class='guide_info <?php echo $none_data;?>'><?php echo $m_langpackage->m_none_data;?></div>

</body>
</html>		