<?php

!defined('IN_HDWIKI') && exit('Access Denied');

class attachmentmodel {

	var $db;
	var $base;

	function attachmentmodel(&$base) {
		$this->base = $base;
		$this->db = $base->db;
	}
	
	function makepath($extname,$format='Ym'){
		return 'uploads/'.gmdate($format, $this->base->time + $this->base->setting['time_offset'])."/{$this->base->time}".util::random(8).'.'.strtolower($extname);
	}
	
	function add_attachment($uid,$did,$filename,$attachment,$description,$filetype='.jpg',$isimage=1){
		$filesize=filesize($attachment);
		$this->db->query("INSERT INTO ".DB_TABLEPRE."attachment(did,time,filename,description,filetype,filesize,attachment,isimage,uid)  VALUES ($did,{$this->base->time},'$filename','$description','$filetype','$filesize','$attachment',$isimage,$uid)");
		return $this->db->insert_id();
	}
	
	function get_attachment($variable,$value,$isimage=0){
		$attachlist=array();
		$query=$this->db->query("SELECT * FROM ".DB_TABLEPRE."attachment WHERE $variable='$value'");
		while($attach=$this->db->fetch_array($query)){
			if($isimage==$attach['isimage']){
				$attachlist[]=$attach;
			}
		}
		return $attachlist;
	}
	
	function update_downloads($id,$downloads=1){
		return $this->db->query("UPDATE ".DB_TABLEPRE."attachment SET downloads=downloads+$downloads WHERE id=$id");
	}
	
	function remove($id){
		if(is_array($id)){
			$id=implode(',',$id);
		}
		return $this->db->query("DELETE FROM ".DB_TABLEPRE."attachment WHERE id in ($id)");
	}
	
	function update_desc($ids,$descs){
		$count=count($ids);
		for($i=0;$i<$count;$i++){
			$this->db->query("UPDATE ".DB_TABLEPRE."attachment SET description='".$descs[$i]."' WHERE id=".$ids[$i]);
		}
	}
	
	function get_attachment_type(){
		$typelist=array();
		$attachmenttype=explode('|',$this->base->setting['attachment_type']) ;
		foreach ($attachmenttype as $type){
			if(!empty($type)){
				$typelist[]=strtolower(trim($type));
			}
		}
		return $typelist;
	}
	
	function upload_attachment($did){
		if(!$this->base->setting['attachment_open']){
			return false;
		}
		$count=count($_FILES['attachment']['name']);
		for($i=0;$i<$count;$i++){
			if(!(bool)$_FILES['attachment']['name'][$i]){
				continue;
			}
			$attachment_type=$this->get_attachment_type();
			$filetype=strtolower(substr($_FILES['attachment']['name'][$i],strrpos($_FILES['attachment']['name'][$i],".")+1));
			if(!in_array($filetype,$attachment_type)){
				$message .=$_FILES['attachment']['name'][$i].$this->base->view->lang['attachTypeError']."<br />";
				continue;
			}
			if($this->base->setting['attachment_size'] < $_FILES['attachment']['size'][$i]/1024){
				$message .=$_FILES['attachment']['name'][$i].$this->base->view->lang['attachSizeError']."<br />";
				continue;
			}
			$destfile='data/attachment/'.date('y-m').'/'.date('Y-m-d').'_'.util::random(10).'.attach';
			file::createaccessfile('data/attachment/'.date('y-m').'/');
			$result=file::uploadfile($_FILES['attachment']['tmp_name'][$i],$destfile,$this->base->setting['attachment_size'],0);
			if($result){
				$_ENV['attachment']->add_attachment($this->base->user['uid'] ,$did,$_FILES['attachment']['name'][$i] ,$destfile ,$this->base->post['attachmentdesc'][$i],$filetype,0 );
			}
		}
		return $message;
	}
	
	function search_attach_num($cid='', $did='',$authorid='', $starttime='', $endtime='',$type='' ){
		$sql="SELECT  count(*)  FROM ".DB_TABLEPRE."attachment m LEFT JOIN ".DB_TABLEPRE."doc d ON d.did = m.did where 1=1 ";
		if($cid){
			$query=$this->db->query("SELECT did FROM ".DB_TABLEPRE."doc  WHERE cid = $cid");
			while($category=$this->db->fetch_array($query)){
				$dids=$category['did'];
			}
			$dids=is_array($dids)?implode(',',$dids):'';
			$sql=$sql." AND m.did IN ($dids) ";
		}
		if($did){
			$sql=$sql." AND m.did ='$did' ";
		}
		if($authorid){
			$sql=$sql." AND m.uid='$authorid' ";
		}
		if($type){
			$sql=$sql." AND m.filetype='$type' ";
		}
		if($starttime){
			$sql=$sql." AND m.time>=$starttime ";
		}
		if($endtime){
			$sql=$sql." AND m.time<=$endtime ";
		}
		return $this->db->result_first($sql);
	}
	
	function search_attachment($start=0,$limit=10, $cid='', $did='',$authorid='', $starttime='', $endtime='',$type='' ){
		$doclist=array();
		$attachlist=array();
		$sql="SELECT  m.id,m.did,m.description,m.attachment,m.downloads,m.filesize,m.isimage,m.filename,m.uid,m.time,d.title title,u.username author FROM ".DB_TABLEPRE."attachment m LEFT JOIN ".DB_TABLEPRE."doc d ON d.did = m.did LEFT JOIN ".DB_TABLEPRE."USER u ON u.uid=m.uid where 1=1 ";
		if($cid){
			$query=$this->db->query("SELECT did FROM ".DB_TABLEPRE."doc  WHERE cid = $cid");
			while($category=$this->db->fetch_array($query)){
				$dids=$category['did'];
			}
			$dids=is_array($dids)?implode(',',$dids):'';
			$sql=$sql." AND m.did IN ($dids) ";
		}
		if($did){
			$sql=$sql." AND m.did ='$did' ";
		}
		if($authorid){
			$sql=$sql." AND m.uid='$authorid' ";
		}
		if($type){
			$sql=$sql." AND m.filetype='$type' ";
		}
		if($starttime){
			$sql=$sql." AND m.time>=$starttime ";
		}
		if($endtime){
			$sql=$sql." AND m.time<=$endtime ";
		}
		$sql=$sql." ORDER BY m.time DESC LIMIT $start,$limit ";
		$query=$this->db->query($sql);
		while($attach=$this->db->fetch_array($query)){
			$attach['time'] = $this->base->date($attach['time']);
			$attach['filename'] = string::substring($attach['filename'],0,28);
			$attach['filename'] .= (strlen($attach['filename'])>28)?"......":"";
			$attach['filesize']=sprintf('%.2f',$attach['filesize']/1024)."k";
			$attachlist[]=$attach;
		}
		return $attachlist;
	}
}


?>