<?php

!defined('IN_HDWIKI') && exit('Access Denied');

class docmodel {

	var $db;
	var $base;

	function docmodel(&$base) {
		$this->base = $base;
		$this->db = $base->db;
	}
	
	function get_doc($docid){
		$query=$this->db->query("SELECT * FROM ".DB_TABLEPRE."doc WHERE did='$docid' ");
		return $this->db->fetch_array($query);
	}
	function get_lastdoc($docid,$doctime){
		$query=$this->db->query("SELECT a.*,b.edits,b.editions,b.views,b.lastedit,b.lasteditor,b.lasteditorid,b.comments from ".DB_TABLEPRE."edition a," .DB_TABLEPRE."doc b WHERE a.did='$docid' AND a.time<'".$doctime."' AND a.did=b.did ORDER BY eid DESC");
		return $this->db->fetch_array($query);
	}
	
	function get_doc_by_title($title) {
		$query=$this->db->query("SELECT * FROM ".DB_TABLEPRE."doc WHERE title='$title' ");
		return $this->db->fetch_array($query);
	}
	
	function get_doc_by_ids($id) {
		$doclist=array();
		$ids=implode(",",$id);
		$query=$this->db->query("SELECT d.*,c.name AS category FROM ".DB_TABLEPRE."doc d,".DB_TABLEPRE."category c WHERE d.did IN ($ids) AND c.cid=d.cid ");
		while($doc=$this->db->fetch_array($query)){
			$doc['time']=$this->base->date($doc['time']);
			$doc['tag']=$this->spilttags($doc['tag']);
			$doclist[]=$doc;
		}
		return $doclist;
	}

	function update_field($field,$value,$did,$type=1){
		if($type){
			$sql="UPDATE ".DB_TABLEPRE."doc SET $field='$value' WHERE did= $did ";
		}else{
			$sql="UPDATE ".DB_TABLEPRE."doc SET $field=$field+$value WHERE did= $did ";
		}
		$this->db->query($sql);
	} 
 
 
	function get_recenteditor($docid,$limit=5, $unuid=0) {
		$editionlist=array();
		$query=$this->db->query("SELECT MAX(`time`) time,e.authorid,e.author FROM ".DB_TABLEPRE."edition e WHERE e.authorid<>$unuid AND did='$docid' GROUP BY authorid ORDER BY time DESC LIMIT $limit");
		while($edition=$this->db->fetch_array($query)){
			$edition['time']=$this->base->date($edition['time']);
			$editionlist[]=$edition;
		}
		return $editionlist;
	}
	
	function get_editor_num($did){
		$authorid = array();
		$query=$this->db->query("SELECT authorid FROM ".DB_TABLEPRE."edition WHERE did=$did");
		while($result=$this->db->fetch_array($query)){
			$authorid[] = $result['authorid'];
		}
		$authorid = array_unique($authorid);
		return count($authorid);
	}
	
	function get_similardoc($cid,$limit=6) {
		$doclist=array();
		$query=$this->db->query("SELECT title,did FROM ".DB_TABLEPRE."doc WHERE cid='$cid' ORDER BY lastedit DESC LIMIT $limit");
		while($doc=$this->db->fetch_array($query)){
			$doclist[]=$doc;
		}
		return $doclist;
	}

	function get_docs_by_cid($cid,$start=0,$limit=5,$letter="0") {
		$doclist=array();
		if(is_array($cid)){
			$cid=implode(",",$cid);
		}
		$sql="SELECT did,title,author,authorid,`time`,tag,summary,edits,views FROM ".DB_TABLEPRE."doc WHERE cid IN ($cid) ";
		if($letter!="0"){
			$sql .=" AND letter='".strtoupper($letter)."'";
		}
		$query=$this->db->query($sql." ORDER BY lastedit DESC LIMIT $start,$limit");
		while($doc=$this->db->fetch_array($query)){
			$doc['tag']=$this->spilttags($doc['tag']);
			$doc['time']=$this->base->date($doc['time']);
			$doclist[]=$doc;
		}
		return $doclist;
	}
	
	function get_totalnum_by_cid($cid,$letter="0") {
		if(is_array($cid)){
			$cid=implode(",",$cid);
		}
		$sql="SELECT COUNT(*) num FROM ".DB_TABLEPRE."doc WHERE cid IN ($cid)";
		if($letter!="0"){
			$sql .=" AND letter='".strtoupper($letter)."'";
		}
		return $this->db->result_first($sql);
	}
	
	function get_total_num() {
		return $this->db->result_first("SELECT COUNT(*) num FROM ".DB_TABLEPRE."doc WHERE 1");
	}

	function get_edits_total_num() {
		return $this->db->result_first("SELECT COUNT(*) num FROM ".DB_TABLEPRE."doc WHERE edits>0");
	}

	function get_letter_total_num($letter) {
		return $this->db->result_first("SELECT COUNT(*) num FROM ".DB_TABLEPRE."doc WHERE letter='$letter'");
	}
	
	function add_doc($doc) {
		$this->db->query("INSERT INTO ".DB_TABLEPRE."doc
		(cid,letter,title,tag ,summary ,content,author,authorid,time,lastedit,lasteditor,lasteditorid,visible)
		VALUES ('".$doc['category']."','".$doc['letter']."','".$doc['title']."','".$doc['tags']."','".$doc['summary']."','".$doc['content']."',
		'".$this->base->user['username']."','".$this->base->user['uid']."',
		".$doc['time'].",".$doc['time'].",'".$this->base->user['username']."','".$this->base->user['uid']."','".$doc['visible']."')");

		$did=$this->db->insert_id();

		$this->db->query("INSERT INTO ".DB_TABLEPRE."edition
		(cid,did,author,authorid,time,ip,title,tag,summary,content,words,images )
		VALUES ('".$doc['category']."',$did,'".$this->base->user['username']."','".$this->base->user['uid']."',
		'".$doc['time']."','".$this->base->ip."','".$doc['title']."','".$doc['tags']."','".$doc['summary']."','".$doc['content']."','".$doc['words']."','".$doc['images']."')");

		return $did;
	}

	function edit_doc($doc,$edittype='1') {
		$this->db->query("UPDATE ".DB_TABLEPRE."doc SET
		tag='".$doc['tags']."' ,summary='".$doc['summary']."' ,content='".$doc['content']."',lastedit='".$doc['time']."',
		lasteditor='".$this->base->user['username']."',lasteditorid='".$this->base->user['uid']."',edits=edits+1,editions=editions+1,visible='".$doc['visible']."' WHERE did=".$doc['did']);

		$this->db->query("INSERT INTO ".DB_TABLEPRE."edition
		(cid,did,author,authorid,time,ip,title,tag,summary,content,words,images,reason,`type`)
		VALUES ('".$doc['cid']."','".$doc['did']."','".$this->base->user['username']."','".$this->base->user['uid']."',
		'".$doc['time']."','".$this->base->ip."','".$doc['title']."','".$doc['tags']."','".$doc['summary']."','".$doc['content']."','".$doc['words']."','".$doc['images']."','".$doc['reason']."','$edittype')");
	}
	
	function edit_unaudit_doc($doc){
		return $this->db->query("UPDATE ".DB_TABLEPRE."doc SET
		tag='".$doc['tags']."' ,summary='".$doc['summary']."' ,content='".$doc['content']."',lastedit='".$doc['time']."',
		lasteditor='".$this->base->user['username']."',lasteditorid='".$this->base->user['uid']."' WHERE did=".$doc['did']);
	}

	function splithtml($html,$preg='/(<div\s+class=\"?hdwiki_tmml\"?>.+?<\/div>)/i'){
		$arrhtml=preg_split($preg,$html,-1,PREG_SPLIT_DELIM_CAPTURE);
		$count=count($arrhtml);
		for($i=0;$i<$count;$i++){
			if(preg_match($preg,$arrhtml[$i])){
				$resarr[$i]['value']=strip_tags($arrhtml[$i]);
				$resarr[$i]['flag']=1;
				continue;
			}
			$resarr[$i]['value']=$arrhtml[$i];
			$resarr[$i]['flag']=0;
		}
		unset($arrhtml);
		return $resarr;
	}

	function joinhtml($arrhtml){
		$html='';
		$count=count($arrhtml);
		for($i=0;$i<$count;$i++){
			if($arrhtml[$i]['flag']==1){
				$html.="<div class=\"hdwiki_tmml\">".$arrhtml[$i]['value']."</div>";
			}else {
				$html.=$arrhtml[$i]['value'];
			}
		}
		return $html;
	}

	function getsections($section){
		$sectionlist=array();
		for($i=0;$i<count($section);$i++){
			if($section[$i]['flag']==1){
				$sectionlist[]=array('key'=>$i,'value'=>$section[$i]['value']);
			}
		}
		unset($section);
		return $sectionlist;
	}
	
	function spilttags($tag){
		$taglist=array();
		$tags=split(';',$tag) ;
		foreach ($tags as $tag){
			if(!empty($tag)){
				$taglist[]=$tag;
			}
		}
		return $taglist;
	}

	function jointags($tags){
		$taglist=array();
		foreach ($tags as $tag){
			if(!empty($tag)){
				$taglist[]=strip_tags(trim($tag));
			}
		}
		return implode(';',array_unique($taglist));
	}
	
	function auto_picture($content){
		preg_match_all('/<img[^>\n]+?src=[^>\n]*?(http:\/\/[^<>\s]+?(?:gif|jpg|png|jpeg)).*?>/is',$content,$imgs);
		if((bool)$imgs){
			$this->base->load('attachment');
			$links=$imgs[0];
			$imgs=$imgs[1];
			$host=($parse=@parse_url($this->base->setting['site_url']))?$parse['host']:'';
			$i=0;
			foreach($imgs as $img){
				$parse=($parse=parse_url($img))?$parse['host']:'';
				if(strpos($host,$parse)!==false){
					$i++;
					continue;
				}
				$ishd=strpos($imgs[$i],'.hudong.com');
				if(false===$ishd){
					$replace="/<a[^>]+?href=[^>]*?>[\s]*?".str_replace('/','\/',addslashes($links[$i]))."[\s]*?<\/a>/is";
					preg_match($replace,$content,$linkimg);
					if((bool)$linkimg){
						$content=str_replace($linkimg[0],$links[$i],$content);
					}
					$tmpname=$_ENV['attachment']->makepath(file::extname($img));
				}else{
					$search = array("http://",".att.hudong.com/","/");
					$replace = array('','_','_');
					$newimg = str_replace($search, $replace, $img);
					$tmpname='uploads/hdpic/'.$newimg;
					if(file_exists($tmpname)){
						$content=str_replace($links[$i],str_replace($img,$tmpname,$links[$i]),$content);
						$i++;
						continue;
					}
				}
				if($pic_content=@util::hfopen($img)){
					file::forcemkdir(dirname($tmpname));
					if(file::writetofile($tmpname,$pic_content)){
						$content=str_replace($links[$i],str_replace($img,$tmpname,$links[$i]),$content);
					}
				}
				$i++;
			}
		}
		return $content;
	}
	
	function iseditlocked($did){
		$editlock=$this->get_editlock_instance($did);
		if(empty($editlock)){
			return 0;
		}else {
			if(  ($this->base->time-$editlock['time']) >180 ){
				return 0;
			}else {
				return $editlock['uid'];
			}
		}
	}

	function  refresheditlock($did,$uid){
		$editlock=$this->get_editlock_instance($did);
		$editlocktime=$this->base->time;
		if(empty($editlock)){
			$this->db->query("INSERT INTO ".DB_TABLEPRE."lock(did,uid,time) VALUES ($did,$uid,'$editlocktime') ");
		}else {
			$this->db->query("UPDATE ".DB_TABLEPRE."lock SET uid=$uid,time='$editlocktime' WHERE did=$did");
		}
	}

	function unset_editlock($did,$uid){
		$this->db->query(" DELETE FROM ".DB_TABLEPRE."lock WHERE did=$did AND uid=$uid");
		return true;
	}
	
	function get_editlock_instance($did){
		$query = $this->db->query(" SELECT * FROM ".DB_TABLEPRE."lock WHERE did=$did");
		return $this->db->fetch_array($query);
	}
	
	function get_list($type=1,$start=0,$limit=10){
		$doclist=array();
		$categorylist=array();
		$query=$this->db->query("SELECT name,cid FROM ".DB_TABLEPRE."category");
		while($category=$this->db->fetch_array($query)){
			$categorylist[$category['cid']]=$category['name'];
		}
		$sql=" SELECT d.did, d.cid,d.letter,d.title,d.tag,d.summary,d.author,d.authorid,d.time,d.lastedit,d.lasteditor,d.lasteditorid,d.views,d.edits,d.editions,d.visible,d.locked  FROM ".DB_TABLEPRE."doc d WHERE 1=1 ";
		if(1==$type){
			$sql .="  ORDER BY d.`lastedit` DESC LIMIT $start,$limit";
		}else{
			$sql .=" AND d.letter='$type' ORDER BY d.`time` DESC LIMIT $start,$limit";
		}
		$query = $this->db->query($sql);
		while($doc=$this->db->fetch_array($query)){
			$doc['iscreate']=($doc['time']==$doc['lastedit']);
			$doc['lastedit']=$this->base->date($doc['lastedit']);
			$doc['time']=$this->base->date($doc['time']);
			$doc['shorttitle']=string::substring($doc['title'],0,16);
			$doc['category']=$categorylist[$doc['cid']];
			$doclist[]=$doc;
		}
		return $doclist;
	}
	
	function get_list_cache($type=1,$start=0,$limit=10){
		$cache=$this->base->cache->getcache("list_{$type}.php",$this->base->setting['list_cache_time']);
		if(!(bool)$cache){
			$cache=$this->get_list($type,$start,$limit);
			$this->base->cache->writecache("list_{$type}.php",$cache);
		}
		return $cache;
	}
	
	function get_focus_list($start=0,$limit=10){
		$focuslist=array();
		$query = $this->db->query(" SELECT * FROM ".DB_TABLEPRE."focus WHERE 1=1 ORDER BY displayorder ASC,time DESC LIMIT $start,$limit");
		while($focus=$this->db->fetch_array($query)){
			$focus['time']=$this->base->date($focus['time']);
			if(empty($focus['image'])){
				$focus['image']='style/default/noimg.jpg';
			}
			$img=explode('/',$focus['image']);
			$focus['simage']=$img[0].'/'.$img[1].'/s_'.$img[2];
			$focuslist[]=$focus;
		}
		return $focuslist;
	}
	
	function get_focus_total_num(){
		$total=$this->db->fetch_first(" SELECT COUNT(*) num FROM ".DB_TABLEPRE."focus WHERE 1=1 ");
		return $total['num'];
	}

	function set_focus_doc($dids){
		$doclist=$this->get_doc_by_ids($dids);
		foreach($doclist as $doc){
			$title = string::haddslashes($doc['title'],1);
			$tag = string::haddslashes($this->jointags($doc['tag']),1);
			$summary = string::haddslashes($doc['summary'],1);
			$image = $this->setfocusimg(util::getfirstimg($doc['content']));
			$this->db->query("REPLACE INTO ".DB_TABLEPRE."focus (did,title,tag,summary,image,time)VALUES (".$doc['did'].",'$title','$tag','$summary','$image','".$this->base->time."')");
		}
		return true;
	}
	
	function setfocusimg($img){
		if(''==$img){
			return '';
		}
		if(substr($img,0,strlen($this->base->setting['site_url']))==$this->base->setting['site_url']){
			$img=substr($img,strlen($this->base->setting['site_url'])+1);
		}
		if("http://"==substr($img,0,7) && substr($img,0,strlen($this->base->setting['site_url']))!=$this->base->setting['site_url']){
			$tmpname='uploads/'.date("Ym")."/".util::random().".jpg";
			if($pic_content=@util::hfopen($img)){
				file::forcemkdir(dirname($tmpname));
				if(file::writetofile($tmpname,$pic_content)){
					$img=$tmpname;
				}
			}
		}
		$compress=util::image_compress($img,'f_',152,114);
		if(!$compress['result']){
			return '';
		}
		util::image_compress($img,'s_f_',100,75);
		return $compress['tempurl'];
	}
	
	function change_category($did,$cid){
		$dids = implode(',',$did);
		if($this->db->query("UPDATE ".DB_TABLEPRE."doc SET cid=$cid WHERE did IN ($dids) ")){
			return true;
		}else{
			return false;
		}
	}
	
	function change_name($did,$title){
		$letter=string::getfirstletter($title);
		if($this->db->query("UPDATE ".DB_TABLEPRE."doc SET title='$title',letter='$letter' WHERE did=$did")){
			$this->db->query("UPDATE ".DB_TABLEPRE."edition SET title='$title' WHERE did=$did");
			return true;
		}else{
			return false;
		}
	}
	
	function lock($dids,$lock=1){
		$dids = implode(',',$dids);
		if($this->db->query("UPDATE ".DB_TABLEPRE."doc SET locked=$lock WHERE did IN ($dids)")){
			return true;
		}else{
			return false;
		}
	}

	function get_edition_list($did, $field='*'){
		$editionlist=array();
		$query=$this->db->query(" SELECT $field FROM ".DB_TABLEPRE."edition WHERE did=$did  ORDER BY eid DESC");
		while($edition=$this->db->fetch_array($query)){
			$edition['time']=$this->base->date($edition['time']);
			$editionlist[]=$edition;
		}
		return $editionlist;
	}
	
	function audit_doc($dids){
		$dids = implode(',',$dids);
		if($this->db->query("UPDATE ".DB_TABLEPRE."doc SET visible = '1' WHERE did IN ($dids) ")){
			return true;
		}else{
			return false;
		}
	}
	function remove_doc($did){
		$uids=array();
		$dids = implode(',',$did);
		$query=$this->db->query("SELECT authorid FROM ".DB_TABLEPRE."doc WHERE did IN ($dids)");
		while($uid=$this->db->fetch_array($query)){
			$uids[] = $uid['authorid'];
		}
		
		$this->db->query("DELETE FROM  ".DB_TABLEPRE."doc WHERE did IN ($dids) ");
		$this->db->query("DELETE FROM  ".DB_TABLEPRE."edition WHERE did IN ($dids) ");
		$this->db->query("DELETE FROM  ".DB_TABLEPRE."focus WHERE did IN ($dids) ");
		$this->db->query("DELETE FROM  ".DB_TABLEPRE."comment WHERE did IN ($dids) ");
		
		$credit = -$this->base->setting['credit_create'];
		foreach($uids as $uid){
			$this->db->query("INSERT INTO ".DB_TABLEPRE."creditdetail(uid,operation,credit,time) VALUES ($uid,'remove_doc',$credit,{$this->base->time}) ");
			$this->db->query("UPDATE ".DB_TABLEPRE."user SET credits=credits+$credit,creates=creates-1 WHERE uid=$uid ");
		}
	}
	
	function is_addcredit($did,$uid){
		$sql="SELECT time FROM ".DB_TABLEPRE."edition WHERE did = $did AND authorid=$uid ORDER BY time DESC LIMIT 1,1";
		$edittime=$this->db->result_first($sql);
		if($this->base->time-$edittime>2*60*60){
			return true;
		}else{
			return false;
		}		
	}
	
	function search_doc($start=0,$limit=10, $cid='', $title='',$author='', $starttime='', $endtime='',$typename){
		$sql="SELECT d.did, d.cid, d.letter, d.title, d.tag, d.summary, d.author, d.authorid, d.time, d.lastedit, d.lasteditor, d.views, d.edits, d.editions, d.visible, d.locked, c.name category, f.did focus FROM ".DB_TABLEPRE;
		if($typename!=1){
			$sql=$sql."doc d LEFT JOIN ".DB_TABLEPRE."category c ON c.cid = d.cid LEFT JOIN ".DB_TABLEPRE."focus f ON f.did = d.did where 1=1 ";
		}else{
			$sql=$sql."focus f LEFT JOIN ".DB_TABLEPRE."doc d ON f.did = d.did  LEFT JOIN ".DB_TABLEPRE."category c ON c.cid = d.cid where 1=1 ";
		}
		if($cid){
			$sql=$sql." and d.cid=$cid ";
		}
		if($title){
			$sql=$sql." and d.title like '%$title%' ";
		}
		if($author){
			$sql=$sql." and d.author='$author' ";
		}
		if($starttime){
			$sql=$sql." and d.time>=$starttime ";
		}
		if($endtime){
			$sql=$sql." and d.time<=$endtime ";
		}
		if($typename!='' && $typename!=1){
			switch($typename){
				case 2:
					$sql=$sql." and d.locked=1 ";
					break;
				case 3:
					$sql=$sql." and d.visible=1 ";
					break;
				case 4:
					$sql=$sql." and d.visible=0 ";
					break;		
			}
		}
		$sql=$sql." order by d.lastedit desc limit $start,$limit ";
		$doclist=array();
		$query=$this->db->query($sql);
		while($doc=$this->db->fetch_array($query)){
			$doc['time'] = $this->base->date($doc['time']);
			$doclist[]=$doc;
		}
		return $doclist;
	}
 
	function search_doc_num($cid='', $title='',$author='', $starttime='', $endtime='',$typename ){
		$sql="SELECT  count(*)  FROM ".DB_TABLEPRE;
		if($typename!=1){
			$sql=$sql."doc d LEFT JOIN ".DB_TABLEPRE."category c ON c.cid = d.cid LEFT JOIN ".DB_TABLEPRE."focus f ON f.did = d.did  where 1=1 ";
		}else{
			$sql=$sql."focus f LEFT JOIN ".DB_TABLEPRE."doc d ON d.did = f.did left JOIN ".DB_TABLEPRE."category c ON c.cid = d.cid where 1=1 ";
		}
		if($cid){
			$sql=$sql." and d.cid=$cid ";
		}
		if($title){
			$sql=$sql." and d.title like '%$title%' ";
		}
		if($author){
			$sql=$sql." and d.author='$author' ";
		}
		if($starttime){
			$sql=$sql." and d.time>=$starttime ";
		}
		if($endtime){
			$sql=$sql." and d.time<=$endtime ";
		}
		if($typename!='' && $typename!=1){
			switch($typename){
				case 2:
					$sql=$sql." and d.locked=1 ";
					break;
				case 3:
					$sql=$sql." and d.visible=1 ";
					break;
				case 4:
					$sql=$sql." and d.visible=0 ";
					break;		
			}
		}
		return $this->db->result_first($sql);
	}

	function get_nav_edition($eid){
		$editionlist=array();
		$eidlist=array();
		
		$edition= $this->db->fetch_first("SELECT did FROM ".DB_TABLEPRE."edition WHERE eid=$eid");
		$did = $edition['did'];
		$query= $this->db->query("SELECT eid FROM ".DB_TABLEPRE."edition WHERE did=$did ORDER BY eid ASC");
		while($edition=$this->db->fetch_array($query)){
			$eidlist[] = $edition['eid'];
		}
		$count=count($eidlist);
		foreach($eidlist as $i => $eids){
			if ($eids == $eid){
				if($i==0){
					$editionlist['previous']=0;
					$editionlist['next']=$eidlist[1];
					$editionlist['latest']=array_pop($eidlist);
				}elseif(($i+1) == $count){
					$editionlist['previous']=$eidlist[$i-1];
					$editionlist['next']=0;
					$editionlist['latest']=0;
				}else {
					$editionlist['previous']=$eidlist[$i-1];
					$editionlist['next']=$eidlist[$i+1];
					$editionlist['latest']=array_pop($eidlist);
				}
			}
		}
		return $editionlist;
	}
	 
	function get_edition($eid){
		$editionlist=array();
		if(is_numeric($eid)){
			$edition= $this->db->fetch_first("SELECT * FROM ".DB_TABLEPRE."edition WHERE eid=$eid");
			$edition['comtime']=$edition['time'];
			$edition['time']=$this->base->date($edition['time']);
			return $edition;
		}else{
			$eid=implode(",",$eid);
			$query=$this->db->query(" SELECT * FROM ".DB_TABLEPRE."edition WHERE eid IN ($eid)");
			while($edition=$this->db->fetch_array($query)){
				$edition['time']=$this->base->date($edition['time']);
				$editionlist[]=$edition;
			}
			return $editionlist;
		}
	}

	function remove_edition($eid){
		if(is_array($eid)){
			$eid=implode(",",$eid);
		}
		$this->db->query("DELETE FROM ".DB_TABLEPRE."edition WHERE eid IN ($eid)");
		return true;
	}
	
	function set_excellent_edition($eid,$type=1){
		if(is_array($eid)){
			$eid=implode(",",$eid);
		}
		$type=(bool)$type?1:0;
		$this->db->query("UPDATE ".DB_TABLEPRE."edition SET excellent=$type WHERE eid IN ($eid)");
		return true;
	}
	
	function copy_edition($eid){
		$edition=$this->get_edition($eid);
		if(!is_array($edition)){
			return false;
		}
		$edition['tags']=$data['tag'];
		$edition['time']=$this->base->time;
		$edition['visible']=$this->base->setting['verify_doc']?'0':'1';
		$this->edit_doc(string::haddslashes($edition,1));
		return true;
	}
	
	function update_to_latest_edition($doc){
		$this->db->query("UPDATE ".DB_TABLEPRE."doc SET
		tag='".$doc['tag']."' ,summary='".$doc['summary']."' ,content='".$doc['content']."',lastedit='".$this->base->time."',
		lasteditor='".$this->base->user['username']."' WHERE did=".$doc['did']);
	}
	
	function add_searchindex($did,$title,$tags,$content){
		return true;
	}

	function have_danger_word($content){
		$words=$this->base->_load_cache('word');
		foreach($words as $key=>$word){
			if(strstr($content,$key)){
				return '1';
				break;
			}
		}
		return '0';
	}
	
	function replace_danger_word($content){
		$words=$this->base->_load_cache('word');
		foreach($words as $key=>$word){
			$content=str_replace($key,$word,$content);
		}
		return $content;
	}



	function get_focus_content($did){
		return $this->db->fetch_first("SELECT * FROM ".DB_TABLEPRE."focus WHERE did=$did");
	}
	
	function save_focus_img($did,$img){
		$this->db->query("UPDATE ".DB_TABLEPRE."focus SET image='$img' WHERE did=$did");
		return true;
	}
	
	function save_focus_content($did,$summary,$image,$order){
		$this->db->query("UPDATE ".DB_TABLEPRE."focus SET summary='$summary',image='$image',displayorder=$order WHERE did=$did");
		return true;
	}
	
	function remove_focus($dids){
		$did=implode(",",$dids);
		$this->db->query("DELETE FROM ".DB_TABLEPRE."focus WHERE did IN ($did)");
		return true;
	}
	
	function order_focus($did,$order){
		$this->db->query("UPDATE ".DB_TABLEPRE."focus SET displayorder=$order WHERE did=$did");
		return true;
	}
	
	function get_hottags(){
		$taglist='';
		$query=$this->db->query("SELECT tag FROM ".DB_TABLEPRE."focus");
		while($tag=$this->db->fetch_array($query)){
			$taglist .=$tag['tag'].';';
		}
		if(!empty($taglist)){
			$taglist = explode(';',substr($taglist,0,-1));
			$taglist = array_keys(array_count_values($taglist));
			$taglist = implode(';',$taglist);
		}
		return $taglist;
	}
	
	function get_colortag($tags){
		$hottag=array();
		$tags = array_unique(explode(';',$tags));
		foreach($tags as $tag){
			$tag=trim($tag);
			if(''==$tag){continue;}
			$tag = stripslashes($tag);
			switch(rand(1,10)){
				case 1 :
					$hottag[]=array('tagname'=>$tag,'tagcolor'=>'blue');
					break;
				case 2 :
					$hottag[]=array('tagname'=>$tag,'tagcolor'=>'green');
					break;
				case 3 :
					$hottag[]=array('tagname'=>$tag,'tagcolor'=>'orange');
					break;
				default :
					$hottag[]=array('tagname'=>$tag,'tagcolor'=>'');
					break;
			}
		}
		$hottag = addslashes(serialize($hottag));
		return $hottag;
	}
	
	function get_maxid() {
		return $this->db->result_first("SELECT MAX(did) FROM ".DB_TABLEPRE."doc WHERE 1");
	}
	
	function get_random() {
		$maxdid=$this->db->result_first('SELECT MAX(did) FROM '.DB_TABLEPRE.'doc ');
		$did=0;
		if(empty($maxid)){
			do{
				$did=rand(1,$maxdid);
				$doc=$this->db->fetch_first('SELECT did FROM '.DB_TABLEPRE.'doc WHERE did='.$did);
			}while(! $doc);
		}
		return $did;
	}

}
?>
