<?php

!defined('IN_HDWIKI') && exit('Access Denied');

class stylemodel {

	var $db;
	var $base;

	function stylemodel(&$base) {
		$this->base = $base;
		$this->db = $base->db;
	}
	
	function get_all_list($start=0,$limit=10){
		$stylelist=array();
		$query=$this->db->query('SELECT path FROM '.DB_TABLEPRE.'style where path!="'.$this->base->setting['style_name'].'" ORDER BY  id ASC limit '.$start.','.$limit);
		while($allstyle=$this->db->fetch_array($query)){
			if($allstyle['path']!=$this->base->setting['style_name']){
				$style=$this->read_xml($allstyle['path']);
				$style['tag']=explode(' ',$style['tag']);
				$style['charset']=explode(' ',$style['charset']);
				$stylelist[]=$style;
			}
		}
		return $stylelist;
	}
	
	function get_all_list_num(){
		$stylelist=array();
		$query=$this->db->query('SELECT path FROM '.DB_TABLEPRE.'style where path!="'.$this->base->setting['style_name'].'" ORDER BY  id ASC ');
		while($allstyle=$this->db->fetch_array($query)){
			if($allstyle['path']!=$this->base->setting['style_name']){
				$stylelist[]=$style;
			}
		}
		return $stylelist;
	}	
	function get_path_list(){
		$pathlist=array();
		$query=$this->db->query('SELECT path FROM '.DB_TABLEPRE.'style  ORDER BY  id ASC ');
		while($style=$this->db->fetch_array($query)){
			$pathlist[]=$style['path'];
		}
		return $pathlist;
	}
	
	function add_style($style){
		$this->db->query("INSERT INTO ".DB_TABLEPRE."style (name,path,available,css,copyright) VALUES ('$style[name]','$style[path]','1','','$style[copyright]')");
	}
	
	function read_xml($filenames){
		$xmlarray=array();
		$values=array();
		$tags=array();
		$filedir=HDWIKI_ROOT.'/style/'.$filenames.'/';
		if(file_exists($filedir."desc.xml")){
			$data = implode("",file($filedir."desc.xml"));
			$parser = xml_parser_create();
			xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
			xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
			xml_parse_into_struct($parser, $data, $values, $tags);
			xml_parser_free($parser);
			$xmlcounts=count($values);
			$xmlarray['path']=$filenames;
			for($x=0;$x<$xmlcounts;$x++){
				if($values[$x]['level']==2){
					$values[$x]['value']=string::hiconv($values[$x]['value']);
					$xmlarray[$values[$x]['tag']]=$values[$x]['value'];
				}
			}
			$filedir=HDWIKI_ROOT."/style/".$filenames.'/';
			file::forcemkdir($filedir);
			if(is_file($filedir."screenshot.jpg")){
				$xmlarray['img']=1;
			}
		}
		return $xmlarray;
	}
	
	function write_xml($style){
		$xml="<?xml version=\"1.0\" encoding=\"".WIKI_CHARSET."\"?>\n".
			"<theme name=\"default\" version=\"1.0.1\" active=\"true\">\n".
			"<author>".$style['author']."</author>\n".
			"<authorurl><![CDATA[".$style['authorurl']."]]></authorurl>\n".
			"<name>".$style['name']."</name>\n".
			"<tag>".$style['tag']."</tag>\n".
			"<desc><![CDATA[".$style['desc']."]]></desc>\n".
			"<sitename>".$style['sitename']."</sitename>\n".
			"<weburl><![CDATA[".$style['weburl']."]]></weburl>\n".
			"<version>".$style['version']."</version>\n".
			"<hdversion>".$style['hdversion']."</hdversion>\n".
			"<copyright>".$style['copyright']."</copyright>\n".
			"<charset>".$style['charset']."</charset>\n".
			"</theme>";
		$filedir=HDWIKI_ROOT.'/style/'.$style['path'].'/';
		file::forcemkdir($filedir);
		$bytes=file::writetofile($filedir.'desc.xml',$xml);
		return ($bytes>0);
	}
	
	function add_check_style($path){
		$style=$this->db->fetch_first("SELECT * FROM ".DB_TABLEPRE."style WHERE path = '$path'");
		return $style;
	}
	
	function update_style($style){
		$this->db->query("UPDATE ".DB_TABLEPRE."style set name='$style[name]',copyright='$style[copyright]',available='1' where path='$style[path]'");
	}
	
	function update_stylecss($style,$path){
		$this->db->query("UPDATE ".DB_TABLEPRE."style set css='$style' where path='$path'");
	}
	
	function default_style($path){
		$this->db->query("UPDATE ".DB_TABLEPRE."setting SET value = '$path' WHERE variable = 'style_name' or variable = 'tpl_name'");
	}
	
	function remove_style($path){
		$this->db->query("DELETE FROM ".DB_TABLEPRE."style WHERE path='$path'");
	}
	
	function choose_style_name($path){
		$style=$this->db->fetch_first("SELECT * FROM ".DB_TABLEPRE."style WHERE path='$path'");
		$xmlstyle=$this->read_xml($style['path']);
		$xmlstyle[tag]=explode(" ",$xmlstyle['tag']);
		$xmlstyle[charset]=explode(" ",$xmlstyle['charset']);
		return $xmlstyle;
	}
	
	function get_style_list($type){
		$toaddlist=array();
		$filedir=HDWIKI_ROOT.'/style/';
		file::forcemkdir($filedir);
		$handle=opendir($filedir);
		while($filename=readdir($handle)){
			if (is_dir($filedir.$filename) && '.'!=$filename && '..'!=$filename){
				if($type==1){
					if(file_exists($filedir.$filename."/desc.xml")){
						$toaddlist[]=$filename;
					}
				}else{
					$toaddlist[]=$filename;
				}
			}
		}
		closedir($handle);
		return $toaddlist;
	}
	
	function upload_img($uploadimg,$filename){
		$counts=count($uploadimg);
		if($counts!=0){
			for($i=0;$i<$counts;$i++){
				$imgname=$uploadimg[$i]['name'];
				$extname=file::extname($imgname);
				$destfile=HDWIKI_ROOT.'/style/'.$filename.'/'.$uploadimg[$i]['rename'].".".$extname;
				$result = file::uploadfile($uploadimg[$i],$destfile);
				if($result['result'] && $uploadimg[$i]['rename']=='screenshot'){
					util::image_compress($destfile,NULL,158,118);
				}
				$success++;
			}
		}
		return $success;
	}
	
	function get_style_name($ziplist){
		if(!is_array($ziplist)){
			return false;
		}
		foreach($ziplist as $list){
			if(false!==strpos($list['filename'],'desc.xml')){
				$style_name=$list['filename'];
				break;
			}
		}
		$style_name=substr($style_name,strpos($style_name,'style/')+6,-9);
		return $style_name;
	}
	
	function style_charset($path){
		$filedir=HDWIKI_ROOT.'/view/'.$path.'/';
		if(is_dir($filedir)){
			$list=array();
			file::forcemkdir($filedir);
			$handle=opendir($filedir);
			while($filename=readdir($handle)){
				if (!is_dir($filedir.$filename) && '.'!=$filename && '..'!=$filename){
					$list[]=$filename;
				}
			}
			if($list==null)$styletag=1;
		}else{
			$styletag=1;
		}
		if($styletag==1){
			if(WIKI_CHARSET=='UTF-8'){
				$charset=WIKI_CHARSET.' GBK';
			}else{
				$charset=WIKI_CHARSET.' UTF-8';
			}	
		}else{
			$charset=WIKI_CHARSET;
		}
		return $charset;
	}
	
	function write_css($style){
		$data="#html{background:".$style['bg_color']." url(".$style['bg_imgname'].") no-repeat center top !important;}\n".
				"#html body .columns .col-h2{background-image:url(".$style['titbg_imgname'].");}\n".
				"#html #left .columns{border:1px ".$style['left_framcolor']." solid;}\n".
				"#html #left .columns .col-h2{background-color:".$style['leftitle_bgcolor']."; border-bottom:1px ".$style['leftitle_framcolor']." solid;}\n".
				"#html #mid .columns {border:1px ".$style['middle_framcolor']." solid;}\n".
				"#html #mid .columns .col-h2{background-color:".$style['middletitle_bgcolor'].";border:1px ".$style['middletitle_framcolor']." solid;}\n".
				"#html .default-r{border:1px ".$style['right_framcolor']." solid;}\n".
				"#html .default-r .col-h2{ border:1px ".$style['rightitle_framcolor']." solid;background-color:".$style['rightitle_bgcolor'].";}\n".
				"#html #nav{border-bottom:1px ".$style['nav_framcolor']." solid;}\n".
				"#html #nav ul{background-color:".$style['nav_bgcolor'].";}\n".
				"#html #nav li a{color:".$style['nav_linkcolor'].";font-size:".$style['nav_size'].";}\n".
				"#html #nav li a:hover{color:".$style['nav_overcolor'].";}";
		$filedir=HDWIKI_ROOT.'/style/'.$style['path'].'/';
		file::forcemkdir($filedir);
		$bytes=file::writetofile($filedir.'mix_color.css',$data);
		return ($bytes>0);
	}
}
?>