<?php
/*
    [BBWPS!] (C)2006-2010 С۷Ȩ.
	This is NOT a freeware, use is subject to license terms
    ʱ䣺20063
    汾V1.0
    ģͻˣʵHTTPЭ(룩
*/
class HttpClient {
    var $host;                      //
    var $port;                      //˿
    var $path;                      //·
    var $method;                    //ʽ
    var $postdata = '';             //ݲ
    var $cookies = array();         //COOKIE
    var $referer;                   //һʵURL
    var $etag;
    var $accept = 'text/xml,application/xml,application/xhtml+xml,text/html,text/plain,image/png,image/jpeg,image/gif,*/*';
    var $accept_encoding = 'gzip';  //ܵѹ
    var $accept_language = 'en-us'; //ܵ
    var $user_agent = 'HttpClient'; //û
    // ±ߵǿѡ
    var $timeout = 20;             //ʱ
    var $use_gzip = true;           //Ƿ
    var $persist_cookies = true;    //ǷCOOKIEЧ
    var $persist_referers = true;   //ǷÿҪдһURL
    var $debug = false;             //Ƿ 
    var $handle_redirects = true;   //ԶתURLǷ
    var $max_redirects = 5;         //ת
    var $headers_only = false;      //ǷֻͷϢ
    //Ȩ
    var $username;                  //û
    var $password;                  //
    //Ӧı
    var $status;                    //״̬
    var $headers = array();         //ͷϢ 
    var $content = '';              //
    var $errormsg;                  //
    //ٱ
    var $redirect_count = 2;        //תĴ
    var $cookie_host = '';          //COOKIE
    //캯
    function HttpClient($host, $port=80) {
        $this->host = $host;
        $this->port = $port;
    }
    //GETdataǸӵʱĲ
    function get($path, $data = false) {
        $this->path = $path;
        $this->method = 'GET';
        if ($data) {
            $this->path .= '?'.$this->buildQueryString($data); //URL˲
        }
        return $this->doRequest();
    }
    //POSTdataύ
    function post($path, $data) {
        $this->path = $path;
        $this->method = 'POST';
        $this->postdata = $this->buildQueryString($data);    //ύ
    	return $this->doRequest();
    }
    //ʱĸӲ
    function buildQueryString($data) {
        $querystring = '';
        if (is_array($data)) {
            //ı
    		foreach ($data as $key => $val) {
    			if (is_array($val)) {
    				foreach ($val as $val2) {
    				    //URL룬&ֿ
    					$querystring .= urlencode($key).'='.urlencode($val2).'&';
    				}
    			} 
    			else {
    				$querystring .= urlencode($key).'='.urlencode($val).'&';
    			}
    		}
    		$querystring = substr($querystring, 0, -1); //ߵһ&
    	} 
    	else {
    	    $querystring = $data;
    	}
    	return $querystring;
    }
    //HTTP
    function doRequest() { 
        //һSOCKET
		if (!$fp = @fsockopen($this->host, $this->port, $errno, $errstr, $this->timeout)) {
		    //жǲϷ
            switch($errno) {
				case -3:
					$this->errormsg = 'Socketʧ(-3)';
				case -4:
					$this->errormsg = 'DNSûн(-4)';
				case -5:
					$this->errormsg = 'ӻǳʱ(-5)';
				default:
					$this->errormsg = 'ʧ('.$errno.')';
			    $this->errormsg .= ' '.$errstr;
			    $this->debug($this->errormsg);
			}
			return false;
        }
        //SOCKETĳʱʱ
        socket_set_timeout($fp, $this->timeout);
        //ͷϢ
        $request = $this->buildRequest();
        $this->debug('Request', $request);
        fwrite($fp, $request);    //ϢдSOCKETģHTTP
    	//еıգԵȴӦ
    	$this->headers = array();  //ӦͷϢ
    	$this->content = '';       //Ӧ
    	$this->errormsg = '';      //ӦĴ
    	//־
    	$inHeaders = true;
    	$atStart = true;
    	//ڿʼȡӦϢͶļĲһ
    	while (!feof($fp)) {
    	    $line = fgets($fp, 4096);  //ȥһϢ
    	    if ($atStart) {
    	        //ʼϢ
    	        $atStart = false;     //ñ־Ϣٽݱ
    	        if (!preg_match('/HTTP\/(\\d\\.\\d)\\s*(\\d+)\\s*(.*)/is', $line, $m)) { //ַ
    	            $this->errormsg = "Ӧ״̬: ".htmlentities($line);
    	            $this->debug($this->errormsg);
    	            return false;
    	        }
    	        $http_version = $m[1]; //HTTPЭİ汾
    	        $this->status = $m[2]; //Ӧ״̬
    	        $status_string = $m[3]; //״̬Ϣ
    	        $this->debug(trim($line));
    	        continue;             //ȥһе
    	    }
    	    if ($inHeaders) {
    	        if (trim($line) == '') {
    	            $inHeaders = false;
    	            $this->debug('Received Headers', $this->headers);
    	            if ($this->headers_only) {//жǷÿֻͷϢ
    	                break; //
    	            }
    	            continue;
    	        }
    	        if (!preg_match('/([^:]+):\\s*(.*)/is', $line, $m)) {
    	            continue;        //ȥһеݣѭ
    	        }
    	        $key = strtolower(trim($m[1]));
    	        $val = trim($m[2]);
    	        //ͷϢпǶ
    	        if (isset($this->headers[$key])) {
    	            if (is_array($this->headers[$key])) {
    	                $this->headers[$key][] = $val;
    	            } else {
    	                $this->headers[$key] = array($this->headers[$key], $val);
    	            }
    	        } else {
    	            $this->headers[$key] = $val;
    	        }
    	        continue;
    	    }
    	    //ͷϢӵ
    	    $this->content .= $line;
        }
        fclose($fp);
        //ǱѹжǷԽѹ͵ļ
        if (isset($this->headers['content-encoding']) && $this->headers['content-encoding'] == 'gzip') {
            $this->debug('ܵѹ, ڽѹ');
            $this->content = substr($this->content, 10); //
            $this->content = gzinflate($this->content);  //ѹ
        }
        $this->etag=$this->headers["etag"];
        //ҪгʱCOOKIEЧCOOKIEݱûйCOOKIEĿ¼ʵʲпЧģʱCOOKIEķͷһͬ
        if ($this->persist_cookies && isset($this->headers['set-cookie'])) { 
            $cookies = $this->headers['set-cookie'];
            if (!is_array($cookies)) {
                $cookies = array($cookies);
            }
            foreach ($cookies as $cookie) {
                if (preg_match('/([^=]+)=([^;]+);/is', $cookie, $m)) { //ԭĴе⣬֮COOKIE֮ûˣԣĻҵֵ
                   $this->cookies[$m[1]] = $m[2];
                }
                else{
                	if(preg_match('/([^=]+)=([^;]+)/is', $cookie, $m)){
                	   $this->cookies[$m[1]] = $m[2];
                	}
                }
            }
            //¼COOKIE򣬱͸COOKIE
            $this->cookie_host = $this->host;
        }
        //Ϊһεύ׼һ㶼ûʲôô
        if ($this->persist_referers) {
            //$this->debug('Persisting referer: '.$this->getRequestURL());
            //$this->debug('Persisting referer: '.'http://www.yesho.com/');
            $this->referer = $this->getRequestURL();
        }
        //֧Զת
        if ($this->handle_redirects) {
            if (++$this->redirect_count >= $this->max_redirects) {
                $this->errormsg = 'Number of redirects exceeded maximum ('.$this->max_redirects.')';
                $this->debug($this->errormsg);
                $this->redirect_count = 0;
                return false;
            }
            //תĵַ·
            $location = isset($this->headers['location']) ? $this->headers['location'] : '';
            $uri = isset($this->headers['uri']) ? $this->headers['uri'] : '';
            if ($location || $uri) {
                $url = parse_url($location.$uri);
                $this->host=$url["host"];
                return $this->get($url['path']);
            }
        }
        return true;
    }
    //ͷϢHTTPЭ
    function buildRequest() {
        $headers = array();
        //HTTPЭİ汾
        $headers[] = "{$this->method} {$this->path} HTTP/1.0";
        //ķ
        $headers[] = "Host: {$this->host}";
        //ôûһӦóHTTPCLIENT
        $headers[] = "User-Agent: {$this->user_agent}";
        //ÿԽܵļ
        $headers[] = "Accept: {$this->accept}";
        //ñ
        if ($this->use_gzip) {
            $headers[] = "Accept-encoding: {$this->accept_encoding}";
        }
        //
        $headers[] = "Accept-language: {$this->accept_language}";
        if ($this->referer) {
            $headers[] = "Referer: {$this->referer}";
            
        }
        //
        //$headers[] = "Referer: {http://count.skycn.com/softdownload.php?id=22620&url=http%3A%2F%2Fgztt.driversky.com%2Fdown%2FMOVDemo.exe}";
        //$headers[] = "Etag: {$this->etag}";
    	// Cookies
    	if ($this->cookies) {
    	    $cookie = 'Cookie: ';
    	    foreach ($this->cookies as $key => $value) {
    	        $cookie .= "$key=$value; ";
    	    }
    	    $headers[] = $cookie;
    	}
    	// ûȨϿɣһWEBǽWWWûôǺܴ
    	if ($this->username && $this->password) {
    	    $headers[] = 'Authorization: BASIC '.base64_encode($this->username.':'.$this->password);
    	}
    	// POSTݵͺͳ
    	if ($this->postdata) {
    	    $headers[] = 'Content-Type: application/x-www-form-urlencoded';
    	    $headers[] = 'Content-Length: '.strlen($this->postdata);
    	}
    	$request = implode("\r\n", $headers)."\r\n\r\n".$this->postdata;
    	return $request;
    }
    //״̬
    function getStatus() {
        return $this->status;
    }
    //󷵻ص
    function getContent() {
        return $this->content;
    }
    //󷵻صͷϢ
    function getHeaders() {
        return $this->headers;
    }
    //ĳһͷϢ
    function getHeader($header) {
        $header = strtolower($header);
        if (isset($this->headers[$header])) {
            return $this->headers[$header];
        } else {
            return false;
        }
    }
    //ô󱨸
    function getError() {
        return $this->errormsg;
    }
    //COOKIE
    function getCookies() {
        return $this->cookies;
    }
    //URL
    function getRequestURL() {
        $url = 'http://'.$this->host;
        if ($this->port != 80) {
            $url .= ':'.$this->port;
        }            
        $url .= $this->path;
        return $url;
    }
    // û
    function setUserAgent($string) {
        $this->user_agent = $string;
    }
    //֤
    function setAuthorization($username, $password) {
        $this->username = $username;
        $this->password = $password;
    }
    //COOKIE
    function setCookies($array) {
        $this->cookies = $array;
    }
    function setHost($string){
    	$this->host=$string;
    }
    function setPath($string){
    	$this->path=$string;
    }
    //ѡ
    function useGzip($boolean) {
        $this->use_gzip = $boolean;
    }
    //óڱCOOKIE
    function setPersistCookies($boolean) {
        $this->persist_cookies = $boolean;
    }
    //Ƿ񱣳һε
    function setPersistReferers($boolean) {
        $this->persist_referers = $boolean;
    }
    //Ƿض
    function setHandleRedirects($boolean) {
        $this->handle_redirects = $boolean;
    }
    //ضĴ
    function setMaxRedirects($num) {
        $this->max_redirects = $num;
    }
    function setHeadersOnly($boolean) {
        $this->headers_only = $boolean;
    }
    //Ƿ򿪵Ե״̬
    function setDebug($boolean) {
        $this->debug = $boolean;
    }
    function setTimePara($time){
    	$this->timeout=$time;
    }
    //٣򵥵GET
    function quickGet($url) {
        $bits = parse_url($url);
        $host = $bits['host'];
        $port = isset($bits['port']) ? $bits['port'] : 80;
        $path = isset($bits['path']) ? $bits['path'] : '/';
        if (isset($bits['query'])) {
            $path .= '?'.$bits['query'];
        }
        $client = new HttpClient($host, $port);
        if (!$client->get($path)) {
            return false;
        } else {
            return $client->getContent();
        }
    }
    //٣򵥵POST
    function quickPost($url, $data) {
        $bits = parse_url($url);
        $host = $bits['host'];
        $port = isset($bits['port']) ? $bits['port'] : 80;
        $path = isset($bits['path']) ? $bits['path'] : '/';
        $client = new HttpClient($host, $port);
        if (!$client->post($path, $data)) {
            return false;
        } else {
            return $client->getContent();
        }
    }
    //Դ
    function debug($msg, $object = false) {
        if ($this->debug) {
            print '<div style="border: 1px solid red; padding: 0.5em; margin: 0.5em;"><strong>HttpClient Debug:</strong> '.$msg;
            if ($object) {
                ob_start();
        	    print_r($object);
        	    $content = htmlentities(ob_get_contents());
        	    ob_end_clean();
        	    print '<pre>'.$content.'</pre>';
        	}
        	print '</div>';
        }
    }   
}
?>