dp.sh.Brushes.Php = function()
{
    var funcs = 'abs acos acosh addcslashes addslashes '+
                'array_change_key_case array_chunk array_combine array_count_values array_diff '+
                'array_diff_assoc array_diff_key array_diff_uassoc array_diff_ukey array_fill '+
                'array_filter array_flip array_intersect array_intersect_assoc array_intersect_key '+
                'array_intersect_uassoc array_intersect_ukey array_key_exists array_keys array_map '+
                'array_merge array_merge_recursive array_multisort array_pad array_pop array_product '+
                'array_push array_rand array_reduce array_reverse array_search array_shift '+
                'array_slice array_splice array_sum array_udiff array_udiff_assoc '+
                'array_udiff_uassoc array_uintersect array_uintersect_assoc '+
                'array_uintersect_uassoc array_unique array_unshift array_values array_walk '+
                'array_walk_recursive atan atan2 atanh base64_decode base64_encode base_convert '+
                'basename bcadd bccomp bcdiv bcmod bcmul bindec bindtextdomain bzclose bzcompress '+
                'bzdecompress bzerrno bzerror bzerrstr bzflush bzopen bzread bzwrite ceil chdir '+
                'checkdate checkdnsrr chgrp chmod chop chown chr chroot chunk_split class_exists '+
                'closedir closelog copy cos cosh count count_chars date decbin dechex decoct '+
                'deg2rad delete ebcdic2ascii end ereg ereg_replace eregi eregi_replace error_log '+
                'error_reporting escapeshellarg escapeshellcmd exec exp explode extension_loaded '+
                'feof fflush fgetc fgetcsv fgets fgetss file_exists file_get_contents file_put_contents '+
                'fileatime filectime filegroup fileinode filemtime fileowner fileperms filesize filetype '+
                'floatval flock floor flush fmod fnmatch fopen fpassthru fprintf fputcsv fputs fread fscanf '+
                'fseek fsockopen fstat ftell ftok getallheaders getcwd getdate getenv gethostbyaddr gethostbyname '+
                'gethostbynamel getimagesize getlastmod getmxrr getmygid getmyinode getmypid getmyuid getopt '+
                'getprotobyname getprotobynumber getrandmax getrusage getservbyname getservbyport gettext '+
                'gettimeofday gettype glob gmdate gmmktime ini_alter ini_get ini_get_all ini_restore ini_set '+
                'interface_exists intval ip2long is_a is_array is_bool is_callable is_dir is_double '+
                'is_executable is_file is_finite is_float is_infinite is_int is_integer is_link is_long '+
                'is_nan is_null is_numeric is_object is_readable is_real is_resource is_scalar is_soap_fault '+
                'is_string is_subclass_of is_uploaded_file is_writable is_writeable mkdir mktime nl2br '+
                'phpinfo parse_ini_file parse_str parse_url passthru pathinfo readlink realpath rewind rewinddir rmdir preg_replace '+
                'round str_ireplace str_pad str_repeat str_replace str_rot13 str_shuffle str_split '+
                'str_word_count strcasecmp strchr strcmp strcoll strcspn strftime strip_tags stripcslashes '+
                'stripos stripslashes stristr strlen strnatcasecmp strnatcmp strncasecmp strncmp strpbrk '+
                'strpos strptime strrchr strrev strripos strrpos strspn strstr strtok strtolower strtotime '+
                'strtoupper strtr strval substr substr_compare get_magic_quotes_gpc sprintf implode';

    var keywords =  '__CLASS__ __FILE__ __FUNCTION__ __LINE__ __METHOD__ abstract and array as break case catch cfunction '+
                    'class clone const continue declare default die do echo else elseif empty enddeclare endfor endforeach '+
                    'endif endswitch endwhile eval exception exit extends final for foreach function global if implements '+
                    'include include_once interface isset list new old_function or php_user_filter print private protected '+
                    'public require require_once return static switch this throw try unset use var while xor '+
                    '-&gt; :: @ TRUE FALSE NULL true false null';

    this.regexList = [
        { regex: dp.sh.RegexLib.SingleLineCComments,           css: 'comment' }, // one line comments
        { regex: dp.sh.RegexLib.MultiLineCComments,            css: 'comment' }, // multiline comments
        { regex: dp.sh.RegexLib.DoubleQuotedString,            css: 'string' },  // double quoted strings
        { regex: dp.sh.RegexLib.SingleQuotedString,            css: 'string' },  // single quoted strings
        { regex: new RegExp('\\$[a-zA-Z0-9_]+', 'g'),   css: 'vars' },    // variables
        { regex: new RegExp(this.GetKeywords(funcs), 'gmi'),   css: 'func' },    // functions
        { regex: new RegExp(this.GetKeywords(keywords), 'gm'), css: 'keyword' }  // keyword
        ];

    this.CssClass = 'dp-php';
}

dp.sh.Brushes.Php.prototype = new dp.sh.Highlighter();
dp.sh.Brushes.Php.Aliases   = ['php'];