<?php
  /**
     * @file   ru.lang.php
     * @author zero <zero@nzeo.com> | translation by Maslennikov Evgeny aka X-[Vr]bL1s5 | e-mail: x-bliss[a]tut.by; ICQ: 225035467;
     * @brief  Russian basic language pack for Zeroboard XE
     **/

    $lang->introduce_title = 'Установка Zeroboard XE';
    $lang->license = <<<EndOfLicense
- Название программы : zeroboard XE (zeroboardXE)
- Лицензия : СТРАНДАРТНАЯ ПУБЛИЧНАЯ ЛИЦЕНЗИЯ GNU (GNU GPL)
- Официальный веб-сайт : <a href="http://www.zeroboard.com">http://www.zeroboard.com</a>
- Автор : zero (zero@zeroboard.com, http://www.zeroboard.com)

Эта программа является бесплатным программным обеспечением, которое следует GPL лицензии.
Но, когда включены скины с дизайнерскими элементами, владелецы могут применять их индивидуальную лицензию.

<b>ПЕРЕВОД НА РУССКИЙ ЯЗЫК GENERAL PUBLIC LICENSE GNU</b>

автор перевода Елена Тяпкина [ tiapkina@hotmail.com ], 09-Aug-2001

This is an unofficial translation of the GNU General Public License into Russian. It was not published by the Free Software Foundation, and does not legally state the distribution terms for software that uses the GNU GPL - only the original English text of the GNU GPL does that. However, we hope that this translation will help Russian speakers understand the GNU GPL better.

Настоящий перевод Стандартной Общественной Лицензии GNU на русский язык не является официальным. Он не публикуется Free Software Foundation и не устанавливает имеющих юридическую силу условий для распространения программного обеспечения, которое распространяется на условиях Стандартной Общественной Лицензии GNU. Условия, имеющие юридическую силу, закреплены исключительно в аутентичном тексте Стандартной Общественной Лицензии GNU на английском языке. Я надеюсь, что настоящий перевод поможет русскоязычным пользователям лучше понять содержание Стандартной Общественной Лицензии GNU.

Текст GNU GPL на английском языке вы можете прочитать здесь http://www.gnu.org/copyleft/gpl.html

Содержание

    * Стандартная Общественная Лицензия GNU
          o Преамбула
          o Условия воспроизведения, распространения и модификации
          o Порядок применения условий Стандартной Общественной Лицензии к созданной вами программе

GNU GENERAL PUBLIC LICENSE

Версия 2, июнь 1991г.

Copyright (C) 1989, 1991 Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

Каждый вправе копировать и распространять экземпляры настоящей Лицензии без внесения изменений в ее текст.
Преамбула

Большинство лицензий на программное обеспечение лишаeт вас права распространять и вносить изменения в это программное обеспечение. Стандартная Общественная Лицензия GNU, напротив, разработана с целью гарантировать вам право совместно использовать и вносить изменения в свободное программное обеспечение, т.е. обеспечить свободный доступ к программному обеспечению для всех пользователей. Условия настоящей Стандартной Общественной Лицензии применяются к большей части программного обеспечения Free Software Foundation, а также к любому другому программному обеспечению по желанию его автора. (К некоторому программному обеспечению Free Software Foundation применяются условия Стандартной Общественной Лицензии GNU для Библиотек). Вы также можете применять Стандартную Общественную Лицензию к разработанному вами программному обеспечению.

Говоря о свободном программном обеспечении, мы имеем в виду свободу, а не безвозмездность. Настоящая Стандартная Общественная Лицензия разработана с целью гарантировать вам право распространять экземпляры свободного программного обеспечения (и при желании получать за это вознаграждение), право получать исходный текст программного обеспечения или иметь возможность его получить, право вносить изменения в программное обеспечение или использовать его части в новом свободном программном обеспечении, а также право знать, что вы имеете все вышеперечисленные права.

Чтобы защитить ваши права, мы вводим ряд ограничений с тем, чтобы никто не имел возможности лишить вас этих прав или обратиться к вам с предложением отказаться от этих прав. Данные ограничения налагают на вас определенные обязанности в случае, если вы распространяете экземпляры программного обеспечения или модифицируете программное обеспечение.

Например, если вы распространяете экземпляры такого программного обеспечения за плату или бесплатно, вы обязаны передать новым обладателям все права в том же объеме, в каком они принадлежат вам. Вы обязаны обеспечить получение новыми обладателями программы ее исходного текста или возможность его получить. Вы также обязаны ознакомить их с условиями настоящей Лицензии.

Для защиты ваших прав мы: (1) оставляем за собой авторские права на программное обеспечение и (2) предлагаем вам использовать настоящую Лицензию, в соответствии с условиями которой вы вправе воспроизводить, распространять и/или модифицировать программное обеспечение.

Кроме того, для защиты как нашей репутации, так и репутации других авторов программного обеспечения, мы уведомляем всех пользователей, что на данное программное обеспечение никаких гарантий не предоставляется. Те, кто приобрел программное обеспечение, с внесенными в него третьими лицами изменениями, должны знать, что они получают не оригинал, в силу чего автор оригинала не несет ответственности за ошибки в работе программного обеспечения, допущенные третьими лицами при внесении изменений.

Наконец, программное обеспечение перестает быть свободным в случае, если лицо приобретает на него исключительные права [1]. Недопустимо, чтобы лица, распространяющие свободное программное обеспечение, могли приобрести исключительные права на использование данного программного обеспечения и зарегистрировать их в Патентном ведомстве. Чтобы избежать этого, мы заявляем, что обладатель исключительных прав обязан предоставить любому лицу права на использование программного обеспечения либо не приобретать исключительных прав вообще.

Ниже изложены условия воспроизведения, распространения и модификации программного обеспечения.
Условия воспроизведения, распространения и модификации

0. Условия настоящей Лицензии применяются ко всем видам программного обеспечения или любому иному произведению, которое содержит указание правообладателя на то, что данное произведение может распространяться на условиях Стандартной Общественной Лицензии. Под термином "Программа" далее понимается любое подобное программное обеспечение или иное произведение. Под термином "произведение, производное от Программы" понимается Программа или любое иное производное произведение в соответствии с законодательством об авторском праве [2], т.е. произведение, включающее в себя Программу или ее часть, как с внесенными в ее текст изменениями, так и без них и/или переведенную на другой язык. (Здесь и далее, понятие "модификация" включает в себя понятие перевода в самом широком смысле). Каждый приобретатель экземпляра Программы именуется в дальнейшем "Лицензиат".

Действие настоящей Лицензии не распространяется на осуществление иных прав, кроме воспроизведения, распространения и модификации программного обеспечения. Не устанавливается ограничений на запуск Программы. Условия Лицензии распространяются на выходные данные из Программы только в том случае, если их содержание составляет произведение, производное от Программы (независимо от того, было ли такое произведение создано в результате запуска Программы). Это зависит от того, какие функции выполняет Программа.

1. Лицензиат вправе изготовлять и распространять экземпляры исходного текста Программы в том виде, в каком он его получил, без внесения в него изменений на любом носителе, при соблюдении следующих условий: на каждом экземпляре помещен знак охраны авторского права и уведомление об отсутствии гарантий; оставлены без изменений все уведомления, относящиеся к настоящей Лицензии и отсутствию гарантий; вместе с экземпляром Программы приобретателю передается копия настоящей Лицензии.

Лицензиат вправе взимать плату за передачу экземпляра Программы, а также вправе за плату оказывать услуги по гарантийной поддержке Программы.

2. Лицензиат вправе модифицировать свой экземпляр или экземпляры Программы полностью или любую ее часть. Данные действия Лицензиата влекут за собой создание произведения, производного от Программы. Лицензиат вправе изготовлять и распространять экземпляры такого произведения, производного от Программы, или собственно экземпляры изменений в соответствии с пунктом 1 настоящей Лицензии при соблюдении следующих условий:

а) файлы, измененные Лицензиатом, должны содержать хорошо заметную пометку, что они были изменены, а также дату внесения изменений;

b) при распространении или публикации Лицензиатом любого произведения, которое содержит Программу или ее часть или является производным от Программы или от ее части, Лицензиат обязан передавать права на использование данного произведения третьим лицам на условиях настоящей Лицензии, при этом Лицензиат не вправе требовать уплаты каких-либо лицензионных платежей. Распространяемое произведение лицензируется как одно целое;

c) если модифицированная Программа при запуске обычно читает команды в интерактивном режиме, Лицензиат обязан обеспечить вывод на экран дисплея или печатающее устройство, сообщение, которое должно включать в себя:
знак охраны авторского права;
уведомление об отсутствии гарантий на Программу (или иное, если Лицензиат предоставляет гарантии);
указание на то, что пользователи вправе распространять экземпляры Программы в соответствии с условиями настоящей Лицензии, а также на то, каким образом пользователь может ознакомиться с текстом настоящей Лицензии. (Исключение: если оригинальная Программа является интерактивной, но не выводит в своем обычном режиме работы сообщение такого рода, то вывод подобного сообщения произведением, производным от Программы, в этом случае не обязателен).

Вышеуказанные условия применяются к модифицированному произведению, производному от Программы, в целом. В случае если отдельные части данного произведения не являются производными от Программы, являются результатом творческой деятельности и могут быть использованы как самостоятельное произведение, Лицензиат вправе распространять отдельно такое произведение на иных лицензионных условиях. В случае если Лицензиат распространяет вышеуказанные части в составе произведения, производного от Программы, то условия настоящей Лицензии применяются к произведению в целом, при этом права, приобретаемые сублицензиатами на основании Лицензии, передаются им в отношении всего произведения, включая все его части, независимо от того, кто является их авторами.

Целью настоящего пункта 2 не является заявление прав или оспаривание прав на произведение, созданное исключительно Лицензиатом. Целью настоящего пункта является обеспечение права контролировать распространение произведений, производных от Программы, и составных произведений, производных от Программы.

Размещение произведения, которое не является производным от Программы, на одном устройстве для хранения информации или носителе вместе с Программой или произведением, производным от Программы, не влечет за собой распространения условий настоящей Лицензии на такое произведение.

3. Лицензиат вправе воспроизводить и распространять экземпляры Программы или произведения, которое является производным от Программы, в соответствии с пунктом 2 настоящей Лицензии, в виде объектного кода или в исполняемой форме в соответствии с условиями п.п.1 и 2 настоящей Лицензии при соблюдении одного из перечисленных ниже условий:

а) к экземпляру должен прилагаться соответствующий полный исходный текст в машиночитаемой форме, который должен распространяться в соответствии с условиями п.п. 1 и 2 настоящей Лицензии на носителе, обычно используемом для передачи программного обеспечения, либо

b) к экземпляру должно прилагаться действительное в течение трех лет предложение в письменной форме к любому третьему лицу передать за плату, не превышающую стоимость осуществления собственно передачи, экземпляр соответствующего полного исходного текста в машиночитаемой форме в соответствии с условиями п.п. 1 и 2 настоящей Лицензии на носителе, обычно используемом для передачи программного обеспечения, либо

c) к экземпляру должна прилагаться полученная Лицензиатом информация о предложении, в соответствии с которым можно получить соответствующий исходный текст. (Данное положение применяется исключительно в том случае, если Лицензиат осуществляет некоммерческое распространение программы, при этом программа была получена самим Лицензиатом в виде объектного кода или в исполняемой форме и сопровождалась предложением, соответствующим условиям пп.b п.3 настоящей Лицензии).

Под исходным текстом произведения понимается такая форма произведения, которая наиболее удобна для внесения изменений. Под полным исходным текстом исполняемого произведения понимается исходный текст всех составляющих произведение модулей, а также всех файлов, связанных с описанием интерфейса, и сценариев, предназначенных для управления компиляцией и установкой исполняемого произведения. Однако, в качестве особого исключения, распространяемый исходный текст может не включать того, что обычно распространяется (в виде исходного текста или в бинарной форме) с основными компонентами (компилятор, ядро и т.д.) операционной системы, в которой работает исполняемое произведение, за исключением случаев, когда исполняемое произведение сопровождается таким компонентом.

В случае если произведение в виде объектного кода или в исполняемой форме распространяется путем предоставления доступа для копирования его из определенного места, обеспечение равноценного доступа для копирования исходного текста из этого же места удовлетворяет требованиям распространения исходного текста, даже если третьи лица при этом не обязаны копировать исходный текст вместе с объектным кодом произведения.

4. Лицензиат вправе воспроизводить, модифицировать, распространять или передавать права на использование Программы только на условиях настоящей Лицензии. Любое воспроизведение, модификация, распространение или передача прав на иных условиях являются недействительными и автоматически ведут к расторжению настоящей Лицензии и прекращению всех прав Лицензиата, предоставленных ему настоящей Лицензией. При этом права третьих лиц, которым Лицензиат в соответствии с настоящей Лицензией передал экземпляры Программы или права на нее, сохраняются в силе при условии полного соблюдения ими настоящей Лицензии.

5. Лицензиат не обязан присоединяться к настоящей Лицензии, поскольку он ее не подписал. Однако только настоящая Лицензия предоставляет право распространять или модифицировать Программу или произведение, производное от Программы. Подобные действия нарушают действующее законодательство, если они не осуществляются в соответствии с настоящей Лицензией. Если Лицензиат внес изменения или осуществил распространение экземпляров Программы или произведения, производного от Программы, Лицензиат тем самым подтвердил свое присоединение к настоящей Лицензии в целом, включая условия, определяющие порядок воспроизведения, распространения или модификации Программы или произведения, производного от Программы.

6. При распространении экземпляров Программы или произведения, производного от Программы, первоначальный лицензиар автоматически передает приобретателю такого экземпляра право воспроизводить, распространять и модифицировать Программу в соответствии с условиями настоящей Лицензии. Лицензиат не вправе ограничивать каким-либо способом осуществление приобретателями полученных ими прав. Лицензиат не несет ответственности за несоблюдение условий настоящей Лицензии третьими лицами.

7. Лицензиат не освобождается от исполнения обязательств в соответствии с настоящей Лицензией в случае, если в результате решения суда или заявления о нарушении исключительных прав или в связи с наступлением иных обстоятельств, не связанных непосредственно с нарушением исключительных прав, на Лицензиата на основании решения суда, договора или ином основании возложены обязательства, которые противоречат условиям настоящей Лицензии. В этом случае Лицензиат не вправе распространять экземпляры Программы, если он не может одновременно исполнить условия настоящей Лицензии и возложенные на него указанным выше способом обязательства. Например, если по условиям лицензионного соглашения сублицензиатам не может быть предоставлено право бесплатного распространения экземпляров Программы, которые они приобрели напрямую или через третьих лиц у Лицензиата, то в этом случае Лицензиат обязан отказаться от распространения экземпляров Программы.

Если любое положение настоящего пункта при наступлении конкретных обстоятельств будет признано недействительным или неприменимым, настоящий пункт применяется за исключением такого положения. Настоящий пункт применяется в целом при прекращении вышеуказанных обстоятельств или их отсутствии.

Целью данного пункта не является принуждение Лицензиата к нарушению патента или заявления на иные права собственности или к оспариванию действительности такого заявления. Единственной целью данного пункта является защита неприкосновенности системы распространения свободного программного обеспечения, которая обеспечивается за счет общественного лицензирования. Многие люди внесли свой щедрый вклад в создание большого количества программного обеспечения, которое распространяется через данную систему в надежде на ее длительное и последовательное применение. Лицензиат не вправе вынуждать автора распространять программное обеспечение через данную систему. Право выбора системы распространения программного обеспечения принадлежит исключительно его автору.

Настоящий пункт 7 имеет целью четко определить те цели, которые преследуют все остальные положения настоящей Лицензии.

8. В том случае если распространение и/или использование Программы в отдельных государствах ограничено соглашениями в области патентных или авторских прав, первоначальный правообладатель, распространяющий Программу на условиях настоящей Лицензии, вправе ограничить территорию распространения Программы, указав только те государства, на территории которых допускается распространение Программы без ограничений, обусловленных такими соглашениями. В этом случае такое указание в отношении территорий определенных государств признается одним из условий настоящей Лицензии.

9. Free Software Foundation может публиковать исправленные и/или новые версии настоящей Стандартной Общественной Лицензии. Такие версии могут быть дополнены различными нормами, регулирующими правоотношения, которые возникли после опубликования предыдущих версий, однако в них будут сохранены основные принципы, закрепленные в настоящей версии.

Каждой версии присваивается свой собственный номер. Если указано, что Программа распространяется в соответствии с определенной версией, т.е. указан ее номер, или любой более поздней версией настоящей Лицензии, Лицензиат вправе присоединиться к любой из этих версий Лицензии, опубликованных Free Software Foundation. Если Программа не содержит такого указания на номер версии Лицензии Лицензиат вправе присоединиться к любой из версий Лицензии, опубликованных когда-либо Free Software Foundation.

10. В случае если Лицензиат намерен включить часть Программы в другое свободное программное обеспечение, которое распространяется на иных условиях, чем в настоящей Лицензии, ему следует испросить письменное разрешение на это у автора программного обеспечения. Разрешение в отношении программного обеспечения, права на которое принадлежат Free Software Foundation, следует испрашивать у Free Software Foundation. В некоторых случаях Free Software Foundation делает исключения. При принятии решения Free Software Foundation будет руководствоваться двумя целями: сохранение статуса свободного для любого произведения, производного от свободного программного обеспечения Free Software Foundation и обеспечение наиболее широкого совместного использования программного обеспечения.

ОТСУТСТВИЕ ГАРАНТИЙНЫХ ОБЯЗАТЕЛЬСТВ

11. ПОСКОЛЬКУ НАСТОЯЩАЯ ПРОГРАММА РАСПРОСТРАНЯЕТСЯ БЕСПЛАТНО, ГАРАНТИИ НА НЕЕ НЕ ПРЕДОСТАВЛЯЮТСЯ В ТОЙ СТЕПЕНИ, В КАКОЙ ЭТО ДОПУСКАЕТСЯ ПРИМЕНИМЫМ ПРАВОМ. НАСТОЯЩАЯ ПРОГРАММА ПОСТАВЛЯЕТСЯ НА УСЛОВИЯХ "КАК ЕСТЬ". ЕСЛИ ИНОЕ НЕ УКАЗАНО В ПИСЬМЕННОЙ ФОРМЕ, АВТОР И/ИЛИ ИНОЙ ПРАВООБЛАДАТЕЛЬ НЕ ПРИНИМАЕТ НА СЕБЯ НИКАКИХ ГАРАНТИЙНЫХ ОБЯЗАТЕЛЬСТВ, КАК ЯВНО ВЫРАЖЕННЫХ, ТАК И ПОДРАЗУМЕВАЕМЫХ, В ОТНОШЕНИИ ПРОГРАММЫ, В ТОМ ЧИСЛЕ ПОДРАЗУМЕВАЕМУЮ ГАРАНТИЮ ТОВАРНОГО СОСТОЯНИЯ ПРИ ПРОДАЖЕ И ПРИГОДНОСТИ ДЛЯ ИСПОЛЬЗОВАНИЯ В КОНКРЕТНЫХ ЦЕЛЯХ, А ТАКЖЕ ЛЮБЫЕ ИНЫЕ ГАРАНТИИ. ВСЕ РИСКИ, СВЯЗАННЫЕ С КАЧЕСТВОМ И ПРОИЗВОДИТЕЛЬНОСТЬЮ ПРОГРАММЫ, НЕСЕТ ЛИЦЕНЗИАТ. В СЛУЧАЕ ЕСЛИ В ПРОГРАММЕ БУДУТ ОБНАРУЖЕНЫ НЕДОСТАТКИ, ВСЕ РАСХОДЫ, СВЯЗАННЫЕ С ТЕХНИЧЕСКИМ ОБСЛУЖИВАНИЕМ, РЕМОНТОМ ИЛИ ИСПРАВЛЕНИЕМ ПРОГРАММЫ, НЕСЕТ ЛИЦЕНЗИАТ.

12. ЕСЛИ ИНОЕ НЕ ПРЕДУСМОТРЕНО ПРИМЕНЯЕМЫМ ПРАВОМ ИЛИ НЕ СОГЛАСОВАНО СТОРОНАМИ В ДОГОВОРЕ В ПИСЬМЕННОЙ ФОРМЕ, АВТОР И/ИЛИ ИНОЙ ПРАВООБЛАДАТЕЛЬ, КОТОРЫЙ МОДИФИЦИРУЕТ И/ИЛИ РАСПРОСТРАНЯЕТ ПРОГРАММУ НА УСЛОВИЯХ НАСТОЯЩЕЙ ЛИЦЕНЗИИ, НЕ НЕСЕТ ОТВЕТСТВЕННОСТИ ПЕРЕД ЛИЦЕНЗИАТОМ ЗА УБЫТКИ, ВКЛЮЧАЯ ОБЩИЕ, РЕАЛЬНЫЕ, ПРЕДВИДИМЫЕ И КОСВЕННЫЕ УБЫТКИ (В ТОМ ЧИСЛЕ УТРАТУ ИЛИ ИСКАЖЕНИЕ ИНФОРМАЦИИ, УБЫТКИ, ПОНЕСЕННЫЕ ЛИЦЕНЗИАТОМ ИЛИ ТРЕТЬИМИ ЛИЦАМИ, НЕВОЗМОЖНОСТЬ РАБОТЫ ПРОГРАММЫ С ЛЮБОЙ ДРУГОЙ ПРОГРАММОЙ И ИНЫЕ УБЫТКИ). АВТОР И/ИЛИ ИНОЙ ПРАВООБЛАДАТЕЛЬ В СООТВЕТСТВИИ С НАСТОЯЩИМ ПУНКТОМ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ДАЖЕ В ТОМ СЛУЧАЕ, ОНИ БЫЛИ ПРЕДУПРЕЖДЕНЫ О ВОЗМОЖНОСТИ ВОЗНИКНОВЕНИЯ ТАКИХ УБЫТКОВ.
Порядок применения условий Стандартной Общественной Лицензии к созданной вами программе

Если вы создали новую программу и хотите, чтобы она принесла наибольшую пользу обществу, лучший способ достичь этого - сделать вашу программу свободной, когда каждый сможет распространять ее и вносить в нее изменения в соответствии с условиями настоящей Лицензии.

В этих целях Программа должна содержать приведенное ниже уведомление. Наиболее правильным будет поместить его в начале исходного текста каждого файла для максимально ясного указания на то, что гарантии на данную программу не предоставляются. Каждый файл в любом случае должен содержать знак охраны авторского права и пояснение, где можно ознакомиться с полным текстом уведомления.

[одна строка с наименованием Программы и кратким описанием ее назначения]
© имя (наименование) автора или иного правообладателя, год первого опубликования программы

Данная программа является свободным программным обеспечением. Вы вправе распространять ее и/или модифицировать в соответствии с условиями версии 2 либо по вашему выбору с условиями более поздней версии Стандартной Общественной Лицензии GNU, опубликованной Free Software Foundation.

Мы распространяем эту программу в надежде на то, что она будет вам полезной, однако НЕ ПРЕДОСТАВЛЯЕМ НА НЕЕ НИКАКИХ ГАРАНТИЙ, в том числе ГАРАНТИИ ТОВАРНОГО СОСТОЯНИЯ ПРИ ПРОДАЖЕ и ПРИГОДНОСТИ ДЛЯ ИСПОЛЬЗОВАНИЯ В КОНКРЕТНЫХ ЦЕЛЯХ.Для получения более подробной информации ознакомьтесь со Стандартной Общественной Лицензией GNU.

Вместе с данной программой вы должны были получить экземпляр Стандартной Общественной Лицензии GNU. Если вы его не получили, сообщите об этом в Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

Также укажите, как можно связаться с вами по электронной или обычной почте.

Если программа работает в интерактивном режиме, сделайте так, чтобы при запуске в интерактивном режиме выводилось короткое сообщение в соответствии с образцом:

Gnomovision version 69, © имя автора, год первого опубликования программы
Gnomovision распространяется БЕЗ ВСЯКИХ ГАРАНТИЙ; чтобы ознакомиться с более подробной информацией, наберите "show w". Данная программа является свободным программным обеспечением и вы можете распространять ее в соответствии с условиями Стандартной Общественной Лицензии GNU. Для получения более подробной информации, наберите "show c".

При введении предлагаемых команд "show w" и "show c" на экран должны выводиться соответствующие пункты Стандартной Общественной Лицензии. Не обязательно использовать именно команды "show w" и "show c". В зависимости от функций программы, команды могут вызываться нажатием кнопки мыши или быть добавлены в меню программы.

Если вы создали программу в порядке выполнения служебных обязанностей или служебного задания работодателя, вам следует получить от него в случае необходимости письменный отказ от исключительных прав на использование данной программы [3 ]. Нижеприведенный текст вы можете использовать в качестве образца, заменив соответствующие имена и наименования:

ЗАО "АБВ" настоящим отказывается от всех исключительных прав на использование программы для ЭВМ "Gnomovision", автором которой является Иванов Алексей Петрович, и передает все исключительные права на использование указанной программы ее автору, Иванову Алексею Петровичу.

Подпись руководителя организации, печать, 1 января 2001г.
[Фамилия, Имя, Отчество], Генеральный директор

Стандартная Общественная Лицензия GNU запрещает включать вашу программу в программы, использование которых ограничено их правообладателями. Если ваша программа является библиотекой подпрограмм, вероятно, более полезным будет разрешить связывание программ, использование которых ограничено их правообладателями, с вашей библиотекой. В этом случае вам следует использовать Стандартную Общественную Лицензию GNU для Библиотек вместо настоящей Лицензии.

Примечания переводчика

[1] - в параграфе 7 Преамбулы в английском тексте Стандартной Общественной Лицензии GNU упоминается патент на программное обеспечение (Software Patents). В начале 90х годов XX века Апелляционный суд Федерального округа США предпринял попытку установить, когда изобретение, частью которого является программное обеспечение, является патентоспособным. Суд постановил, что в этом случае следует провести экспертизу в отношении произведения в целом. Изобретение не будет признано патентоспособным, если оно представляет собой исключительно математический алгоритм. Однако, если положенный в основу изобретения способ при помощи программного обеспечения позволяет получить конкретные, промышленно применимые результаты, в этом случае изобретение является патентоспособным. В отличие от США, в РФ соответствии с Патентным законом от 23.09.1992г. не признаются патентоспособными изобретениями программы для вычислительных машин. Защита программ для ЭВМ осуществляется на основании норм законодательства об авторском праве. Исключительные права на программу для ЭВМ принадлежат автору или иному правообладателю, который приобрел их на основании договора или ином основании, предусмотренным законом. Правообладатель всех имущественных прав на программу для ЭВМ в течение срока действия авторского права может по своему желанию зарегистрировать программу для ЭВМ путем подачи заявки в Патентное ведомство РФ

[2] - Здесь имеется в виду законодательство об авторском праве США.

[3] - В данном абзаце в английском тексте указано, что вам следует получить письменный отказ от исключительных прав на использование созданной вами программы у вашего работодателя, если вы работаете программистом, или у учебного заведения, в котором вы обучаетесь (школа, университет, институт, колледж). В соответствии с Законом РФ "Об авторском праве и смежных правах" такой отказ следует получить только от своего работодателя. В соответствии с указанным Законом РФ авторское право на произведение, созданное в порядке выполнения служебных обязанностей или служебного задания работодателя (служебное произведение), принадлежит автору служебного произведения. Исключительные права на использование служебного произведения (в том числе программы для ЭВМ) принадлежат лицу, с которым автор состоит в трудовых отношениях (работодателю), если в договоре между ними и автором не предусмотрено иное. Данное положение не распространяется на создание в порядке выполнения служебных обязанностей или служебного задания работодателя энциклопедий, энциклопедических словарей, периодических и продолжающихся сборников научных трудов, газет, журналов и других периодических изданий. Издателю энциклопедий, энциклопедических словарей, периодических и продолжающихся изданий принадлежат исключительные права на использование таких изданий. Авторы произведений, включенных в такие издания, сохраняют исключительные права на использование своих произведений независимо от издания в целом.

My goal was not just a verbal translation of English text of GNU General Public License in Russian, but a translation, which will follow the rules of current legislation of Russian Federation on copyrights. I hope that this will help to use GNU General Public License when distributing free software in Russian Federation. Below you may find some comments (in Russian) on current legislation of Russian Federation.

Моей целью был не просто перевод Стандартной Общественной Лицензии GNU, который бы максимально точно соответствовал аутентичному тексту на английском языке, но также учитывал нормы действующего законодательства РФ об авторском праве, что увеличило бы возможность использовать Стандартную Общественную Лицензию GPL для распространения свободного программного обеспечения на территории РФ. Ниже Вы можете ознакомиться с некоторыми комментариями относительно действующего законодательства РФ.

В настоящее время на территории Российской Федерации порядок воспроизведения, распространения и модификации программного обеспечения регулируется Законом РФ "О правовой охране программ для ЭВМ и баз данных" от 23.09.1992г. ╧3523-1 и Законом РФ "Об авторском праве и смежных правах" от 09.07.1993г. ╧5351-1.

С целью наибольшего соответствия настоящего неофициального перевода Стандартной Общественной Лицензии GNU на русский язык нормам действующего законодательства РФ об авторском праве, ниже приводятся основные понятие, используемые в тексте перевода, и их определения в соответствии с указанными выше Законами РФ:

Программное обеспечение - данное понятие не применяется в указанных Законах, однако оно является наиболее общепринятым при обозначении программ для ЭВМ в переводах лицензионных соглашений, в частности Лицензионных соглашений с конечным пользователем (EULA), на русский язык. В силу этого понятие "Программное обеспечение" используется в тексте перевода для обозначения понятия "программа для ЭВМ". Под программой для ЭВМ Законе РФ понимается объективная форма представления совокупности данных и команд, предназначенных для функционирования электронных вычислительных машин (ЭВМ) и других компьютерных устройств с целью получения определенного результата, включая подготовительные материалы, полученные в ходе разработки программы для ЭВМ, и порождаемые ею аудиовизуальные отображения.

Исключительные права на использование произведения - означает право осуществлять или разрешать следующие действия: воспроизводить произведение (право на воспроизведение); распространять экземпляры произведения любым способом: продавать, сдавать в прокат и так далее (право на распространение); публично показывать произведение (право на публичный показ), переводить произведение (право на перевод); переделывать, аранжировать или другим образом перерабатывать произведение (право на переработку), а также иные права в соответствии с Законом РФ "Об авторском праве и смежных правах".

Исключительные (или имущественные) права на использование программы для ЭВМ - означает исключительное право осуществлять и (или) разрешать осуществление следующих действий: выпуск в свет программы для ЭВМ, воспроизведение программы для ЭВМ (полное или частичное) в любой форме, любыми способами, распространение программы для ЭВМ, модификацию программы для ЭВМ, в том числе перевод программы для ЭВМ с одного языка на другой, а также иное использование в соответствии с Законом РФ "О правовой охране программ для ЭВМ и баз данных".

Воспроизведение Программного Обеспечения - это изготовление одного или более экземпляров Программного обеспечения в любой материальной форме, а также его запись в память ЭВМ.

Модификация (переработка) Программного Обеспечения - любые его изменения, не являющиеся адаптацией.

Распространение Программного Обеспечения - это предоставление доступа для воспроизведения в любой материальной форме Программного Обеспечения, в том числе сетевыми и иными способами, а также путем продажи, проката, сдачи в наем, предоставление взаймы, включая импорт для любой из этих целей.

© Перевод лицензии: Елена Тяпкина, 2001г.
© License Translation: Elena Tyapkina, 2001.


<b>Перевод Zeroboard XE на русский язык произвел Масленников Евгений aka X-[Vr]bL1s5.</b>
Перевод следует Лицензии Свободной Документации GNU (GNU Free Documentation License), с содержимым которой можно ознакомиться по следующему адесу: http://www.gnu.org/licenses/fdl.html
Кантакты: x-bliss(at)tut.by, ICQ: 225035467, MSN: x-bliss(at)tut.by, YIM: maenwen, AIM: mayoojin, Skype: maenwen

<b>Translation of Zeroboard XE into Russian language is made by Maslennikov Evgeny aka X-[Vr]bL1s5.</b>
The translation follows GNU Free Documentation License, which you can observe on the following address: http://www.gnu.org/licenses/fdl.html
Contacts: x-bliss(at)tut.by, ICQ: 225035467, MSN: x-bliss(at)tut.by, YIM: maenwen, AIM: mayoojin, Skype: maenwen


Оригинал лицензии GNU GPL на английским языке.

<b>GNU GENERAL PUBLIC LICENSE</b>

Version 2, June 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
Everyone is permitted to copy and distribute verbatim copies of this license document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public License is intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users. This General Public License applies to most of the Free Software Foundation's software and to any other program whose authors commit to using it. (Some other Free Software Foundation software is covered by the GNU Lesser General Public License instead.) You can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish), that you receive source code or can get it if you want it, that you can change the software or use pieces of it in new free programs; and that you know you can do these things.

To protect your rights, we need to make restrictions that forbid anyone to deny you these rights or to ask you to surrender the rights. These restrictions translate to certain responsibilities for you if you distribute copies of the software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or for a fee, you must give the recipients all the rights that you have. You must make sure that they, too, receive or can get the source code. And you must show them these terms so they know their rights.

We protect your rights with two steps: (1) copyright the software, and (2) offer you this license which gives you legal permission to copy, distribute and/or modify the software.

Also, for each author's protection and ours, we want to make certain that everyone understands that there is no warranty for this free software. If the software is modified by someone else and passed on, we want its recipients to know that what they have is not the original, so that any problems introduced by others will not reflect on the original authors' reputations.

Finally, any free program is threatened constantly by software patents. We wish to avoid the danger that redistributors of a free program will individually obtain patent licenses, in effect making the program proprietary. To prevent this, we have made it clear that any patent must be licensed for everyone's free use or not licensed at all.

The precise terms and conditions for copying, distribution and modification follow.
TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice placed by the copyright holder saying it may be distributed under the terms of this General Public License. The "Program", below, refers to any such program or work, and a "work based on the Program" means either the Program or any derivative work under copyright law: that is to say, a work containing the Program or a portion of it, either verbatim or with modifications and/or translated into another language. (Hereinafter, translation is included without limitation in the term "modification".) Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running the Program is not restricted, and the output from the Program is covered only if its contents constitute a work based on the Program (independent of having been made by running the Program). Whether that is true depends on what the Program does.

1. You may copy and distribute verbatim copies of the Program's source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and give any other recipients of the Program a copy of this License along with the Program.

You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee.

2. You may modify your copy or copies of the Program or any portion of it, thus forming a work based on the Program, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions:

a) You must cause the modified files to carry prominent notices stating that you changed the files and the date of any change. 
b) You must cause any work that you distribute or publish, that in whole or in part contains or is derived from the Program or any part thereof, to be licensed as a whole at no charge to all third parties under the terms of this License. 
c) If the modified program normally reads commands interactively when run, you must cause it, when started running for such interactive use in the most ordinary way, to print or display an announcement including an appropriate copyright notice and a notice that there is no warranty (or else, saying that you provide a warranty) and that users may redistribute the program under these conditions, and telling the user how to view a copy of this License. (Exception: if the Program itself is interactive but does not normally print such an announcement, your work based on the Program is not required to print an announcement.) 

These requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Program, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Program, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Program.

In addition, mere aggregation of another work not based on the Program with the Program (or with a work based on the Program) on a volume of a storage or distribution medium does not bring the other work under the scope of this License.

3. You may copy and distribute the Program (or a work based on it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you also do one of the following:

a) Accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or, 
b) Accompany it with a written offer, valid for at least three years, to give any third party, for a charge no more than your cost of physically performing source distribution, a complete machine-readable copy of the corresponding source code, to be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange; or, 
c) Accompany it with the information you received as to the offer to distribute corresponding source code. (This alternative is allowed only for noncommercial distribution and only if you received the program in object code or executable form with such an offer, in accord with Subsection b above.) 

The source code for a work means the preferred form of the work for making modifications to it. For an executable work, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the executable. However, as a special exception, the source code distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable.

If distribution of executable or object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place counts as distribution of the source code, even though third parties are not compelled to copy the source along with the object code.

4. You may not copy, modify, sublicense, or distribute the Program except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense or distribute the Program is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance.

5. You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Program or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Program (or any work based on the Program), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Program or works based on it.

6. Each time you redistribute the Program (or any work based on the Program), the recipient automatically receives a license from the original licensor to copy, distribute or modify the Program subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties to this License.

7. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Program at all. For example, if a patent license would not permit royalty-free redistribution of the Program by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply and the section as a whole is intended to apply in other circumstances.

It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system, which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice.

This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License.

8. If the distribution and/or use of the Program is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Program under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License.

9. The Free Software Foundation may publish revised and/or new versions of the General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns.

Each version is given a distinguishing version number. If the Program specifies a version number of this License which applies to it and "any later version", you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Program does not specify a version number of this License, you may choose any version ever published by the Free Software Foundation.

10. If you wish to incorporate parts of the Program into other free programs whose distribution conditions are different, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally.

NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
END OF TERMS AND CONDITIONS





EndOfLicense;

    $lang->install_condition_title = "Пожалуйста, проверьте требования к установке.";

    $lang->install_checklist_title = array(
			'php_version' => 'Версия PHP',
            'permission' => 'Права доступа',
            'xml' => 'XML библиотека',
            'iconv' => 'ICONV библиотека',
            'gd' => 'GD библиотека',
            'session' => 'Session.auto_start настройка',
        );

    $lang->install_checklist_desc = array(
			'php_version' => '[Требуется] Если версия PHP равна 5.2.2, то zeroboard не будет установлена из-за бага',
            'permission' => '[Требуется] Путь установки Zeroboard или директория ./files должна иметь права доступа 707',
            'xml' => '[Требуется] XML Библиотека нужна для XML коммуникации',
            'session' => '[Требуется] Файл настроек PHP (php.ini) \'Session.auto_start\' должен быть равен нулю, чтобы zeroboard могла использовать сессии',
            'iconv' => 'Iconv должна быть установлена для конвертирования между UTF-8 и иными языковыми кодировками',
            'gd' => 'GD Библиотека должна быть установлена для использования функции конвертироваия изображений',
        );

    $lang->install_checklist_xml = 'Установить XML библиотеку';
    $lang->install_without_xml = 'XML библиотека не установлена';
    $lang->install_checklist_gd = 'Установить GD библиотеку';
    $lang->install_without_gd  = 'GD библиотека не установлена';
    $lang->install_checklist_gd = 'Установить GD библиотеку';
    $lang->install_without_iconv = 'Iconv библиотека не установлена';
    $lang->install_session_auto_start = 'Возможно возникнут проблемы из-за настройки PHP session.auto_start, установленной в 1';
    $lang->install_permission_denied = 'Права доступа пути не установлены в 707';

    $lang->cmd_agree_license = 'Я согласен с данной лицензией';
    $lang->cmd_install_fix_checklist = 'Я удоволетворил требуемые условия';
    $lang->cmd_install_next = 'Продолжить установку';

    $lang->db_desc = array(
        'mysql' => 'Используем mysql*() функцию, чтобы использовать базу данных mysql.<br />Транзакция отключена из-за того, что файл базы данных создан посредством myisam.',
        'mysql_innodb' => 'Используем innodb  чтобы использовать базу данных mysql.<br />Транзакция включена для innodb',
        'sqlite2' => 'Поддерживает sqlite2, которая сохраняет данные в файл.<br />Устанавливая, следует размещать файл базы данных в недоступном с веб месте.<br />(Никогда не тестировалось на стабильность)',
        'sqlite3_pdo' => 'Поддерживает sqlite3 посредством PHP\'s PDO.<br />Устанавливая, следует размещать файл базы данных в недоступном с веб месте.',
        'cubrid' => 'Используем CUBRID DB.',
        'postgresql' => 'Используем PostgreSql DB.',
    );

    $lang->form_title = 'Пожалуйста, введите дазу данных &amp; Административная Информация';
    $lang->db_title = 'Пожалуйста, введите информацию базы данных';
    $lang->db_type = 'Тип базы данных';
    $lang->select_db_type = 'Пожалуйста, выберите базу данных, которую Вы хотите использовать.';
    $lang->db_hostname = 'Хост базы данных';
    $lang->db_port = 'Порт базы данных';
    $lang->db_userid = 'ID базы данных';
    $lang->db_password = 'Пароль базы данных';
    $lang->db_database = 'Имя базы данных';
    $lang->db_database_file = 'Файл базы данных';
    $lang->db_table_prefix = 'Префикс таблиц';

    $lang->admin_title = 'Административная информация';

    $lang->env_title = 'Конфигурация';
    $lang->use_optimizer = 'Включить оптимизатор';
    $lang->about_optimizer = 'Если оптимизатор включен, пользователи могут быстро использовать этот сайт, поскольку несколько CSS / JS файлов собраны вместе и сжаты до передачи. <br /> Тем не менее, эта оптимизация может быть проблематичной согласно CSS или JS. Если Вы выключите ее, движок будет работать правильно, хотя и медленее.';
    $lang->use_rewrite = 'Использовать модуль перезаписи (rewrite mod)';
    $lang->about_rewrite = "Если сервер предлагает rewrite mod, длинные URL такие как  http://blah/?document_srl=123 могут быть сокращены до http://blah/123";
    $lang->time_zone = 'Часовой пояс';
    $lang->about_time_zone = "Если серверное время и Ваше локальное время не совпадают, Вы можете установить такое же время, как Ваше локальное, используя часовой пояс";

    $lang->about_database_file = 'Sqlite сохраняет данные в файл. Размещение базы данных должно быть недоступно с веб<br/><span style="color:red">Файл базы данных должен иметь права доступа 707.</span>';

    $lang->success_installed = 'Установка завершена';
    $lang->success_updated = 'Обновление завершено';

    $lang->msg_cannot_proc = 'Невозможно исполнить запрос, поскольку окружение установки не указано';
    $lang->msg_already_installed = 'Zeroboard уже установлена';
    $lang->msg_dbconnect_failed = "Произошла ошибка подключения к базе данных.\nПожалуйста, проверьте иформацию базы данных еще раз";
    $lang->msg_table_is_exists = "Таблица существует в базе данных.\nФайл конфигурации создан заново";
    $lang->msg_install_completed = "Установка завершена.\nСпасибо Вам за выбор ZeroboardXE";
    $lang->msg_install_failed = "Произошла ошибка при создании файла конфигурации.";
?>
