﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;

namespace TimeService
{
    /// <summary>
    /// 根据淘宝NTP授时
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            List<string> list = new List<string>();
            for (int i = 0; i < 24; i++)
            {
                list.Add(i.ToString().PadLeft(2, '0') + "00");
            }
            try
            {
                SyncTime(list);
            }
            catch
            {
                Console.WriteLine("授时服务故障，60秒后自动重试！" + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                Thread.Sleep(60);
                SyncTime(list);
            }
        }
        private static void SyncTime(List<string> list)
        {
            DateTime dt = GetDate();
            while (true)
            {
                Console.WriteLine("博衍科技，授时服务工具，请勿关闭，谢谢！" + dt.ToString("yyyy-MM-dd HH:mm:ss"));
                SetDate(dt);
                Thread.Sleep(1000);
                dt = dt.AddSeconds(1);
                if (list.Contains(dt.ToString("HHmm"))) dt = GetDate();
            }
        }

        private static DateTime GetDate()
        {
            try
            {
                string result = Get("http://api.m.taobao.com/rest/api3.do?api=mtop.common.getTimestamp");
                Regex reg = new Regex("[^0-9]");
                long timeSpan;
                if (!long.TryParse(reg.Replace(result.Split(',')[3], string.Empty), out timeSpan)) return DateTime.Now;

                DateTime dateTime = TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(timeSpan * 10000 + 621355968000000000));
                return dateTime;
            }
            catch
            {
                return DateTime.Now;
            }
        }
        /// <summary>
        /// 指定Url地址使用Get 方式获取全部字符串
        /// </summary>
        /// <param name="url">请求链接地址</param>
        /// <returns></returns>
        public static string Get(string url)
        {
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            HttpWebResponse resp = (HttpWebResponse)req.GetResponse();
            Stream stream = resp.GetResponseStream();
            try
            {
                //获取内容
                using (StreamReader reader = new StreamReader(stream))
                {
                    return reader.ReadToEnd();
                }
            }
            catch
            {
                return string.Empty;
            }
            finally
            {
                stream.Close();
            }
        }
        private static void NTP()
        {
            int port = 13;
            List<string> listServ = new List<string>(); //授时服务器列表 
            listServ.Add("ntp1.aliyun.com");
            listServ.Add("ntp2.aliyun.com");
            listServ.Add("ntp3.aliyun.com");
            listServ.Add("ntp4.aliyun.com");
            listServ.Add("ntp5.aliyun.com");
            listServ.Add("ntp6.aliyun.com");
            listServ.Add("ntp7.aliyun.com");

            listServ.Add("0.cn.pool.ntp.org"); //中国国家授时中心
            listServ.Add("cn.ntp.org.cn"); //中国授时

            listServ.Add("time.windows.com");
            listServ.Add("time-a.nist.gov");
            listServ.Add("time-b.nist.gov");

            IPHostEntry iphostinfo;
            IPAddress ip;
            IPEndPoint ipe;
            Socket c = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);//创建Socket
            c.ReceiveTimeout = 3 * 1000;//设置超时时间

            string sEX = "";// 接受错误信息

            // 遍历时间服务器列表
            foreach (string strHost in listServ)
            {
                try
                {
                    iphostinfo = Dns.GetHostEntry(strHost);
                    ip = iphostinfo.AddressList[0];
                    ipe = new IPEndPoint(ip, port);

                    c.Connect(ipe);//连接到服务器
                    if (c.Connected) break;// 如果连接到服务器就跳出
                }
                catch (Exception ex)
                {
                    sEX = ex.Message;
                }
            }
            if (!c.Connected)
            {
                Console.WriteLine("时间服务器连接失败！/r错误信息：" + sEX, "系统提示");
                return;
            }
            //SOCKET同步接受数据
            byte[] RecvBuffer = new byte[1024];
            int nBytes, nTotalBytes = 0;
            StringBuilder sb = new StringBuilder();
            System.Text.Encoding myE = Encoding.UTF8;

            while ((nBytes = c.Receive(RecvBuffer, 0, 1024, SocketFlags.None)) > 0)
            {
                nTotalBytes += nBytes;
                sb.Append(myE.GetString(RecvBuffer, 0, nBytes));
            }
            //关闭连接
            c.Close();

            string[] o = sb.ToString().Split(' '); // 打断字符串
            Console.WriteLine(sb);
            Console.ReadKey();
            //TimeSpan k = new TimeSpan();
            //k = (TimeSpan)(DateTime.Now - startDT);// 得到开始到现在所消耗的时间

            //DateTime SetDT = Convert.ToDateTime(o[1] + " " + o[2]).Subtract(-k);// 减去中途消耗的时间
            ////处置北京时间 +8时
            //SetDT = SetDT.AddHours(8);

            ////转换System.DateTime到SystemTime
            //SystemTime st = new SystemTime();
            //st.FromDateTime(SetDT);

            ////调用Win32 API设置系统时间
            //Win32API.SetLocalTime(ref st);

            //MessageBox.Show("时间已同步", "系统提示", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }
        /// <summary>
        /// 设置系统时间
        /// </summary>
        /// <param name="dt">需要设置的时间</param>
        /// <returns>返回系统时间设置状态，true为成功，false为失败</returns>
        private static bool SetDate(DateTime dt)
        {
            SYSTEMTIME st;

            st.year = (short)dt.Year;
            st.month = (short)dt.Month;
            st.dayOfWeek = (short)dt.DayOfWeek;
            st.day = (short)dt.Day;
            st.hour = (short)dt.Hour;
            st.minute = (short)dt.Minute;
            st.second = (short)dt.Second;
            st.milliseconds = (short)dt.Millisecond;
            bool rt = SetLocalTime(ref st);
            return rt;
        }

        //设置系统时间的API函数
        [DllImport("kernel32.dll")]
        private static extern bool SetLocalTime(ref SYSTEMTIME time);

        [StructLayout(LayoutKind.Sequential)]
        private struct SYSTEMTIME
        {
            public short year;
            public short month;
            public short dayOfWeek;
            public short day;
            public short hour;
            public short minute;
            public short second;
            public short milliseconds;
        }

    }
}
