/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50717
Source Host           : localhost:3306
Source Database       : bootdo

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2018-01-10 13:21:30
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `act_evt_log`
-- ----------------------------
DROP TABLE IF EXISTS `act_evt_log`;
CREATE TABLE `act_evt_log` (
  `LOG_NR_` bigint(20) NOT NULL AUTO_INCREMENT,
  `TYPE_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TIME_STAMP_` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `USER_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `DATA_` longblob,
  `LOCK_OWNER_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `LOCK_TIME_` timestamp NULL DEFAULT NULL,
  `IS_PROCESSED_` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`LOG_NR_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_evt_log
-- ----------------------------

-- ----------------------------
-- Table structure for `act_ge_bytearray`
-- ----------------------------
DROP TABLE IF EXISTS `act_ge_bytearray`;
CREATE TABLE `act_ge_bytearray` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `DEPLOYMENT_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `BYTES_` longblob,
  `GENERATED_` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_BYTEARR_DEPL` (`DEPLOYMENT_ID_`),
  CONSTRAINT `ACT_FK_BYTEARR_DEPL` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `act_re_deployment` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ge_bytearray
-- ----------------------------
INSERT INTO `act_ge_bytearray` VALUES ('135065', '1', '流程审批测试流程.bpmn20.xml', '135064', 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, '0');
INSERT INTO `act_ge_bytearray` VALUES ('135066', '1', '流程审批测试流程.salary.png', '135064', 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
INSERT INTO `act_ge_bytearray` VALUES ('142502', '3', 'source', null, 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, null);
INSERT INTO `act_ge_bytearray` VALUES ('142503', '2', 'source-extra', null, 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null);
INSERT INTO `act_ge_bytearray` VALUES ('145002', '1', 'new-process.bpmn20.xml', '145001', 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, '0');
INSERT INTO `act_ge_bytearray` VALUES ('145003', '1', 'new-process.process.png', '145001', 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
INSERT INTO `act_ge_bytearray` VALUES ('145006', '2', 'source', null, 0x7B227265736F757263654964223A22313435303035222C2270726F70657274696573223A7B2270726F636573735F6964223A2270726F63657373222C226E616D65223A22222C22646F63756D656E746174696F6E223A22222C2270726F636573735F617574686F72223A22222C2270726F636573735F76657273696F6E223A22222C2270726F636573735F6E616D657370616365223A22687474703A2F2F7777772E61637469766974692E6F72672F70726F63657373646566222C22657865637574696F6E6C697374656E657273223A22222C226576656E746C697374656E657273223A22222C227369676E616C646566696E6974696F6E73223A22222C226D657373616765646566696E6974696F6E73223A22227D2C227374656E63696C223A7B226964223A2242504D4E4469616772616D227D2C226368696C64536861706573223A5B5D2C22626F756E6473223A7B226C6F7765725269676874223A7B2278223A313230302C2279223A313035307D2C2275707065724C656674223A7B2278223A302C2279223A307D7D2C227374656E63696C736574223A7B2275726C223A227374656E63696C736574732F62706D6E322E302F62706D6E322E302E6A736F6E222C226E616D657370616365223A22687474703A2F2F62336D6E2E6F72672F7374656E63696C7365742F62706D6E322E3023227D2C227373657874656E73696F6E73223A5B5D7D, null);
INSERT INTO `act_ge_bytearray` VALUES ('145007', '1', 'source-extra', null, 0x89504E470D0A1A0A0000000D49484452000000320000003208060000001E3F88B1000000206348524D00007A26000080840000FA00000080E8000075300000EA6000003A98000017709CBA513C0000000467414D410000B18E7CFB5193000000017352474200AECE1CE900000006624B474400FF00FF00FFA0BDA793000000097048597300000EC400000EC401952B0E1B000000204944415478DAEDC101010000008220FFAF6E4840010000000000000000C0A30127420001FCA695FE0000000049454E44AE426082, null);
INSERT INTO `act_ge_bytearray` VALUES ('57502', '8', 'source', null, 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, null);
INSERT INTO `act_ge_bytearray` VALUES ('62501', '3', 'source-extra', null, 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null);

-- ----------------------------
-- Table structure for `act_ge_property`
-- ----------------------------
DROP TABLE IF EXISTS `act_ge_property`;
CREATE TABLE `act_ge_property` (
  `NAME_` varchar(64) COLLATE utf8_bin NOT NULL,
  `VALUE_` varchar(300) COLLATE utf8_bin DEFAULT NULL,
  `REV_` int(11) DEFAULT NULL,
  PRIMARY KEY (`NAME_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ge_property
-- ----------------------------
INSERT INTO `act_ge_property` VALUES ('next.dbid', '147501', '60');
INSERT INTO `act_ge_property` VALUES ('schema.history', 'create(5.22.0.0)', '1');
INSERT INTO `act_ge_property` VALUES ('schema.version', '5.22.0.0', '1');

-- ----------------------------
-- Table structure for `act_hi_actinst`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_actinst`;
CREATE TABLE `act_hi_actinst` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `ACT_ID_` varchar(255) COLLATE utf8_bin NOT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `CALL_PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `ACT_NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `ACT_TYPE_` varchar(255) COLLATE utf8_bin NOT NULL,
  `ASSIGNEE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `START_TIME_` datetime NOT NULL,
  `END_TIME_` datetime DEFAULT NULL,
  `DURATION_` bigint(20) DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_ACT_INST_START` (`START_TIME_`),
  KEY `ACT_IDX_HI_ACT_INST_END` (`END_TIME_`),
  KEY `ACT_IDX_HI_ACT_INST_PROCINST` (`PROC_INST_ID_`,`ACT_ID_`),
  KEY `ACT_IDX_HI_ACT_INST_EXEC` (`EXECUTION_ID_`,`ACT_ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_actinst
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_attachment`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_attachment`;
CREATE TABLE `act_hi_attachment` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `USER_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `URL_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `CONTENT_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TIME_` datetime DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_attachment
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_comment`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_comment`;
CREATE TABLE `act_hi_comment` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TIME_` datetime NOT NULL,
  `USER_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `ACTION_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `MESSAGE_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `FULL_MSG_` longblob,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_comment
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_detail`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_detail`;
CREATE TABLE `act_hi_detail` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `ACT_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin NOT NULL,
  `VAR_TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `REV_` int(11) DEFAULT NULL,
  `TIME_` datetime NOT NULL,
  `BYTEARRAY_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `DOUBLE_` double DEFAULT NULL,
  `LONG_` bigint(20) DEFAULT NULL,
  `TEXT_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TEXT2_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_DETAIL_PROC_INST` (`PROC_INST_ID_`),
  KEY `ACT_IDX_HI_DETAIL_ACT_INST` (`ACT_INST_ID_`),
  KEY `ACT_IDX_HI_DETAIL_TIME` (`TIME_`),
  KEY `ACT_IDX_HI_DETAIL_NAME` (`NAME_`),
  KEY `ACT_IDX_HI_DETAIL_TASK_ID` (`TASK_ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_detail
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_identitylink`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_identitylink`;
CREATE TABLE `act_hi_identitylink` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `GROUP_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `USER_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_IDENT_LNK_USER` (`USER_ID_`),
  KEY `ACT_IDX_HI_IDENT_LNK_TASK` (`TASK_ID_`),
  KEY `ACT_IDX_HI_IDENT_LNK_PROCINST` (`PROC_INST_ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_identitylink
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_procinst`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_procinst`;
CREATE TABLE `act_hi_procinst` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `BUSINESS_KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `START_TIME_` datetime NOT NULL,
  `END_TIME_` datetime DEFAULT NULL,
  `DURATION_` bigint(20) DEFAULT NULL,
  `START_USER_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `START_ACT_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `END_ACT_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `SUPER_PROCESS_INSTANCE_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `DELETE_REASON_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  UNIQUE KEY `PROC_INST_ID_` (`PROC_INST_ID_`),
  KEY `ACT_IDX_HI_PRO_INST_END` (`END_TIME_`),
  KEY `ACT_IDX_HI_PRO_I_BUSKEY` (`BUSINESS_KEY_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_procinst
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_taskinst`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_taskinst`;
CREATE TABLE `act_hi_taskinst` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TASK_DEF_KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `OWNER_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `ASSIGNEE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `START_TIME_` datetime NOT NULL,
  `CLAIM_TIME_` datetime DEFAULT NULL,
  `END_TIME_` datetime DEFAULT NULL,
  `DURATION_` bigint(20) DEFAULT NULL,
  `DELETE_REASON_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `PRIORITY_` int(11) DEFAULT NULL,
  `DUE_DATE_` datetime DEFAULT NULL,
  `FORM_KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `CATEGORY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_TASK_INST_PROCINST` (`PROC_INST_ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_taskinst
-- ----------------------------

-- ----------------------------
-- Table structure for `act_hi_varinst`
-- ----------------------------
DROP TABLE IF EXISTS `act_hi_varinst`;
CREATE TABLE `act_hi_varinst` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin NOT NULL,
  `VAR_TYPE_` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `REV_` int(11) DEFAULT NULL,
  `BYTEARRAY_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `DOUBLE_` double DEFAULT NULL,
  `LONG_` bigint(20) DEFAULT NULL,
  `TEXT_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TEXT2_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `CREATE_TIME_` datetime DEFAULT NULL,
  `LAST_UPDATED_TIME_` datetime DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_HI_PROCVAR_PROC_INST` (`PROC_INST_ID_`),
  KEY `ACT_IDX_HI_PROCVAR_NAME_TYPE` (`NAME_`,`VAR_TYPE_`),
  KEY `ACT_IDX_HI_PROCVAR_TASK_ID` (`TASK_ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_hi_varinst
-- ----------------------------

-- ----------------------------
-- Table structure for `act_id_group`
-- ----------------------------
DROP TABLE IF EXISTS `act_id_group`;
CREATE TABLE `act_id_group` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_id_group
-- ----------------------------

-- ----------------------------
-- Table structure for `act_id_info`
-- ----------------------------
DROP TABLE IF EXISTS `act_id_info`;
CREATE TABLE `act_id_info` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `USER_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `VALUE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PASSWORD_` longblob,
  `PARENT_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_id_info
-- ----------------------------

-- ----------------------------
-- Table structure for `act_id_membership`
-- ----------------------------
DROP TABLE IF EXISTS `act_id_membership`;
CREATE TABLE `act_id_membership` (
  `USER_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `GROUP_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`USER_ID_`,`GROUP_ID_`),
  KEY `ACT_FK_MEMB_GROUP` (`GROUP_ID_`),
  CONSTRAINT `ACT_FK_MEMB_GROUP` FOREIGN KEY (`GROUP_ID_`) REFERENCES `act_id_group` (`ID_`),
  CONSTRAINT `ACT_FK_MEMB_USER` FOREIGN KEY (`USER_ID_`) REFERENCES `act_id_user` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_id_membership
-- ----------------------------

-- ----------------------------
-- Table structure for `act_id_user`
-- ----------------------------
DROP TABLE IF EXISTS `act_id_user`;
CREATE TABLE `act_id_user` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `FIRST_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `LAST_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `EMAIL_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PWD_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PICTURE_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_id_user
-- ----------------------------

-- ----------------------------
-- Table structure for `act_procdef_info`
-- ----------------------------
DROP TABLE IF EXISTS `act_procdef_info`;
CREATE TABLE `act_procdef_info` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `INFO_JSON_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  UNIQUE KEY `ACT_UNIQ_INFO_PROCDEF` (`PROC_DEF_ID_`),
  KEY `ACT_IDX_INFO_PROCDEF` (`PROC_DEF_ID_`),
  KEY `ACT_FK_INFO_JSON_BA` (`INFO_JSON_ID_`),
  CONSTRAINT `ACT_FK_INFO_JSON_BA` FOREIGN KEY (`INFO_JSON_ID_`) REFERENCES `act_ge_bytearray` (`ID_`),
  CONSTRAINT `ACT_FK_INFO_PROCDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `act_re_procdef` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_procdef_info
-- ----------------------------

-- ----------------------------
-- Table structure for `act_re_deployment`
-- ----------------------------
DROP TABLE IF EXISTS `act_re_deployment`;
CREATE TABLE `act_re_deployment` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `CATEGORY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  `DEPLOY_TIME_` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_re_deployment
-- ----------------------------
INSERT INTO `act_re_deployment` VALUES ('135064', '流程审批测试流程', null, '', '2018-01-07 18:09:37.652');
INSERT INTO `act_re_deployment` VALUES ('145001', 'new-process', null, '', '2018-01-09 19:32:28.374');

-- ----------------------------
-- Table structure for `act_re_model`
-- ----------------------------
DROP TABLE IF EXISTS `act_re_model`;
CREATE TABLE `act_re_model` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `CATEGORY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `CREATE_TIME_` timestamp NULL DEFAULT NULL,
  `LAST_UPDATE_TIME_` timestamp NULL DEFAULT NULL,
  `VERSION_` int(11) DEFAULT NULL,
  `META_INFO_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `DEPLOYMENT_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EDITOR_SOURCE_VALUE_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EDITOR_SOURCE_EXTRA_VALUE_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_MODEL_SOURCE` (`EDITOR_SOURCE_VALUE_ID_`),
  KEY `ACT_FK_MODEL_SOURCE_EXTRA` (`EDITOR_SOURCE_EXTRA_VALUE_ID_`),
  KEY `ACT_FK_MODEL_DEPLOYMENT` (`DEPLOYMENT_ID_`),
  CONSTRAINT `ACT_FK_MODEL_DEPLOYMENT` FOREIGN KEY (`DEPLOYMENT_ID_`) REFERENCES `act_re_deployment` (`ID_`),
  CONSTRAINT `ACT_FK_MODEL_SOURCE` FOREIGN KEY (`EDITOR_SOURCE_VALUE_ID_`) REFERENCES `act_ge_bytearray` (`ID_`),
  CONSTRAINT `ACT_FK_MODEL_SOURCE_EXTRA` FOREIGN KEY (`EDITOR_SOURCE_EXTRA_VALUE_ID_`) REFERENCES `act_ge_bytearray` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_re_model
-- ----------------------------
INSERT INTO `act_re_model` VALUES ('142501', '8', 'new-process', 'process', null, '2018-01-08 16:10:30.232', '2018-01-09 19:32:29.885', '1', '{\"name\":\"new-process\",\"description\":\"\",\"revision\":1}', '145001', '142502', '142503', '');
INSERT INTO `act_re_model` VALUES ('145005', '4', 'new-process', 'process', null, '2018-01-09 20:00:51.185', '2018-01-09 20:01:00.256', '1', '{\"name\":\"new-process\",\"description\":\"\",\"revision\":1}', null, '145006', '145007', '');
INSERT INTO `act_re_model` VALUES ('57501', '31', '流程审批测试流程', 'test_audit02', null, '2017-11-12 08:42:12.515', '2018-01-07 18:09:37.946', '1', '{\"name\":\"流程审批测试流程\",\"revision\":1,\"description\":\"\"}', '135064', '57502', '62501', '');

-- ----------------------------
-- Table structure for `act_re_procdef`
-- ----------------------------
DROP TABLE IF EXISTS `act_re_procdef`;
CREATE TABLE `act_re_procdef` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `CATEGORY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `KEY_` varchar(255) COLLATE utf8_bin NOT NULL,
  `VERSION_` int(11) NOT NULL,
  `DEPLOYMENT_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `RESOURCE_NAME_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `DGRM_RESOURCE_NAME_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `HAS_START_FORM_KEY_` tinyint(4) DEFAULT NULL,
  `HAS_GRAPHICAL_NOTATION_` tinyint(4) DEFAULT NULL,
  `SUSPENSION_STATE_` int(11) DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  UNIQUE KEY `ACT_UNIQ_PROCDEF` (`KEY_`,`VERSION_`,`TENANT_ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_re_procdef
-- ----------------------------
INSERT INTO `act_re_procdef` VALUES ('process:1:145004', '1', 'http://www.activiti.org/processdef', null, 'process', '1', '145001', 'new-process.bpmn20.xml', 'new-process.process.png', null, '0', '1', '1', '');
INSERT INTO `act_re_procdef` VALUES ('salary:3:135067', '1', 'http://www.activiti.org/test', '流程审批测试流程', 'salary', '3', '135064', '流程审批测试流程.bpmn20.xml', '流程审批测试流程.salary.png', null, '1', '1', '1', '');

-- ----------------------------
-- Table structure for `act_ru_event_subscr`
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_event_subscr`;
CREATE TABLE `act_ru_event_subscr` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `EVENT_TYPE_` varchar(255) COLLATE utf8_bin NOT NULL,
  `EVENT_NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `ACTIVITY_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `CONFIGURATION_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `CREATED_` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_EVENT_SUBSCR_CONFIG_` (`CONFIGURATION_`),
  KEY `ACT_FK_EVENT_EXEC` (`EXECUTION_ID_`),
  CONSTRAINT `ACT_FK_EVENT_EXEC` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `act_ru_execution` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ru_event_subscr
-- ----------------------------

-- ----------------------------
-- Table structure for `act_ru_execution`
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_execution`;
CREATE TABLE `act_ru_execution` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `BUSINESS_KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PARENT_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `SUPER_EXEC_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `ACT_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `IS_ACTIVE_` tinyint(4) DEFAULT NULL,
  `IS_CONCURRENT_` tinyint(4) DEFAULT NULL,
  `IS_SCOPE_` tinyint(4) DEFAULT NULL,
  `IS_EVENT_SCOPE_` tinyint(4) DEFAULT NULL,
  `SUSPENSION_STATE_` int(11) DEFAULT NULL,
  `CACHED_ENT_STATE_` int(11) DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `LOCK_TIME_` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_EXEC_BUSKEY` (`BUSINESS_KEY_`),
  KEY `ACT_FK_EXE_PROCINST` (`PROC_INST_ID_`),
  KEY `ACT_FK_EXE_PARENT` (`PARENT_ID_`),
  KEY `ACT_FK_EXE_SUPER` (`SUPER_EXEC_`),
  KEY `ACT_FK_EXE_PROCDEF` (`PROC_DEF_ID_`),
  CONSTRAINT `ACT_FK_EXE_PARENT` FOREIGN KEY (`PARENT_ID_`) REFERENCES `act_ru_execution` (`ID_`),
  CONSTRAINT `ACT_FK_EXE_PROCDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `act_re_procdef` (`ID_`),
  CONSTRAINT `ACT_FK_EXE_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `act_ru_execution` (`ID_`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ACT_FK_EXE_SUPER` FOREIGN KEY (`SUPER_EXEC_`) REFERENCES `act_ru_execution` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ru_execution
-- ----------------------------

-- ----------------------------
-- Table structure for `act_ru_identitylink`
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_identitylink`;
CREATE TABLE `act_ru_identitylink` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `GROUP_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `USER_ID_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_IDENT_LNK_USER` (`USER_ID_`),
  KEY `ACT_IDX_IDENT_LNK_GROUP` (`GROUP_ID_`),
  KEY `ACT_IDX_ATHRZ_PROCEDEF` (`PROC_DEF_ID_`),
  KEY `ACT_FK_TSKASS_TASK` (`TASK_ID_`),
  KEY `ACT_FK_IDL_PROCINST` (`PROC_INST_ID_`),
  CONSTRAINT `ACT_FK_ATHRZ_PROCEDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `act_re_procdef` (`ID_`),
  CONSTRAINT `ACT_FK_IDL_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `act_ru_execution` (`ID_`),
  CONSTRAINT `ACT_FK_TSKASS_TASK` FOREIGN KEY (`TASK_ID_`) REFERENCES `act_ru_task` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ru_identitylink
-- ----------------------------

-- ----------------------------
-- Table structure for `act_ru_job`
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_job`;
CREATE TABLE `act_ru_job` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin NOT NULL,
  `LOCK_EXP_TIME_` timestamp NULL DEFAULT NULL,
  `LOCK_OWNER_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `EXCLUSIVE_` tinyint(1) DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROCESS_INSTANCE_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `RETRIES_` int(11) DEFAULT NULL,
  `EXCEPTION_STACK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `EXCEPTION_MSG_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `DUEDATE_` timestamp NULL DEFAULT NULL,
  `REPEAT_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_TYPE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `HANDLER_CFG_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  PRIMARY KEY (`ID_`),
  KEY `ACT_FK_JOB_EXCEPTION` (`EXCEPTION_STACK_ID_`),
  CONSTRAINT `ACT_FK_JOB_EXCEPTION` FOREIGN KEY (`EXCEPTION_STACK_ID_`) REFERENCES `act_ge_bytearray` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ru_job
-- ----------------------------

-- ----------------------------
-- Table structure for `act_ru_task`
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_task`;
CREATE TABLE `act_ru_task` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_DEF_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `PARENT_TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `DESCRIPTION_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TASK_DEF_KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `OWNER_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `ASSIGNEE_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `DELEGATION_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PRIORITY_` int(11) DEFAULT NULL,
  `CREATE_TIME_` timestamp NULL DEFAULT NULL,
  `DUE_DATE_` datetime DEFAULT NULL,
  `CATEGORY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `SUSPENSION_STATE_` int(11) DEFAULT NULL,
  `TENANT_ID_` varchar(255) COLLATE utf8_bin DEFAULT '',
  `FORM_KEY_` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_TASK_CREATE` (`CREATE_TIME_`),
  KEY `ACT_FK_TASK_EXE` (`EXECUTION_ID_`),
  KEY `ACT_FK_TASK_PROCINST` (`PROC_INST_ID_`),
  KEY `ACT_FK_TASK_PROCDEF` (`PROC_DEF_ID_`),
  CONSTRAINT `ACT_FK_TASK_EXE` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `act_ru_execution` (`ID_`),
  CONSTRAINT `ACT_FK_TASK_PROCDEF` FOREIGN KEY (`PROC_DEF_ID_`) REFERENCES `act_re_procdef` (`ID_`),
  CONSTRAINT `ACT_FK_TASK_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `act_ru_execution` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ru_task
-- ----------------------------

-- ----------------------------
-- Table structure for `act_ru_variable`
-- ----------------------------
DROP TABLE IF EXISTS `act_ru_variable`;
CREATE TABLE `act_ru_variable` (
  `ID_` varchar(64) COLLATE utf8_bin NOT NULL,
  `REV_` int(11) DEFAULT NULL,
  `TYPE_` varchar(255) COLLATE utf8_bin NOT NULL,
  `NAME_` varchar(255) COLLATE utf8_bin NOT NULL,
  `EXECUTION_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `PROC_INST_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `TASK_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `BYTEARRAY_ID_` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `DOUBLE_` double DEFAULT NULL,
  `LONG_` bigint(20) DEFAULT NULL,
  `TEXT_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  `TEXT2_` varchar(4000) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`ID_`),
  KEY `ACT_IDX_VARIABLE_TASK_ID` (`TASK_ID_`),
  KEY `ACT_FK_VAR_EXE` (`EXECUTION_ID_`),
  KEY `ACT_FK_VAR_PROCINST` (`PROC_INST_ID_`),
  KEY `ACT_FK_VAR_BYTEARRAY` (`BYTEARRAY_ID_`),
  CONSTRAINT `ACT_FK_VAR_BYTEARRAY` FOREIGN KEY (`BYTEARRAY_ID_`) REFERENCES `act_ge_bytearray` (`ID_`),
  CONSTRAINT `ACT_FK_VAR_EXE` FOREIGN KEY (`EXECUTION_ID_`) REFERENCES `act_ru_execution` (`ID_`),
  CONSTRAINT `ACT_FK_VAR_PROCINST` FOREIGN KEY (`PROC_INST_ID_`) REFERENCES `act_ru_execution` (`ID_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- ----------------------------
-- Records of act_ru_variable
-- ----------------------------

-- ----------------------------
-- Table structure for `blog_content`
-- ----------------------------
DROP TABLE IF EXISTS `blog_content`;
CREATE TABLE `blog_content` (
  `cid` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `slug` varchar(255) DEFAULT NULL,
  `created` bigint(20) DEFAULT NULL COMMENT '创建人id',
  `modified` bigint(20) DEFAULT NULL COMMENT '最近修改人id',
  `content` text COMMENT '内容',
  `type` varchar(16) DEFAULT NULL COMMENT '类型',
  `tags` varchar(200) DEFAULT NULL COMMENT '标签',
  `categories` varchar(200) DEFAULT NULL COMMENT '分类',
  `hits` int(5) DEFAULT NULL,
  `comments_num` int(5) DEFAULT '0' COMMENT '评论数量',
  `allow_comment` int(1) DEFAULT '0' COMMENT '开启评论',
  `allow_ping` int(1) DEFAULT '0' COMMENT '允许ping',
  `allow_feed` int(1) DEFAULT '0' COMMENT '允许反馈',
  `status` int(1) DEFAULT NULL COMMENT '状态',
  `author` varchar(100) DEFAULT NULL COMMENT '作者',
  `gtm_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gtm_modified` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8 COMMENT='文章内容';

-- ----------------------------
-- Records of blog_content
-- ----------------------------
INSERT INTO `blog_content` VALUES ('75', '基于 Springboot 和 Mybatis 的后台管理系统 BootDo', null, null, null, '<h3 style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif;\">项目介绍</h3><ul style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 0px 30px; list-style-position: initial; list-style-image: initial; color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\"><li><p>面向学习型的开源框架，简洁高效，减少过渡封装，展现技术本质</p></li><li><p>Springboot作为基础框架，使用mybatis作为持久层框架</p></li><li><p>使用官方推荐的thymeleaf做为模板引擎，shiro作为安全框架,主流技术，“一网打尽”</p></li><li><p>基于注解的sql写法，零XML，极简配置，一键前后台代码生成</p></li></ul><p style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\"><span style=\"font-weight: bolder;\">演示地址</span>&nbsp;<a href=\"http://47.93.239.129/\" style=\"outline: 0px; color: rgb(68, 102, 187);\">http://47.93.239.129</a></p><h3 style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif;\">功能简介</h3><p style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\">1. 用户管理<br>2. 角色管理<br>3. 部门管理<br>4. 菜单管理<br>5. 系统日志<br>6. 代码生成<br>7. 内容管理</p><h3 style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif;\">所用框架</h3><p style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\"><span style=\"font-weight: bolder;\">前端</span><br>1. Bootstrap<br>2. jQuery<br>3. bootstrap-table<br>4. layer<br>5. jsTree&nbsp;<br>6. summernote<br>7. jquery-validate<br>8. jquery-treegrid</p><p style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\"><span style=\"font-weight: bolder;\">后端</span><br>1. SpringBoot&nbsp;<br>2. MyBatis<br>3. Thymeleaf<br>4. Shiro<br>5. druid</p><p style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\"><span style=\"font-weight: bolder;\">项目截图</span></p><p style=\"color: rgb(17, 17, 17); font-family: &quot;PingFang SC&quot;, &quot;Helvetica Neue&quot;, &quot;Microsoft YaHei UI&quot;, &quot;Microsoft YaHei&quot;, &quot;Noto Sans CJK SC&quot;, Sathu, EucrosiaUPC, sans-serif; font-size: 16px;\"><img height=\"400\" src=\"https://static.oschina.net/uploads/space/2017/0912/182421_5LaN_3244087.png\" width=\"650\" style=\"border-width: initial; border-style: none; outline: 0px; width: 882px; max-width: -webkit-fit-content; height: auto;\"></p>', 'article', null, null, null, null, '0', '0', '1', '1', 'bootdo', '2017-09-22 14:44:44', '2017-09-22 14:44:44');
INSERT INTO `blog_content` VALUES ('100', 'springboot thymeleaf和shiro 整合——按钮可见性', null, null, null, '<p style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; margin-bottom: 16px; color: rgb(61, 70, 77); font-family: &quot;Pingfang SC&quot;, STHeiti, &quot;Lantinghei SC&quot;, &quot;Open Sans&quot;, Arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, SimSun, sans-serif; font-size: 16px; background-color: rgb(248, 248, 248);\">添加依赖</p><pre class=\"hljs xml\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; padding: 2px; background: rgb(63, 63, 63); color: rgb(220, 220, 220); border-radius: 3px; line-height: 1.4; word-wrap: normal; font-family: Menlo, Monaco, Consolas, &quot;Courier New&quot;, monospace;\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">&lt;<span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">dependency</span>&gt;</span><code class=\"hljs xml\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; display: block; overflow-x: auto; padding: 10px; background: rgb(63, 63, 63); color: rgb(220, 220, 220); border-radius: 4px; font-size: 13px; line-height: 1.4; word-wrap: normal; font-family: Menlo, Monaco, Consolas, &quot;Courier New&quot;, monospace;\"> \r\n   <span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">groupId</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span>com.github.theborakompanioni<span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;/</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">groupId</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span>\r\n    <span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">artifactId</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span>thymeleaf-extras-shiro<span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;/</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">artifactId</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span>\r\n    <span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">version</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span></code>1.2.1<code class=\"hljs xml\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; display: block; overflow-x: auto; padding: 10px; background: rgb(63, 63, 63); color: rgb(220, 220, 220); border-radius: 4px; font-size: 13px; line-height: 1.4; word-wrap: normal; font-family: Menlo, Monaco, Consolas, &quot;Courier New&quot;, monospace;\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;/</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">version</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span> \r\n<span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&lt;/</span><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\"><span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">dependency</span></span></span><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">&gt;</span></span></code></pre><p style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; margin-bottom: 16px; color: rgb(61, 70, 77); font-family: &quot;Pingfang SC&quot;, STHeiti, &quot;Lantinghei SC&quot;, &quot;Open Sans&quot;, Arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, SimSun, sans-serif; font-size: 16px; background-color: rgb(248, 248, 248);\">&nbsp;</p><p style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; margin-bottom: 16px; color: rgb(61, 70, 77); font-family: &quot;Pingfang SC&quot;, STHeiti, &quot;Lantinghei SC&quot;, &quot;Open Sans&quot;, Arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, SimSun, sans-serif; font-size: 16px; background-color: rgb(248, 248, 248);\">在shiro的configuration中配置</p><pre class=\"hljs java\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; padding: 2px; background: rgb(63, 63, 63); color: rgb(220, 220, 220); border-radius: 3px; line-height: 1.4; word-wrap: normal; font-family: Menlo, Monaco, Consolas, &quot;Courier New&quot;, monospace;\"><span class=\"hljs-meta\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(127, 159, 127);\">@Bean</span>\r\n    <span class=\"hljs-function\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\"><span class=\"hljs-keyword\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">public</span> ShiroDialect <span class=\"hljs-title\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">shiroDialect</span><span class=\"hljs-params\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">()</span> </span>{\r\n        <span class=\"hljs-keyword\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">return</span> <span class=\"hljs-keyword\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">new</span> ShiroDialect();\r\n    }</pre><p style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; margin-bottom: 16px; color: rgb(61, 70, 77); font-family: &quot;Pingfang SC&quot;, STHeiti, &quot;Lantinghei SC&quot;, &quot;Open Sans&quot;, Arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, SimSun, sans-serif; font-size: 16px; background-color: rgb(248, 248, 248);\">&nbsp;</p><p style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; margin-bottom: 16px; color: rgb(61, 70, 77); font-family: &quot;Pingfang SC&quot;, STHeiti, &quot;Lantinghei SC&quot;, &quot;Open Sans&quot;, Arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, SimSun, sans-serif; font-size: 16px; background-color: rgb(248, 248, 248);\">在html中加入xmlns</p><pre class=\"hljs xml\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; padding: 2px; background: rgb(63, 63, 63); color: rgb(220, 220, 220); border-radius: 3px; line-height: 1.4; word-wrap: normal; font-family: Menlo, Monaco, Consolas, &quot;Courier New&quot;, monospace;\"><span class=\"hljs-tag\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">&lt;<span class=\"hljs-name\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(239, 239, 143);\">html</span> <span class=\"hljs-attr\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">lang</span>=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"zh_CN\"</span> <span class=\"hljs-attr\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">xmlns:th</span>=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"http://www.thymeleaf.org\"</span>\r\n      <span class=\"hljs-attr\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\">xmlns:shiro</span>=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"http://www.pollix.at/thymeleaf/shiro\"</span>&gt;</span></pre><p style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; margin-bottom: 16px; color: rgb(61, 70, 77); font-family: &quot;Pingfang SC&quot;, STHeiti, &quot;Lantinghei SC&quot;, &quot;Open Sans&quot;, Arial, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, SimSun, sans-serif; font-size: 16px; background-color: rgb(248, 248, 248);\">例子</p><pre class=\"hljs scala\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; padding: 2px; background: rgb(63, 63, 63); color: rgb(220, 220, 220); border-radius: 3px; line-height: 1.4; word-wrap: normal; font-family: Menlo, Monaco, Consolas, &quot;Courier New&quot;, monospace;\">&lt;button shiro:hasPermission=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"sys:user:add\"</span> <span class=\"hljs-class\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\"><span class=\"hljs-keyword\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">type</span></span>=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"button\"</span> <span class=\"hljs-class\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\"><span class=\"hljs-keyword\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">class</span></span>=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"btn &nbsp;btn-primary\"</span> onclick=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"add()\"</span>&gt;\r\n&nbsp;&nbsp; &lt;i <span class=\"hljs-class\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent;\"><span class=\"hljs-keyword\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(227, 206, 171);\">class</span></span>=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"fa fa-plus\"</span> aria-hidden=<span class=\"hljs-string\" style=\"box-sizing: inherit; -webkit-tap-highlight-color: transparent; color: rgb(204, 147, 147);\">\"true\"</span>&gt;&lt;/i&gt;添加\r\n&lt;/button&gt;</pre>', 'article', null, null, null, null, '1', null, '0', '1', 'bootdo', '2017-09-22 13:24:30', '2017-09-22 13:24:30');
INSERT INTO `blog_content` VALUES ('108', 'spring boot ehcache整合', null, null, null, '<h3 id=\"pomxml配置-引入依赖包\" style=\"font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; color: rgb(63, 63, 63); margin: 0.8em 0px; font-size: 1.7em; padding: 0px;\">pom.xml配置 引入依赖包</h3><pre class=\"prettyprint\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; font-size: 14px; white-space: nowrap; padding: 5px 5px 5px 60px; margin-bottom: 1.1em; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-color: rgba(128, 128, 128, 0.075); border-radius: 0px; position: relative; overflow-y: hidden;\"><code class=\"hljs xml has-numbering\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; display: block; word-wrap: normal;\"><span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">dependency</span>&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">groupId</span>&gt;</span>org.springframework.boot<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">groupId</span>&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">artifactId</span>&gt;</span>spring-boot-starter-cache<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">artifactId</span>&gt;</span>\r\n<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">dependency</span>&gt;</span>\r\n<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">dependency</span>&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">groupId</span>&gt;</span>net.sf.ehcache<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">groupId</span>&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">artifactId</span>&gt;</span>ehcache<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">artifactId</span>&gt;</span>\r\n<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">dependency</span>&gt;</span></code><ul class=\"pre-numbering\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; list-style: none; position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; border-right: 1px solid rgb(221, 221, 221); text-align: right;\"><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">1</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">2</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">3</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">4</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">5</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">6</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">7</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">8</li></ul></pre><h3 id=\"编写配置类设置缓存机制\" style=\"font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; color: rgb(63, 63, 63); margin: 0.8em 0px; font-size: 1.7em; padding: 0px;\">编写配置类,设置缓存机制</h3><pre class=\"prettyprint\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; font-size: 14px; white-space: nowrap; padding: 5px 5px 5px 60px; margin-bottom: 1.1em; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-color: rgba(128, 128, 128, 0.075); border-radius: 0px; position: relative; overflow-y: hidden;\"><code class=\"hljs java has-numbering\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; display: block; word-wrap: normal;\"><span class=\"hljs-annotation\" style=\"margin: 0px; padding: 0px; color: rgb(155, 133, 157);\">@Configuration</span>\r\n<span class=\"hljs-annotation\" style=\"margin: 0px; padding: 0px; color: rgb(155, 133, 157);\">@EnableCaching</span>\r\n<span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">public</span> <span class=\"hljs-class\" style=\"margin: 0px; padding: 0px;\"><span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">class</span> <span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">CacheConfiguration</span> {</span>\r\n\r\n    <span class=\"hljs-annotation\" style=\"margin: 0px; padding: 0px; color: rgb(155, 133, 157);\">@Bean</span>\r\n    <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">public</span> EhCacheCacheManager <span class=\"hljs-title\" style=\"margin: 0px; padding: 0px;\">ehCacheCacheManager</span>(EhCacheManagerFactoryBean bean) {\r\n        <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">return</span> <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">new</span> EhCacheCacheManager(bean.getObject());\r\n    }\r\n\r\n    <span class=\"hljs-annotation\" style=\"margin: 0px; padding: 0px; color: rgb(155, 133, 157);\">@Bean</span>\r\n    <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">public</span> EhCacheManagerFactoryBean <span class=\"hljs-title\" style=\"margin: 0px; padding: 0px;\">ehCacheManagerFactoryBean</span>() {\r\n        EhCacheManagerFactoryBean cacheManagerFactoryBean = <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">new</span> EhCacheManagerFactoryBean();\r\n        cacheManagerFactoryBean.setConfigLocation(<span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">new</span> ClassPathResource(<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"config/ehcache.xml\"</span>));\r\n        cacheManagerFactoryBean.setShared(<span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">true</span>);\r\n        <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">return</span> cacheManagerFactoryBean;\r\n    }\r\n}</code><ul class=\"pre-numbering\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; list-style: none; position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; border-right: 1px solid rgb(221, 221, 221); text-align: right;\"><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">1</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">2</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">3</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">4</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">5</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">6</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">7</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">8</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">9</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">10</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">11</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">12</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">13</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">14</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">15</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">16</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">17</li></ul></pre><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(63, 63, 63); font-family: &quot;microsoft yahei&quot;; font-size: 15px;\">ehcache.xml配置:</p><pre class=\"prettyprint\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; font-size: 14px; white-space: nowrap; padding: 5px 5px 5px 60px; margin-bottom: 1.1em; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-color: rgba(128, 128, 128, 0.075); border-radius: 0px; position: relative; overflow-y: hidden;\"><code class=\"hljs xml has-numbering\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; display: block; word-wrap: normal;\"><span class=\"hljs-pi\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;</span>\r\n<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">ehcache</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">xmlns:xsi</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"http://www.w3.org/2001/XMLSchema-instance\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">xsi:noNamespaceSchemaLocation</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"http://ehcache.org/ehcache.xsd\"</span>\r\n    <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">updateCheck</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span>&gt;</span>\r\n    <span class=\"hljs-comment\" style=\"margin: 0px; padding: 0px; color: rgb(136, 0, 0);\">&lt;!-- diskStore：为缓存路径，ehcache分为内存和磁盘两级，此属性定义磁盘的缓存位置。\r\n    参数解释如下： user.home – 用户主目录 \r\n    user.dir – 用户当前工作目录 \r\n    java.io.tmpdir – 默认临时文件路径 --&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">diskStore</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">path</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"java.io.tmpdir/Tmp_EhCache\"</span> /&gt;</span>\r\n    <span class=\"hljs-comment\" style=\"margin: 0px; padding: 0px; color: rgb(136, 0, 0);\">&lt;!-- defaultCache：默认缓存策略，当ehcache找不到定义的缓存时，则使用这个缓存策略。只能定义一个。 --&gt;</span>\r\n    <span class=\"hljs-comment\" style=\"margin: 0px; padding: 0px; color: rgb(136, 0, 0);\">&lt;!-- name:缓存名称。 \r\n        maxElementsInMemory:缓存最大数目\r\n        maxElementsOnDisk：硬盘最大缓存个数。 \r\n        eternal:对象是否永久有效，一但设置了，timeout将不起作用。 \r\n        overflowToDisk:是否保存到磁盘，当系统当机时 \r\n        timeToIdleSeconds:设置对象在失效前的允许闲置时间（单位：秒）。仅当eternal=false对象不是永久有效时使 用，可选属性，默认值是0，也就是可闲置时间无穷大。\r\n        timeToLiveSeconds:设置对象在失效前允许存活时间（单位：秒）。最大时间介于创建时间和失效时间之间。仅 当eternal=false对象不是永久有效时使用，默认是0.，也就是对象存活时间无穷大。 \r\n        diskPersistent：是否缓存虚拟机重启期数据Whether the disk store persists between restarts \r\n        of the Virtual Machine. The default value is false. \r\n        diskSpoolBufferSizeMB：这个参数设置DiskStore（磁盘缓存）的缓存区大小。默认是30MB。每个Cache都应该 有自己的一个缓冲区。 \r\n        diskExpiryThreadIntervalSeconds：磁盘失效线程运行时间间隔，默认是120秒。 \r\n        memoryStoreEvictionPolicy：当达到maxElementsInMemory限制时，Ehcache将会根据指定的策略去清理内 存。默认策略是LRU（最近最少使用）。\r\n        你可以设置为FIFO（先进先出）或是LFU（较少使用）。 \r\n        clearOnFlush：内存数量最大时是否清除。\r\n        memoryStoreEvictionPolicy:可选策略有：LRU（最近最少使用，默认策略）、FIFO（先进先出）、LFU（最少 访问次数）。 \r\n         FIFO，first in first out，这个是大家最熟的，先进先出。\r\n         LFU， Less Frequently Used，就是上面例子中使用的策略，直白一点就是讲一直以来最少被使用的。如上面 所讲，缓存的元素有一个hit属性，hit值最小的将会被清出缓存。 \r\n         LRU，Least Recently Used，最近最少使用的，缓存的元素有一个时间戳，当缓存容量满了，而又需要腾出地 方来缓存新的元素的时候，\r\n         那么现有缓存元素中时间戳离当前时间最远的元素将被清出缓存。 --&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">defaultCache</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">eternal</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">maxElementsInMemory</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"1000\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">overflowToDisk</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">diskPersistent</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span>\r\n        <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">timeToIdleSeconds</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"0\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">timeToLiveSeconds</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"600\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">memoryStoreEvictionPolicy</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"LRU\"</span> /&gt;</span>\r\n    <span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">cache</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">name</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"snailAuthCache\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">eternal</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">maxElementsInMemory</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"10000\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">overflowToDisk</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">diskPersistent</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"false\"</span>\r\n        <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">timeToIdleSeconds</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"0\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">timeToLiveSeconds</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"0\"</span> <span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">memoryStoreEvictionPolicy</span>=<span class=\"hljs-value\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"LFU\"</span> /&gt;</span>\r\n<span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">ehcache</span>&gt;</span></code><ul class=\"pre-numbering\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; list-style: none; position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; border-right: 1px solid rgb(221, 221, 221); text-align: right;\"><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">1</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">2</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">3</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">4</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">5</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">6</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">7</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">8</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">9</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">10</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">11</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">12</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">13</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">14</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">15</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">16</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">17</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">18</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">19</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">20</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">21</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">22</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">23</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">24</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">25</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">26</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">27</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">28</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">29</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">30</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">31</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">32</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">33</li></ul><div class=\"save_code tracking-ad\" data-mod=\"popu_249\" style=\"margin: 0px; padding: 0px; position: absolute; height: 60px; right: 30px; top: 5px; color: rgb(255, 255, 255); cursor: pointer; z-index: 2;\"><a style=\"color: rgb(202, 12, 22); margin: 0px; padding: 0px; outline: none;\"><img src=\"http://static.blog.csdn.net/images/save_snippets.png\" style=\"outline: none; max-width: 100%;\"></a></div></pre><h3 id=\"测试\" style=\"font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; color: rgb(63, 63, 63); margin: 0.8em 0px; font-size: 1.7em; padding: 0px;\"><br></h3>', 'article', null, null, null, null, '1', null, '0', '1', 'bootdo', '2017-09-22 17:48:29', '2017-09-22 17:48:29');
INSERT INTO `blog_content` VALUES ('109', 'spring-boot整合ehcache实现缓存机制', null, null, null, '<p><br></p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　EhCache 是一个纯Java的进程内缓存框架，具有快速、精干等特点，是Hibernate中默认的CacheProvider。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　ehcache提供了多种缓存策略，主要分为内存和磁盘两级，所以无需担心容量问题。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　spring-boot是一个快速的集成框架，其设计目的是用来简化新Spring应用的初始搭建以及开发过程。该框架使用了特定的方式来进行配置，从而使开发人员不再需要定义样板化的配置。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　由于spring-boot无需任何样板化的配置文件，所以spring-boot集成一些其他框架时会有略微的不同。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　1.spring-boot是一个通过maven管理的jar包的框架，集成ehcache需要的依赖如下</p><div class=\"cnblogs_code\" style=\"background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); padding: 5px; overflow: auto; margin: 5px 0px; color: rgb(0, 0, 0); font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div><pre style=\"margin-bottom: 0px; line-height: 1.42857; font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n     <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-context-support<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n         <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>net.sf.ehcache<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n      <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>ehcache<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n          <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>2.8.3<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>        </pre><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div></div><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　具体pom.xml文件如下</p><div class=\"cnblogs_code\" style=\"background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); padding: 5px; overflow: auto; margin: 5px 0px; color: rgb(0, 0, 0); font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div><pre style=\"margin-bottom: 0px; line-height: 1.42857; font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;?</span><span style=\"color: rgb(255, 0, 255); line-height: 1.5 !important;\">xml version=\"1.0\" encoding=\"UTF-8\"</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">?&gt;</span>\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">project </span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">xmlns</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"http://maven.apache.org/POM/4.0.0\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> xmlns:xsi</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"http://www.w3.org/2001/XMLSchema-instance\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">\r\n    xsi:schemaLocation</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">modelVersion</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>4.0.0<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">modelVersion</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>com.lclc.boot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>boot-cache<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>0.0.1-SNAPSHOT<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">&lt;!--</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\"> Inherit defaults from Spring Boot </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">--&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">parent</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework.boot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-boot-starter-parent<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>1.1.3.RELEASE<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">parent</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependencies</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework.boot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-boot-starter-web<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework.boot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-boot-starter-data-jpa<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework.boot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-boot-starter-thymeleaf<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        \r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>mysql<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>mysql-connector-java<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>com.google.guava<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>guava<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>17.0<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        \r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-context-support<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>net.sf.ehcache<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>ehcache<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>2.8.3<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">version</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependency</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependencies</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependencyManagement</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependencies</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependencies</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">dependencyManagement</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">build</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">plugins</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">plugin</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n                <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>org.springframework.boot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">groupId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n                <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-boot-maven-plugin<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">artifactId</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">plugin</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">plugins</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">build</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">repositories</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">repository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-snapshots<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>http://repo.spring.io/snapshot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">snapshots</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n                <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">enabled</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>true<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">enabled</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">snapshots</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">repository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">repository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-milestones<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>http://repo.spring.io/milestone<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">repository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">repositories</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">pluginRepositories</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">pluginRepository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-snapshots<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>http://repo.spring.io/snapshot<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">pluginRepository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">pluginRepository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>spring-milestones<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">id</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>http://repo.spring.io/milestone<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">url</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n        <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">pluginRepository</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">pluginRepositories</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">project</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span></pre><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div></div><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;　　2.使用ehcache，我们需要一个ehcache.xml来定义一些cache的属性。</p><div class=\"cnblogs_code\" style=\"background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); padding: 5px; overflow: auto; margin: 5px 0px; color: rgb(0, 0, 0); font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div><pre style=\"margin-bottom: 0px; line-height: 1.42857; font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;?</span><span style=\"color: rgb(255, 0, 255); line-height: 1.5 !important;\">xml version=\"1.0\" encoding=\"UTF-8\"</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">?&gt;</span>\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">ehcache </span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">xmlns:xsi</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"http://www.w3.org/2001/XMLSchema-instance\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> xsi:noNamespaceSchemaLocation</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"http://ehcache.org/ehcache.xsd\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">\r\n  updateCheck</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span>\r\n          <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">diskStore </span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">path</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"java.io.tmpdir/Tmp_EhCache\"</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">/&gt;</span>\r\n           <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">defaultCache </span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">eternal</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> maxElementsInMemory</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"1000\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> overflowToDisk</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> diskPersistent</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">\r\n    timeToIdleSeconds</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"0\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> timeToLiveSeconds</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"600\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> memoryStoreEvictionPolicy</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"LRU\"</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">/&gt;</span>\r\n\r\n            <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">cache </span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">name</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"demo\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> eternal</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> maxElementsInMemory</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"100\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> overflowToDisk</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> diskPersistent</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"false\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\">\r\n    timeToIdleSeconds</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"0\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> timeToLiveSeconds</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"300\"</span><span style=\"color: rgb(255, 0, 0); line-height: 1.5 !important;\"> memoryStoreEvictionPolicy</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">=\"LRU\"</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">/&gt;</span>\r\n\r\n<span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&lt;/</span><span style=\"color: rgb(128, 0, 0); line-height: 1.5 !important;\">ehcache</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">&gt;</span></pre><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div></div><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;　　解释下这个xml文件中的标签。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　(1).<span style=\"color: rgb(128, 0, 0);\">diskStore：</span>&nbsp;为缓存路径，ehcache分为内存和磁盘两级，此属性定义磁盘的缓存位置。参数解释如下：　　　　<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 　　　　user.home – 用户主目录<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 　　　 　user.dir&nbsp; – 用户当前工作目录<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;　　　　&nbsp; java.io.tmpdir – 默认临时文件路径</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　(2).<span style=\"color: rgb(128, 0, 0);\">defaultCache：<span style=\"color: rgb(0, 0, 0);\">默认缓存策略，当ehcache找不到定义的缓存时，则使用这个缓存策略。只能定义一个。</span></span></p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\"><span style=\"color: rgb(128, 0, 0);\"><span style=\"color: rgb(0, 0, 0);\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; (3).<span style=\"color: rgb(128, 0, 0);\">cache</span>：自定缓存策略，为自定义的缓存策略。参数解释如下：</span></span></p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\"><span style=\"color: rgb(128, 0, 0);\"><span style=\"color: rgb(0, 0, 0);\">　　　 cache元素的属性：&nbsp; &nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; name：缓存名称&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; maxElementsInMemory：内存中最大缓存对象数&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; maxElementsOnDisk：硬盘中最大缓存对象数，若是0表示无穷大&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; eternal：true表示对象永不过期，此时会忽略timeToIdleSeconds和timeToLiveSeconds属性，默认为false &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; overflowToDisk：true表示当内存缓存的对象数目达到了maxElementsInMemory界限后，会把溢出的对象写到硬盘缓存中。注意：如果缓存的对象要写入到硬盘中的话，则该对象必须实现了Serializable接口才行。&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; diskSpoolBufferSizeMB：磁盘缓存区大小，默认为30MB。每个Cache都应该有自己的一个缓存区。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; diskPersistent：是否缓存虚拟机重启期数据&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; diskExpiryThreadIntervalSeconds：磁盘失效线程运行时间间隔，默认为120秒&nbsp; &nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; timeToIdleSeconds： 设定允许对象处于空闲状态的最长时间，以秒为单位。当对象自从最近一次被访问后，如果处于空闲状态的时间超过了timeToIdleSeconds属性值，这个对象就会过期，EHCache将把它从缓存中清空。只有当eternal属性为false，该属性才有效。如果该属性值为0，则表示对象可以无限期地处于空闲状态&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; timeToLiveSeconds：设定对象允许存在于缓存中的最长时间，以秒为单位。当对象自从被存放到缓存中后，如果处于缓存中的时间超过了 timeToLiveSeconds属性值，这个对象就会过期，EHCache将把它从缓存中清除。只有当eternal属性为false，该属性才有效。如果该属性值为0，则表示对象可以无限期地存在于缓存中。timeToLiveSeconds必须大于timeToIdleSeconds属性，才有意义&nbsp; &nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; memoryStoreEvictionPolicy：当达到maxElementsInMemory限制时，Ehcache将会根据指定的策略去清理内存。可选策略有：LRU（最近最少使用，默认策略）、FIFO（先进先出）、LFU（最少访问次数）。&nbsp;&nbsp;</span></span></p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\"><span style=\"color: rgb(128, 0, 0);\"><span style=\"color: rgb(0, 0, 0);\">　　3.将ehcache的管理器暴露给spring的上下文容器，</span></span></p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\"><span style=\"color: rgb(128, 0, 0);\"><span style=\"color: rgb(0, 0, 0);\">　　</span></span></p><div class=\"cnblogs_code\" style=\"background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); padding: 5px; overflow: auto; margin: 5px 0px; color: rgb(0, 0, 0); font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div><pre style=\"margin-bottom: 0px; line-height: 1.42857; font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">@Configuration\r\n</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">//</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\"> 标注启动了缓存</span>\r\n<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">@EnableCaching\r\n</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">class</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> CacheConfiguration {\r\n\r\n    </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">/*</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">\r\n     * ehcache 主要的管理器\r\n     </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">*/</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">\r\n    @Bean(name </span>= \"appEhCacheCacheManager\"<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">)\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> EhCacheCacheManager ehCacheCacheManager(EhCacheManagerFactoryBean bean){\r\n        </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">return</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">new</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> EhCacheCacheManager (bean.getObject ());\r\n    }\r\n\r\n    </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">/*</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">\r\n     * 据shared与否的设置,Spring分别通过CacheManager.create()或new CacheManager()方式来创建一个ehcache基地.\r\n     </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">*/</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">\r\n    @Bean\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> EhCacheManagerFactoryBean ehCacheManagerFactoryBean(){\r\n        EhCacheManagerFactoryBean cacheManagerFactoryBean </span>= <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">new</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> EhCacheManagerFactoryBean ();\r\n        cacheManagerFactoryBean.setConfigLocation (</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">new</span> ClassPathResource (\"conf/ehcache-app.xml\"<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">));\r\n        cacheManagerFactoryBean.setShared (</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">true</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">);\r\n        </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">return</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> cacheManagerFactoryBean;\r\n    }\r\n}</span></pre><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div></div><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;&nbsp; 　　　　<span style=\"color: rgb(0, 0, 0);\">@Configuration</span>：为spring-boot注解，主要标注此为配置类，优先扫描。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp; 　　　　<span style=\"color: rgb(0, 0, 0);\">@Bean</span>：向spring容器中加入bean。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　至此所有的配置都做好了，通过spring-boot进行集成框架就是这么简单。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　4.使用ehcache</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　使用ehcache主要通过spring的缓存机制，上面我们将spring的缓存机制使用了ehcache进行实现，所以使用方面就完全使用spring缓存机制就行了。<br>　　　　具体牵扯到几个注解：</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　@Cacheable：负责将方法的返回值加入到缓存中，参数3<br>　　　　@CacheEvict：负责清除缓存，参数4</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　　参数解释：</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　value：缓存位置名称，不能为空，如果使用EHCache，就是ehcache.xml中声明的cache的name<br>　　　　key：缓存的key，默认为空，既表示使用方法的参数类型及参数值作为key，支持SpEL<br>　　　　condition：触发条件，只有满足条件的情况才会加入缓存，默认为空，既表示全部都加入缓存，支持SpEL</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　allEntries：CacheEvict参数，true表示清除value中的全部缓存，默认为false</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　不多说，直接上代码：</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　</p><div class=\"cnblogs_code\" style=\"background-color: rgb(245, 245, 245); border: 1px solid rgb(204, 204, 204); padding: 5px; overflow: auto; margin: 5px 0px; color: rgb(0, 0, 0); font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div><pre style=\"margin-bottom: 0px; line-height: 1.42857; font-family: &quot;Courier New&quot; !important; font-size: 12px !important;\"><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">@Service\r\n</span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">class</span> CacheDemoServiceImpl <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">implements</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> CacheDemoService {\r\n\r\n    </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">/**</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">\r\n     * 缓存的key\r\n     </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">*/</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">static</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">final</span> String THING_ALL_KEY   = \"\\\"thing_all\\\"\"<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">;\r\n    </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">/**</span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">\r\n     * value属性表示使用哪个缓存策略，缓存策略在ehcache.xml\r\n     </span><span style=\"color: rgb(0, 128, 0); line-height: 1.5 !important;\">*/</span>\r\n    <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">static</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">final</span> String DEMO_CACHE_NAME = \"demo\"<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">;\r\n   \r\n    @CacheEvict(value </span>= DEMO_CACHE_NAME,key =<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> THING_ALL_KEY)\r\n    @Override\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">void</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> create(Thing thing){\r\n        Long id </span>=<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> getNextId ();\r\n        thing.setId (id);\r\n        data.put (id, thing);\r\n    } \r\n      \r\n     @Cacheable(value </span>=<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> DEMO_CACHE_NAME,key = \"#thing.getId()+\'thing\'\")\r\n    @Override\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> Thing findById(Long id){\r\n        System.err.println (</span>\"没有走缓存！\" +<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> id);\r\n        </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">return</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> data.get (id);\r\n    }\r\n\r\n      @Cacheable(value </span>= DEMO_CACHE_NAME,key =<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> THING_ALL_KEY)\r\n    @Override\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> List&lt;Thing&gt;<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> findAll(){\r\n        </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">return</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> Lists.newArrayList (data.values ());\r\n    }\r\n   \r\n   </span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">\r\n      @Override\r\n    @CachePut(value </span>= DEMO_CACHE_NAME,key = \"#thing.getId()+\'thing\'\"<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\">)\r\n    @CacheEvict(value </span>= DEMO_CACHE_NAME,key =<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> THING_ALL_KEY)\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> Thing update(Thing thing){\r\n        System.out.println (thing);\r\n        data.put (thing.getId (), thing);\r\n        </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">return</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> thing;\r\n    }\r\n\r\n    @CacheEvict(value </span>=<span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> DEMO_CACHE_NAME)\r\n    @Override\r\n    </span><span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">public</span> <span style=\"color: rgb(0, 0, 255); line-height: 1.5 !important;\">void</span><span style=\"color: rgb(0, 0, 0); line-height: 1.5 !important;\"> delete(Long id){\r\n        data.remove (id);\r\n    }\r\n   \r\n}</span></pre><div class=\"cnblogs_code_toolbar\" style=\"margin-top: 5px;\"><span class=\"cnblogs_code_copy\" style=\"padding-right: 5px; line-height: 1.5 !important;\"><a title=\"复制代码\" style=\"color: rgb(86, 182, 233); background-color: rgb(245, 245, 245) !important; border: none !important;\"><img src=\"http://common.cnblogs.com/images/copycode.gif\" alt=\"复制代码\" style=\"max-width: 900px; border-width: initial !important; border-style: none !important;\"></a></span></div></div><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">　　　　5.只需要通过注解在service层方法上打注解便可以使用缓存，在find**上存入缓存，在delete**,update**上清除缓存。</p><p style=\"margin-top: 10px; margin-right: auto; margin-left: auto; color: rgb(35, 35, 35); font-family: Verdana, Arial, helvetica, sans-seriff; font-size: 14px;\">&nbsp;</p>', 'article', null, null, null, null, '1', null, '0', '1', 'bootdo', '2017-09-24 11:15:18', '2017-09-24 11:15:18');
INSERT INTO `blog_content` VALUES ('110', 'spring boot 图片上传后的图片读取路径在win与linux环境配置的差别', null, null, null, '<ol><li><p style=\"margin-bottom: 0px; padding: 0px; color: rgb(69, 69, 69); font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; font-size: 16px;\">win</p><p style=\"margin-bottom: 0px; padding: 0px; color: rgb(69, 69, 69); font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; font-size: 16px;\"></p><div class=\"dp-highlighter bg_java\" style=\"padding: 1px 0px 0px; font-family: Consolas, &quot;Courier New&quot;, Courier, mono, serif; font-size: 12px; background-color: rgb(231, 229, 220); width: 849.412px; overflow-x: auto; overflow-y: hidden; position: relative; color: rgb(69, 69, 69); margin: 18px 0px !important;\"><div class=\"bar\" style=\"margin: 0px; padding: 0px 0px 0px 45px;\"><div class=\"tools\" style=\"margin: 0px; padding: 3px 8px 10px 10px; font-stretch: normal; font-size: 9px; line-height: normal; font-family: Verdana, Geneva, Arial, Helvetica, sans-serif; color: silver; background-color: rgb(248, 248, 248); border-left: 3px solid rgb(108, 226, 108); border-right: 1px solid rgb(231, 229, 220);\"><b>[java]</b>&nbsp;<a href=\"http://blog.csdn.net/qq1115094858/article/details/51873698#\" class=\"ViewSource\" title=\"view plain\" style=\"background-image: url(&quot;images/default/ico_plain.gif&quot;); background-position: left top; background-repeat: no-repeat; color: rgb(202, 12, 22); margin: 0px 10px 0px 0px; padding: 1px; outline: none; border: none; font-size: 9px; display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">view plain</a><span class=\"tracking-ad\" data-mod=\"popu_168\" style=\"margin: 0px; padding: 0px;\">&nbsp;<a href=\"http://blog.csdn.net/qq1115094858/article/details/51873698#\" class=\"CopyToClipboard\" title=\"copy\" style=\"background-image: url(&quot;images/default/ico_copy.gif&quot;); background-position: left top; background-repeat: no-repeat; color: rgb(202, 12, 22); margin: 0px 10px 0px 0px; padding: 1px; outline: none; border: none; font-size: 9px; display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">copy</a><div style=\"margin: 0px; padding: 0px; position: absolute; left: 294px; top: 296px; width: 16px; height: 16px; z-index: 99;\"></div></span><span class=\"tracking-ad\" data-mod=\"popu_169\" style=\"margin: 0px; padding: 0px;\"></span></div></div><ol start=\"1\" class=\"dp-j\" style=\"padding: 0px; list-style-position: initial; list-style-image: initial; border-top: none; border-right: 1px solid rgb(231, 229, 220); border-bottom: none; border-left: none; border-image: initial; background-color: rgb(255, 255, 255); color: rgb(92, 92, 92); margin-right: 0px !important; margin-bottom: 1px !important; margin-left: 45px !important;\"><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Component</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">class</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;WebConfigurer&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">extends</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;WebMvcConfigurerAdapter&nbsp;{&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Override</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">public</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">void</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;addResourceHandlers(ResourceHandlerRegistry&nbsp;registry)&nbsp;{&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;registry.addResourceHandler(<span class=\"string\" style=\"margin: 0px; padding: 0px; border: none; color: blue; background-color: inherit;\">\"/files/**\"</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">).addResourceLocations(</span><span class=\"string\" style=\"margin: 0px; padding: 0px; border: none; color: blue; background-color: inherit;\">\"file:///E:/var/spring/uploaded_files/\"</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">);&nbsp;&nbsp;</span></span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;</span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">}&nbsp;&nbsp;</span></li></ol></div><span style=\"color: rgb(69, 69, 69); font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; font-size: 16px;\">linux</span><br style=\"color: rgb(69, 69, 69); font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; font-size: 16px;\"><div class=\"dp-highlighter bg_java\" style=\"padding: 1px 0px 0px; font-family: Consolas, &quot;Courier New&quot;, Courier, mono, serif; font-size: 12px; background-color: rgb(231, 229, 220); width: 849.412px; overflow-x: auto; overflow-y: hidden; position: relative; color: rgb(69, 69, 69); margin: 18px 0px !important;\"><div class=\"bar\" style=\"margin: 0px; padding: 0px 0px 0px 45px;\"><div class=\"tools\" style=\"margin: 0px; padding: 3px 8px 10px 10px; font-stretch: normal; font-size: 9px; line-height: normal; font-family: Verdana, Geneva, Arial, Helvetica, sans-serif; color: silver; background-color: rgb(248, 248, 248); border-left: 3px solid rgb(108, 226, 108); border-right: 1px solid rgb(231, 229, 220);\"><b>[java]</b>&nbsp;<a href=\"http://blog.csdn.net/qq1115094858/article/details/51873698#\" class=\"ViewSource\" title=\"view plain\" style=\"background-image: url(&quot;images/default/ico_plain.gif&quot;); background-position: left top; background-repeat: no-repeat; color: rgb(202, 12, 22); margin: 0px 10px 0px 0px; padding: 1px; outline: none; border: none; font-size: 9px; display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">view plain</a><span class=\"tracking-ad\" data-mod=\"popu_168\" style=\"margin: 0px; padding: 0px;\">&nbsp;<a href=\"http://blog.csdn.net/qq1115094858/article/details/51873698#\" class=\"CopyToClipboard\" title=\"copy\" style=\"background-image: url(&quot;images/default/ico_copy.gif&quot;); background-position: left top; background-repeat: no-repeat; color: rgb(202, 12, 22); margin: 0px 10px 0px 0px; padding: 1px; outline: none; border: none; font-size: 9px; display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">copy</a><div style=\"margin: 0px; padding: 0px; position: absolute; left: 294px; top: 528px; width: 16px; height: 16px; z-index: 99;\"></div></span><span class=\"tracking-ad\" data-mod=\"popu_169\" style=\"margin: 0px; padding: 0px;\"></span></div></div><ol start=\"1\" class=\"dp-j\" style=\"padding: 0px; list-style-position: initial; list-style-image: initial; border-top: none; border-right: 1px solid rgb(231, 229, 220); border-bottom: none; border-left: none; border-image: initial; background-color: rgb(255, 255, 255); color: rgb(92, 92, 92); margin-right: 0px !important; margin-bottom: 1px !important; margin-left: 45px !important;\"><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Component</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">class</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;WebConfigurer&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">extends</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;WebMvcConfigurerAdapter&nbsp;{&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Override</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">public</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; font-weight: bold; border: none; color: rgb(0, 102, 153); background-color: inherit;\">void</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;addResourceHandlers(ResourceHandlerRegistry&nbsp;registry)&nbsp;{&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;registry.addResourceHandler(<span class=\"string\" style=\"margin: 0px; padding: 0px; border: none; color: blue; background-color: inherit;\">\"/files/**\"</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">).addResourceLocations(</span><span class=\"string\" style=\"margin: 0px; padding: 0px; border: none; color: blue; background-color: inherit;\">\"file:///var/spring/uploaded_files\"</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">);&nbsp;&nbsp;</span></span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; color: inherit; line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;</span></li><li class=\"\" style=\"margin-left: 40px; list-style: decimal; border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin-top: 0px !important; margin-right: 0px !important; margin-bottom: 0px !important; padding: 0px 3px 0px 10px !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">}&nbsp;&nbsp;</span></li><li></li></ol></div></li></ol>', 'article', null, null, null, null, '1', null, '1', '1', 'bootdo', '2017-09-24 09:15:35', '2017-09-24 09:15:35');
INSERT INTO `blog_content` VALUES ('111', 'Springmvc提交日期类型参数', null, null, null, '<ol style=\"color: rgb(63, 63, 63); font-family: &quot;microsoft yahei&quot;; font-size: 15px;\"><li><p style=\"margin-bottom: 1.1em; padding: 0px;\">背景介绍&nbsp;<br>在springmvc框架中，前台传入到后台的form会经过springmvc自动封装到pojo类中，后台接受的时候可以在参数内直接接受这个java类。</p></li><li><p style=\"margin-bottom: 1.1em; padding: 0px;\">传参&nbsp;<br>通常情况下，前台的表单的类型诸如int,string等，都会根据pojo中字段的类型自动转换。所以为我们省去了不少麻烦，但很可惜其中不包括日期类型。</p></li><li><p style=\"margin-bottom: 1.1em; padding: 0px;\">原因&nbsp;<br>因为日期的格式多种多样，spring自身不适合对其进行封装。好在spring给出了便捷的方法给我们自己转换数据类型。</p></li><li><p style=\"margin-bottom: 1.1em; padding: 0px;\">具体实现</p></li></ol><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(63, 63, 63); font-family: &quot;microsoft yahei&quot;; font-size: 15px;\">在controller层中，加入以下代码段</p><pre class=\"prettyprint\" name=\"code\" style=\"white-space: nowrap; position: relative; overflow-y: hidden; margin-bottom: 1.1em; font-family: &quot;Source Code Pro&quot;, monospace; padding: 5px 5px 5px 60px; font-size: 14px; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-width: 0px; border-color: rgb(136, 136, 136); border-radius: 0px;\"><code class=\"hljs java has-numbering\" style=\"display: block; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; word-wrap: normal;\"><span class=\"hljs-annotation\" style=\"color: rgb(155, 133, 157);\">@InitBinder</span>\r\n<span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">public</span> <span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">void</span> <span class=\"hljs-title\">initBinder</span>(WebDataBinder binder) {\r\n    SimpleDateFormat dateFormat = <span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">new</span> SimpleDateFormat(<span class=\"hljs-string\" style=\"color: rgb(0, 136, 0);\">\"yyyy-MM-dd\"</span>);\r\n    dateFormat.setLenient(<span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">false</span>);\r\n    binder.registerCustomEditor(Date.class, <span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">new</span> CustomDateEditor(dateFormat, <span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">true</span>));<span class=\"hljs-comment\" style=\"color: rgb(136, 0, 0);\">//true:允许输入空值，false:不能为空值</span>\r\n}</code><ul class=\"pre-numbering\" style=\"position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; border-right: 1px solid rgb(221, 221, 221); list-style: none; text-align: right;\"><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">1</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">2</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">3</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">4</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">5</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">6</li></ul></pre><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(63, 63, 63); font-family: &quot;microsoft yahei&quot;; font-size: 15px;\">可以解决这个问题。但是这个时候Date类型的参数是null的话，还是会报错。采用另外一种方式则更好，为null也不会报错，就是把请求参数封装为一个vo类，在对应的类属性上加上注解，这样</p><pre class=\"prettyprint\" name=\"code\" style=\"white-space: nowrap; position: relative; overflow-y: hidden; margin-bottom: 1.1em; font-family: &quot;Source Code Pro&quot;, monospace; padding: 5px 5px 5px 60px; font-size: 14px; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-width: 0px; border-color: rgb(136, 136, 136); border-radius: 0px;\"><code class=\"hljs java has-numbering\" style=\"display: block; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; word-wrap: normal;\"><span class=\"hljs-annotation\" style=\"color: rgb(155, 133, 157);\">@DateTimeFormat</span>(iso = ISO.DATE_TIME, pattern = <span class=\"hljs-string\" style=\"color: rgb(0, 136, 0);\">\"w:yyyy\"</span>)\r\n<span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">private</span> Date startTime;\r\n或者\r\n<span class=\"hljs-annotation\" style=\"color: rgb(155, 133, 157);\">@DateTimeFormat</span>(pattern=<span class=\"hljs-string\" style=\"color: rgb(0, 136, 0);\">\"yyyy-MM-dd HH:mm:ss\"</span>)\r\n<span class=\"hljs-keyword\" style=\"color: rgb(0, 0, 136);\">private</span> Date lastLoginDate;</code><ul class=\"pre-numbering\" style=\"position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; border-right: 1px solid rgb(221, 221, 221); list-style: none; text-align: right;\"><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">1</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">2</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">3</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">4</li><li style=\"padding: 0px 5px; list-style: none; margin-left: 0px;\">5</li></ul></pre><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(63, 63, 63); font-family: &quot;microsoft yahei&quot;; font-size: 15px;\">另外如果使用验证框架，方法参数这样写(@Valid XxxParam param, BindingResult binding) ，就能直接通过BindingResult得到验证结果了。</p>', 'article', null, null, null, null, '1', null, '1', '1', 'bootdo', '2017-09-25 21:34:51', '2017-09-25 21:34:51');
INSERT INTO `blog_content` VALUES ('112', ' SpringBoot 在启动时运行代码', null, null, null, '<p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">在Spring boot项目的实际开发中，我们有时需要项目服务启动时加载一些数据或预先完成某些动作。为了解决这样的问题，Spring&nbsp;boot 为我们提供了一个方法：通过实现接口 CommandLineRunner 来实现这样的需求。</p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">实现方式：只需要一个类即可，无需其他配置。&nbsp;</p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">实现步骤：</p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">1.创建实现接口 CommandLineRunner 的类 MyStartupRunnerTest</p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\"></p><div class=\"dp-highlighter bg_java\" style=\"font-family: Consolas, &quot;Courier New&quot;, Courier, mono, serif; font-size: 12px; background-color: rgb(231, 229, 220); width: 936.531px; overflow-x: auto; overflow-y: hidden; padding-top: 1px; position: relative; border-color: rgb(204, 204, 204); color: rgb(85, 85, 85); margin: 18px 0px !important;\"><div class=\"bar\" style=\"padding-left: 45px;\"><div class=\"tools\" style=\"padding: 3px 8px 10px 10px; font-stretch: normal; font-size: 9px; line-height: normal; font-family: Verdana, Geneva, Arial, Helvetica, sans-serif; color: silver; background-color: rgb(248, 248, 248); border-left: 3px solid rgb(108, 226, 108); border-right: 1px solid rgb(231, 229, 220);\"><strong>[java]</strong>&nbsp;<a target=\"_blank\" href=\"http://blog.csdn.net/mimica247706624/article/details/58596490#\" class=\"ViewSource\" title=\"view plain\" style=\"background-image: url(&quot;images/default/ico_plain.gif&quot;); background-position: left top; background-repeat: no-repeat; border: none; padding: 1px; margin: 0px 10px 0px 0px; font-size: 9px; color: rgb(160, 160, 160); display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">view plain</a>&nbsp;<a target=\"_blank\" href=\"http://blog.csdn.net/mimica247706624/article/details/58596490#\" class=\"CopyToClipboard\" title=\"copy\" style=\"background-image: url(&quot;images/default/ico_copy.gif&quot;); background-position: left top; background-repeat: no-repeat; border: none; padding: 1px; margin: 0px 10px 0px 0px; font-size: 9px; color: rgb(160, 160, 160); display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">copy</a><div style=\"position: absolute; left: 559px; top: 655px; width: 18px; height: 18px; z-index: 99;\"></div><div style=\"position: absolute; left: 721px; top: 723px; width: 18px; height: 18px; z-index: 99;\"></div></div></div><ol start=\"1\" class=\"dp-j\" style=\"padding: 0px; border: none; list-style-position: initial; list-style-image: initial; background-color: rgb(255, 255, 255); color: rgb(92, 92, 92); margin-right: 0px !important; margin-bottom: 1px !important; margin-left: 45px !important;\"><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">package</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;com.energy;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">import</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;org.springframework.boot.CommandLineRunner;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">import</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;org.springframework.core.annotation.Order;&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">import</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;org.springframework.stereotype.Component;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"comment\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 130, 0); background-color: inherit;\">/**</span>&nbsp;</span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"comment\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 130, 0); background-color: inherit;\">&nbsp;*&nbsp;Created&nbsp;by&nbsp;CavanLiu&nbsp;on&nbsp;2017/2/28&nbsp;0028.</span>&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"comment\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 130, 0); background-color: inherit;\">&nbsp;*/</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Component</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Order</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">(value=</span><span class=\"number\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(192, 0, 0); background-color: inherit;\">1</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">)</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">public</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">class</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;MyStartupRunnerTest&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">implements</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;CommandLineRunner&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">{&nbsp;&nbsp;</span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Override</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">public</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">void</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;run(String...&nbsp;args)&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">throws</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;Exception&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class=\"string\" style=\"margin: 0px; padding: 0px; border: none; color: blue; background-color: inherit;\">\"&gt;&gt;&gt;&gt;This&nbsp;is&nbsp;MyStartupRunnerTest&nbsp;Order=1.&nbsp;Only&nbsp;testing&nbsp;CommandLineRunner...&lt;&lt;&lt;&lt;\"</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">);&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">}&nbsp;&nbsp;</span></li></ol></div><p style=\"margin-bottom: 0px; padding: 0px; color: rgb(85, 85, 85); font-family: Arial; font-size: 14px;\"></p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">2.创建实现接口CommandLineRunner 的类 MyStartupRunnerTest2</p><div class=\"dp-highlighter bg_java\" style=\"font-family: Consolas, &quot;Courier New&quot;, Courier, mono, serif; font-size: 12px; background-color: rgb(231, 229, 220); width: 936.531px; overflow-x: auto; overflow-y: hidden; padding-top: 1px; position: relative; border-color: rgb(204, 204, 204); color: rgb(85, 85, 85); margin: 18px 0px !important;\"><div class=\"bar\" style=\"padding-left: 45px;\"><div class=\"tools\" style=\"padding: 3px 8px 10px 10px; font-stretch: normal; font-size: 9px; line-height: normal; font-family: Verdana, Geneva, Arial, Helvetica, sans-serif; color: silver; background-color: rgb(248, 248, 248); border-left: 3px solid rgb(108, 226, 108); border-right: 1px solid rgb(231, 229, 220);\"><strong>[java]</strong>&nbsp;<a target=\"_blank\" href=\"http://blog.csdn.net/mimica247706624/article/details/58596490#\" class=\"ViewSource\" title=\"view plain\" style=\"background-image: url(&quot;images/default/ico_plain.gif&quot;); background-position: left top; background-repeat: no-repeat; border: none; padding: 1px; margin: 0px 10px 0px 0px; font-size: 9px; color: rgb(160, 160, 160); display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">view plain</a>&nbsp;<a target=\"_blank\" href=\"http://blog.csdn.net/mimica247706624/article/details/58596490#\" class=\"CopyToClipboard\" title=\"copy\" style=\"background-image: url(&quot;images/default/ico_copy.gif&quot;); background-position: left top; background-repeat: no-repeat; border: none; padding: 1px; margin: 0px 10px 0px 0px; font-size: 9px; color: rgb(160, 160, 160); display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">copy</a><div style=\"position: absolute; left: 559px; top: 1094px; width: 18px; height: 18px; z-index: 99;\"></div><div style=\"position: absolute; left: 721px; top: 1160px; width: 18px; height: 18px; z-index: 99;\"></div></div></div><ol start=\"1\" class=\"dp-j\" style=\"padding: 0px; border: none; list-style-position: initial; list-style-image: initial; background-color: rgb(255, 255, 255); color: rgb(92, 92, 92); margin-right: 0px !important; margin-bottom: 1px !important; margin-left: 45px !important;\"><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">package</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;com.energy;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">import</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;org.springframework.boot.CommandLineRunner;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">import</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;org.springframework.core.annotation.Order;&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">import</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;org.springframework.stereotype.Component;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"comment\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 130, 0); background-color: inherit;\">/**</span>&nbsp;</span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"comment\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 130, 0); background-color: inherit;\">&nbsp;*&nbsp;Created&nbsp;by&nbsp;CavanLiu&nbsp;on&nbsp;2017/2/28&nbsp;0028.</span>&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"comment\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 130, 0); background-color: inherit;\">&nbsp;*/</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Component</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Order</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">(value=</span><span class=\"number\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(192, 0, 0); background-color: inherit;\">2</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">)</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">public</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">class</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;MyStartupRunnerTest2&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">implements</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;CommandLineRunner&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">{&nbsp;&nbsp;</span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"annotation\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(100, 100, 100); background-color: inherit;\">@Override</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;&nbsp;</span></span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;<span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">public</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">void</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;run(String...&nbsp;args)&nbsp;</span><span class=\"keyword\" style=\"margin: 0px; padding: 0px; border: none; color: rgb(0, 102, 153); background-color: inherit; font-weight: bold;\">throws</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&nbsp;Exception&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;System.out.println(<span class=\"string\" style=\"margin: 0px; padding: 0px; border: none; color: blue; background-color: inherit;\">\"&gt;&gt;&gt;&gt;This&nbsp;is&nbsp;MyStartupRunnerTest&nbsp;Order=2.&nbsp;Only&nbsp;testing&nbsp;CommandLineRunner...&lt;&lt;&lt;&lt;\"</span><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">);&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&nbsp;&nbsp;&nbsp;&nbsp;}&nbsp;&nbsp;</span></li><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">}&nbsp;&nbsp;</span></li></ol></div><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">3.启动Spring boot后查看控制台输出信息，如下所示：</p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\"></p><div class=\"dp-highlighter bg_plain\" style=\"font-family: Consolas, &quot;Courier New&quot;, Courier, mono, serif; font-size: 12px; background-color: rgb(231, 229, 220); width: 936.531px; overflow-x: auto; overflow-y: hidden; padding-top: 1px; position: relative; border-color: rgb(204, 204, 204); color: rgb(85, 85, 85); margin: 18px 0px !important;\"><div class=\"bar\" style=\"padding-left: 45px;\"><div class=\"tools\" style=\"padding: 3px 8px 10px 10px; font-stretch: normal; font-size: 9px; line-height: normal; font-family: Verdana, Geneva, Arial, Helvetica, sans-serif; color: silver; background-color: rgb(248, 248, 248); border-left: 3px solid rgb(108, 226, 108); border-right: 1px solid rgb(231, 229, 220);\"><strong>[plain]</strong>&nbsp;<a target=\"_blank\" href=\"http://blog.csdn.net/mimica247706624/article/details/58596490#\" class=\"ViewSource\" title=\"view plain\" style=\"background-image: url(&quot;images/default/ico_plain.gif&quot;); background-position: left top; background-repeat: no-repeat; border: none; padding: 1px; margin: 0px 10px 0px 0px; font-size: 9px; color: rgb(160, 160, 160); display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">view plain</a>&nbsp;<a target=\"_blank\" href=\"http://blog.csdn.net/mimica247706624/article/details/58596490#\" class=\"CopyToClipboard\" title=\"copy\" style=\"background-image: url(&quot;images/default/ico_copy.gif&quot;); background-position: left top; background-repeat: no-repeat; border: none; padding: 1px; margin: 0px 10px 0px 0px; font-size: 9px; color: rgb(160, 160, 160); display: inline-block; width: 16px; height: 16px; text-indent: -2000px;\">copy</a><div style=\"position: absolute; left: 563px; top: 1532px; width: 18px; height: 18px; z-index: 99;\"></div><div style=\"position: absolute; left: 725px; top: 1597px; width: 18px; height: 18px; z-index: 99;\"></div></div></div><ol start=\"1\" style=\"padding: 0px; border: none; list-style-position: initial; list-style-image: initial; background-color: rgb(255, 255, 255); color: rgb(92, 92, 92); margin-right: 0px !important; margin-bottom: 1px !important; margin-left: 45px !important;\"><li class=\"alt\" style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; color: inherit; line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\"><span style=\"margin: 0px; padding: 0px; border: none; background-color: inherit;\">&gt;&gt;&gt;&gt;This&nbsp;is&nbsp;MyStartupRunnerTest&nbsp;Order=1.&nbsp;Only&nbsp;testing&nbsp;CommandLineRunner...&lt;&lt;&lt;&lt;&nbsp;&nbsp;</span></span></li><li style=\"border-top: none; border-right: none; border-bottom: none; border-left: 3px solid rgb(108, 226, 108); border-image: initial; list-style-type: decimal-leading-zero; list-style-image: initial; background-color: rgb(248, 248, 248); line-height: 18px; margin: 0px !important; padding: 0px 3px 0px 10px !important; list-style-position: outside !important;\"><span style=\"margin: 0px; padding: 0px; border: none; color: black; background-color: inherit;\">&gt;&gt;&gt;&gt;This&nbsp;is&nbsp;MyStartupRunnerTest2&nbsp;Order=2.&nbsp;Only&nbsp;testing&nbsp;CommandLineRunner...&lt;&lt;&lt;&lt;&nbsp;&nbsp;</span></li></ol></div><p style=\"margin-bottom: 0px; padding: 0px; color: rgb(85, 85, 85); font-family: Arial; font-size: 14px;\"></p><p style=\"margin-bottom: 1.1em; padding: 0px; color: rgb(85, 85, 85); font-family: &quot;microsoft yahei&quot;; font-size: 14px;\">4.Application启动类代码略。</p><p><span style=\"color: rgb(85, 85, 85); font-family: Arial; font-size: 14px;\">说明：CommandLineRunner接口的运行顺序是依据@Order注解的value由小到大执行，即value值越小优先级越高。</span><br></p>', 'article', null, null, null, null, '1', null, '1', '1', 'bootdo', '2017-09-26 15:18:15', '2017-09-26 15:18:15');
INSERT INTO `blog_content` VALUES ('115', 'communication', null, null, null, '<h2 style=\"color: rgb(103, 106, 108);\"><span style=\"font-family: Times; font-size: 17.5px; font-weight: bold;\"><a href=\"https://jq.qq.com/?_wv=1027&amp;k=5EfMNFL\" target=\"_blank\" style=\"color: rgb(42, 100, 150); text-decoration-line: underline; outline: 0px;\">qq群 669039323</a></span></h2>', null, null, 'communication', null, null, '1', null, '0', '1', 'bootdo', '2017-09-30 14:43:30', '2017-09-30 14:43:30');
INSERT INTO `blog_content` VALUES ('116', 'ablout', null, null, null, '<h1 style=\"box-sizing: inherit; font-size: 28px; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); min-height: 1rem; -webkit-font-smoothing: antialiased; cursor: text; position: relative; margin-top: 0px !important;\">BootDo 面向学习型的开源框架</h1><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"平台简介\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E5%B9%B3%E5%8F%B0%E7%AE%80%E4%BB%8B\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>平台简介</h2><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">BootDo是高效率，低封装，面向学习型，面向微服的<strong style=\"box-sizing: inherit;\">开源</strong>Java EE开发框架。</p><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">BootDo是在SpringBoot基础上搭建的一个Java基础开发平台，MyBatis为数据访问层，ApacheShiro为权限授权层，Ehcahe对常用数据进行缓存。</p><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">BootDo主要定位于后台管理系统学习交流，已内置后台管理系统的基础功能和高效的<strong style=\"box-sizing: inherit;\">代码生成</strong>工具， 包括：系统权限组件、数据权限组件、数据字典组件、核心工具组件、视图操作组件、工作流组件、代码生成等。 前端界面风格采用了结构简单、性能优良、页面美观大气的Twitter Bootstrap页面展示框架。 采用分层设计、双重验证、提交数据安全编码、密码加密、访问验证、数据权限验证。 使用Maven做项目管理，提高项目的易开发性、扩展性。</p><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">BootDo目前包括以下四大模块，系统管理（SYS）模块、 内容管理（CMS）模块、在线办公（OA）模块、代码生成（GEN）模块。&nbsp;<strong style=\"box-sizing: inherit;\">系统管理模块</strong>&nbsp;，包括企业组织架构（用户管理、机构管理、区域管理）、 菜单管理、角色权限管理、字典管理等功能；&nbsp;<strong style=\"box-sizing: inherit;\">内容管理模块</strong>&nbsp;，包括内容管理（文章、链接），栏目管理、站点管理、 公共留言、文件管理、前端网站展示等功能；&nbsp;<strong style=\"box-sizing: inherit;\">在线办公模块</strong>&nbsp;，提供简单的请假流程实例；<strong style=\"box-sizing: inherit;\">代码生成模块</strong>&nbsp;，完成重复的工作。</p><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">BootDo 提供了常用工具进行封装，包括日志工具、缓存工具、服务器端验证、数据字典、当前组织机构数据 （用户、机构、区域）以及其它常用小工具等。另外还提供一个强大的在线&nbsp;<strong style=\"box-sizing: inherit;\">代码生成</strong>&nbsp;工具。</p><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"内置功能\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E5%86%85%E7%BD%AE%E5%8A%9F%E8%83%BD\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>内置功能</h2><ol class=\"task-list\" style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 24px; padding-left: 30px; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\"><li style=\"box-sizing: inherit; list-style-type: decimal;\">用户管理：用户是系统操作者，该功能主要完成系统用户配置。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">机构管理：配置系统组织机构（公司、部门、小组），树结构展现，可随意调整上下级。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">区域管理：系统城市区域模型，如：国家、省市、地市、区县的维护。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">菜单管理：配置系统菜单，操作权限，按钮权限标识等。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">角色管理：角色菜单权限分配、设置角色按机构进行数据范围权限划分。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">字典管理：对系统中经常使用的一些较为固定的数据进行维护，如：是否、男女、类别、级别等。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">操作日志：系统正常操作日志记录和查询；系统异常信息日志记录和查询。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">连接池监视：监视当期系统数据库连接池状态，可进行分析SQL找出系统性能瓶颈。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">工作流引擎：实现业务工单流转、在线流程设计器。</li></ol><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"技术选型\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E6%8A%80%E6%9C%AF%E9%80%89%E5%9E%8B\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>技术选型</h2><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">1、后端</p><ul class=\"task-list\" style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 24px; padding-left: 30px; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\"><li style=\"box-sizing: inherit; list-style-type: initial;\">核心框架：Spring Boot</li><li style=\"box-sizing: inherit; list-style-type: initial;\">安全框架：Apache Shiro</li><li style=\"box-sizing: inherit; list-style-type: initial;\">模板引擎：Thymeleaf</li><li style=\"box-sizing: inherit; list-style-type: initial;\">持久层框架：MyBatis</li><li style=\"box-sizing: inherit; list-style-type: initial;\">数据库连接池：Alibaba Druid</li><li style=\"box-sizing: inherit; list-style-type: initial;\">缓存框架：Ehcache 、Redis</li><li style=\"box-sizing: inherit; list-style-type: initial;\">日志管理：SLF4J</li><li style=\"box-sizing: inherit; list-style-type: initial;\">工具类：Apache Commons、Jackson 、Xstream 1.4、Dozer 5.3、POI 3.9</li></ul><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">2、前端</p><ul class=\"task-list\" style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 24px; padding-left: 30px; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\"><li style=\"box-sizing: inherit; list-style-type: initial;\">JS框架：jQuery</li><li style=\"box-sizing: inherit; list-style-type: initial;\">客户端验证：JQuery Validation</li><li style=\"box-sizing: inherit; list-style-type: initial;\">富文本在线编辑：summernote</li><li style=\"box-sizing: inherit; list-style-type: initial;\">在线文件管理：CKFinder</li><li style=\"box-sizing: inherit; list-style-type: initial;\">数据表格：bootstrapTable</li><li style=\"box-sizing: inherit; list-style-type: initial;\">弹出层：layer</li><li style=\"box-sizing: inherit; list-style-type: initial;\">树结构控件：jsTree</li></ul><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">4、平台</p><ul class=\"task-list\" style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 24px; padding-left: 30px; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\"><li style=\"box-sizing: inherit; list-style-type: initial;\">服务器中间件：SpringBoot内置</li><li style=\"box-sizing: inherit; list-style-type: initial;\">数据库支持：目前仅提供MySql数据库的支持，但不限于数据库，平台留有其它数据库支持接口， 你可以很方便的更改为其它数据库，如：SqlServer 2008、MySql 5.5、H2等</li><li style=\"box-sizing: inherit; list-style-type: initial;\">开发环境：Java、Eclipse Java EE 、Maven 、Git</li></ul><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"安全考虑\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E5%AE%89%E5%85%A8%E8%80%83%E8%99%91\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>安全考虑</h2><ol class=\"task-list\" style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 24px; padding-left: 30px; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\"><li style=\"box-sizing: inherit; list-style-type: decimal;\">开发语言：系统采用Java 语言开发，具有卓越的通用性、高效性、平台移植性和安全性。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">分层设计：（数据库层，数据访问层，业务逻辑层，展示层）层次清楚，低耦合，各层必须通过接口才能接入并进行参数校验（如：在展示层不可直接操作数据库），保证数据操作的安全。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">双重验证：用户表单提交双验证：包括服务器端验证及客户端验证，防止用户通过浏览器恶意修改（如不可写文本域、隐藏变量篡改、上传非法文件等），跳过客户端验证操作数据库。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">安全编码：用户表单提交所有数据，在服务器端都进行安全编码，防止用户提交非法脚本及SQL注入获取敏感数据等，确保数据安全。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">密码加密：登录用户密码进行SHA1散列加密，此加密方法是不可逆的。保证密文泄露后的安全问题。</li><li style=\"box-sizing: inherit; list-style-type: decimal;\">强制访问：系统对所有管理端链接都进行用户身份权限验证，防止用户直接填写url进行访问。</li></ol><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"演示地址\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E6%BC%94%E7%A4%BA%E5%9C%B0%E5%9D%80\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>演示地址</h2><h6 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; color: rgb(119, 119, 119); margin-top: 20px; font-size: 14px; -webkit-font-smoothing: antialiased; cursor: text; position: relative;\"><a id=\"布嘟开源wwwbootdocom\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E5%B8%83%E5%98%9F%E5%BC%80%E6%BA%90wwwbootdocom\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>布嘟开源<a href=\"http://www.bootdo.com./blog\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word;\">www.bootdo.com</a></h6><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"交流反馈\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E4%BA%A4%E6%B5%81%E5%8F%8D%E9%A6%88\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>交流反馈</h2><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"qq群-669039323\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#qq%E7%BE%A4-669039323\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>QQ群 669039323</h2><h2 style=\"box-sizing: inherit; font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-weight: bold; line-height: 1.33em; color: rgb(0, 0, 0); margin-top: 20px; font-size: 24px; padding-bottom: 0.3em; -webkit-font-smoothing: antialiased; cursor: text; position: relative; border-bottom: 1px solid rgb(204, 204, 204);\"><a id=\"版权声明\" class=\"anchor\" href=\"https://gitee.com/lcg0124/bootdo#%E7%89%88%E6%9D%83%E5%A3%B0%E6%98%8E\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word; display: block; padding-left: 30px; margin-left: -20px; position: absolute; top: 0px; left: 0px; bottom: 0px; outline: none;\"></a>版权声明</h2><p style=\"box-sizing: inherit; margin-bottom: 15px; line-height: 25px; word-break: break-word; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px;\">本软件使用&nbsp;<a href=\"http://www.apache.org/licenses/LICENSE-2.0\" style=\"box-sizing: inherit; color: rgb(9, 94, 171); word-wrap: break-word;\">Apache License 2.0</a>&nbsp;协议，请严格遵照协议内容</p><ul class=\"task-list\" style=\"box-sizing: inherit; line-height: 24px; padding-left: 30px; color: rgb(64, 72, 91); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Helvetica, Arial, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Liberation Sans&quot;, &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, &quot;Hiragino Sans GB&quot;, &quot;Wenquanyi Micro Hei&quot;, &quot;WenQuanYi Zen Hei&quot;, &quot;ST Heiti&quot;, SimHei, &quot;WenQuanYi Zen Hei Sharp&quot;, sans-serif; font-size: 15px; margin-bottom: 0px !important;\"><li class=\"task-list-item\" style=\"box-sizing: inherit; list-style-type: initial;\"><input type=\"checkbox\" class=\"task-list-item-checkbox\" checked=\"\" disabled=\"\" style=\"margin-top: 0px; cursor: default; transition: border 0.2s linear, box-shadow 0.2s linear; box-shadow: rgba(0, 0, 0, 0.1) 0px 1px 3px inset; vertical-align: middle;\">&nbsp;注：已上内容为整体规化，部分功能还在实现中</li></ul>', null, null, 'about', null, null, '1', null, '0', '1', 'bootdo', '2017-09-30 14:43:09', '2017-09-30 14:43:09');
INSERT INTO `blog_content` VALUES ('117', '页面加载速度优化建议', null, null, null, '<p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">1、合并Js文件和CSS</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">将JS代码和CSS样式分别合并到一个共享的文件，这样不仅能简化代码，而且在执行JS文件的时候，如果JS文件比较多，就需要进行多次“Get”请求，延长加载速度，将JS文件合并在一起后，自然就减少了Get请求次数，提高了加载速度。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">2、Sprites图片技术</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">Spriting是一种网页图片应用处理方式，它是将一个页面涉及到的所有零星图片都包含到一张大图中去，然后利用CSS技术展现出来。这样一来，当访问该页面时，载入的图片就不会像以前那样一幅一幅地慢慢显示出来了，可以减少了整个网页的图片大小，并且利用CSSSprites能很好地减少网页的http请求，从而大大的提高页面的性能。CSSSprites在国内很多人叫css精灵，很早就有了，在很多大型网站都有用到，特别是一些所有页面都存在的图标用得比较多，很好的提升加载速度。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">3、压缩文本和图片</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">压缩技术如gzip可以有效减少页面加载的时间。包括HTML，XML，JSON(JavaScript对象符号)，JavaScript和CSS等，压缩率都可以在大小70%左右。文本压缩用得比较多，一般直接在空间开启就行，而图片的压缩就比较随意，很多都是直接上传，其实还有很大的压缩空间。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">4、延迟显示可见区域外的内容</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">为了确保用户可以更快地看见可见区域的网页可以延迟加载或展现可见区域外的内容，为了避免页面变形，可以使用占位符标签制定正确的高度和宽度。比如WP的jQueryImage LazyLoad插件就可以在用户停留在第一屏的时候，不加载任何第一屏以下的图片信息，只有当用户把鼠标往下滚动的时候，这些图片才开始加载。这样很明显提升可见区域的加载速度，提高用户体验。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">5、确保功能图片优先加载</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">网站主要考虑可用性的重要性，一个功能按钮要提前加载出来，用户进入下载页，一个只需要8s时间的下载花了5s在等待、寻找下载按钮图片，谁能忍受?</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">6、重新布置Call-to-Action按钮</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">其实这个和上面一条是差不多的，都是从用户体验速度着手，跳过了网页的整体加载速度。速度没变，只是让一些行为按钮提前，Call-to-Action按钮一般习惯设计在页面底部，这样的习惯对于用户来说并不总是好的，购买用户需要等到最下面加载出来才能点击下一步操作。可以调整CTA按钮的位置或使用滑动的图片按钮。很多大型购物网站的加入购物车就是这种类型。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">7、图片格式优化</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">不恰当的图像格式是一种极为常见的减慢加载速度的罪魁祸首。正确的图片格式可以让图片缩小数倍，如果保存为最佳格式。可以节省大量带宽，减少处理时间时间，大大加快页面加载速度，这是一种很常见的做法。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">8、使用 Progressive JPEGs</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">ProgressiveJPEGs图片是JPEG格式的一个特殊变种，名为“高级JPEG”。在创建高级JPEG文件时，数据是这样安排的：在装入图像时，开始只显示一个模糊的图像，随着数据的装入，图像逐步变得清晰。它相当于交织的GIF格式的图片。高级JPEG主要是考虑到使用调制解调器的慢速网络而设计的，快速网络的使用者通常不会体会到它和正常JPEG格式图片的区别。对于网速比较慢的用户，这无疑有很好的体验。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">9、精简代码</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">这个可以说是最直接的一个方法，也是用得比较多的，对网页代码进行瘦身，删除不必要的沉冗代码，比如不必要的空格、换行符、注释等，包括JS代码中的无用代码也需要清除。其中对于注释代码的清除可能有些人存在误区，甚至有的在里面堆砌关键词。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">10、延迟加载和执行非必要脚本</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">网页中有很多脚本是在页面完全加载完前都不需要执行的，可以延迟加载和执行非必要脚本。这些脚本可以在onload事件之后执行，避免对网页上重要内容的呈现造成影响。这些脚本可能是你自己网页的甲苯，往往更多的是一些第三方脚本，这样的有很多，比如评论、广告、智能推荐、百度云图、分享等等，这些完全可以等主体内容加载完后再执行。</p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\"><span style=\"font-weight: 700;\">11、使用AJAX</span></p><p style=\"margin-bottom: 24px; color: rgb(14, 14, 14); font-family: Arial, &quot;Hiragino Sans GB&quot;, 冬青黑, &quot;Microsoft YaHei&quot;, 微软雅黑, SimSun, 宋体, Helvetica, Tahoma, &quot;Arial sans-serif&quot;; font-size: 16px; text-align: justify;\">AJAX即“Asynchronous Javascript +XML“，是指一种创建交互式网页应用的网页开发技术。通过在后台与服务器进行少量数据交换，AJAX可以使网页实现异步更新。这意味着可以在不重新加载整个网页的情况下，对网页的某部分进行更新。传统的网页(不使用AJAX)如果需要更新内容，必须重载整个网页面。</p>', null, null, '', null, null, '1', null, '0', '1', 'bootdo', '2017-09-30 16:13:35', '2017-09-30 16:13:35');
INSERT INTO `blog_content` VALUES ('118', 'elementUI select组件使用详解', null, null, null, '<article style=\"padding: 20px 0px; border-top: 1px solid rgb(228, 235, 244); border-left: 1px solid rgb(228, 235, 244); border-right: 1px solid rgb(228, 235, 244); color: rgb(51, 51, 51); font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun; font-size: 16px;\"><div id=\"article_content\" class=\"article_content csdn-tracking-statistics\" data-mod=\"popu_307\" data-dsm=\"post\" style=\"margin: 0px 0px 50px; padding: 20px 30px 0px; color: rgb(69, 69, 69); overflow: hidden;\"><div class=\"markdown_views\" style=\"margin: 0px; padding: 0px; font-family: &quot;microsoft yahei&quot;; font-size: 15px; color: rgb(63, 63, 63);\"><h1 id=\"elementui-select组件使用详解\" style=\"margin-top: 0.8em; margin-bottom: 0.8em; font-size: 2.6em; font-family: inherit; padding: 0px;\">elementUI select组件使用详解</h1><ul style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 0px; list-style-position: initial; list-style-image: initial;\"><li style=\"margin: 0px 0px 0px 40px; padding: 0px; list-style: disc;\"><strong>动态生成option选项</strong></li><li style=\"margin: 0px 0px 0px 40px; padding: 0px; list-style: disc;\"><strong>option选项绑定对应的文本值和value值</strong></li><li style=\"margin: 0px 0px 0px 40px; padding: 0px; list-style: disc;\"><strong>作为表单项目，新增、编辑功能</strong></li><li style=\"margin: 0px 0px 0px 40px; padding: 0px; list-style: disc;\"><strong>对选项改变后触发相关事件</strong></li></ul><pre class=\"prettyprint\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; font-size: 14px; white-space: nowrap; padding: 5px 5px 5px 60px; margin-bottom: 1.1em; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-color: rgba(128, 128, 128, 0.075); border-radius: 0px; position: relative; overflow-y: hidden;\"><code class=\"hljs lasso has-numbering\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; display: block; word-wrap: normal;\"><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>div id<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"app\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n    <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-form</span> :model<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"form\"</span>  ref<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"form\"</span> label<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-width</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"100px\"</span> class<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"demo-ruleForm\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n        <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-form</span><span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-item</span> label<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"姓名选择\"</span> prop<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"typeId\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n            <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-select</span> v<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-model</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"form.typeId\"</span> placeholder<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"请选择\"</span> @change<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"change\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n                <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-option</span> v<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-for</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"item in items\"</span> :label<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"item.name\"</span> :value<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"item.id\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-option</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n            <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-select</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n        <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-form</span><span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-item</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n        <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-form</span><span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-item</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n            <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-button</span> <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">type</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"primary\"</span> @click<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"add()\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>新增<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-button</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n            <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-button</span> <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">type</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"primary\"</span> @click<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"edit()\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>编辑<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-button</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n            <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-button</span> @click<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">=</span><span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"cancel()\"</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>取消<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-button</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n        <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-form</span><span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-item</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n    <span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/el<span class=\"hljs-attribute\" style=\"margin: 0px; padding: 0px;\">-form</span><span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span>\r\n<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&lt;</span>/div<span class=\"hljs-subst\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 0);\">&gt;</span></code><ul class=\"pre-numbering\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; list-style: none; position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; border-right: 1px solid rgb(221, 221, 221); text-align: right;\"><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">1</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">2</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">3</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">4</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">5</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">6</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">7</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">8</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">9</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">10</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">11</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">12</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">13</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">14</li></ul></pre><pre class=\"prettyprint\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; font-size: 14px; white-space: nowrap; padding: 5px 5px 5px 60px; margin-bottom: 1.1em; line-height: 1.45; background-color: rgba(128, 128, 128, 0.05); border-color: rgba(128, 128, 128, 0.075); border-radius: 0px; position: relative; overflow-y: hidden;\"><code class=\"hljs xml has-numbering\" style=\"font-family: &quot;Source Code Pro&quot;, monospace; white-space: pre; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; display: block; word-wrap: normal;\"><span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">script</span>&gt;</span><span class=\"javascript\" style=\"margin: 0px; padding: 0px;\">\r\n    <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">var</span> vm = <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">new</span> Vue({\r\n        el:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"#app\"</span>,\r\n        mounted(){\r\n            <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.getData();\r\n        },\r\n        data:{\r\n            form:{\r\n                typeId:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\'\'</span>\r\n            },\r\n            items:[],\r\n            datas:[{name:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"senbo\"</span>,id:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\'1\'</span>},{name:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"muse\"</span>,id:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\'2\'</span>},{name:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"bobo\"</span>,id:<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\'3\'</span>}]\r\n        },\r\n        methods:{\r\n            getData:<span class=\"hljs-function\" style=\"margin: 0px; padding: 0px;\"><span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">function</span><span class=\"hljs-params\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">()</span>{</span>\r\n                <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.items = <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.datas; \r\n\r\n            },\r\n            add:<span class=\"hljs-function\" style=\"margin: 0px; padding: 0px;\"><span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">function</span><span class=\"hljs-params\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">()</span>{</span>\r\n                <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.form.typeId = <span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"\"</span>;\r\n            },\r\n            cancel(){\r\n                 <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.form.typeId = <span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"\"</span>;   \r\n            },\r\n            change:<span class=\"hljs-function\" style=\"margin: 0px; padding: 0px;\"><span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">function</span><span class=\"hljs-params\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">()</span>{</span>\r\n                console.log(<span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.form.typeId)\r\n            },\r\n            edit:<span class=\"hljs-function\" style=\"margin: 0px; padding: 0px;\"><span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">function</span><span class=\"hljs-params\" style=\"margin: 0px; padding: 0px; color: rgb(102, 0, 102);\">()</span>{</span>\r\n                <span class=\"hljs-keyword\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">this</span>.form.typeId =<span class=\"hljs-string\" style=\"margin: 0px; padding: 0px; color: rgb(0, 136, 0);\">\"1\"</span>;\r\n            }\r\n        }\r\n    })\r\n</span><span class=\"hljs-tag\" style=\"margin: 0px; padding: 0px; color: rgb(0, 102, 102);\">&lt;/<span class=\"hljs-title\" style=\"margin: 0px; padding: 0px; color: rgb(0, 0, 136);\">script</span>&gt;</span></code><ul class=\"pre-numbering\" style=\"margin-right: 0px; margin-bottom: 0px; margin-left: 0px; padding: 6px 0px 40px; list-style: none; position: absolute; width: 50px; background-color: rgb(238, 238, 238); top: 0px; left: 0px; border-right: 1px solid rgb(221, 221, 221); text-align: right;\"><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">1</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">2</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">3</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">4</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">5</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">6</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">7</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">8</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">9</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">10</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">11</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">12</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">13</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">14</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">15</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">16</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">17</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">18</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">19</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">20</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">21</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">22</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">23</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">24</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">25</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">26</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">27</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">28</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">29</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">30</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">31</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">32</li><li style=\"margin: 0px; padding: 0px 5px; list-style: none; color: rgb(153, 153, 153);\">33</li></ul></pre></div></div></article><div class=\"article_copyright\" style=\"margin: 0px 0px -20px; padding: 0px 20px 30px; border-bottom: 1px solid rgb(228, 235, 244); border-left: 1px solid rgb(228, 235, 244); border-right: 1px solid rgb(228, 235, 244); font-size: 14px; color: rgb(120, 128, 135); clear: both; overflow: hidden; font-family: &quot;PingFang SC&quot;, &quot;Microsoft YaHei&quot;, SimHei, Arial, SimSun;\">转自http://blog.csdn.net/museions/article/details/77824361</div>', 'article', null, '', null, null, '1', null, '0', '1', 'bootdo', '2017-10-12 10:41:07', '2017-10-12 10:41:07');
INSERT INTO `blog_content` VALUES ('119', 'Java程序员秋招面经大合集（BAT美团网易小米华为中兴等）', null, null, null, '<h1 class=\"title\" style=\"font-size: 34px; margin-top: 20px; margin-bottom: 0px; font-family: -apple-system, &quot;SF UI Display&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-weight: 700; line-height: 1.3; color: rgb(51, 51, 51); word-break: break-word !important;\">Java程序员秋招面经大合集（BAT美团网易小米华为中兴等）</h1><div data-note-content=\"\" class=\"show-content\" style=\"color: rgb(47, 47, 47); font-size: 16px; line-height: 1.7; font-family: -apple-system, &quot;SF UI Text&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; word-break: break-word !important;\"><blockquote style=\"padding-top: 20px; padding-bottom: 20px; margin-bottom: 25px; font-size: 16px; border-left-width: 6px; border-left-color: rgb(180, 180, 180); background-color: rgb(247, 247, 247); line-height: 30px; word-break: break-word !important;\"><ul style=\"padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">Cvte提前批</li><li style=\"line-height: 30px; margin-bottom: 10px;\">阿里内推</li><li style=\"line-height: 30px; margin-bottom: 10px;\">便利蜂内推</li><li style=\"line-height: 30px; margin-bottom: 10px;\">小米内推</li><li style=\"line-height: 30px; margin-bottom: 10px;\">金山wps内推</li><li style=\"line-height: 30px; margin-bottom: 10px;\">多益网络</li><li style=\"line-height: 30px; margin-bottom: 10px;\">拼多多学霸批</li><li style=\"line-height: 30px; margin-bottom: 10px;\">搜狗校招</li><li style=\"line-height: 30px; margin-bottom: 10px;\">涂鸦移动</li><li style=\"line-height: 30px; margin-bottom: 10px;\">中国电信it研发中心</li><li style=\"line-height: 30px; margin-bottom: 10px;\">中兴</li><li style=\"line-height: 30px; margin-bottom: 10px;\">华为</li><li style=\"line-height: 30px; margin-bottom: 10px;\">苏宁内推</li><li style=\"line-height: 30px; margin-bottom: 10px;\">美团内推</li><li style=\"line-height: 30px; margin-bottom: 10px;\">百度</li><li style=\"line-height: 30px; margin-bottom: 10px;\">腾讯</li><li style=\"line-height: 30px; margin-bottom: 10px;\">招商银行信用卡</li><li style=\"line-height: 30px; margin-bottom: 10px;\">招银网络科技</li><li style=\"line-height: 30px; margin-bottom: 10px;\">网易</li><li style=\"line-height: 30px; margin-bottom: 0px;\">Vivo</li></ul></blockquote><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">Cvte提前批</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍你的项目</li><li style=\"line-height: 30px; margin-bottom: 10px;\">加密解密了解么？几种算法，讲一下你了解的</li><li style=\"line-height: 30px; margin-bottom: 10px;\">多线程了解么？什么是线程安全？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">说一个你最熟悉的设计模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲一下你项目中用到了哪些设计模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java的hashmap的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap的线程安全性，什么是线程安全的？如何实现线程安全</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（视频）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍项目</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Mysql的数据库引擎，区别特点</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计模式了解？讲一下最熟悉的</li><li style=\"line-height: 30px; margin-bottom: 10px;\">写一个单例模式，答主写的是双检查锁单例，问了为什么用Volatile，synchronize移到方法最外面会怎么样？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">单例模式在你项目里哪些应用？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据连接池</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对高负载有了解么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你意向的技术方向是哪块？（答主回答的高并发，然后面试官说他是做高负载的）</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对高并发有了解么？</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">阿里内推</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">听说你有博客，博客里大概有什么内容？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍，最复杂的表</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap为什么大小是2的幂次</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍一下红黑树</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Arraylist的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">场景题：设计判断论文抄袭的系统</li><li style=\"line-height: 30px; margin-bottom: 10px;\">堆排序的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">抽象工厂和工厂方法模式的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">工厂模式的思想</li><li style=\"line-height: 30px; margin-bottom: 10px;\">object类你知道的方法</li><li style=\"line-height: 30px; margin-bottom: 10px;\">哪里用到了工厂模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Forward和redirect的区别</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（视频）</h2><p style=\"margin-bottom: 25px; word-break: break-word !important;\">1， 自我介绍<br>2， 项目介绍<br>3， 项目架构<br>4， 项目难点<br>5， Synchronize关键字为什么jdk1.5后效率提高了<br>6， 线程池的使用时的注意事项<br>7， Spring中autowire和resourse关键字的区别<br>8， Hashmap的原理<br>9， Hashmap的大小为什么指定为2的幂次<br>10， 讲一下线程状态转移图<br>11， 消息队列了解么<br>12， 分布式了解么</p><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">便利蜂内推</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">volatile和synchronized</li><li style=\"line-height: 30px; margin-bottom: 10px;\">来个算法题：一个无序数组，其中一个数字出现的次数大于其他数字之和，求这个数字 （主元素）</li><li style=\"line-height: 30px; margin-bottom: 10px;\">答完再来一个：一个数组，有正有负，不改变顺序的情况下，求和最大的最长子序列</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目用到什么数据库？隔离级别？每个隔离级别各做了什么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的索引？mysql不同引擎索引的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">垃圾回收算法的过程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你了解的垃圾收集器？ Cms收集器的过程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎样进入老年代？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">平时用到了什么设计模式？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲一下你最熟的两个设计模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">用过什么系统？shell写过脚本吗？</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">小米内推</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">看你最近博客写的是redis，介绍redis和mysql的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的应用场景</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap中jdk1.8之后做了哪些优化</li><li style=\"line-height: 30px; margin-bottom: 10px;\">垃圾回收的过程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Jvm的参数设置</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目中的优化</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">金山wps内推</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对Java的面向对象的理解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对java多线程的理解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的索引</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的隔离级别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计模式的理解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲几个设计模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对算法有什么了解？答主先回答了动态规划，解释了一下dp的思想</li><li style=\"line-height: 30px; margin-bottom: 10px;\">快排的思想讲一下</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Tcp怎么保证可靠传输（中间穿插了好多小问题）</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Tcp的拥塞控制</li><li style=\"line-height: 30px; margin-bottom: 10px;\">让你设计一个即时聊天的系统</li><li style=\"line-height: 30px; margin-bottom: 10px;\">支付宝转账，是如何实现，几个小时通知转账成功的（面试官想让回答长连接，答主一直没get到点）</li><li style=\"line-height: 30px; margin-bottom: 10px;\">解释一下长连接</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">多益网络</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（视频）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对面向对象的理解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍多态</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java新建线程有哪几种方式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">线程池的作用</li><li style=\"line-height: 30px; margin-bottom: 10px;\">看过框架源码么</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">拼多多学霸批</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场面）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：一棵二叉排序树，给定一个数，找到与给定数差值最小的数</li><li style=\"line-height: 30px; margin-bottom: 10px;\">场景题：设计一个系统，解决抢购时所需要的大量的短链接的功能，如何保证高并发，如何设计短链接</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（现场面）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">代码量多少</li><li style=\"line-height: 30px; margin-bottom: 10px;\">给了一张纸，各种名词，会的写出来</li><li style=\"line-height: 30px; margin-bottom: 10px;\">然后给它解释那些会的</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计题：设计一个系统，记录qq用户前一天的登录状态，提供16g内存和2tb的硬盘，要做到查询指定qq号的前一天的登录状态，快速查询O(1)复杂度</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">搜狗校招</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）：</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：两个排序的数组A和B分别含有m和n个数，找到两个排序数组的中位数，答主用的二分，时间复杂度为O(log (m+n))。结果面试官不满意，让用归并的思想做，时间复杂度其实更高了</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍网络编程</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">涂鸦移动</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的索引原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">索引使用的注意事项</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的引擎</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java垃圾回收机制</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java的finalize，finally，final三个关键字的区别和应用场景</li><li style=\"line-height: 30px; margin-bottom: 10px;\">String类可以被继承么<br>手撕算法：假设你是一个专业的窃贼，准备沿着一条街打劫房屋。每个房子都存放着特定金额的钱。你面临的唯一约束条件是：相邻的房子装着相互联系的防盗系统，且 当相邻的两个房子同一天被打劫时，该系统会自动报警。<br>给定一个非负整数列表，表示每个房子中存放的钱， 算一算，如果今晚去打劫，你最多可以得到多少钱 在不触动报警装置的情况下。</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">对游戏的了解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">算法题：给一个整数数组，找到两个数使得他们的和等于一个给定的数 target。</li><li style=\"line-height: 30px; margin-bottom: 10px;\">红黑树</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的应用</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">中国电信it研发中心</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目里用的什么服务器</li><li style=\"line-height: 30px; margin-bottom: 10px;\">自己写一个tomcat服务器，你会怎么写</li><li style=\"line-height: 30px; margin-bottom: 10px;\">分布式服务器会出现哪些问题</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么解决session一致性缓存的问题</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的优势和特点</li><li style=\"line-height: 30px; margin-bottom: 10px;\">一千万用户并发抢购，怎么设计</li><li style=\"line-height: 30px; margin-bottom: 10px;\">如果成功的用户有10万，redis存不下怎么处理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你项目中的难点</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍spring中的熟悉的注解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">让你实现autowire注解的功能你会如何实现</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis和mysql的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的持久化有哪些方式，具体原理</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">中兴</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">专业面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你了解的设计模式，讲两个</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java collection类，集合，讲两个你了解的，说实现原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java线程池的作用</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你觉得你在你实验室处于什么水平</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">综合面试（现场）</h2><p style=\"margin-bottom: 25px; word-break: break-word !important;\">说好的综合面试纯聊天呢？<br>1． 自我介绍<br>2． 项目介绍<br>3． 说一下你知道的设计模式<br>4． 画一个策略模式的uml图<br>5． Java多线程的理解<br>6． 内存屏障是什么<br>7． 数据库索引<br>8． 项目中的优化<br>9． 然后开始聊人生<br>10． 你的缺点，你最不喜欢什么样的人，你的家庭等等</p><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">华为</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目架构</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目一个完整的执行流程（由于我是搞java的，而面试官是搞c的，所以全程尬聊）</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目优化</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么管理项目进度</li><li style=\"line-height: 30px; margin-bottom: 10px;\">平常的爱好</li><li style=\"line-height: 30px; margin-bottom: 10px;\">感觉面试官也不是搞java的，所以又是一阵尬聊</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">苏宁内推</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">面过哪些公司了</li><li style=\"line-height: 30px; margin-bottom: 10px;\">有哪些offer了</li><li style=\"line-height: 30px; margin-bottom: 10px;\">聊到多益，于是开始聊最近微博上很火的多益老板</li><li style=\"line-height: 30px; margin-bottom: 10px;\">得出结论，我和面试官都觉得多益老板三观有问题，但做游戏就是要偏执的人</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你博客主要哪方面的</li><li style=\"line-height: 30px; margin-bottom: 10px;\">多线程并发包了解么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲一下countDownLatch</li></ol><p style=\"margin-bottom: 25px; word-break: break-word !important;\">苏宁聊了20分钟八卦就面完了，一轮技术面</p><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">美团内推</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（电话）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">了解redis源码么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">了解redis集群么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">hashmap容量为什么是2的幂次</li><li style=\"line-height: 30px; margin-bottom: 10px;\">hashset的源码</li><li style=\"line-height: 30px; margin-bottom: 10px;\">object类你知道的方法</li><li style=\"line-height: 30px; margin-bottom: 10px;\">hashcode和equals</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你重写过hashcode和equals么，要注意什么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">假设现在一个学生类，有学号和姓名，我现在hashcode方法重写的时候，只将学号参与计算，会出现什么情况？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">往set里面put一个学生对象，然后将这个学生对象的学号改了，再put进去，可以放进set么？并讲出为什么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的持久化？有哪些方式，原理是什么？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲一下稳定的排序算法和不稳定的排序算法</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲一下快速排序的思想</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲一下数据的acid</li><li style=\"line-height: 30px; margin-bottom: 10px;\">什么是一致性</li><li style=\"line-height: 30px; margin-bottom: 10px;\">什么是隔离性</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Mysql的隔离级别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">每个隔离级别是如何解决</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Mysql要加上nextkey锁，语句该怎么写</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java的内存模型，垃圾回收</li><li style=\"line-height: 30px; margin-bottom: 10px;\">线程池的参数</li><li style=\"line-height: 30px; margin-bottom: 10px;\">每个参数解释一遍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">然后面试官设置了每个参数，给了是个线程，让描述出完整的线程池执行的流程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Nio和IO有什么区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Nio和aio的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Spring的aop怎么实现</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Spring的aop有哪些实现方式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">动态代理的实现方式和区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Linux了解么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么查看系统负载</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Cpu load的参数如果为4，描述一下现在系统处于什么情况</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Linux，查找磁盘上最大的文件的命令</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Linux，如何查看系统日志文件</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：leeetcode原题 22，Generate Parentheses，给定 n 对括号，请写一个函数以将其生成新的括号组合，并返回所有组合结果。</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">三面（现场）</h2><p style=\"margin-bottom: 25px; word-break: break-word !important;\">三面没怎么问技术，问了很多技术管理方面的问题</p><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么管理项目成员</li><li style=\"line-height: 30px; margin-bottom: 10px;\">当意见不一致时，如何沟通并说服开发成员，并举个例子</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么保证项目的进度</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的索引原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">非聚簇索引和聚簇索引</li><li style=\"line-height: 30px; margin-bottom: 10px;\">索引的使用注意事项</li><li style=\"line-height: 30px; margin-bottom: 10px;\">联合索引</li><li style=\"line-height: 30px; margin-bottom: 10px;\">从底层解释最左匹配原则</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Mysql对联合索引有优化么？会自动调整顺序么？哪个版本开始优化？</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的应用</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的持久化的方式和原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">技术选型，一个新技术和一个稳定的旧技术，你会怎么选择，选择的考虑有哪些</li><li style=\"line-height: 30px; margin-bottom: 10px;\">说你印象最深的美团点评技术团队的三篇博客</li><li style=\"line-height: 30px; margin-bottom: 10px;\">最近在学什么新技术</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你是怎么去接触一门新技术的</li><li style=\"line-height: 30px; margin-bottom: 10px;\">会看哪些书</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么选择要看的书</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">百度</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java中的多态</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Object类下的方法</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Finalize的作用和使用场景</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashcode和equals</li><li style=\"line-height: 30px; margin-bottom: 10px;\">为什么要同时重写hashcode和equals</li><li style=\"line-height: 30px; margin-bottom: 10px;\">不同时重写会出现哪些问题</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hashmap如何变线程安全，每种方式的优缺点</li><li style=\"line-height: 30px; margin-bottom: 10px;\">垃圾回收机制</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Jvm的参数你知道的说一下</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计模式了解的说一下啊</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕一个单例模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">快速排序的思想讲一下</li><li style=\"line-height: 30px; margin-bottom: 10px;\">给个数组，模拟快排的过程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手写快排</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计题，一个图书馆管理系统，数据库怎么设计，需求自己定</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis的特点</li><li style=\"line-height: 30px; margin-bottom: 10px;\">分布式事务了解么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">反爬虫的机制，有哪些方式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：反转单链表</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：实现类似微博子结构的数据结构，输入一系列父子关系，输出一个类似微博评论的父子结构图</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手写java多线程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手写java的soeket编程，服务端和客户端</li><li style=\"line-height: 30px; margin-bottom: 10px;\">进程间的通信方式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法： 爬楼梯，写出状态转移方程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">智力题：时针分针什么时候重合</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">三面（现场）</h2><p style=\"margin-bottom: 25px; word-break: break-word !important;\">由于三面面试官不懂java，我不熟c加加，所以全程尬聊</p><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：给定一个数字三角形，找到从顶部到底部的最小路径和。每一步可以移动到下面一行的相邻数字上。</li><li style=\"line-height: 30px; margin-bottom: 10px;\"></li><li style=\"line-height: 30px; margin-bottom: 10px;\">然后继续在这个问题上扩展</li><li style=\"line-height: 30px; margin-bottom: 10px;\">求出最短那条的路径</li><li style=\"line-height: 30px; margin-bottom: 10px;\">递归求出所有的路径</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计模式讲一下熟悉的</li><li style=\"line-height: 30px; margin-bottom: 10px;\">会不会滥用设计模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">多线程条件变量为什么要在while体里</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你遇到什么挫折</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">腾讯</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hibernate的作用，你的理解</li><li style=\"line-height: 30px; margin-bottom: 10px;\">多线程的理解，如何保证线程安全</li><li style=\"line-height: 30px; margin-bottom: 10px;\">mysql数据库的引擎和区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">场景题：千万用户抢购，如何处理高并发，并且有一个链接，指向前一天抢购成功的用户，如何设计这个系统和数据库</li><li style=\"line-height: 30px; margin-bottom: 10px;\">如果后台处理抢购请求的服务器，每次最多承受200的负载，系统该怎么设计</li><li style=\"line-height: 30px; margin-bottom: 10px;\">手撕算法：最小公倍数和最大公约数</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目里一个完整请求的流程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目的优化</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hibernate和mybatis的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">为什么用ssh框架</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Mysql的容灾备份</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Redis和memcache 的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">为什么选择redis</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Java的full gc</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Full gc会导致什么问题</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">招商银行信用卡</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">分布式事务</li><li style=\"line-height: 30px; margin-bottom: 10px;\">设计模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">访问者模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">装饰者模式</li><li style=\"line-height: 30px; margin-bottom: 10px;\">有哪些offer</li><li style=\"line-height: 30px; margin-bottom: 10px;\">为什么还来我们这</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">招银网络科技</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">写一个两个有序链表合并成一个有序链表</li><li style=\"line-height: 30px; margin-bottom: 10px;\">死锁是什么呢</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么解决死锁</li><li style=\"line-height: 30px; margin-bottom: 10px;\">http请求流程</li><li style=\"line-height: 30px; margin-bottom: 10px;\">为什么负载均衡</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么实现负载均衡</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库挂了怎么办？除了热备份还有什么方法</li><li style=\"line-height: 30px; margin-bottom: 10px;\">讲讲你对spring的理解，不要把ioc和aop背给我听</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">算法：找出两个数组相等的数，不能用其他数据结构</li><li style=\"line-height: 30px; margin-bottom: 10px;\">算法：给定一个数字，一个数组，找出数组中相加等于这两个数的和，不能用数据结构</li><li style=\"line-height: 30px; margin-bottom: 10px;\">算法：如何判断一个树是不是另一颗树的子树</li><li style=\"line-height: 30px; margin-bottom: 10px;\">如何解决并发访问的错误</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">网易</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面（现场）</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">I++操作怎么保证线程安全</li><li style=\"line-height: 30px; margin-bottom: 10px;\">场景题：设计一个下单系统，下单成功后可以给用户发优惠券</li><li style=\"line-height: 30px; margin-bottom: 10px;\">接上面场景题：服务器挂了，优惠券还没发怎么办</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库挂了怎么怎么办</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么保证一致性</li><li style=\"line-height: 30px; margin-bottom: 10px;\">分布式事务知道么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">介绍分布式事务</li><li style=\"line-height: 30px; margin-bottom: 10px;\">你的职业规划</li></ol><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">二面</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Nio的原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Channel和buffer</li><li style=\"line-height: 30px; margin-bottom: 10px;\">directBuffer和buffer的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">nio和aio的区别</li><li style=\"line-height: 30px; margin-bottom: 10px;\">锁的实现原理</li><li style=\"line-height: 30px; margin-bottom: 10px;\">怎么解决缓存和主存的一致性问题</li><li style=\"line-height: 30px; margin-bottom: 10px;\">缓存还没更新到主存，服务器挂了怎么办</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库挂了怎么办</li></ol><h1 style=\"font-size: 26px; margin-top: 0px; margin-bottom: 15px; font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); text-rendering: optimizeLegibility;\">Vivo</h1><h2 style=\"font-family: inherit; font-weight: 700; line-height: 1.7; color: rgb(47, 47, 47); margin: 0px 0px 15px; font-size: 24px; text-rendering: optimizeLegibility;\">一面</h2><ol style=\"margin-bottom: 20px; padding: 0px; margin-left: 22px; word-break: break-word !important;\"><li style=\"line-height: 30px; margin-bottom: 10px;\">自我介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">项目介绍</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Hibernate的batch有数量限制么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Jquery用过么</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Extjs的优缺点</li><li style=\"line-height: 30px; margin-bottom: 10px;\">有没有扩展过extjs</li><li style=\"line-height: 30px; margin-bottom: 10px;\">读写锁</li><li style=\"line-height: 30px; margin-bottom: 10px;\">什么时候用读锁</li><li style=\"line-height: 30px; margin-bottom: 10px;\">什么时候用写锁</li><li style=\"line-height: 30px; margin-bottom: 10px;\">Cas的原理，使用场景</li><li style=\"line-height: 30px; margin-bottom: 10px;\">数据库的瓶颈</li></ol><div><br></div><div><br></div><div>转自<a href=\"http://www.jianshu.com//p/72712546648b\" target=\"_blank\">http://www.jianshu.com//p/72712546648b</a></div></div>', 'article', null, '', null, null, '1', null, '0', '1', 'Bootdo', '2017-10-13 13:45:20', '2017-10-13 13:45:20');
INSERT INTO `blog_content` VALUES ('121', 'Spring Cloud下微服务权限方案', null, null, null, '<p><br></p><div class=\"Layout-navbarHolder\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; height: 59px; color: rgb(51, 51, 51); font-family: -apple-system, &quot;Helvetica Neue&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: medium;\"><header class=\"Navbar ScrollBackFixed\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: horizontal; -webkit-box-direction: normal; flex-direction: row; -webkit-box-align: center; align-items: center; flex-shrink: 0; contain: layout; -webkit-box-pack: justify; justify-content: space-between; height: 59px; width: 1519.2px; border-bottom: 1px solid rgba(0, 0, 0, 0.08); color: rgb(128, 128, 128); background: rgba(255, 255, 255, 0.97); z-index: 2; position: fixed; border-top-color: rgba(0, 0, 0, 0.08); border-right-color: rgba(0, 0, 0, 0.08); border-left-color: rgba(0, 0, 0, 0.08); transform: translateY(-100%); will-change: transform;\"><div class=\"Navbar-functionality\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: horizontal; -webkit-box-direction: normal; flex-direction: row; -webkit-box-align: center; align-items: center; flex-shrink: 0; position: absolute; right: 0px; top: 0px; height: 58px; align-self: stretch;\"><a class=\"Navbar-write\" style=\"box-sizing: inherit; color: inherit; display: flex; -webkit-box-align: center; align-items: center; padding: 0px 10px; white-space: nowrap; transition: color 0.2s;\"><span class=\"icon icon-ic_nav_new\" style=\"box-sizing: inherit; font-size: 24px; speak: none; font-feature-settings: normal; line-height: 1; -webkit-font-smoothing: antialiased; margin-right: 3px; font-family: icomoon !important;\"></span>写文章</a><button class=\"Button Navbar-loginButon Button--blue\" type=\"button\" style=\"box-sizing: inherit; padding: 0px 16px; color: rgb(0, 128, 255); font-size: 14px; line-height: 30px; background-image: none; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial; border-width: 1px; border-style: solid; border-color: rgb(0, 128, 255); -webkit-appearance: none; border-radius: 4px; height: 32px; margin-right: 16px; margin-left: 6px; width: 72px;\">登录</button></div></header></div><div style=\"box-sizing: inherit; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; color: rgb(51, 51, 51); font-family: -apple-system, &quot;Helvetica Neue&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: medium;\"></div><div class=\"Layout-main av-card av-paddingBottom av-bodyFont Layout-titleImage--normal\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; margin: 22px auto 0px; padding: 0px; width: 660px; z-index: 1; color: rgb(51, 51, 51); font-family: -apple-system, &quot;Helvetica Neue&quot;, Arial, &quot;PingFang SC&quot;, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, &quot;WenQuanYi Micro Hei&quot;, sans-serif; font-size: medium;\"><div class=\"PostIndex-header av-paddingTop av-card\" data-zop=\"{&quot;authorName&quot;:&quot;老A&quot;,&quot;itemId&quot;:&quot;29345083&quot;,&quot;title&quot;:&quot;Spring Cloud下微服务权限方案&quot;,&quot;type&quot;:&quot;article&quot;}\" data-za-module=\"PostItem\" data-za-module-info=\"{&quot;card&quot;:{&quot;content&quot;:{&quot;type&quot;:&quot;Post&quot;,&quot;token&quot;:&quot;29345083&quot;}}}\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; position: relative;\"><div class=\"TitleImage\" style=\"box-sizing: inherit; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; margin-bottom: 22px;\"><img alt=\"Spring Cloud下微服务权限方案\" src=\"https://pic4.zhimg.com/v2-32e374b99a4332ca8bd52fca9d090617_r.png\" class=\"TitleImage-imagePure TitleImage-imagePure--fixed\" height=\"396px\" style=\"box-sizing: inherit; overflow: hidden; width: 660px; display: block;\"></div><h1 class=\"PostIndex-title av-paddingSide av-titleFont\" style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; font-size: 32px; line-height: 1.3;\">Spring Cloud下微服务权限方案</h1><div class=\"PostIndex-author\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: horizontal; -webkit-box-direction: normal; flex-direction: row; -webkit-box-align: center; align-items: center; flex-shrink: 0; position: relative; font-size: 14px; color: rgb(128, 128, 128); margin-top: 22px;\"><a href=\"https://www.zhihu.com/people/lao-a-68-38\" target=\"_blank\" style=\"box-sizing: inherit; color: inherit;\"><img class=\"Avatar-hemingway PostIndex-authorAvatar Avatar--xs\" alt=\"老A\" src=\"https://pic1.zhimg.com/v2-3b6c82a0652b73ee56207a2f45955ca8_xs.jpg\" srcset=\"https://pic1.zhimg.com/v2-3b6c82a0652b73ee56207a2f45955ca8_l.jpg 2x\" style=\"box-sizing: inherit; overflow: hidden; width: 36px; height: 36px; border-radius: 50%; margin-right: 12px;\"></a><a href=\"https://www.zhihu.com/people/lao-a-68-38\" target=\"_blank\" class=\"PostIndex-authorName\" style=\"box-sizing: inherit; color: rgb(128, 128, 128); min-width: 0px; text-overflow: ellipsis; white-space: nowrap; overflow: hidden;\">老A</a><span class=\"Bull\" style=\"box-sizing: inherit; margin: 0px 6px;\"></span><div class=\"HoverTitle\" data-hover-title=\"2017 年 9月 14 日星期四晚上 7 点 12 分\" style=\"box-sizing: inherit; display: flex; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; position: relative;\"><time datetime=\"Thu Sep 14 2017 19:12:26 GMT+0800 (中国标准时间)\" style=\"box-sizing: inherit;\">1 个月前</time></div></div></div><div class=\"RichText PostIndex-content av-paddingSide av-card\" style=\"box-sizing: inherit; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0; word-break: break-word; margin: 30px 0px; line-height: 1.7;\"><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">背景</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">从传统的单体应用转型Spring Cloud的朋友都在问我，Spring Cloud下的微服务权限怎么管？怎么设计比较合理？从大层面讲叫服务权限，往小处拆分，分别为三块：用户认证、用户权限、服务校验。</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">用户认证</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">传统的单体应用可能习惯了session的存在，而到了Spring cloud的微服务化后，session虽然可以采取分布式会话来解决，但终究不是上上策。开始有人推行Spring Cloud Security结合很好的OAuth2，后面为了优化OAuth 2中Access Token的存储问题，提高后端服务的可用性和扩展性，有了更好Token验证方式JWT（JSON Web Token）。这里要强调一点的是，OAuth2和JWT这两个根本没有可比性，是两个完全不同的东西。 OAuth2是一种授权框架，而JWT是一种认证协议</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">OAuth2认证框架</h2><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">OAuth2中包含四个角色：</h2><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">资源拥有者(Resource Owner)</li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">资源服务器(Resource Server)</li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">授权服务器(Authorization Server)</li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">客户端(Client)</li></ul><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">OAuth2包含4种授权模式</h2><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">授权码（认证码）模式 （Authorization code)</li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">简化（隐形）模式 (Impilict</li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">用户名密码模式 (Resource Owner Password Credential)</li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">客户端模式 (Client Credential)</li></ul><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">其中，OAuth2的运行流程如下图，摘自RFC 6749：</p><div class=\"highlight\" style=\"box-sizing: inherit; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0;\"><pre style=\"box-sizing: inherit; margin-top: 1em; margin-bottom: 1em; padding: 10px; font-family: Menlo, Monaco, Consolas, &quot;Andale Mono&quot;, &quot;lucida console&quot;, &quot;Courier New&quot;, monospace; font-size: 14px; word-wrap: normal; background: rgb(235, 238, 245);\"><code class=\"language-text\" style=\"box-sizing: inherit; font-family: Menlo, Monaco, Consolas, &quot;Andale Mono&quot;, &quot;lucida console&quot;, &quot;Courier New&quot;, monospace;\"><span style=\"box-sizing: inherit;\"></span>+--------+                               +---------------+\r\n|        |--(A)- Authorization Request -&gt;|   Resource    |\r\n|        |                               |     Owner     |\r\n|        |&lt;-(B)-- Authorization Grant ---|               |\r\n|        |                               +---------------+\r\n|        |\r\n|        |                               +---------------+\r\n|        |--(C)-- Authorization Grant --&gt;| Authorization |\r\n| Client |                               |     Server    |\r\n|        |&lt;-(D)----- Access Token -------|               |\r\n|        |                               +---------------+\r\n|        |\r\n|        |                               +---------------+\r\n|        |--(E)----- Access Token ------&gt;|    Resource   |\r\n|        |                               |     Server    |\r\n|        |&lt;-(F)--- Protected Resource ---|               |\r\n+--------+                               +---------------+\r\n</code></pre></div><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">我们在Spring Cloud OAuth2中，所有访问微服务资源的请求都在Http Header中携带Token，被访问的服务接下来再去请求授权服务器验证Token的有效性，目前这种方式，我们需要两次或者更多次的请求，所有的Token有效性校验都落在的授权服务器上，对于我们系统的水平扩展成为一个非常大的瓶颈。</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">JWT认证协议</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">授权服务器将用户信息和授权范围序列化后放入一个JSON字符串，然后使用Base64进行编码，最终在授权服务器用私钥对这个字符串进行签名，得到一个JSON Web Token。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">假设其他所有的资源服务器都将持有一个RSA公钥，当资源服务器接收到这个在Http Header中存有Token的请求，资源服务器就可以拿到这个Token，并验证它是否使用正确的私钥签名（是否经过授权服务器签名，也就是验签）。验签通过，反序列化后就拿到Toekn中包含的有效验证信息。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">其中，主体运作流程图如下：</p><div class=\"highlight\" style=\"box-sizing: inherit; -webkit-box-orient: vertical; -webkit-box-direction: normal; flex-direction: column; -webkit-box-align: stretch; align-items: stretch; flex-shrink: 0;\"><pre style=\"box-sizing: inherit; margin-top: 1em; margin-bottom: 1em; padding: 10px; font-family: Menlo, Monaco, Consolas, &quot;Andale Mono&quot;, &quot;lucida console&quot;, &quot;Courier New&quot;, monospace; font-size: 14px; word-wrap: normal; background: rgb(235, 238, 245);\"><code class=\"language-text\" style=\"box-sizing: inherit; font-family: Menlo, Monaco, Consolas, &quot;Andale Mono&quot;, &quot;lucida console&quot;, &quot;Courier New&quot;, monospace;\"><span style=\"box-sizing: inherit;\"></span>+-----------+                                     +-------------+\r\n|           |       1-Request Authorization       |             |\r\n|           |------------------------------------&gt;|             |\r\n|           |     grant_type&amp;username&amp;password    |             |--+\r\n|           |                                     |Authorization|  | 2-Gen\r\n|           |                                     |Service      |  |   JWT\r\n|           |       3-Response Authorization      |             |&lt;-+\r\n|           |&lt;------------------------------------| Private Key |\r\n|           |    access_token / refresh_token     |             |\r\n|           |    token_type / expire_in           |             |\r\n|  Client   |                                     +-------------+\r\n|           |                                 \r\n|           |                                     +-------------+\r\n|           |       4-Request Resource            |             |\r\n|           |-----------------------------------&gt; |             |\r\n|           | Authorization: bearer Access Token  |             |--+\r\n|           |                                     | Resource    |  | 5-Verify\r\n|           |                                     | Service     |  |  Token\r\n|           |       6-Response Resource           |             |&lt;-+\r\n|           |&lt;----------------------------------- | Public Key  |\r\n+-----------+                                     +-------------+\r\n</code></pre></div><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">通过上述的方式，我们可以很好地完成服务化后的用户认证。</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">用户权限</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">传统的单体应用的权限拦截，大家都喜欢shiro，而且用的颇为顺手。可是一旦拆分后，这权限开始分散在各个API了，shiro还好使吗？笔者在项目中，并没有用shiro。前后端分离后，交互都是token，后端的服务无状态化，前端按钮资源化，权限放哪儿管好使？</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">抽象与设计</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">在介绍灵活的核心设计前，先给大家普及一个入门的概念：RBAC（Role-Based Access Control，基于角色的访问控制），就是用户通过角色与权限进行关联。简单地说，一个用户拥有若干角色，每一个角色拥有若干权限。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">RBAC其实是一种分析模型，主要分为：基本模型RBAC0（Core RBAC）、角色分层模型RBAC1（Hierarchal RBAC）、角色限制模型RBAC2（Constraint RBAC）和统一模型RBAC3（Combines RBAC）。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">更多详情大家可以了解：<a href=\"http://link.zhihu.com/?target=http%3A//blog.csdn.net/zwk626542417/article/details/46726491\" class=\" wrap external\" target=\"_blank\" rel=\"nofollow noreferrer\" style=\"box-sizing: inherit; color: rgb(34, 85, 153); border-bottom: 1px solid rgba(64, 64, 64, 0.72); word-break: break-all;\">RBAC权限模型<span class=\"icon-external\" style=\"box-sizing: inherit; font-size: 24px; speak: none; font-feature-settings: normal; line-height: 1; -webkit-font-smoothing: antialiased; font-family: icomoon !important;\"></span></a></p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">核心UML</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><img src=\"https://pic2.zhimg.com/v2-3e3eed438a7df522714407c5436c9bc9_b.png\" data-rawwidth=\"1168\" data-rawheight=\"532\" class=\"origin_image zh-lightbox-thumb lazy\" width=\"1168\" data-original=\"https://pic2.zhimg.com/v2-3e3eed438a7df522714407c5436c9bc9_r.png\" data-actualsrc=\"https://pic2.zhimg.com/v2-3e3eed438a7df522714407c5436c9bc9_b.png\" style=\"box-sizing: inherit; overflow: hidden; display: block; max-width: 100%; margin: 24px auto; cursor: -webkit-zoom-in;\"><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">这是笔者通过多种业务场景后抽象的RBAC关系图</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">类说明</h2><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">Group</li></ul><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">群或组，拥有一定数量权限的集合，亦可以是权限的载体。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">子类：User（用户）、Role（角色）、Position（岗位）、Unit（部门），通过用户的特定构成，形成不同业务场景的群或组，而通过对群或组的父类授权，完成了用户的权限获取。</p><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">Permission</li></ul><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">权限，拥有一定数量资源的集成，亦可以是资源的载体。</p><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">Resources</li></ul><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">权限下有资源，资源的来源有：Menu（菜单）、Button（动作权限）、页面元素（按钮、tab等）、数据权限等</p><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">Program</li></ul><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">程序，相关权限控制的呈现载体，可以在多个菜单中挂载。</p><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">常见web程序基本构成</li></ul><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><img src=\"https://pic1.zhimg.com/v2-9f156709621fdd7685db9781829e2948_b.png\" data-rawwidth=\"873\" data-rawheight=\"492\" class=\"origin_image zh-lightbox-thumb lazy\" width=\"873\" data-original=\"https://pic1.zhimg.com/v2-9f156709621fdd7685db9781829e2948_r.png\" data-actualsrc=\"https://pic1.zhimg.com/v2-9f156709621fdd7685db9781829e2948_b.png\" style=\"box-sizing: inherit; overflow: hidden; display: block; max-width: 100%; margin: 24px auto; cursor: -webkit-zoom-in;\"><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">模型与微服务的关系</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">如果把Spring Cloud服务化后的所有api接口都定义为上文的Resources，那么我们可以看到这么一个情况。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">比如一个用户的增删改查，我们的页面会这么做</p><img src=\"https://pic1.zhimg.com/v2-ac1fa4fc0005af11c0a7aa59fe62cbbc_b.png\" data-rawwidth=\"2880\" data-rawheight=\"1460\" class=\"origin_image zh-lightbox-thumb lazy\" width=\"2880\" data-original=\"https://pic1.zhimg.com/v2-ac1fa4fc0005af11c0a7aa59fe62cbbc_r.png\" data-actualsrc=\"https://pic1.zhimg.com/v2-ac1fa4fc0005af11c0a7aa59fe62cbbc_b.png\" style=\"box-sizing: inherit; overflow: hidden; display: block; max-width: 100%; margin: 24px auto; cursor: -webkit-zoom-in;\"><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">页面元素资源编码资源URI资源请求方式查询user_btn_get/api/user/{id}GET增加user_btn_add/api/userPOST编辑user_btn_edit/api/user/{id}PUT删除user_btn_del/api/user/{id}DELETE</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">在抽象成上述的映射关系后，我们的前后端的资源有了参照，我们对于用户组的权限授权就容易了。比如我授予一个用户增加、删除权限。在前端我们只需要检验该资源编码的有无就可以控制按钮的显示和隐藏，而在后端我们只需要统一拦截判断该用户是否具有URI和对应请求方式即可。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">至于权限的统一拦截是放置在Zuul这个网关上，还是落在具体的后端服务的拦截器上（Filter、Inteceptor），都可以轻而易举地实现。不在局限于代码的侵入性。放置Zuul流程图如下：</p><img src=\"https://pic3.zhimg.com/v2-efbe4a2af48e48c86867a49f04759b7a_b.png\" data-rawwidth=\"1426\" data-rawheight=\"710\" class=\"origin_image zh-lightbox-thumb lazy\" width=\"1426\" data-original=\"https://pic3.zhimg.com/v2-efbe4a2af48e48c86867a49f04759b7a_r.png\" data-actualsrc=\"https://pic3.zhimg.com/v2-efbe4a2af48e48c86867a49f04759b7a_b.png\" style=\"box-sizing: inherit; overflow: hidden; display: block; max-width: 100%; margin: 24px auto; cursor: -webkit-zoom-in;\"><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">要是权限的统一拦截放置在Zuul上，会有一个问题，那就是后端服务安不安全，服务只需要通过注册中心，即可对其他服务进行调用。这里就涉及到后面的第三个模块，服务之间的鉴权。</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">服务之间的鉴权</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">因为我们都知道服务之间开源通过注册中心寻到客户端后，直接远程过程调用的。对于生产上的各个服务，一个个敏感性的接口，我们更是需要加以保护。主题的流程如下图：</p><img src=\"https://pic4.zhimg.com/v2-2c574cb730d4e02834e238d0f7fc40eb_b.png\" data-rawwidth=\"1700\" data-rawheight=\"926\" class=\"origin_image zh-lightbox-thumb lazy\" width=\"1700\" data-original=\"https://pic4.zhimg.com/v2-2c574cb730d4e02834e238d0f7fc40eb_r.png\" data-actualsrc=\"https://pic4.zhimg.com/v2-2c574cb730d4e02834e238d0f7fc40eb_b.png\" style=\"box-sizing: inherit; overflow: hidden; display: block; max-width: 100%; margin: 24px auto; cursor: -webkit-zoom-in;\"><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">笔者的实现方式是基于Spring Cloud的FeignClient Inteceprot（自动申请服务token、传递当前上下文）和Mvc Inteceptor（服务token校验、更新当前上下文）来实现，从而对服务的安全性做进一步保护。</p><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">结合Spring Cloud的特性后，整体流程图如下：</p><img src=\"https://pic1.zhimg.com/v2-467d442498d0ed41372a7567fc36a714_b.png\" data-rawwidth=\"2182\" data-rawheight=\"1638\" class=\"origin_image zh-lightbox-thumb lazy\" width=\"2182\" data-original=\"https://pic1.zhimg.com/v2-467d442498d0ed41372a7567fc36a714_r.png\" data-actualsrc=\"https://pic1.zhimg.com/v2-467d442498d0ed41372a7567fc36a714_b.png\" style=\"box-sizing: inherit; overflow: hidden; display: block; max-width: 100%; margin: 24px auto; cursor: -webkit-zoom-in;\"><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\"><br style=\"box-sizing: inherit;\"></p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">优化点</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">虽然通过上述的用户合法性检验、用户权限拦截以及服务之间的鉴权，保证了Api接口的安全性，但是其间的Http访问频率是比较高的，请求数量上来的时候，慢的问题是就会特别明显。可以考虑一定的优化策略，比如用户权限缓存、服务授权信息的派发与混存、定时刷新服务鉴权Token等。</p><h2 style=\"box-sizing: inherit; margin: 20px 0px; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit;\">结语</h2><p style=\"box-sizing: inherit; margin-top: 20px; margin-bottom: 20px;\">上述是笔者在项目里的大体思路，有兴趣的朋友可以借鉴我的开源项目，欢迎star：</p><ul style=\"box-sizing: inherit; margin: 20px 0px; padding: 0px 0px 0px 40px;\"><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">gitchina：<a href=\"http://link.zhihu.com/?target=http%3A//git.oschina.net/geek_qi/ace-security%25EF%25BC%2588Jwt%25E3%2580%2581%25E7%2594%25A8%25E6%2588%25B7%25E6%259D%2583%25E9%2599%2590%25EF%25BC%2589\" class=\" wrap external\" target=\"_blank\" rel=\"nofollow noreferrer\" style=\"box-sizing: inherit; color: rgb(34, 85, 153); border-bottom: 1px solid rgba(64, 64, 64, 0.72); word-break: break-all;\">http://git.oschina.net/geek_qi/ace-security（Jwt、用户权限）<span class=\"icon-external\" style=\"box-sizing: inherit; font-size: 24px; speak: none; font-feature-settings: normal; line-height: 1; -webkit-font-smoothing: antialiased; font-family: icomoon !important;\"></span></a></li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">github：<a href=\"http://link.zhihu.com/?target=https%3A//github.com/wxiaoqi/ace-security\" class=\" external\" target=\"_blank\" rel=\"nofollow noreferrer\" style=\"box-sizing: inherit; color: rgb(34, 85, 153); border-bottom: 1px solid rgba(64, 64, 64, 0.72); word-break: break-all;\"><span class=\"invisible\" style=\"box-sizing: inherit; font-stretch: normal; font-size: 0px; line-height: 0; font-family: a; color: transparent; text-shadow: none; background-color: transparent;\">https://</span><span class=\"visible\" style=\"box-sizing: inherit;\">github.com/wxiaoqi/ace-</span><span class=\"invisible\" style=\"box-sizing: inherit; font-stretch: normal; font-size: 0px; line-height: 0; font-family: a; color: transparent; text-shadow: none; background-color: transparent;\">security</span><span class=\"ellipsis\" style=\"box-sizing: inherit;\"></span><span class=\"icon-external\" style=\"box-sizing: inherit; font-size: 24px; speak: none; font-feature-settings: normal; line-height: 1; -webkit-font-smoothing: antialiased; font-family: icomoon !important;\"></span></a></li><li style=\"box-sizing: inherit; list-style-type: initial; margin-top: 10px; list-style-position: outside;\">gitchina：<a href=\"http://link.zhihu.com/?target=http%3A//git.oschina.net/geek_qi/ace-gate%25EF%25BC%2588%25E6%259C%258D%25E5%258A%25A1%25E9%2589%25B4%25E6%259D%2583%25EF%25BC%2589\" class=\" wrap external\" target=\"_blank\" rel=\"nofollow noreferrer\" style=\"box-sizing: inherit; color: rgb(34, 85, 153); border-bottom: 1px solid rgba(64, 64, 64, 0.72); word-break: break-all;\">http://git.oschina.net/geek_qi/ace-gate（服务鉴权）</a></li></ul></div></div>', 'article', null, '', null, null, '1', null, '0', '1', 'bootdo', '2017-10-25 12:28:19', '2017-10-25 12:28:19');

-- ----------------------------
-- Table structure for `oa_notify`
-- ----------------------------
DROP TABLE IF EXISTS `oa_notify`;
CREATE TABLE `oa_notify` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `type` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '类型',
  `title` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '标题',
  `content` varchar(2000) COLLATE utf8_bin DEFAULT NULL COMMENT '内容',
  `files` varchar(2000) COLLATE utf8_bin DEFAULT NULL COMMENT '附件',
  `status` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '状态',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '更新者',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `oa_notify_del_flag` (`del_flag`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='通知通告';

-- ----------------------------
-- Records of oa_notify
-- ----------------------------
INSERT INTO `oa_notify` VALUES ('41', '3', '十九大召开了', '十九大召开了，竟然没邀请我', '', '1', '1', null, null, '2017-10-10 17:21:11', '', null);
INSERT INTO `oa_notify` VALUES ('42', '3', '苹果发布新手机了', '有全面屏的iphoneX', '', '1', '1', null, null, '2017-10-10 18:51:14', '', null);
INSERT INTO `oa_notify` VALUES ('43', '3', '十九大要消灭贫困人口', '我还只有两三年的活头了', '', '1', '1', null, null, '2017-10-11 09:56:35', '', null);
INSERT INTO `oa_notify` VALUES ('44', '3', '骑士又输了', '捉急', '', '1', '1', null, null, '2017-10-26 13:59:34', '', null);
INSERT INTO `oa_notify` VALUES ('45', '3', '火箭5连败', '没有保罗不行呀', '', '1', '1', null, null, '2017-12-30 12:10:20', '', null);

-- ----------------------------
-- Table structure for `oa_notify_record`
-- ----------------------------
DROP TABLE IF EXISTS `oa_notify_record`;
CREATE TABLE `oa_notify_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `notify_id` bigint(20) DEFAULT NULL COMMENT '通知通告ID',
  `user_id` bigint(20) DEFAULT NULL COMMENT '接受人',
  `is_read` tinyint(1) DEFAULT '0' COMMENT '阅读标记',
  `read_date` date DEFAULT NULL COMMENT '阅读时间',
  PRIMARY KEY (`id`),
  KEY `oa_notify_record_notify_id` (`notify_id`),
  KEY `oa_notify_record_user_id` (`user_id`),
  KEY `oa_notify_record_read_flag` (`is_read`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='通知通告发送记录';

-- ----------------------------
-- Records of oa_notify_record
-- ----------------------------
INSERT INTO `oa_notify_record` VALUES ('18', '41', '1', '1', '2017-10-26');
INSERT INTO `oa_notify_record` VALUES ('19', '42', '1', '1', '2017-10-26');
INSERT INTO `oa_notify_record` VALUES ('20', '43', '136', '0', null);
INSERT INTO `oa_notify_record` VALUES ('21', '43', '133', '0', null);
INSERT INTO `oa_notify_record` VALUES ('22', '43', '130', '0', null);
INSERT INTO `oa_notify_record` VALUES ('23', '43', '1', '1', '2017-10-26');
INSERT INTO `oa_notify_record` VALUES ('24', '44', '1', '1', '2017-12-29');
INSERT INTO `oa_notify_record` VALUES ('25', '45', '1', '1', '2018-01-07');
INSERT INTO `oa_notify_record` VALUES ('26', '45', '135', '0', null);

-- ----------------------------
-- Table structure for `salary`
-- ----------------------------
DROP TABLE IF EXISTS `salary`;
CREATE TABLE `salary` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `PROC_INS_ID` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '流程实例ID',
  `USER_ID` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '变动用户',
  `OFFICE_ID` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '归属部门',
  `POST` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '岗位',
  `AGE` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '性别',
  `EDU` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '学历',
  `CONTENT` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '调整原因',
  `OLDA` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '现行标准 薪酬档级',
  `OLDB` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '现行标准 月工资额',
  `OLDC` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '现行标准 年薪总额',
  `NEWA` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '调整后标准 薪酬档级',
  `NEWB` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '调整后标准 月工资额',
  `NEWC` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '调整后标准 年薪总额',
  `ADD_NUM` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '月增资',
  `EXE_DATE` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '执行时间',
  `HR_TEXT` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '人力资源部门意见',
  `LEAD_TEXT` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '分管领导意见',
  `MAIN_LEAD_TEXT` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '集团主要领导意见',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `OA_TEST_AUDIT_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='审批流程测试表';

-- ----------------------------
-- Records of salary
-- ----------------------------
INSERT INTO `salary` VALUES ('825693cd6c1c4f6b86699fc3f1a54887', '', '136', '', '', '', '', '技能提高', '', '', '', '', '100', '', '', '', '同意', '同意', '总经理审批', '1', '2017-12-15 22:01:41', '1', '2017-12-15 22:01:41', null, '1');
INSERT INTO `salary` VALUES ('a80e1d9ef35a4502bd65b0e5ba7eafff', '', 'cccc', 'ccc', 'ccccc', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '2017-11-30 16:35:15', '', '2017-11-30 16:35:15', '', '');
INSERT INTO `salary` VALUES ('b5d228f729f74833883917825749f0d5', '', '', '', '', '', '', '', '', '', '', '', '', '防守打法', '', '', '', '', '', '', '2017-11-30 19:58:36', '', '2017-11-30 19:58:36', '', '');
INSERT INTO `salary` VALUES ('cc2e8083f9d8478f831b2ea852e5c17b', '', '', 'cc', 'cc', '', '', 'xxx', '', '', '', '', '', '', '', '', '', '', '', '', '2017-11-30 19:18:59', '', '2017-11-30 19:18:59', '', '');
INSERT INTO `salary` VALUES ('cebdb316794b48be87d93dd4dbfb7d4b', '', '', '', '发的顺丰', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '2017-11-30 19:58:43', '', '2017-11-30 19:58:43', '', '');

-- ----------------------------
-- Table structure for `sys_dept`
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept` (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) DEFAULT NULL COMMENT '上级部门ID，一级部门为0',
  `name` varchar(50) DEFAULT NULL COMMENT '部门名称',
  `order_num` int(11) DEFAULT NULL COMMENT '排序',
  `del_flag` tinyint(4) DEFAULT '0' COMMENT '是否删除  -1：已删除  0：正常',
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='部门管理';

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES ('6', '0', '研发部', '1', '1');
INSERT INTO `sys_dept` VALUES ('7', '6', '研發一部', '1', '1');
INSERT INTO `sys_dept` VALUES ('8', '6', '研发二部', '2', '1');
INSERT INTO `sys_dept` VALUES ('9', '0', '销售部', '2', '1');
INSERT INTO `sys_dept` VALUES ('10', '9', '销售一部', '1', '1');
INSERT INTO `sys_dept` VALUES ('11', '0', '产品部', '3', '1');
INSERT INTO `sys_dept` VALUES ('12', '11', '产品一部', '1', '1');
INSERT INTO `sys_dept` VALUES ('13', '0', '测试部', '5', '1');
INSERT INTO `sys_dept` VALUES ('14', '13', '测试一部', '1', '1');
INSERT INTO `sys_dept` VALUES ('15', '13', '测试二部', '2', '1');

-- ----------------------------
-- Table structure for `sys_dict`
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict`;
CREATE TABLE `sys_dict` (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '标签名',
  `value` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '数据值',
  `type` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '类型',
  `description` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '描述',
  `sort` decimal(10,0) DEFAULT NULL COMMENT '排序（升序）',
  `parent_id` bigint(64) DEFAULT '0' COMMENT '父级编号',
  `create_by` int(64) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(64) DEFAULT NULL COMMENT '更新者',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_dict_value` (`value`),
  KEY `sys_dict_label` (`name`),
  KEY `sys_dict_del_flag` (`del_flag`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='字典表';

-- ----------------------------
-- Records of sys_dict
-- ----------------------------
INSERT INTO `sys_dict` VALUES ('1', '正常', '0', 'del_flag', '删除标记', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('3', '显示', '1', 'show_hide', '显示/隐藏', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('4', '隐藏', '0', 'show_hide', '显示/隐藏', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('5', '是', '1', 'yes_no', '是/否', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('6', '否', '0', 'yes_no', '是/否', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('7', '红色', 'red', 'color', '颜色值', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('8', '绿色', 'green', 'color', '颜色值', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('9', '蓝色', 'blue', 'color', '颜色值', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('10', '黄色', 'yellow', 'color', '颜色值', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('11', '橙色', 'orange', 'color', '颜色值', '50', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('12', '默认主题', 'default', 'theme', '主题方案', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('13', '天蓝主题', 'cerulean', 'theme', '主题方案', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('14', '橙色主题', 'readable', 'theme', '主题方案', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('15', '红色主题', 'united', 'theme', '主题方案', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('16', 'Flat主题', 'flat', 'theme', '主题方案', '60', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('17', '国家', '1', 'sys_area_type', '区域类型', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('18', '省份、直辖市', '2', 'sys_area_type', '区域类型', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('19', '地市', '3', 'sys_area_type', '区域类型', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('20', '区县', '4', 'sys_area_type', '区域类型', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('21', '公司', '1', 'sys_office_type', '机构类型', '60', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('22', '部门', '2', 'sys_office_type', '机构类型', '70', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('23', '小组', '3', 'sys_office_type', '机构类型', '80', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('24', '其它', '4', 'sys_office_type', '机构类型', '90', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('25', '综合部', '1', 'sys_office_common', '快捷通用部门', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('26', '开发部', '2', 'sys_office_common', '快捷通用部门', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('27', '人力部', '3', 'sys_office_common', '快捷通用部门', '50', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('28', '一级', '1', 'sys_office_grade', '机构等级', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('29', '二级', '2', 'sys_office_grade', '机构等级', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('30', '三级', '3', 'sys_office_grade', '机构等级', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('31', '四级', '4', 'sys_office_grade', '机构等级', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('32', '所有数据', '1', 'sys_data_scope', '数据范围', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('33', '所在公司及以下数据', '2', 'sys_data_scope', '数据范围', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('34', '所在公司数据', '3', 'sys_data_scope', '数据范围', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('35', '所在部门及以下数据', '4', 'sys_data_scope', '数据范围', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('36', '所在部门数据', '5', 'sys_data_scope', '数据范围', '50', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('37', '仅本人数据', '8', 'sys_data_scope', '数据范围', '90', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('38', '按明细设置', '9', 'sys_data_scope', '数据范围', '100', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('39', '系统管理', '1', 'sys_user_type', '用户类型', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('40', '部门经理', '2', 'sys_user_type', '用户类型', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('41', '普通用户', '3', 'sys_user_type', '用户类型', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('42', '基础主题', 'basic', 'cms_theme', '站点主题', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('43', '蓝色主题', 'blue', 'cms_theme', '站点主题', '20', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('44', '红色主题', 'red', 'cms_theme', '站点主题', '30', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('45', '文章模型', 'article', 'cms_module', '栏目模型', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('46', '图片模型', 'picture', 'cms_module', '栏目模型', '20', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('47', '下载模型', 'download', 'cms_module', '栏目模型', '30', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('48', '链接模型', 'link', 'cms_module', '栏目模型', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('49', '专题模型', 'special', 'cms_module', '栏目模型', '50', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('50', '默认展现方式', '0', 'cms_show_modes', '展现方式', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('51', '首栏目内容列表', '1', 'cms_show_modes', '展现方式', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('52', '栏目第一条内容', '2', 'cms_show_modes', '展现方式', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('53', '发布', '0', 'cms_del_flag', '内容状态', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('54', '删除', '1', 'cms_del_flag', '内容状态', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('55', '审核', '2', 'cms_del_flag', '内容状态', '15', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('56', '首页焦点图', '1', 'cms_posid', '推荐位', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('57', '栏目页文章推荐', '2', 'cms_posid', '推荐位', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('58', '咨询', '1', 'cms_guestbook', '留言板分类', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('59', '建议', '2', 'cms_guestbook', '留言板分类', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('60', '投诉', '3', 'cms_guestbook', '留言板分类', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('61', '其它', '4', 'cms_guestbook', '留言板分类', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('62', '公休', '1', 'oa_leave_type', '请假类型', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('63', '病假', '2', 'oa_leave_type', '请假类型', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('64', '事假', '3', 'oa_leave_type', '请假类型', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('65', '调休', '4', 'oa_leave_type', '请假类型', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('66', '婚假', '5', 'oa_leave_type', '请假类型', '60', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('67', '接入日志', '1', 'sys_log_type', '日志类型', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('68', '异常日志', '2', 'sys_log_type', '日志类型', '40', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('69', '请假流程', 'leave', 'act_type', '流程类型', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('70', '审批测试流程', 'test_audit', 'act_type', '流程类型', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('71', '分类1', '1', 'act_category', '流程分类', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('72', '分类2', '2', 'act_category', '流程分类', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('73', '增删改查', 'crud', 'gen_category', '代码生成分类', '10', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('74', '增删改查（包含从表）', 'crud_many', 'gen_category', '代码生成分类', '20', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('75', '树结构', 'tree', 'gen_category', '代码生成分类', '30', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('76', '=', '=', 'gen_query_type', '查询方式', '10', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('77', '!=', '!=', 'gen_query_type', '查询方式', '20', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('78', '&gt;', '&gt;', 'gen_query_type', '查询方式', '30', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('79', '&lt;', '&lt;', 'gen_query_type', '查询方式', '40', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('80', 'Between', 'between', 'gen_query_type', '查询方式', '50', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('81', 'Like', 'like', 'gen_query_type', '查询方式', '60', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('82', 'Left Like', 'left_like', 'gen_query_type', '查询方式', '70', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('83', 'Right Like', 'right_like', 'gen_query_type', '查询方式', '80', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('84', '文本框', 'input', 'gen_show_type', '字段生成方案', '10', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('85', '文本域', 'textarea', 'gen_show_type', '字段生成方案', '20', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('86', '下拉框', 'select', 'gen_show_type', '字段生成方案', '30', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('87', '复选框', 'checkbox', 'gen_show_type', '字段生成方案', '40', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('88', '单选框', 'radiobox', 'gen_show_type', '字段生成方案', '50', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('89', '日期选择', 'dateselect', 'gen_show_type', '字段生成方案', '60', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('90', '人员选择', 'userselect', 'gen_show_type', '字段生成方案', '70', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('91', '部门选择', 'officeselect', 'gen_show_type', '字段生成方案', '80', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('92', '区域选择', 'areaselect', 'gen_show_type', '字段生成方案', '90', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('93', 'String', 'String', 'gen_java_type', 'Java类型', '10', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('94', 'Long', 'Long', 'gen_java_type', 'Java类型', '20', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('95', '仅持久层', 'dao', 'gen_category', '代码生成分类', '40', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('96', '男', '1', 'sex', '性别', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('97', '女', '2', 'sex', '性别', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('98', 'Integer', 'Integer', 'gen_java_type', 'Java类型', '30', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('99', 'Double', 'Double', 'gen_java_type', 'Java类型', '40', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('100', 'Date', 'java.util.Date', 'gen_java_type', 'Java类型', '50', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('104', 'Custom', 'Custom', 'gen_java_type', 'Java类型', '90', '0', '1', null, '1', null, null, '1');
INSERT INTO `sys_dict` VALUES ('105', '会议通告', '1', 'oa_notify_type', '通知通告类型', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('106', '奖惩通告', '2', 'oa_notify_type', '通知通告类型', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('107', '活动通告', '3', 'oa_notify_type', '通知通告类型', '30', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('108', '草稿', '0', 'oa_notify_status', '通知通告状态', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('109', '发布', '1', 'oa_notify_status', '通知通告状态', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('110', '未读', '0', 'oa_notify_read', '通知通告状态', '10', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('111', '已读', '1', 'oa_notify_read', '通知通告状态', '20', '0', '1', null, '1', null, null, '0');
INSERT INTO `sys_dict` VALUES ('112', '草稿', '0', 'oa_notify_status', '通知通告状态', '10', '0', '1', null, '1', null, '', '0');
INSERT INTO `sys_dict` VALUES ('113', '删除', '0', 'del_flag', '删除标记', null, null, null, null, null, null, '', '');
INSERT INTO `sys_dict` VALUES ('118', '关于', 'about', 'blog_type', '博客类型', null, null, null, null, null, null, '全url是:/blog/open/page/about', '');
INSERT INTO `sys_dict` VALUES ('119', '交流', 'communication', 'blog_type', '博客类型', null, null, null, null, null, null, '', '');
INSERT INTO `sys_dict` VALUES ('120', '文章', 'article', 'blog_type', '博客类型', null, null, null, null, null, null, '', '');
INSERT INTO `sys_dict` VALUES ('121', '编码', 'code', 'hobby', '爱好', null, null, null, null, null, null, '', '');
INSERT INTO `sys_dict` VALUES ('122', '绘画', 'painting', 'hobby', '爱好', null, null, null, null, null, null, '', '');

-- ----------------------------
-- Table structure for `sys_file`
-- ----------------------------
DROP TABLE IF EXISTS `sys_file`;
CREATE TABLE `sys_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL COMMENT '文件类型',
  `url` varchar(200) DEFAULT NULL COMMENT 'URL地址',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8 COMMENT='文件上传';

-- ----------------------------
-- Records of sys_file
-- ----------------------------
INSERT INTO `sys_file` VALUES ('110', '0', '/files/d64a62e3-6821-48f1-bac6-a1b9945f4afb.jpg', '2017-10-14 16:20:17');
INSERT INTO `sys_file` VALUES ('111', '0', '/files/aa2c3dc6-495f-48cc-8e12-446eceb2535e.jpg', '2017-10-14 16:20:21');
INSERT INTO `sys_file` VALUES ('118', '0', '/files/a973499e-3ec7-4d43-8a52-b6f6517c77e3.jpg', '2017-10-20 11:53:52');
INSERT INTO `sys_file` VALUES ('132', '0', '/files/e6f13526-e31c-4ebe-a3cf-5fd88dd10be6.jpg', '2017-12-18 20:19:51');
INSERT INTO `sys_file` VALUES ('134', '0', '/files/cd016e72-77f7-4425-afe2-b79dfbdc3ae9.jpeg', '2017-12-18 22:44:07');
INSERT INTO `sys_file` VALUES ('138', '0', '/files/9ec12ee7-65b5-4cc5-9900-d2ec6185b336.jpg', '2017-12-19 19:55:27');
INSERT INTO `sys_file` VALUES ('139', '0', '/files/f6aab9d4-00a1-4bc8-a695-40fc472d4ea9.jpg', '2018-01-02 19:53:24');
INSERT INTO `sys_file` VALUES ('141', '0', '/files/445c5d98-b3b6-4226-a5af-249d1b2a6a34.jpg', '2018-01-09 19:28:53');

-- ----------------------------
-- Table structure for `sys_log`
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  `username` varchar(50) DEFAULT NULL COMMENT '用户名',
  `operation` varchar(50) DEFAULT NULL COMMENT '用户操作',
  `time` int(11) DEFAULT NULL COMMENT '响应时间',
  `method` varchar(200) DEFAULT NULL COMMENT '请求方法',
  `params` varchar(5000) DEFAULT NULL COMMENT '请求参数',
  `ip` varchar(64) DEFAULT NULL COMMENT 'IP地址',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=609 DEFAULT CHARSET=utf8 COMMENT='系统日志';

-- ----------------------------
-- Records of sys_log
-- ----------------------------

-- ----------------------------
-- Table structure for `sys_menu`
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父菜单ID，一级菜单为0',
  `name` varchar(50) DEFAULT NULL COMMENT '菜单名称',
  `url` varchar(200) DEFAULT NULL COMMENT '菜单URL',
  `perms` varchar(500) DEFAULT NULL COMMENT '授权(多个用逗号分隔，如：user:list,user:create)',
  `type` int(11) DEFAULT NULL COMMENT '类型   0：目录   1：菜单   2：按钮',
  `icon` varchar(50) DEFAULT NULL COMMENT '菜单图标',
  `order_num` int(11) DEFAULT NULL COMMENT '排序',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8 COMMENT='菜单管理';

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES ('1', '0', '基础管理', '', '', '0', 'fa fa-bars', '0', '2017-08-09 22:49:47', null);
INSERT INTO `sys_menu` VALUES ('2', '3', '系统菜单', 'sys/menu/', 'sys:menu:menu', '1', 'fa fa-th-list', '2', '2017-08-09 22:55:15', null);
INSERT INTO `sys_menu` VALUES ('3', '0', '系统管理', null, null, '0', 'fa fa-desktop', '1', '2017-08-09 23:06:55', '2017-08-14 14:13:43');
INSERT INTO `sys_menu` VALUES ('6', '3', '用户管理', 'sys/user/', 'sys:user:user', '1', 'fa fa-user', '0', '2017-08-10 14:12:11', null);
INSERT INTO `sys_menu` VALUES ('7', '3', '角色管理', 'sys/role', 'sys:role:role', '1', 'fa fa-paw', '1', '2017-08-10 14:13:19', null);
INSERT INTO `sys_menu` VALUES ('12', '6', '新增', '', 'sys:user:add', '2', '', '0', '2017-08-14 10:51:35', null);
INSERT INTO `sys_menu` VALUES ('13', '6', '编辑', '', 'sys:user:edit', '2', '', '0', '2017-08-14 10:52:06', null);
INSERT INTO `sys_menu` VALUES ('14', '6', '删除', null, 'sys:user:remove', '2', null, '0', '2017-08-14 10:52:24', null);
INSERT INTO `sys_menu` VALUES ('15', '7', '新增', '', 'sys:role:add', '2', '', '0', '2017-08-14 10:56:37', null);
INSERT INTO `sys_menu` VALUES ('20', '2', '新增', '', 'sys:menu:add', '2', '', '0', '2017-08-14 10:59:32', null);
INSERT INTO `sys_menu` VALUES ('21', '2', '编辑', '', 'sys:menu:edit', '2', '', '0', '2017-08-14 10:59:56', null);
INSERT INTO `sys_menu` VALUES ('22', '2', '删除', '', 'sys:menu:remove', '2', '', '0', '2017-08-14 11:00:26', null);
INSERT INTO `sys_menu` VALUES ('24', '6', '批量删除', '', 'sys:user:batchRemove', '2', '', '0', '2017-08-14 17:27:18', null);
INSERT INTO `sys_menu` VALUES ('25', '6', '停用', null, 'sys:user:disable', '2', null, '0', '2017-08-14 17:27:43', null);
INSERT INTO `sys_menu` VALUES ('26', '6', '重置密码', '', 'sys:user:resetPwd', '2', '', '0', '2017-08-14 17:28:34', null);
INSERT INTO `sys_menu` VALUES ('27', '91', '系统日志', 'common/log', 'common:log', '1', 'fa fa-warning', '0', '2017-08-14 22:11:53', null);
INSERT INTO `sys_menu` VALUES ('28', '27', '刷新', null, 'sys:log:list', '2', null, '0', '2017-08-14 22:30:22', null);
INSERT INTO `sys_menu` VALUES ('29', '27', '删除', null, 'sys:log:remove', '2', null, '0', '2017-08-14 22:30:43', null);
INSERT INTO `sys_menu` VALUES ('30', '27', '清空', null, 'sys:log:clear', '2', null, '0', '2017-08-14 22:31:02', null);
INSERT INTO `sys_menu` VALUES ('48', '77', '代码生成', 'common/generator', 'common:generator', '1', 'fa fa-code', '3', null, null);
INSERT INTO `sys_menu` VALUES ('49', '0', '博客管理', '', '', '0', 'fa fa-rss', '6', null, null);
INSERT INTO `sys_menu` VALUES ('50', '49', '文章列表', 'blog/bContent', 'blog:bContent:bContent', '1', 'fa fa-file-image-o', '1', null, null);
INSERT INTO `sys_menu` VALUES ('51', '50', '新增', '', 'blog:bContent:add', '2', '', null, null, null);
INSERT INTO `sys_menu` VALUES ('55', '7', '编辑', '', 'sys:role:edit', '2', '', null, null, null);
INSERT INTO `sys_menu` VALUES ('56', '7', '删除', '', 'sys:role:remove', '2', null, null, null, null);
INSERT INTO `sys_menu` VALUES ('57', '91', '运行监控', '/druid/index.html', '', '1', 'fa fa-caret-square-o-right', '1', null, null);
INSERT INTO `sys_menu` VALUES ('58', '50', '编辑', '', 'blog:bContent:edit', '2', null, null, null, null);
INSERT INTO `sys_menu` VALUES ('59', '50', '删除', '', 'blog:bContent:remove', '2', null, null, null, null);
INSERT INTO `sys_menu` VALUES ('60', '50', '批量删除', '', 'blog:bContent:batchRemove', '2', null, null, null, null);
INSERT INTO `sys_menu` VALUES ('61', '2', '批量删除', '', 'sys:menu:batchRemove', '2', null, null, null, null);
INSERT INTO `sys_menu` VALUES ('62', '7', '批量删除', '', 'sys:role:batchRemove', '2', null, null, null, null);
INSERT INTO `sys_menu` VALUES ('68', '49', '发布文章', '/blog/bContent/add', 'blog:bContent:add', '1', 'fa fa-edit', '0', null, null);
INSERT INTO `sys_menu` VALUES ('71', '1', '文件管理', '/common/sysFile', 'common:sysFile:sysFile', '1', 'fa fa-folder-open', '2', null, null);
INSERT INTO `sys_menu` VALUES ('72', '77', '计划任务', 'common/job', 'common:taskScheduleJob', '1', 'fa fa-hourglass-1', '4', null, null);
INSERT INTO `sys_menu` VALUES ('73', '3', '部门管理', '/system/sysDept', 'system:sysDept:sysDept', '1', 'fa fa-users', '3', null, null);
INSERT INTO `sys_menu` VALUES ('74', '73', '增加', '/system/sysDept/add', 'system:sysDept:add', '2', null, '1', null, null);
INSERT INTO `sys_menu` VALUES ('75', '73', '刪除', 'system/sysDept/remove', 'system:sysDept:remove', '2', null, '2', null, null);
INSERT INTO `sys_menu` VALUES ('76', '73', '编辑', '/system/sysDept/edit', 'system:sysDept:edit', '2', null, '3', null, null);
INSERT INTO `sys_menu` VALUES ('77', '0', '系统工具', '', '', '0', 'fa fa-gear', '4', null, null);
INSERT INTO `sys_menu` VALUES ('78', '1', '数据字典', '/common/dict', 'common:dict:dict', '1', 'fa fa-book', '1', null, null);
INSERT INTO `sys_menu` VALUES ('79', '78', '增加', '/common/dict/add', 'common:dict:add', '2', null, '2', null, null);
INSERT INTO `sys_menu` VALUES ('80', '78', '编辑', '/common/dict/edit', 'common:dict:edit', '2', null, '2', null, null);
INSERT INTO `sys_menu` VALUES ('81', '78', '删除', '/common/dict/remove', 'common:dict:remove', '2', '', '3', null, null);
INSERT INTO `sys_menu` VALUES ('83', '78', '批量删除', '/common/dict/batchRemove', 'common:dict:batchRemove', '2', '', '4', null, null);
INSERT INTO `sys_menu` VALUES ('84', '0', '办公管理', '', '', '0', 'fa fa-laptop', '5', null, null);
INSERT INTO `sys_menu` VALUES ('85', '84', '通知公告', 'oa/notify', 'oa:notify:notify', '1', 'fa fa-pencil-square', null, null, null);
INSERT INTO `sys_menu` VALUES ('86', '85', '新增', 'oa/notify/add', 'oa:notify:add', '2', 'fa fa-plus', '1', null, null);
INSERT INTO `sys_menu` VALUES ('87', '85', '编辑', 'oa/notify/edit', 'oa:notify:edit', '2', 'fa fa-pencil-square-o', '2', null, null);
INSERT INTO `sys_menu` VALUES ('88', '85', '删除', 'oa/notify/remove', 'oa:notify:remove', '2', 'fa fa-minus', null, null, null);
INSERT INTO `sys_menu` VALUES ('89', '85', '批量删除', 'oa/notify/batchRemove', 'oa:notify:batchRemove', '2', '', null, null, null);
INSERT INTO `sys_menu` VALUES ('90', '84', '我的通知', 'oa/notify/selfNotify', '', '1', 'fa fa-envelope-square', null, null, null);
INSERT INTO `sys_menu` VALUES ('91', '0', '系统监控', '', '', '0', 'fa fa-video-camera', '5', null, null);
INSERT INTO `sys_menu` VALUES ('92', '91', '在线用户', 'sys/online', '', '1', 'fa fa-user', null, null, null);
INSERT INTO `sys_menu` VALUES ('93', '0', '工作流程', '', '', '0', 'fa fa-print', '6', null, null);
INSERT INTO `sys_menu` VALUES ('94', '93', '模型管理', 'activiti/model', '', '1', 'fa fa-sort-amount-asc', null, null, null);
INSERT INTO `sys_menu` VALUES ('95', '94', '全部权限', '', 'activiti:model', '2', '', null, null, null);
INSERT INTO `sys_menu` VALUES ('96', '93', '流程管理', 'activiti/process', '', '1', 'fa fa-flag', null, null, null);
INSERT INTO `sys_menu` VALUES ('97', '0', '图表管理', '', '', '0', 'fa fa-bar-chart', '7', null, null);
INSERT INTO `sys_menu` VALUES ('98', '97', '百度chart', '/chart/graph_echarts.html', '', '1', 'fa fa-area-chart', null, null, null);
INSERT INTO `sys_menu` VALUES ('99', '96', '所有权限', '', 'act:process', '2', '', null, null, null);
INSERT INTO `sys_menu` VALUES ('101', '93', '待办任务', 'activiti/task/todo', '', '1', '', null, null, null);
INSERT INTO `sys_menu` VALUES ('104', '77', 'swagger', '/swagger-ui.html', '', '1', '', null, null, null);

-- ----------------------------
-- Table structure for `sys_role`
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `role_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_name` varchar(100) DEFAULT NULL COMMENT '角色名称',
  `role_sign` varchar(100) DEFAULT NULL COMMENT '角色标识',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `user_id_create` bigint(255) DEFAULT NULL COMMENT '创建用户id',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modified` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8 COMMENT='角色';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES ('1', '超级用户角色', 'admin', '拥有最高权限', '2', '2017-08-12 00:43:52', '2017-08-12 19:14:59');
INSERT INTO `sys_role` VALUES ('59', '普通用户', null, '基本用户权限', null, null, null);

-- ----------------------------
-- Table structure for `sys_role_menu`
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20) DEFAULT NULL COMMENT '角色ID',
  `menu_id` bigint(20) DEFAULT NULL COMMENT '菜单ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3284 DEFAULT CHARSET=utf8 COMMENT='角色与菜单对应关系';

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
INSERT INTO `sys_role_menu` VALUES ('367', '44', '1');
INSERT INTO `sys_role_menu` VALUES ('368', '44', '32');
INSERT INTO `sys_role_menu` VALUES ('369', '44', '33');
INSERT INTO `sys_role_menu` VALUES ('370', '44', '34');
INSERT INTO `sys_role_menu` VALUES ('371', '44', '35');
INSERT INTO `sys_role_menu` VALUES ('372', '44', '28');
INSERT INTO `sys_role_menu` VALUES ('373', '44', '29');
INSERT INTO `sys_role_menu` VALUES ('374', '44', '30');
INSERT INTO `sys_role_menu` VALUES ('375', '44', '38');
INSERT INTO `sys_role_menu` VALUES ('376', '44', '4');
INSERT INTO `sys_role_menu` VALUES ('377', '44', '27');
INSERT INTO `sys_role_menu` VALUES ('378', '45', '38');
INSERT INTO `sys_role_menu` VALUES ('379', '46', '3');
INSERT INTO `sys_role_menu` VALUES ('380', '46', '20');
INSERT INTO `sys_role_menu` VALUES ('381', '46', '21');
INSERT INTO `sys_role_menu` VALUES ('382', '46', '22');
INSERT INTO `sys_role_menu` VALUES ('383', '46', '23');
INSERT INTO `sys_role_menu` VALUES ('384', '46', '11');
INSERT INTO `sys_role_menu` VALUES ('385', '46', '12');
INSERT INTO `sys_role_menu` VALUES ('386', '46', '13');
INSERT INTO `sys_role_menu` VALUES ('387', '46', '14');
INSERT INTO `sys_role_menu` VALUES ('388', '46', '24');
INSERT INTO `sys_role_menu` VALUES ('389', '46', '25');
INSERT INTO `sys_role_menu` VALUES ('390', '46', '26');
INSERT INTO `sys_role_menu` VALUES ('391', '46', '15');
INSERT INTO `sys_role_menu` VALUES ('392', '46', '2');
INSERT INTO `sys_role_menu` VALUES ('393', '46', '6');
INSERT INTO `sys_role_menu` VALUES ('394', '46', '7');
INSERT INTO `sys_role_menu` VALUES ('598', '50', '38');
INSERT INTO `sys_role_menu` VALUES ('632', '38', '42');
INSERT INTO `sys_role_menu` VALUES ('737', '51', '38');
INSERT INTO `sys_role_menu` VALUES ('738', '51', '39');
INSERT INTO `sys_role_menu` VALUES ('739', '51', '40');
INSERT INTO `sys_role_menu` VALUES ('740', '51', '41');
INSERT INTO `sys_role_menu` VALUES ('741', '51', '4');
INSERT INTO `sys_role_menu` VALUES ('742', '51', '32');
INSERT INTO `sys_role_menu` VALUES ('743', '51', '33');
INSERT INTO `sys_role_menu` VALUES ('744', '51', '34');
INSERT INTO `sys_role_menu` VALUES ('745', '51', '35');
INSERT INTO `sys_role_menu` VALUES ('746', '51', '27');
INSERT INTO `sys_role_menu` VALUES ('747', '51', '28');
INSERT INTO `sys_role_menu` VALUES ('748', '51', '29');
INSERT INTO `sys_role_menu` VALUES ('749', '51', '30');
INSERT INTO `sys_role_menu` VALUES ('750', '51', '1');
INSERT INTO `sys_role_menu` VALUES ('1064', '54', '53');
INSERT INTO `sys_role_menu` VALUES ('1095', '55', '2');
INSERT INTO `sys_role_menu` VALUES ('1096', '55', '6');
INSERT INTO `sys_role_menu` VALUES ('1097', '55', '7');
INSERT INTO `sys_role_menu` VALUES ('1098', '55', '3');
INSERT INTO `sys_role_menu` VALUES ('1099', '55', '50');
INSERT INTO `sys_role_menu` VALUES ('1100', '55', '49');
INSERT INTO `sys_role_menu` VALUES ('1101', '55', '1');
INSERT INTO `sys_role_menu` VALUES ('1856', '53', '28');
INSERT INTO `sys_role_menu` VALUES ('1857', '53', '29');
INSERT INTO `sys_role_menu` VALUES ('1858', '53', '30');
INSERT INTO `sys_role_menu` VALUES ('1859', '53', '27');
INSERT INTO `sys_role_menu` VALUES ('1860', '53', '57');
INSERT INTO `sys_role_menu` VALUES ('1861', '53', '71');
INSERT INTO `sys_role_menu` VALUES ('1862', '53', '48');
INSERT INTO `sys_role_menu` VALUES ('1863', '53', '72');
INSERT INTO `sys_role_menu` VALUES ('1864', '53', '1');
INSERT INTO `sys_role_menu` VALUES ('1865', '53', '7');
INSERT INTO `sys_role_menu` VALUES ('1866', '53', '55');
INSERT INTO `sys_role_menu` VALUES ('1867', '53', '56');
INSERT INTO `sys_role_menu` VALUES ('1868', '53', '62');
INSERT INTO `sys_role_menu` VALUES ('1869', '53', '15');
INSERT INTO `sys_role_menu` VALUES ('1870', '53', '2');
INSERT INTO `sys_role_menu` VALUES ('1871', '53', '61');
INSERT INTO `sys_role_menu` VALUES ('1872', '53', '20');
INSERT INTO `sys_role_menu` VALUES ('1873', '53', '21');
INSERT INTO `sys_role_menu` VALUES ('1874', '53', '22');
INSERT INTO `sys_role_menu` VALUES ('2084', '56', '68');
INSERT INTO `sys_role_menu` VALUES ('2085', '56', '60');
INSERT INTO `sys_role_menu` VALUES ('2086', '56', '59');
INSERT INTO `sys_role_menu` VALUES ('2087', '56', '58');
INSERT INTO `sys_role_menu` VALUES ('2088', '56', '51');
INSERT INTO `sys_role_menu` VALUES ('2089', '56', '50');
INSERT INTO `sys_role_menu` VALUES ('2090', '56', '49');
INSERT INTO `sys_role_menu` VALUES ('2243', '48', '72');
INSERT INTO `sys_role_menu` VALUES ('2247', '63', '-1');
INSERT INTO `sys_role_menu` VALUES ('2248', '63', '84');
INSERT INTO `sys_role_menu` VALUES ('2249', '63', '85');
INSERT INTO `sys_role_menu` VALUES ('2250', '63', '88');
INSERT INTO `sys_role_menu` VALUES ('2251', '63', '87');
INSERT INTO `sys_role_menu` VALUES ('2252', '64', '84');
INSERT INTO `sys_role_menu` VALUES ('2253', '64', '89');
INSERT INTO `sys_role_menu` VALUES ('2254', '64', '88');
INSERT INTO `sys_role_menu` VALUES ('2255', '64', '87');
INSERT INTO `sys_role_menu` VALUES ('2256', '64', '86');
INSERT INTO `sys_role_menu` VALUES ('2257', '64', '85');
INSERT INTO `sys_role_menu` VALUES ('2258', '65', '89');
INSERT INTO `sys_role_menu` VALUES ('2259', '65', '88');
INSERT INTO `sys_role_menu` VALUES ('2260', '65', '86');
INSERT INTO `sys_role_menu` VALUES ('2262', '67', '48');
INSERT INTO `sys_role_menu` VALUES ('2263', '68', '88');
INSERT INTO `sys_role_menu` VALUES ('2264', '68', '87');
INSERT INTO `sys_role_menu` VALUES ('2265', '69', '89');
INSERT INTO `sys_role_menu` VALUES ('2266', '69', '88');
INSERT INTO `sys_role_menu` VALUES ('2267', '69', '86');
INSERT INTO `sys_role_menu` VALUES ('2268', '69', '87');
INSERT INTO `sys_role_menu` VALUES ('2269', '69', '85');
INSERT INTO `sys_role_menu` VALUES ('2270', '69', '84');
INSERT INTO `sys_role_menu` VALUES ('2271', '70', '85');
INSERT INTO `sys_role_menu` VALUES ('2272', '70', '89');
INSERT INTO `sys_role_menu` VALUES ('2273', '70', '88');
INSERT INTO `sys_role_menu` VALUES ('2274', '70', '87');
INSERT INTO `sys_role_menu` VALUES ('2275', '70', '86');
INSERT INTO `sys_role_menu` VALUES ('2276', '70', '84');
INSERT INTO `sys_role_menu` VALUES ('2277', '71', '87');
INSERT INTO `sys_role_menu` VALUES ('2278', '72', '59');
INSERT INTO `sys_role_menu` VALUES ('2279', '73', '48');
INSERT INTO `sys_role_menu` VALUES ('2280', '74', '88');
INSERT INTO `sys_role_menu` VALUES ('2281', '74', '87');
INSERT INTO `sys_role_menu` VALUES ('2282', '75', '88');
INSERT INTO `sys_role_menu` VALUES ('2283', '75', '87');
INSERT INTO `sys_role_menu` VALUES ('2284', '76', '85');
INSERT INTO `sys_role_menu` VALUES ('2285', '76', '89');
INSERT INTO `sys_role_menu` VALUES ('2286', '76', '88');
INSERT INTO `sys_role_menu` VALUES ('2287', '76', '87');
INSERT INTO `sys_role_menu` VALUES ('2288', '76', '86');
INSERT INTO `sys_role_menu` VALUES ('2289', '76', '84');
INSERT INTO `sys_role_menu` VALUES ('2292', '78', '88');
INSERT INTO `sys_role_menu` VALUES ('2293', '78', '87');
INSERT INTO `sys_role_menu` VALUES ('2294', '78', null);
INSERT INTO `sys_role_menu` VALUES ('2295', '78', null);
INSERT INTO `sys_role_menu` VALUES ('2296', '78', null);
INSERT INTO `sys_role_menu` VALUES ('2308', '80', '87');
INSERT INTO `sys_role_menu` VALUES ('2309', '80', '86');
INSERT INTO `sys_role_menu` VALUES ('2310', '80', '-1');
INSERT INTO `sys_role_menu` VALUES ('2311', '80', '84');
INSERT INTO `sys_role_menu` VALUES ('2312', '80', '85');
INSERT INTO `sys_role_menu` VALUES ('2328', '79', '72');
INSERT INTO `sys_role_menu` VALUES ('2329', '79', '48');
INSERT INTO `sys_role_menu` VALUES ('2330', '79', '77');
INSERT INTO `sys_role_menu` VALUES ('2331', '79', '84');
INSERT INTO `sys_role_menu` VALUES ('2332', '79', '89');
INSERT INTO `sys_role_menu` VALUES ('2333', '79', '88');
INSERT INTO `sys_role_menu` VALUES ('2334', '79', '87');
INSERT INTO `sys_role_menu` VALUES ('2335', '79', '86');
INSERT INTO `sys_role_menu` VALUES ('2336', '79', '85');
INSERT INTO `sys_role_menu` VALUES ('2337', '79', '-1');
INSERT INTO `sys_role_menu` VALUES ('2338', '77', '89');
INSERT INTO `sys_role_menu` VALUES ('2339', '77', '88');
INSERT INTO `sys_role_menu` VALUES ('2340', '77', '87');
INSERT INTO `sys_role_menu` VALUES ('2341', '77', '86');
INSERT INTO `sys_role_menu` VALUES ('2342', '77', '85');
INSERT INTO `sys_role_menu` VALUES ('2343', '77', '84');
INSERT INTO `sys_role_menu` VALUES ('2344', '77', '72');
INSERT INTO `sys_role_menu` VALUES ('2345', '77', '-1');
INSERT INTO `sys_role_menu` VALUES ('2346', '77', '77');
INSERT INTO `sys_role_menu` VALUES ('2974', '57', '93');
INSERT INTO `sys_role_menu` VALUES ('2975', '57', '99');
INSERT INTO `sys_role_menu` VALUES ('2976', '57', '95');
INSERT INTO `sys_role_menu` VALUES ('2977', '57', '101');
INSERT INTO `sys_role_menu` VALUES ('2978', '57', '96');
INSERT INTO `sys_role_menu` VALUES ('2979', '57', '94');
INSERT INTO `sys_role_menu` VALUES ('2980', '57', '-1');
INSERT INTO `sys_role_menu` VALUES ('2981', '58', '93');
INSERT INTO `sys_role_menu` VALUES ('2982', '58', '99');
INSERT INTO `sys_role_menu` VALUES ('2983', '58', '95');
INSERT INTO `sys_role_menu` VALUES ('2984', '58', '101');
INSERT INTO `sys_role_menu` VALUES ('2985', '58', '96');
INSERT INTO `sys_role_menu` VALUES ('2986', '58', '94');
INSERT INTO `sys_role_menu` VALUES ('2987', '58', '-1');
INSERT INTO `sys_role_menu` VALUES ('3115', '1', '103');
INSERT INTO `sys_role_menu` VALUES ('3116', '1', '98');
INSERT INTO `sys_role_menu` VALUES ('3117', '1', '101');
INSERT INTO `sys_role_menu` VALUES ('3118', '1', '99');
INSERT INTO `sys_role_menu` VALUES ('3119', '1', '95');
INSERT INTO `sys_role_menu` VALUES ('3120', '1', '92');
INSERT INTO `sys_role_menu` VALUES ('3121', '1', '57');
INSERT INTO `sys_role_menu` VALUES ('3122', '1', '30');
INSERT INTO `sys_role_menu` VALUES ('3123', '1', '29');
INSERT INTO `sys_role_menu` VALUES ('3124', '1', '28');
INSERT INTO `sys_role_menu` VALUES ('3125', '1', '90');
INSERT INTO `sys_role_menu` VALUES ('3126', '1', '89');
INSERT INTO `sys_role_menu` VALUES ('3127', '1', '88');
INSERT INTO `sys_role_menu` VALUES ('3128', '1', '87');
INSERT INTO `sys_role_menu` VALUES ('3129', '1', '86');
INSERT INTO `sys_role_menu` VALUES ('3130', '1', '72');
INSERT INTO `sys_role_menu` VALUES ('3131', '1', '48');
INSERT INTO `sys_role_menu` VALUES ('3132', '1', '68');
INSERT INTO `sys_role_menu` VALUES ('3133', '1', '60');
INSERT INTO `sys_role_menu` VALUES ('3134', '1', '59');
INSERT INTO `sys_role_menu` VALUES ('3135', '1', '58');
INSERT INTO `sys_role_menu` VALUES ('3136', '1', '51');
INSERT INTO `sys_role_menu` VALUES ('3137', '1', '76');
INSERT INTO `sys_role_menu` VALUES ('3138', '1', '75');
INSERT INTO `sys_role_menu` VALUES ('3139', '1', '74');
INSERT INTO `sys_role_menu` VALUES ('3140', '1', '62');
INSERT INTO `sys_role_menu` VALUES ('3141', '1', '56');
INSERT INTO `sys_role_menu` VALUES ('3142', '1', '55');
INSERT INTO `sys_role_menu` VALUES ('3143', '1', '15');
INSERT INTO `sys_role_menu` VALUES ('3144', '1', '26');
INSERT INTO `sys_role_menu` VALUES ('3145', '1', '25');
INSERT INTO `sys_role_menu` VALUES ('3146', '1', '24');
INSERT INTO `sys_role_menu` VALUES ('3147', '1', '14');
INSERT INTO `sys_role_menu` VALUES ('3148', '1', '13');
INSERT INTO `sys_role_menu` VALUES ('3149', '1', '12');
INSERT INTO `sys_role_menu` VALUES ('3150', '1', '61');
INSERT INTO `sys_role_menu` VALUES ('3151', '1', '22');
INSERT INTO `sys_role_menu` VALUES ('3152', '1', '21');
INSERT INTO `sys_role_menu` VALUES ('3153', '1', '20');
INSERT INTO `sys_role_menu` VALUES ('3154', '1', '83');
INSERT INTO `sys_role_menu` VALUES ('3155', '1', '81');
INSERT INTO `sys_role_menu` VALUES ('3156', '1', '80');
INSERT INTO `sys_role_menu` VALUES ('3157', '1', '79');
INSERT INTO `sys_role_menu` VALUES ('3158', '1', '71');
INSERT INTO `sys_role_menu` VALUES ('3159', '1', '102');
INSERT INTO `sys_role_menu` VALUES ('3160', '1', '97');
INSERT INTO `sys_role_menu` VALUES ('3161', '1', '96');
INSERT INTO `sys_role_menu` VALUES ('3162', '1', '94');
INSERT INTO `sys_role_menu` VALUES ('3163', '1', '93');
INSERT INTO `sys_role_menu` VALUES ('3164', '1', '27');
INSERT INTO `sys_role_menu` VALUES ('3165', '1', '91');
INSERT INTO `sys_role_menu` VALUES ('3166', '1', '85');
INSERT INTO `sys_role_menu` VALUES ('3167', '1', '84');
INSERT INTO `sys_role_menu` VALUES ('3168', '1', '50');
INSERT INTO `sys_role_menu` VALUES ('3169', '1', '49');
INSERT INTO `sys_role_menu` VALUES ('3170', '1', '73');
INSERT INTO `sys_role_menu` VALUES ('3171', '1', '7');
INSERT INTO `sys_role_menu` VALUES ('3172', '1', '6');
INSERT INTO `sys_role_menu` VALUES ('3173', '1', '2');
INSERT INTO `sys_role_menu` VALUES ('3174', '1', '3');
INSERT INTO `sys_role_menu` VALUES ('3175', '1', '78');
INSERT INTO `sys_role_menu` VALUES ('3176', '1', '1');
INSERT INTO `sys_role_menu` VALUES ('3177', '1', '104');
INSERT INTO `sys_role_menu` VALUES ('3178', '1', '77');
INSERT INTO `sys_role_menu` VALUES ('3179', '1', '-1');
INSERT INTO `sys_role_menu` VALUES ('3232', '59', '98');
INSERT INTO `sys_role_menu` VALUES ('3233', '59', '101');
INSERT INTO `sys_role_menu` VALUES ('3234', '59', '99');
INSERT INTO `sys_role_menu` VALUES ('3235', '59', '95');
INSERT INTO `sys_role_menu` VALUES ('3236', '59', '90');
INSERT INTO `sys_role_menu` VALUES ('3237', '59', '89');
INSERT INTO `sys_role_menu` VALUES ('3238', '59', '88');
INSERT INTO `sys_role_menu` VALUES ('3239', '59', '87');
INSERT INTO `sys_role_menu` VALUES ('3240', '59', '86');
INSERT INTO `sys_role_menu` VALUES ('3241', '59', '68');
INSERT INTO `sys_role_menu` VALUES ('3242', '59', '60');
INSERT INTO `sys_role_menu` VALUES ('3243', '59', '59');
INSERT INTO `sys_role_menu` VALUES ('3244', '59', '58');
INSERT INTO `sys_role_menu` VALUES ('3245', '59', '51');
INSERT INTO `sys_role_menu` VALUES ('3246', '59', '76');
INSERT INTO `sys_role_menu` VALUES ('3247', '59', '75');
INSERT INTO `sys_role_menu` VALUES ('3248', '59', '74');
INSERT INTO `sys_role_menu` VALUES ('3249', '59', '62');
INSERT INTO `sys_role_menu` VALUES ('3250', '59', '56');
INSERT INTO `sys_role_menu` VALUES ('3251', '59', '55');
INSERT INTO `sys_role_menu` VALUES ('3252', '59', '15');
INSERT INTO `sys_role_menu` VALUES ('3253', '59', '26');
INSERT INTO `sys_role_menu` VALUES ('3254', '59', '25');
INSERT INTO `sys_role_menu` VALUES ('3255', '59', '24');
INSERT INTO `sys_role_menu` VALUES ('3256', '59', '14');
INSERT INTO `sys_role_menu` VALUES ('3257', '59', '13');
INSERT INTO `sys_role_menu` VALUES ('3258', '59', '12');
INSERT INTO `sys_role_menu` VALUES ('3259', '59', '61');
INSERT INTO `sys_role_menu` VALUES ('3260', '59', '22');
INSERT INTO `sys_role_menu` VALUES ('3261', '59', '21');
INSERT INTO `sys_role_menu` VALUES ('3262', '59', '20');
INSERT INTO `sys_role_menu` VALUES ('3263', '59', '83');
INSERT INTO `sys_role_menu` VALUES ('3264', '59', '81');
INSERT INTO `sys_role_menu` VALUES ('3265', '59', '80');
INSERT INTO `sys_role_menu` VALUES ('3266', '59', '79');
INSERT INTO `sys_role_menu` VALUES ('3267', '59', '71');
INSERT INTO `sys_role_menu` VALUES ('3268', '59', '97');
INSERT INTO `sys_role_menu` VALUES ('3269', '59', '96');
INSERT INTO `sys_role_menu` VALUES ('3270', '59', '94');
INSERT INTO `sys_role_menu` VALUES ('3271', '59', '93');
INSERT INTO `sys_role_menu` VALUES ('3272', '59', '85');
INSERT INTO `sys_role_menu` VALUES ('3273', '59', '84');
INSERT INTO `sys_role_menu` VALUES ('3274', '59', '50');
INSERT INTO `sys_role_menu` VALUES ('3275', '59', '49');
INSERT INTO `sys_role_menu` VALUES ('3276', '59', '73');
INSERT INTO `sys_role_menu` VALUES ('3277', '59', '7');
INSERT INTO `sys_role_menu` VALUES ('3278', '59', '6');
INSERT INTO `sys_role_menu` VALUES ('3279', '59', '2');
INSERT INTO `sys_role_menu` VALUES ('3280', '59', '3');
INSERT INTO `sys_role_menu` VALUES ('3281', '59', '78');
INSERT INTO `sys_role_menu` VALUES ('3282', '59', '1');
INSERT INTO `sys_role_menu` VALUES ('3283', '59', '-1');

-- ----------------------------
-- Table structure for `sys_task`
-- ----------------------------
DROP TABLE IF EXISTS `sys_task`;
CREATE TABLE `sys_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `cron_expression` varchar(255) DEFAULT NULL COMMENT 'cron表达式',
  `method_name` varchar(255) DEFAULT NULL COMMENT '任务调用的方法名',
  `is_concurrent` varchar(255) DEFAULT NULL COMMENT '任务是否有状态',
  `description` varchar(255) DEFAULT NULL COMMENT '任务描述',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新者',
  `bean_class` varchar(255) DEFAULT NULL COMMENT '任务执行时调用哪个类的方法 包名+类名',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `job_status` varchar(255) DEFAULT NULL COMMENT '任务状态',
  `job_group` varchar(255) DEFAULT NULL COMMENT '任务分组',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建者',
  `spring_bean` varchar(255) DEFAULT NULL COMMENT 'Spring bean',
  `job_name` varchar(255) DEFAULT NULL COMMENT '任务名',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sys_task
-- ----------------------------
INSERT INTO `sys_task` VALUES ('2', '0/10 * * * * ?', 'run1', '1', '', '4028ea815a3d2a8c015a3d2f8d2a0002', 'com.bootdo.common.task.WelcomeJob', '2017-05-19 18:30:56', '0', 'group1', '2017-05-19 18:31:07', null, '', 'welcomJob');

-- ----------------------------
-- Table structure for `sys_user`
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) DEFAULT NULL COMMENT '用户名',
  `name` varchar(100) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL COMMENT '密码',
  `dept_id` bigint(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱',
  `mobile` varchar(100) DEFAULT NULL COMMENT '手机号',
  `status` tinyint(255) DEFAULT NULL COMMENT '状态 0:禁用，1:正常',
  `user_id_create` bigint(255) DEFAULT NULL COMMENT '创建用户id',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  `sex` bigint(32) DEFAULT NULL COMMENT '性别',
  `birth` datetime DEFAULT NULL COMMENT '出身日期',
  `pic_id` bigint(32) DEFAULT NULL,
  `live_address` varchar(500) DEFAULT NULL COMMENT '现居住地',
  `hobby` varchar(255) DEFAULT NULL COMMENT '爱好',
  `province` varchar(255) DEFAULT NULL COMMENT '省份',
  `city` varchar(255) DEFAULT NULL COMMENT '所在城市',
  `district` varchar(255) DEFAULT NULL COMMENT '所在地区',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES ('1', 'admin', '超级管理员', '27bd386e70f280e24c2f4f2a549b82cf', '6', 'admin@example.com', '17699999999', '1', '1', '2017-08-15 21:40:39', '2017-08-15 21:41:00', '96', '2017-12-14 00:00:00', '138', 'ccc', '122;121;', '北京市', '北京市市辖区', '东城区');
INSERT INTO `sys_user` VALUES ('2', 'test', '临时用户', '6cf3bb3deba2aadbd41ec9a22511084e', '6', 'test@bootdo.com', null, '1', '1', '2017-08-14 13:43:05', '2017-08-14 21:15:36', null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('36', 'ldh', '刘德华', 'bfd9394475754fbe45866eba97738c36', '7', 'ldh@bootdo.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('123', 'zxy', '张学友', '35174ba93f5fe7267f1fb3c1bf903781', '6', 'zxy@bootdo', null, '0', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('124', 'wyf', '吴亦凡', 'e179e6f687bbd57b9d7efc4746c8090a', '6', 'wyf@bootdo.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('130', 'lh', '鹿晗', '7924710cd673f68967cde70e188bb097', '9', 'lh@bootdo.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('131', 'lhc', '令狐冲', 'd515538e17ecb570ba40344b5618f5d4', '6', 'lhc@bootdo.com', null, '0', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('132', 'lyf', '刘亦菲', '7fdb1d9008f45950c1620ba0864e5fbd', '13', 'lyf@bootdo.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('134', 'lyh', '李彦宏', 'dc26092b3244d9d432863f2738180e19', '8', 'lyh@bootdo.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('135', 'wjl', '王健林', '3967697dfced162cf6a34080259b83aa', '6', 'wjl@bootod.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `sys_user` VALUES ('136', 'gdg', '郭德纲', '3bb1bda86bc02bf6478cd91e42135d2f', '9', 'gdg@bootdo.com', null, '1', null, null, null, null, null, null, null, null, null, null, null);

-- ----------------------------
-- Table structure for `sys_user_plus`
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_plus`;
CREATE TABLE `sys_user_plus` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `payment` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sys_user_plus
-- ----------------------------

-- ----------------------------
-- Table structure for `sys_user_role`
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `role_id` bigint(20) DEFAULT NULL COMMENT '角色ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8 COMMENT='用户与角色对应关系';

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES ('73', '30', '48');
INSERT INTO `sys_user_role` VALUES ('74', '30', '49');
INSERT INTO `sys_user_role` VALUES ('75', '30', '50');
INSERT INTO `sys_user_role` VALUES ('76', '31', '48');
INSERT INTO `sys_user_role` VALUES ('77', '31', '49');
INSERT INTO `sys_user_role` VALUES ('78', '31', '52');
INSERT INTO `sys_user_role` VALUES ('79', '32', '48');
INSERT INTO `sys_user_role` VALUES ('80', '32', '49');
INSERT INTO `sys_user_role` VALUES ('81', '32', '50');
INSERT INTO `sys_user_role` VALUES ('82', '32', '51');
INSERT INTO `sys_user_role` VALUES ('83', '32', '52');
INSERT INTO `sys_user_role` VALUES ('84', '33', '38');
INSERT INTO `sys_user_role` VALUES ('85', '33', '49');
INSERT INTO `sys_user_role` VALUES ('86', '33', '52');
INSERT INTO `sys_user_role` VALUES ('87', '34', '50');
INSERT INTO `sys_user_role` VALUES ('88', '34', '51');
INSERT INTO `sys_user_role` VALUES ('89', '34', '52');
INSERT INTO `sys_user_role` VALUES ('106', '124', '1');
INSERT INTO `sys_user_role` VALUES ('110', '1', '1');
INSERT INTO `sys_user_role` VALUES ('111', '2', '1');
INSERT INTO `sys_user_role` VALUES ('113', '131', '48');
INSERT INTO `sys_user_role` VALUES ('117', '135', '1');
INSERT INTO `sys_user_role` VALUES ('120', '134', '1');
INSERT INTO `sys_user_role` VALUES ('121', '134', '48');
INSERT INTO `sys_user_role` VALUES ('123', '130', '1');
INSERT INTO `sys_user_role` VALUES ('124', null, '48');
INSERT INTO `sys_user_role` VALUES ('125', '132', '52');
INSERT INTO `sys_user_role` VALUES ('126', '132', '49');
INSERT INTO `sys_user_role` VALUES ('127', '123', '48');
INSERT INTO `sys_user_role` VALUES ('132', '36', '48');
