/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.http;

import android.os.SystemClock;
import java.io.IOException;
import java.net.UnknownHostException;
import net.tsz.afinal.core.AsyncTask;
import net.tsz.afinal.http.AjaxCallBack;
import net.tsz.afinal.http.entityhandler.EntityCallBack;
import net.tsz.afinal.http.entityhandler.FileEntityHandler;
import net.tsz.afinal.http.entityhandler.StringEntityHandler;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

public class AjaxRequestHandler<T>
extends AsyncTask<Object, Object, Object> {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private static final StringEntityHandler mStrEntityHandler = new StringEntityHandler();
    private static final FileEntityHandler mFileEntityHandler = new FileEntityHandler();
    private final AjaxCallBack<T> callback;
    private int executionCount = 0;
    private String targetUrl = null;
    private String charset;
    private static final int UPDATE_START = 1;
    private static final int UPDATE_LOADING = 2;
    private static final int UPDATE_FAILURE = 3;
    private static final int UPDATE_SUCCESS = 4;

    public AjaxRequestHandler(AbstractHttpClient client, HttpContext context, AjaxCallBack<T> callback, String charset) {
        this.client = client;
        this.context = context;
        this.callback = callback;
        this.charset = charset;
    }

    private void makeRequestWithRetries(HttpUriRequest request) throws IOException {
        boolean retry = true;
        IOException cause = null;
        HttpRequestRetryHandler retryHandler = this.client.getHttpRequestRetryHandler();
        while (retry) {
            try {
                if (!this.isCancelled()) {
                    HttpResponse response = this.client.execute(request, this.context);
                    if (!this.isCancelled()) {
                        this.handleResponse(response);
                    }
                }
                return;
            }
            catch (UnknownHostException e) {
                this.publishProgress(3, e, "unknownHostException\uff1acan't resolve host");
                return;
            }
            catch (IOException e) {
                cause = e;
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
            catch (NullPointerException e) {
                cause = new IOException("NPE in HttpClient" + e.getMessage());
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
            catch (Exception e) {
                cause = new IOException("Exception" + e.getMessage());
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
        }
        throw cause;
    }

    @Override
    protected Object doInBackground(Object ... params) {
        if (params != null && params.length == 2) {
            this.targetUrl = String.valueOf(params[1]);
        }
        try {
            this.publishProgress(1);
            this.makeRequestWithRetries((HttpUriRequest)params[0]);
        }
        catch (IOException e) {
            this.publishProgress(3, e, e == null ? "null" : e.getMessage());
        }
        return null;
    }

    @Override
    protected void onProgressUpdate(Object ... values) {
        int update = Integer.valueOf(String.valueOf(values[0]));
        switch (update) {
            case 1: {
                if (this.callback == null) break;
                this.callback.onStart();
                break;
            }
            case 2: {
                if (this.callback == null) break;
                this.callback.onLoading(Long.valueOf(String.valueOf(values[1])), Long.valueOf(String.valueOf(values[2])));
                break;
            }
            case 3: {
                if (this.callback == null) break;
                this.callback.onFailure((Throwable)values[1], (String)values[2]);
                break;
            }
            case 4: {
                if (this.callback == null) break;
                this.callback.onSuccess(values[1]);
                break;
            }
        }
        super.onProgressUpdate(values);
    }

    private void handleResponse(HttpResponse response) {
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() >= 300) {
            this.publishProgress(3, new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()), "response status code:" + status.getStatusCode());
        } else {
            try {
                HttpEntity temp = response.getEntity();
                Object responseBody = null;
                if (temp != null) {
                    responseBody = this.targetUrl != null ? mFileEntityHandler.handleEntity(temp, new EntityCallBackImpl(), this.targetUrl) : mStrEntityHandler.handleEntity(temp, new EntityCallBackImpl(), this.charset);
                }
                this.publishProgress(4, responseBody);
            }
            catch (IOException e) {
                this.publishProgress(3, e, null);
            }
        }
    }

    class EntityCallBackImpl
    implements EntityCallBack {
        private long time = SystemClock.uptimeMillis();

        @Override
        public void callBack(long count, long current) {
            long thisTime;
            if (AjaxRequestHandler.this.callback != null && AjaxRequestHandler.this.callback.isProgress() && (thisTime = SystemClock.uptimeMillis()) - this.time > (long)AjaxRequestHandler.this.callback.getRate()) {
                this.time = thisTime;
                AjaxRequestHandler.this.publishProgress(new Object[]{2, count, current});
            }
        }
    }
}

