/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.widget.ImageView;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.tsz.afinal.bitmap.core.BitmapCache;
import net.tsz.afinal.bitmap.core.BitmapCommonUtils;
import net.tsz.afinal.bitmap.core.BitmapDisplayConfig;
import net.tsz.afinal.bitmap.core.BitmapProcess;
import net.tsz.afinal.bitmap.display.Displayer;
import net.tsz.afinal.bitmap.display.SimpleDisplayer;
import net.tsz.afinal.bitmap.download.Downloader;
import net.tsz.afinal.bitmap.download.SimpleHttpDownloader;
import net.tsz.afinal.common.AsyncTask;

public class FinalBitmap {
    private FinalBitmapConfig mConfig;
    private static BitmapCache mImageCache;
    private boolean mExitTasksEarly = false;
    private boolean mPauseWork = false;
    private final Object mPauseWorkLock = new Object();
    private Context mContext;
    private static ExecutorService bitmapLoadAndDisplayExecutor;
    private HashMap<String, BitmapDisplayConfig> configMap = new HashMap();

    public FinalBitmap(Context context) {
        this.mContext = context;
        this.mConfig = new FinalBitmapConfig(context);
        this.configDiskCachePath(BitmapCommonUtils.getDiskCacheDir(context, "afinalCache"));
        this.configDisplayer(new SimpleDisplayer());
        this.configDownlader(new SimpleHttpDownloader());
    }

    public FinalBitmap configLoadingImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadingImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configLoadfailImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadfailImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configDiskCachePath(String strPath) {
        if (!TextUtils.isEmpty((CharSequence)strPath)) {
            this.mConfig.cachePath = strPath;
        }
        return this;
    }

    public FinalBitmap configDiskCachePath(File pathFile) {
        if (pathFile != null) {
            this.configDiskCachePath(pathFile.getAbsolutePath());
        }
        return this;
    }

    public FinalBitmap configBitmapMaxHeight(int bitmapHeight) {
        this.mConfig.defaultDisplayConfig.setBitmapHeight(bitmapHeight);
        return this;
    }

    public FinalBitmap configBitmapMaxWidth(int bitmapWidth) {
        this.mConfig.defaultDisplayConfig.setBitmapWidth(bitmapWidth);
        return this;
    }

    public FinalBitmap configDownlader(Downloader downlader) {
        this.mConfig.downloader = downlader;
        return this;
    }

    public FinalBitmap configDisplayer(Displayer displayer) {
        this.mConfig.displayer = displayer;
        return this;
    }

    public FinalBitmap configMemoryCacheSize(int size) {
        this.mConfig.memCacheSize = size;
        return this;
    }

    public FinalBitmap configMemoryCachePercent(float percent) {
        this.mConfig.memCacheSizePercent = percent;
        return this;
    }

    public FinalBitmap configDiskCacheSize(int size) {
        this.mConfig.diskCacheSize = size;
        return this;
    }

    public FinalBitmap configOriginalDiskCacheSize(int size) {
        this.mConfig.diskCacheSize = size;
        return this;
    }

    public FinalBitmap configBitmapLoadThreadSize(int size) {
        if (size >= 1) {
            this.mConfig.poolSize = size;
        }
        return this;
    }

    public FinalBitmap init() {
        this.mConfig.init();
        BitmapCache.ImageCacheParams imageCacheParams = new BitmapCache.ImageCacheParams(this.mConfig.cachePath);
        if ((double)this.mConfig.memCacheSizePercent > 0.05 && (double)this.mConfig.memCacheSizePercent < 0.8) {
            imageCacheParams.setMemCacheSizePercent(this.mContext, this.mConfig.memCacheSizePercent);
        } else if (this.mConfig.memCacheSize > 0x200000) {
            imageCacheParams.setMemCacheSize(this.mConfig.memCacheSize);
        } else {
            imageCacheParams.setMemCacheSizePercent(this.mContext, 0.3f);
        }
        if (this.mConfig.diskCacheSize > 0x500000) {
            imageCacheParams.setDiskCacheSize(this.mConfig.diskCacheSize);
        }
        mImageCache = new BitmapCache(imageCacheParams);
        bitmapLoadAndDisplayExecutor = Executors.newFixedThreadPool(this.mConfig.poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(4);
                return t;
            }
        });
        new CacheExecutecTask().execute(1);
        return this;
    }

    public void display(ImageView imageView, String uri) {
        this.doDisplay(imageView, uri, null);
    }

    public void display(ImageView imageView, String uri, int imageWidth, int imageHeight) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(imageWidth) + "_" + imageHeight);
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setBitmapHeight(imageHeight);
            displayConfig.setBitmapWidth(imageWidth);
            this.configMap.put(String.valueOf(imageWidth) + "_" + imageHeight, displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, Bitmap loadingBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(loadingBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setLoadingBitmap(loadingBitmap);
            this.configMap.put(String.valueOf(loadingBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(String.valueOf(loadingBitmap)) + "_" + String.valueOf(laodfailBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setLoadingBitmap(loadingBitmap);
            displayConfig.setLoadfailBitmap(laodfailBitmap);
            this.configMap.put(String.valueOf(String.valueOf(loadingBitmap)) + "_" + String.valueOf(laodfailBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, int imageWidth, int imageHeight, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(imageWidth) + "_" + imageHeight + "_" + String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setBitmapHeight(imageHeight);
            displayConfig.setBitmapWidth(imageWidth);
            displayConfig.setLoadingBitmap(loadingBitmap);
            displayConfig.setLoadfailBitmap(laodfailBitmap);
            this.configMap.put(String.valueOf(imageWidth) + "_" + imageHeight + "_" + String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, BitmapDisplayConfig config) {
        this.doDisplay(imageView, uri, config);
    }

    private void doDisplay(ImageView imageView, String uri, BitmapDisplayConfig displayConfig) {
        if (TextUtils.isEmpty((CharSequence)uri) || imageView == null) {
            return;
        }
        if (displayConfig == null) {
            displayConfig = this.mConfig.defaultDisplayConfig;
        }
        Bitmap bitmap = null;
        if (mImageCache != null) {
            bitmap = mImageCache.getBitmapFromMemCache(uri);
        }
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        } else if (FinalBitmap.checkImageTask(uri, imageView)) {
            BitmapLoadAndDisplayTask task = new BitmapLoadAndDisplayTask(imageView, displayConfig);
            AsyncDrawable asyncDrawable = new AsyncDrawable(this.mContext.getResources(), displayConfig.getLoadingBitmap(), task);
            imageView.setImageDrawable((Drawable)asyncDrawable);
            task.executeOnExecutor(bitmapLoadAndDisplayExecutor, uri);
        }
    }

    private BitmapDisplayConfig getDisplayConfig() {
        BitmapDisplayConfig config = new BitmapDisplayConfig();
        config.setAnimation(this.mConfig.defaultDisplayConfig.getAnimation());
        config.setAnimationType(this.mConfig.defaultDisplayConfig.getAnimationType());
        config.setBitmapHeight(this.mConfig.defaultDisplayConfig.getBitmapHeight());
        config.setBitmapWidth(this.mConfig.defaultDisplayConfig.getBitmapWidth());
        config.setLoadfailBitmap(this.mConfig.defaultDisplayConfig.getLoadfailBitmap());
        config.setLoadingBitmap(this.mConfig.defaultDisplayConfig.getLoadingBitmap());
        return config;
    }

    private void initDiskCacheInternal() {
        if (mImageCache != null) {
            mImageCache.initDiskCache();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.initHttpDiskCache();
        }
    }

    private void clearCacheInternal() {
        if (mImageCache != null) {
            mImageCache.clearCache();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.clearCacheInternal();
        }
    }

    private void flushCacheInternal() {
        if (mImageCache != null) {
            mImageCache.flush();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.flushCacheInternal();
        }
    }

    private void closeCacheInternal() {
        if (mImageCache != null) {
            mImageCache.close();
            mImageCache = null;
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.clearCacheInternal();
        }
    }

    private Bitmap processBitmap(String uri, BitmapDisplayConfig config) {
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            return this.mConfig.bitmapProcess.processBitmap(uri, config);
        }
        return null;
    }

    public void setExitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
    }

    public void onResume() {
        this.setExitTasksEarly(false);
    }

    public void onPause() {
        this.setExitTasksEarly(true);
        this.flushCache();
    }

    public void onDestroy() {
        this.closeCache();
    }

    public void clearCache() {
        new CacheExecutecTask().execute(0);
    }

    public void flushCache() {
        new CacheExecutecTask().execute(2);
    }

    public void closeCache() {
        new CacheExecutecTask().execute(3);
    }

    public void exitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
        if (exitTasksEarly) {
            this.pauseWork(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWork(boolean pauseWork) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pauseWork;
            if (!this.mPauseWork) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    private static BitmapLoadAndDisplayTask getBitmapTaskFromImageView(ImageView imageView) {
        Drawable drawable;
        if (imageView != null && (drawable = imageView.getDrawable()) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    public static boolean checkImageTask(Object data, ImageView imageView) {
        BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapTaskFromImageView(imageView);
        if (bitmapWorkerTask != null) {
            Object bitmapData = bitmapWorkerTask.data;
            if (bitmapData == null || !bitmapData.equals(data)) {
                bitmapWorkerTask.cancel(true);
            } else {
                return false;
            }
        }
        return true;
    }

    private static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapLoadAndDisplayTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapLoadAndDisplayTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapLoadAndDisplayTask>(bitmapWorkerTask);
        }

        public BitmapLoadAndDisplayTask getBitmapWorkerTask() {
            return (BitmapLoadAndDisplayTask)this.bitmapWorkerTaskReference.get();
        }
    }

    private class BitmapLoadAndDisplayTask
    extends AsyncTask<Object, Void, Bitmap> {
        private Object data;
        private final WeakReference<ImageView> imageViewReference;
        private final BitmapDisplayConfig displayConfig;

        public BitmapLoadAndDisplayTask(ImageView imageView, BitmapDisplayConfig config) {
            this.imageViewReference = new WeakReference<ImageView>(imageView);
            this.displayConfig = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Bitmap doInBackground(Object ... params) {
            this.data = params[0];
            String dataString = String.valueOf(this.data);
            Bitmap bitmap = null;
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                while (FinalBitmap.this.mPauseWork && !this.isCancelled()) {
                    try {
                        FinalBitmap.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (mImageCache != null && !this.isCancelled() && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly) {
                bitmap = mImageCache.getBitmapFromDiskCache(dataString);
            }
            if (bitmap == null && !this.isCancelled() && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly) {
                bitmap = FinalBitmap.this.processBitmap(dataString, this.displayConfig);
            }
            if (bitmap != null && mImageCache != null) {
                mImageCache.addBitmapToCache(dataString, bitmap);
            }
            return bitmap;
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {
            if (this.isCancelled() || FinalBitmap.this.mExitTasksEarly) {
                bitmap = null;
            }
            ImageView imageView = this.getAttachedImageView();
            if (bitmap != null && imageView != null) {
                ((FinalBitmap)FinalBitmap.this).mConfig.displayer.loadCompletedisplay(imageView, bitmap, this.displayConfig);
            } else if (bitmap == null && imageView != null) {
                ((FinalBitmap)FinalBitmap.this).mConfig.displayer.loadFailDisplay(imageView, this.displayConfig.getLoadfailBitmap());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCancelled(Bitmap bitmap) {
            super.onCancelled(bitmap);
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                FinalBitmap.this.mPauseWorkLock.notifyAll();
            }
        }

        private ImageView getAttachedImageView() {
            ImageView imageView = (ImageView)this.imageViewReference.get();
            BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapTaskFromImageView(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }
    }

    private class CacheExecutecTask
    extends AsyncTask<Object, Void, Void> {
        public static final int MESSAGE_CLEAR = 0;
        public static final int MESSAGE_INIT_DISK_CACHE = 1;
        public static final int MESSAGE_FLUSH = 2;
        public static final int MESSAGE_CLOSE = 3;

        private CacheExecutecTask() {
        }

        @Override
        protected Void doInBackground(Object ... params) {
            switch ((Integer)params[0]) {
                case 0: {
                    FinalBitmap.this.clearCacheInternal();
                    break;
                }
                case 1: {
                    FinalBitmap.this.initDiskCacheInternal();
                    break;
                }
                case 2: {
                    FinalBitmap.this.flushCacheInternal();
                    break;
                }
                case 3: {
                    FinalBitmap.this.closeCacheInternal();
                }
            }
            return null;
        }
    }

    private class FinalBitmapConfig {
        public String cachePath;
        public Displayer displayer;
        public Downloader downloader;
        public BitmapProcess bitmapProcess;
        public BitmapDisplayConfig defaultDisplayConfig = new BitmapDisplayConfig();
        public float memCacheSizePercent;
        public int memCacheSize;
        public int diskCacheSize;
        public int poolSize = 3;
        public int originalDiskCache = 0x1400000;

        public FinalBitmapConfig(Context context) {
            this.defaultDisplayConfig.setAnimation(null);
            this.defaultDisplayConfig.setAnimationType(1);
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int defaultWidth = (int)Math.floor(displayMetrics.widthPixels / 3);
            this.defaultDisplayConfig.setBitmapHeight(defaultWidth);
            this.defaultDisplayConfig.setBitmapWidth(defaultWidth);
        }

        public void init() {
            if (this.downloader == null) {
                this.downloader = new SimpleHttpDownloader();
            }
            if (this.displayer == null) {
                this.displayer = new SimpleDisplayer();
            }
            this.bitmapProcess = new BitmapProcess(this.downloader, this.cachePath, this.originalDiskCache);
        }
    }
}

