/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.tsz.afinal.bitmap.core.BitmapCommonUtils;
import net.tsz.afinal.bitmap.core.FileNameGenerator;
import net.tsz.afinal.bitmap.core.LruDiskCache;
import net.tsz.afinal.bitmap.core.LruMemoryCache;

public class BitmapCache {
    private static final String TAG = "ImageCache";
    private static final int DEFAULT_MEM_CACHE_SIZE = 0x800000;
    private static final int DEFAULT_DISK_CACHE_SIZE = 0x1400000;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int DEFAULT_COMPRESS_QUALITY = 70;
    private static final int DISK_CACHE_INDEX = 0;
    private static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
    private static final boolean DEFAULT_DISK_CACHE_ENABLED = true;
    private static final boolean DEFAULT_CLEAR_DISK_CACHE_ON_START = false;
    private static final boolean DEFAULT_INIT_DISK_CACHE_ON_CREATE = false;
    private LruDiskCache mDiskLruCache;
    private LruMemoryCache<String, Bitmap> mMemoryCache;
    private ImageCacheParams mCacheParams;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;

    public BitmapCache(ImageCacheParams cacheParams) {
        this.init(cacheParams);
    }

    private void init(ImageCacheParams cacheParams) {
        this.mCacheParams = cacheParams;
        if (this.mCacheParams.memoryCacheEnabled) {
            this.mMemoryCache = new LruMemoryCache<String, Bitmap>(this.mCacheParams.memCacheSize){

                @Override
                protected int sizeOf(String key, Bitmap bitmap) {
                    return BitmapCommonUtils.getBitmapSize(bitmap);
                }
            };
        }
        if (cacheParams.initDiskCacheOnCreate) {
            this.initDiskCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) {
                File diskCacheDir = this.mCacheParams.diskCacheDir;
                if (this.mCacheParams.diskCacheEnabled && diskCacheDir != null) {
                    if (!diskCacheDir.exists()) {
                        diskCacheDir.mkdirs();
                    }
                    if (BitmapCommonUtils.getUsableSpace(diskCacheDir) > (long)this.mCacheParams.diskCacheSize) {
                        try {
                            this.mDiskLruCache = LruDiskCache.open(diskCacheDir, 1, 1, this.mCacheParams.diskCacheSize);
                        }
                        catch (IOException e) {
                            this.mCacheParams.diskCacheDir = null;
                            Log.e((String)TAG, (String)("initDiskCache - " + e));
                        }
                    }
                }
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBitmapToCache(String data, Bitmap bitmap) {
        if (data == null || bitmap == null) {
            return;
        }
        if (this.mMemoryCache != null && this.mMemoryCache.get(data) == null) {
            this.mMemoryCache.put(data, bitmap);
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            block27: {
                if (this.mDiskLruCache != null) {
                    String key = FileNameGenerator.generator(data);
                    OutputStream out = null;
                    try {
                        LruDiskCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                        if (snapshot == null) {
                            LruDiskCache.Editor editor = this.mDiskLruCache.edit(key);
                            if (editor != null) {
                                out = editor.newOutputStream(0);
                                bitmap.compress(this.mCacheParams.compressFormat, this.mCacheParams.compressQuality, out);
                                editor.commit();
                                out.close();
                            }
                        } else {
                            snapshot.getInputStream(0).close();
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)("addBitmapToCache - " + e));
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block27;
                        }
                        catch (IOException iOException) {}
                        break block27;
                    }
                    catch (Exception e) {
                        try {
                            Log.e((String)TAG, (String)("addBitmapToCache - " + e));
                            break block27;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Bitmap getBitmapFromMemCache(String data) {
        Bitmap memBitmap;
        if (this.mMemoryCache != null && (memBitmap = this.mMemoryCache.get(data)) != null) {
            return memBitmap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmapFromDiskCache(String data) {
        String key = FileNameGenerator.generator(data);
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            block22: {
                Bitmap bitmap;
                InputStream inputStream;
                while (true) {
                    if (!this.mDiskCacheStarting) {
                        if (this.mDiskLruCache == null) break block22;
                        inputStream = null;
                        try {
                            LruDiskCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                            if (snapshot != null && (inputStream = snapshot.getInputStream(0)) != null) {
                                Bitmap bitmap2;
                                bitmap = bitmap2 = BitmapFactory.decodeStream((InputStream)inputStream);
                                break;
                            }
                            break block22;
                        }
                        catch (IOException e) {
                            Log.e((String)TAG, (String)("getBitmapFromDiskCache - " + e));
                            break block22;
                        }
                    }
                    try {
                        this.mDiskCacheLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return bitmap;
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("clearCache - " + e));
                }
                this.mDiskLruCache = null;
                this.initDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("close - " + e));
                }
            }
        }
    }

    static /* synthetic */ Bitmap.CompressFormat access$0() {
        return DEFAULT_COMPRESS_FORMAT;
    }

    public static class ImageCacheParams {
        public int memCacheSize = 0x800000;
        public int diskCacheSize = 0x1400000;
        public File diskCacheDir;
        public Bitmap.CompressFormat compressFormat = BitmapCache.access$0();
        public int compressQuality = 70;
        public boolean memoryCacheEnabled = true;
        public boolean diskCacheEnabled = true;
        public boolean clearDiskCacheOnStart = false;
        public boolean initDiskCacheOnCreate = false;

        public ImageCacheParams(File diskCacheDir) {
            this.diskCacheDir = diskCacheDir;
        }

        public ImageCacheParams(String diskCacheDir) {
            this.diskCacheDir = new File(diskCacheDir);
        }

        public void setMemCacheSizePercent(Context context, float percent) {
            if (percent < 0.05f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.05 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.round(percent * (float)ImageCacheParams.getMemoryClass(context) * 1024.0f * 1024.0f);
        }

        public void setMemCacheSize(int memCacheSize) {
            this.memCacheSize = memCacheSize;
        }

        public void setDiskCacheSize(int diskCacheSize) {
            this.diskCacheSize = diskCacheSize;
        }

        private static int getMemoryClass(Context context) {
            return ((ActivityManager)context.getSystemService("activity")).getMemoryClass();
        }
    }
}

