/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class BitmapCommonUtils {
    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) ? BitmapCommonUtils.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        return new File(String.valueOf(cachePath) + File.separator + uniqueName);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static File getExternalCacheDir(Context context) {
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + cacheDir);
    }

    public static long getUsableSpace(File path) {
        StatFs stats = new StatFs(path.getPath());
        return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
    }
}

