/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.db.sqlite;

import android.database.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.tsz.afinal.db.sqlite.DbModel;
import net.tsz.afinal.db.table.Property;
import net.tsz.afinal.db.table.TableInfo;

public class CursorUtils {
    public static <T> T getEntity(Cursor cursor, Class<T> clazz) {
        try {
            if (cursor != null) {
                TableInfo table = TableInfo.get(clazz);
                int columnCount = cursor.getColumnCount();
                if (columnCount > 0) {
                    T entity = clazz.newInstance();
                    int i = 0;
                    while (i < columnCount) {
                        String column = cursor.getColumnName(i);
                        Property property = table.propertyMap.get(column);
                        if (property != null) {
                            property.setValue(entity, cursor.getString(i));
                        } else if (table.getId().getColumn().equals(column)) {
                            table.getId().setValue(entity, cursor.getString(i));
                        }
                        ++i;
                    }
                    return entity;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static DbModel getDbModel(Cursor cursor) {
        if (cursor != null && cursor.getColumnCount() > 0) {
            DbModel model = new DbModel();
            int columnCount = cursor.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                model.set(cursor.getColumnName(i), cursor.getString(i));
                ++i;
            }
            return model;
        }
        return null;
    }

    public static <T> T dbModel2Entity(DbModel dbModel, Class<?> clazz) {
        if (dbModel != null) {
            HashMap<String, Object> dataMap = dbModel.getDataMap();
            try {
                Object entity = clazz.newInstance();
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String column = entry.getKey();
                    TableInfo table = TableInfo.get(clazz);
                    Property property = table.propertyMap.get(column);
                    if (property != null) {
                        property.setValue(entity, entry.getValue() == null ? null : entry.getValue().toString());
                        continue;
                    }
                    if (!table.getId().getColumn().equals(column)) continue;
                    table.getId().setValue(entity, entry.getValue() == null ? null : entry.getValue().toString());
                }
                return (T)entity;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

