/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.tsz.afinal.http.AjaxCallBack;
import net.tsz.afinal.http.AjaxParams;
import net.tsz.afinal.http.AjaxRequestHandler;
import net.tsz.afinal.http.RetryHandler;
import net.tsz.afinal.http.SyncRequestHandler;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

public class FinalHttp {
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static int maxConnections = 10;
    private static int socketTimeout = 10000;
    private static int maxRetries = 5;
    private final DefaultHttpClient httpClient;
    private final HttpContext httpContext;
    private String charset = "utf-8";
    private final Map<String, String> clientHeaderMap;

    public FinalHttp() {
        BasicHttpParams httpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)socketTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)socketTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)socketTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)httpParams, schemeRegistry);
        this.httpContext = new SyncBasicHttpContext((HttpContext)new BasicHttpContext());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                if (!request.containsHeader(FinalHttp.HEADER_ACCEPT_ENCODING)) {
                    request.addHeader(FinalHttp.HEADER_ACCEPT_ENCODING, FinalHttp.ENCODING_GZIP);
                }
                for (String header : FinalHttp.this.clientHeaderMap.keySet()) {
                    request.addHeader(header, (String)FinalHttp.this.clientHeaderMap.get(header));
                }
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return;
                }
                Header encoding = entity.getContentEncoding();
                if (encoding != null) {
                    HeaderElement[] headerElementArray = encoding.getElements();
                    int n = headerElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HeaderElement element = headerElementArray[n2];
                        if (element.getName().equalsIgnoreCase(FinalHttp.ENCODING_GZIP)) {
                            response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(maxRetries));
        this.clientHeaderMap = new HashMap<String, String>();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void configCharset(String charSet) {
        if (charSet != null && charSet.trim().length() != 0) {
            this.charset = charSet;
        }
    }

    public void configCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public void configUserAgent(String userAgent) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)userAgent);
    }

    public void configTimeout(int timeout) {
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
    }

    public void configSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        Scheme scheme = new Scheme("https", (SocketFactory)sslSocketFactory, 443);
        this.httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
    }

    public void configRequestExecutionRetryCount(int count) {
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(count));
    }

    public void addHeader(String header, String value) {
        this.clientHeaderMap.put(header, value);
    }

    public void get(String url, AjaxCallBack<? extends Object> callBack) {
        this.get(url, null, callBack);
    }

    public void get(String url, AjaxParams params, AjaxCallBack<? extends Object> callBack) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpGet(FinalHttp.getUrlWithQueryString(url, params)), null, callBack);
    }

    public void get(String url, Header[] headers, AjaxParams params, AjaxCallBack<? extends Object> callBack) {
        HttpGet request = new HttpGet(FinalHttp.getUrlWithQueryString(url, params));
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, null, callBack);
    }

    public Object getSync(String url) {
        return this.getSync(url, null);
    }

    public Object getSync(String url, AjaxParams params) {
        HttpGet request = new HttpGet(FinalHttp.getUrlWithQueryString(url, params));
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, null);
    }

    public Object getSync(String url, Header[] headers, AjaxParams params) {
        HttpGet request = new HttpGet(FinalHttp.getUrlWithQueryString(url, params));
        if (headers != null) {
            request.setHeaders(headers);
        }
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, null);
    }

    public void post(String url, AjaxCallBack<? extends Object> callBack) {
        this.post(url, null, callBack);
    }

    public void post(String url, AjaxParams params, AjaxCallBack<? extends Object> callBack) {
        this.post(url, this.paramsToEntity(params), null, callBack);
    }

    public void post(String url, HttpEntity entity, String contentType, AjaxCallBack<? extends Object> callBack) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(url), entity), contentType, callBack);
    }

    public void post(String url, Header[] headers, AjaxParams params, String contentType, AjaxCallBack<? extends Object> callBack) {
        HttpPost request = new HttpPost(url);
        if (params != null) {
            request.setEntity(this.paramsToEntity(params));
        }
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType, callBack);
    }

    public void post(String url, Header[] headers, HttpEntity entity, String contentType, AjaxCallBack<? extends Object> callBack) {
        HttpEntityEnclosingRequestBase request = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(url), entity);
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType, callBack);
    }

    public Object postSync(String url) {
        return this.postSync(url, null);
    }

    public Object postSync(String url, AjaxParams params) {
        return this.postSync(url, this.paramsToEntity(params), null);
    }

    public Object postSync(String url, HttpEntity entity, String contentType) {
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(url), entity), contentType);
    }

    public Object postSync(String url, Header[] headers, AjaxParams params, String contentType) {
        HttpPost request = new HttpPost(url);
        if (params != null) {
            request.setEntity(this.paramsToEntity(params));
        }
        if (headers != null) {
            request.setHeaders(headers);
        }
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType);
    }

    public Object postSync(String url, Header[] headers, HttpEntity entity, String contentType) {
        HttpEntityEnclosingRequestBase request = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(url), entity);
        if (headers != null) {
            request.setHeaders(headers);
        }
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType);
    }

    public void put(String url, AjaxCallBack<? extends Object> callBack) {
        this.put(url, null, callBack);
    }

    public void put(String url, AjaxParams params, AjaxCallBack<? extends Object> callBack) {
        this.put(url, this.paramsToEntity(params), null, callBack);
    }

    public void put(String url, HttpEntity entity, String contentType, AjaxCallBack<? extends Object> callBack) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(url), entity), contentType, callBack);
    }

    public void put(String url, Header[] headers, HttpEntity entity, String contentType, AjaxCallBack<? extends Object> callBack) {
        HttpEntityEnclosingRequestBase request = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(url), entity);
        if (headers != null) {
            request.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType, callBack);
    }

    public Object putSync(String url) {
        return this.putSync(url, null);
    }

    public Object putSync(String url, AjaxParams params) {
        return this.putSync(url, this.paramsToEntity(params), null);
    }

    public Object putSync(String url, HttpEntity entity, String contentType) {
        return this.putSync(url, null, entity, contentType);
    }

    public Object putSync(String url, Header[] headers, HttpEntity entity, String contentType) {
        HttpEntityEnclosingRequestBase request = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(url), entity);
        if (headers != null) {
            request.setHeaders(headers);
        }
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)request, contentType);
    }

    public void delete(String url, AjaxCallBack<? extends Object> callBack) {
        HttpDelete delete = new HttpDelete(url);
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)delete, null, callBack);
    }

    public void delete(String url, Header[] headers, AjaxCallBack<? extends Object> callBack) {
        HttpDelete delete = new HttpDelete(url);
        if (headers != null) {
            delete.setHeaders(headers);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)delete, null, callBack);
    }

    public Object deleteSync(String url) {
        return this.deleteSync(url, null);
    }

    public Object deleteSync(String url, Header[] headers) {
        HttpDelete delete = new HttpDelete(url);
        if (headers != null) {
            delete.setHeaders(headers);
        }
        return this.sendSyncRequest(this.httpClient, this.httpContext, (HttpUriRequest)delete, null);
    }

    public void download(String url, String target, AjaxCallBack<File> callback) {
        HttpGet get = new HttpGet(url);
        new AjaxRequestHandler((AbstractHttpClient)this.httpClient, this.httpContext, callback, this.charset).executeOnExecutor(AjaxRequestHandler.DUAL_THREAD_EXECUTOR, get, target);
    }

    public void download(String url, AjaxParams params, String target, AjaxCallBack<File> callback) {
        HttpGet get = new HttpGet(FinalHttp.getUrlWithQueryString(url, params));
        new AjaxRequestHandler((AbstractHttpClient)this.httpClient, this.httpContext, callback, this.charset).executeOnExecutor(AjaxRequestHandler.DUAL_THREAD_EXECUTOR, get, target);
    }

    protected <T> void sendRequest(DefaultHttpClient client, HttpContext httpContext, HttpUriRequest uriRequest, String contentType, AjaxCallBack<T> ajaxCallBack) {
        if (contentType != null) {
            uriRequest.addHeader("Content-Type", contentType);
        }
        new AjaxRequestHandler((AbstractHttpClient)client, httpContext, ajaxCallBack, this.charset).executeOnExecutor(AjaxRequestHandler.DUAL_THREAD_EXECUTOR, uriRequest);
    }

    protected Object sendSyncRequest(DefaultHttpClient client, HttpContext httpContext, HttpUriRequest uriRequest, String contentType) {
        if (contentType != null) {
            uriRequest.addHeader("Content-Type", contentType);
        }
        return new SyncRequestHandler((AbstractHttpClient)client, httpContext, this.charset).sendRequest(uriRequest);
    }

    public static String getUrlWithQueryString(String url, AjaxParams params) {
        if (params != null) {
            String paramString = params.getParamString();
            url = String.valueOf(url) + "?" + paramString;
        }
        return url;
    }

    private HttpEntity paramsToEntity(AjaxParams params) {
        HttpEntity entity = null;
        if (params != null) {
            entity = params.getEntity();
        }
        return entity;
    }

    private HttpEntityEnclosingRequestBase addEntityToRequestBase(HttpEntityEnclosingRequestBase requestBase, HttpEntity entity) {
        if (entity != null) {
            requestBase.setEntity(entity);
        }
        return requestBase;
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

