/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.tsz.afinal.db.sqlite.CursorUtils;
import net.tsz.afinal.db.sqlite.DbModel;
import net.tsz.afinal.db.sqlite.SqlBuilder;
import net.tsz.afinal.db.sqlite.SqlInfo;
import net.tsz.afinal.db.table.KeyValue;
import net.tsz.afinal.db.table.ManyToOne;
import net.tsz.afinal.db.table.OneToMany;
import net.tsz.afinal.db.table.TableInfo;

public class FinalDb {
    private static final String TAG = "FinalDb";
    private static HashMap<String, FinalDb> daoMap = new HashMap();
    private SQLiteDatabase db;
    private DaoConfig config;

    private FinalDb(DaoConfig config) {
        if (config == null) {
            throw new RuntimeException("daoConfig is null");
        }
        if (config.getContext() == null) {
            throw new RuntimeException("android context is null");
        }
        this.db = new SqliteDbHelper(config.getContext().getApplicationContext(), config.getDbName(), config.getDbVersion(), config.getDbUpdateListener()).getWritableDatabase();
        this.config = config;
    }

    private static synchronized FinalDb getInstance(DaoConfig daoConfig) {
        FinalDb dao = daoMap.get(daoConfig.getDbName());
        if (dao == null) {
            dao = new FinalDb(daoConfig);
            daoMap.put(daoConfig.getDbName(), dao);
        }
        return dao;
    }

    public static FinalDb create(Context context) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDebug(isDebug);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, String dbName) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug, int dbVersion, DbUpdateListener dbUpdateListener) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        config.setDbVersion(dbVersion);
        config.setDbUpdateListener(dbUpdateListener);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(DaoConfig daoConfig) {
        return FinalDb.getInstance(daoConfig);
    }

    public void save(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildInsertSql(entity));
    }

    public boolean saveBindId(Object entity) {
        this.checkTableExist(entity.getClass());
        List<KeyValue> entityKvList = SqlBuilder.getSaveKeyValueListByEntity(entity);
        if (entityKvList != null && entityKvList.size() > 0) {
            TableInfo tf = TableInfo.get(entity.getClass());
            ContentValues cv = new ContentValues();
            this.insertContentValues(entityKvList, cv);
            Long id = this.db.insert(tf.getTableName(), null, cv);
            if (id == -1L) {
                return false;
            }
            tf.getId().setValue(entity, id);
            return true;
        }
        return false;
    }

    private void insertContentValues(List<KeyValue> list, ContentValues cv) {
        if (list != null && cv != null) {
            for (KeyValue kv : list) {
                cv.put(kv.getKey(), kv.getValue().toString());
            }
        } else {
            Log.w((String)TAG, (String)"insertContentValues: List<KeyValue> is empty or ContentValues is empty!");
        }
    }

    public void update(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(entity));
    }

    public void update(Object entity, String strWhere) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(entity, strWhere));
    }

    public void delete(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(entity));
    }

    public void deleteById(Class<?> clazz, Object id) {
        this.checkTableExist(clazz);
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(clazz, id));
    }

    public void deleteByWhere(Class<?> clazz, String strWhere) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.buildDeleteSql(clazz, strWhere);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    private void exeSqlInfo(SqlInfo sqlInfo) {
        if (sqlInfo != null) {
            this.debugSql(sqlInfo.getSql());
            this.db.execSQL(sqlInfo.getSql(), sqlInfo.getBindArgsAsArray());
        } else {
            Log.e((String)TAG, (String)"sava error:sqlInfo is null");
        }
    }

    public <T> T findById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        SqlInfo sqlInfo = SqlBuilder.getSelectSqlAsSqlInfo(clazz, id);
        if (sqlInfo != null) {
            this.debugSql(sqlInfo.getSql());
            Cursor cursor = this.db.rawQuery(sqlInfo.getSql(), sqlInfo.getBindArgsAsStringArray());
            try {
                if (cursor.moveToNext()) {
                    T t = CursorUtils.getEntity(cursor, clazz);
                    return t;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public <T> T findWithManyToOneById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<ManyToOne> manys = TableInfo.get(clazz).manyToOneMap.values();
                    for (ManyToOne many : manys) {
                        Object manyEntity;
                        Object obj = dbModel.get(many.getColumn());
                        if (obj == null || (manyEntity = this.findById(Integer.valueOf(obj.toString()), many.getDataType())) == null) continue;
                        many.setValue(entity, manyEntity);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> T findWithManyToOneById(Object id, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<ManyToOne> manys = TableInfo.get(clazz).manyToOneMap.values();
                    for (ManyToOne many : manys) {
                        Object manyEntity;
                        boolean isFind = false;
                        Class<?>[] classArray = findClass;
                        int n = findClass.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> mClass = classArray[n2];
                            if (many.getManyClass() == mClass) {
                                isFind = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!isFind || (manyEntity = this.findById(dbModel.get(many.getColumn()), many.getDataType())) == null) continue;
                        many.setValue(entity, manyEntity);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> T findWithOneToManyById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<OneToMany> ones = TableInfo.get(clazz).oneToManyMap.values();
                    for (OneToMany one : ones) {
                        List<?> list = this.findAllByWhere(one.getOneClass(), String.valueOf(one.getColumn()) + "=" + id);
                        if (list == null) continue;
                        one.setValue(entity, list);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> T findWithOneToManyById(Object id, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<OneToMany> ones = TableInfo.get(clazz).oneToManyMap.values();
                    for (OneToMany one : ones) {
                        List<?> list;
                        boolean isFind = false;
                        Class<?>[] classArray = findClass;
                        int n = findClass.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> mClass = classArray[n2];
                            if (one.getOneClass().equals(mClass.getName())) {
                                isFind = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!isFind || (list = this.findAllByWhere(one.getOneClass(), String.valueOf(one.getColumn()) + "=" + id)) == null) continue;
                        one.setValue(entity, list);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> List<T> findAll(Class<T> clazz) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQL(clazz));
    }

    public <T> List<T> findAll(Class<T> clazz, String orderBy) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, String.valueOf(SqlBuilder.getSelectSQL(clazz)) + " ORDER BY " + orderBy + " DESC");
    }

    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQLByWhere(clazz, strWhere));
    }

    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere, String orderBy) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, String.valueOf(SqlBuilder.getSelectSQLByWhere(clazz, strWhere)) + " ORDER BY '" + orderBy + "' DESC");
    }

    private <T> List<T> findAllBySql(Class<T> clazz, String strSQL) {
        this.checkTableExist(clazz);
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            ArrayList<T> list = new ArrayList<T>();
            while (cursor.moveToNext()) {
                T t = CursorUtils.getEntity(cursor, clazz);
                list.add(t);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return null;
    }

    public DbModel findDbModelBySQL(String strSQL) {
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorUtils.getDbModel(cursor);
                return dbModel;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public List<DbModel> findDbModelListBySQL(String strSQL) {
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        try {
            try {
                while (cursor.moveToNext()) {
                    dbModelList.add(CursorUtils.getDbModel(cursor));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                cursor.close();
            }
        }
        finally {
            cursor.close();
        }
        return dbModelList;
    }

    private void checkTableExist(Class<?> clazz) {
        if (!this.tableIsExist(TableInfo.get(clazz))) {
            String sql = SqlBuilder.getCreatTableSQL(clazz);
            this.debugSql(sql);
            this.db.execSQL(sql);
        }
    }

    private boolean tableIsExist(TableInfo table) {
        if (table.isCheckDatabese()) {
            return true;
        }
        Cursor cursor = null;
        try {
            int count;
            String sql = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + table.getTableName() + "' ";
            this.debugSql(sql);
            cursor = this.db.rawQuery(sql, null);
            if (cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                table.setCheckDatabese(true);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return false;
    }

    private void debugSql(String sql) {
        if (this.config != null && this.config.isDebug()) {
            Log.d((String)"Debug SQL", (String)(">>>>>>  " + sql));
        }
    }

    public static class DaoConfig {
        private Context context = null;
        private String dbName = "afinal.db";
        private int dbVersion = 1;
        private boolean debug = true;
        private DbUpdateListener dbUpdateListener;

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public String getDbName() {
            return this.dbName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public void setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public DbUpdateListener getDbUpdateListener() {
            return this.dbUpdateListener;
        }

        public void setDbUpdateListener(DbUpdateListener dbUpdateListener) {
            this.dbUpdateListener = dbUpdateListener;
        }
    }

    public static interface DbUpdateListener {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);
    }

    class SqliteDbHelper
    extends SQLiteOpenHelper {
        private DbUpdateListener mDbUpdateListener;

        public SqliteDbHelper(Context context, String name, int version, DbUpdateListener dbUpdateListener) {
            super(context, name, null, version);
            this.mDbUpdateListener = dbUpdateListener;
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (this.mDbUpdateListener != null) {
                this.mDbUpdateListener.onUpgrade(db, oldVersion, newVersion);
            } else {
                Cursor cursor = db.rawQuery("SELECT name FROM sqlite_master WHERE type ='table'", null);
                if (cursor != null) {
                    while (cursor.moveToNext()) {
                        db.execSQL("DROP TABLE " + cursor.getString(0));
                    }
                }
                if (cursor != null) {
                    cursor.close();
                    cursor = null;
                }
            }
        }
    }
}

