/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.File;

public class BitmapCommonUtils {
    private static final String TAG = "BitmapCommonUtils";

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) ? BitmapCommonUtils.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        return new File(String.valueOf(cachePath) + File.separator + uniqueName);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static File getExternalCacheDir(Context context) {
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + cacheDir);
    }

    public static long getUsableSpace(File path) {
        try {
            StatFs stats = new StatFs(path.getPath());
            return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"\u83b7\u53d6 sdcard \u7f13\u5b58\u5927\u5c0f \u51fa\u9519\uff0c\u8bf7\u67e5\u770bAndroidManifest.xml \u662f\u5426\u6dfb\u52a0\u4e86sdcard\u7684\u8bbf\u95ee\u6743\u9650");
            e.printStackTrace();
            return -1L;
        }
    }
}

