/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.FileDescriptor;

public class BitmapDecoder {
    private static final String TAG = "BitmapDecoder";

    private BitmapDecoder() {
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPurgeable = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"decodeSampledBitmapFromResource\u5185\u5b58\u6ea2\u51fa\uff0c\u5982\u679c\u9891\u7e41\u51fa\u73b0\u8fd9\u4e2a\u60c5\u51b5 \u53ef\u4ee5\u5c1d\u8bd5\u914d\u7f6e\u589e\u52a0\u5185\u5b58\u7f13\u5b58\u5927\u5c0f");
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeSampledBitmapFromFile(String filename, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPurgeable = true;
        BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"decodeSampledBitmapFromFile\u5185\u5b58\u6ea2\u51fa\uff0c\u5982\u679c\u9891\u7e41\u51fa\u73b0\u8fd9\u4e2a\u60c5\u51b5 \u53ef\u4ee5\u5c1d\u8bd5\u914d\u7f6e\u589e\u52a0\u5185\u5b58\u7f13\u5b58\u5927\u5c0f");
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeSampledBitmapFromDescriptor(FileDescriptor fileDescriptor, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPurgeable = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"decodeSampledBitmapFromDescriptor\u5185\u5b58\u6ea2\u51fa\uff0c\u5982\u679c\u9891\u7e41\u51fa\u73b0\u8fd9\u4e2a\u60c5\u51b5 \u53ef\u4ee5\u5c1d\u8bd5\u914d\u7f6e\u589e\u52a0\u5185\u5b58\u7f13\u5b58\u5927\u5c0f");
            e.printStackTrace();
            return null;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize = width > height ? Math.round((float)height / (float)reqHeight) : Math.round((float)width / (float)reqWidth);
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }
}

