/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.tsz.afinal.annotation.sqlite.Id;
import net.tsz.afinal.annotation.sqlite.Table;
import net.tsz.afinal.db.table.ManyToOne;
import net.tsz.afinal.db.table.OneToMany;
import net.tsz.afinal.db.table.Property;
import net.tsz.afinal.exception.DbException;
import net.tsz.afinal.reflect.FieldUtils;

public class ClassUtils {
    public static String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null || table.name().trim().length() == 0) {
            return clazz.getName().replace('.', '_');
        }
        return table.name();
    }

    public static Object getPrimaryKeyValue(Object entity) {
        return FieldUtils.getFieldValue(entity, ClassUtils.getPrimaryKeyField(entity.getClass()));
    }

    public static String getPrimaryKeyColumn(Class<?> clazz) {
        String primaryKey = null;
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            Field field;
            Id idAnnotation = null;
            Field idField = null;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                idAnnotation = field.getAnnotation(Id.class);
                if (idAnnotation != null) {
                    idField = field;
                    break;
                }
                ++n2;
            }
            if (idAnnotation != null) {
                primaryKey = idAnnotation.column();
                if (primaryKey == null || primaryKey.trim().length() == 0) {
                    primaryKey = idField.getName();
                }
            } else {
                fieldArray = fields;
                n = fields.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    if ("_id".equals(field.getName())) {
                        return "_id";
                    }
                    ++n2;
                }
                fieldArray = fields;
                n = fields.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    if ("id".equals(field.getName())) {
                        return "id";
                    }
                    ++n2;
                }
            }
        } else {
            throw new RuntimeException("this model[" + clazz + "] has no field");
        }
        return primaryKey;
    }

    public static Field getPrimaryKeyField(Class<?> clazz) {
        Field primaryKeyField = null;
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            Field field;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                if (field.getAnnotation(Id.class) != null) {
                    primaryKeyField = field;
                    break;
                }
                ++n2;
            }
            if (primaryKeyField == null) {
                fieldArray = fields;
                n = fields.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    if ("_id".equals(field.getName())) {
                        primaryKeyField = field;
                        break;
                    }
                    ++n2;
                }
            }
            if (primaryKeyField == null) {
                fieldArray = fields;
                n = fields.length;
                n2 = 0;
                while (n2 < n) {
                    field = fieldArray[n2];
                    if ("id".equals(field.getName())) {
                        primaryKeyField = field;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            throw new RuntimeException("this model[" + clazz + "] has no field");
        }
        return primaryKeyField;
    }

    public static String getPrimaryKeyFieldName(Class<?> clazz) {
        Field f = ClassUtils.getPrimaryKeyField(clazz);
        return f == null ? null : f.getName();
    }

    public static List<Property> getPropertyList(Class<?> clazz) {
        ArrayList<Property> plist = new ArrayList<Property>();
        try {
            Field[] fs = clazz.getDeclaredFields();
            String primaryKeyFieldName = ClassUtils.getPrimaryKeyFieldName(clazz);
            Field[] fieldArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!FieldUtils.isTransient(f) && FieldUtils.isBaseDateType(f) && !f.getName().equals(primaryKeyFieldName)) {
                    Property property = new Property();
                    property.setColumn(FieldUtils.getColumnByField(f));
                    property.setFieldName(f.getName());
                    property.setDataType(f.getType());
                    property.setDefaultValue(FieldUtils.getPropertyDefaultValue(f));
                    property.setSet(FieldUtils.getFieldSetMethod(clazz, f));
                    property.setGet(FieldUtils.getFieldGetMethod(clazz, f));
                    property.setField(f);
                    plist.add(property);
                }
                ++n2;
            }
            return plist;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<ManyToOne> getManyToOneList(Class<?> clazz) {
        ArrayList<ManyToOne> mList = new ArrayList<ManyToOne>();
        try {
            Field[] fs;
            Field[] fieldArray = fs = clazz.getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!FieldUtils.isTransient(f) && FieldUtils.isManyToOne(f)) {
                    ManyToOne mto = new ManyToOne();
                    mto.setManyClass(f.getType());
                    mto.setColumn(FieldUtils.getColumnByField(f));
                    mto.setFieldName(f.getName());
                    mto.setDataType(f.getType());
                    mto.setSet(FieldUtils.getFieldSetMethod(clazz, f));
                    mto.setGet(FieldUtils.getFieldGetMethod(clazz, f));
                    mList.add(mto);
                }
                ++n2;
            }
            return mList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<OneToMany> getOneToManyList(Class<?> clazz) {
        ArrayList<OneToMany> oList = new ArrayList<OneToMany>();
        try {
            Field[] fs;
            Field[] fieldArray = fs = clazz.getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!FieldUtils.isTransient(f) && FieldUtils.isOneToMany(f)) {
                    OneToMany otm = new OneToMany();
                    otm.setColumn(FieldUtils.getColumnByField(f));
                    otm.setFieldName(f.getName());
                    Type type = f.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType pType = (ParameterizedType)f.getGenericType();
                        Class pClazz = (Class)pType.getActualTypeArguments()[0];
                        if (pClazz != null) {
                            otm.setOneClass(pClazz);
                        }
                    } else {
                        throw new DbException("getOneToManyList Exception:" + f.getName() + "'s type is null");
                    }
                    otm.setDataType(f.getClass());
                    otm.setSet(FieldUtils.getFieldSetMethod(clazz, f));
                    otm.setGet(FieldUtils.getFieldGetMethod(clazz, f));
                    oList.add(otm);
                }
                ++n2;
            }
            return oList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

