/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import java.lang.reflect.Field;
import net.tsz.afinal.annotation.view.EventListener;
import net.tsz.afinal.annotation.view.Select;
import net.tsz.afinal.annotation.view.ViewInject;

public abstract class FinalActivity
extends Activity {
    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        FinalActivity.initInjectedView(this);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        FinalActivity.initInjectedView(this);
    }

    public void setContentView(View view) {
        super.setContentView(view);
        FinalActivity.initInjectedView(this);
    }

    public static void initInjectedView(Activity activity) {
        FinalActivity.initInjectedView(activity, activity.getWindow().getDecorView());
    }

    public static void initInjectedView(Object injectedSource, View sourceView) {
        Field[] fields = injectedSource.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    ViewInject viewInject;
                    field.setAccessible(true);
                    if (field.get(injectedSource) == null && (viewInject = field.getAnnotation(ViewInject.class)) != null) {
                        int viewId = viewInject.id();
                        field.set(injectedSource, sourceView.findViewById(viewId));
                        FinalActivity.setListener(injectedSource, field, viewInject.click(), Method.Click);
                        FinalActivity.setListener(injectedSource, field, viewInject.longClick(), Method.LongClick);
                        FinalActivity.setListener(injectedSource, field, viewInject.itemClick(), Method.ItemClick);
                        FinalActivity.setListener(injectedSource, field, viewInject.itemLongClick(), Method.itemLongClick);
                        Select select = viewInject.select();
                        if (!TextUtils.isEmpty((CharSequence)select.selected())) {
                            FinalActivity.setViewSelectListener(injectedSource, field, select.selected(), select.noSelected());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private static void setViewSelectListener(Object injectedSource, Field field, String select, String noSelect) throws Exception {
        Object obj = field.get(injectedSource);
        if (obj instanceof View) {
            ((AbsListView)obj).setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new EventListener(injectedSource).select(select).noSelect(noSelect));
        }
    }

    private static void setListener(Object injectedSource, Field field, String methodName, Method method) throws Exception {
        if (methodName == null || methodName.trim().length() == 0) {
            return;
        }
        Object obj = field.get(injectedSource);
        switch (method) {
            case Click: {
                if (!(obj instanceof View)) break;
                ((View)obj).setOnClickListener((View.OnClickListener)new EventListener(injectedSource).click(methodName));
                break;
            }
            case ItemClick: {
                if (!(obj instanceof AbsListView)) break;
                ((AbsListView)obj).setOnItemClickListener((AdapterView.OnItemClickListener)new EventListener(injectedSource).itemClick(methodName));
                break;
            }
            case LongClick: {
                if (!(obj instanceof View)) break;
                ((View)obj).setOnLongClickListener((View.OnLongClickListener)new EventListener(injectedSource).longClick(methodName));
                break;
            }
            case itemLongClick: {
                if (!(obj instanceof AbsListView)) break;
                ((AbsListView)obj).setOnItemLongClickListener((AdapterView.OnItemLongClickListener)new EventListener(injectedSource).itemLongClick(methodName));
                break;
            }
        }
    }

    public static enum Method {
        Click,
        LongClick,
        ItemClick,
        itemLongClick;

    }
}

