/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.tsz.afinal.bitmap.core.BitmapCache;
import net.tsz.afinal.bitmap.core.BitmapDisplayConfig;
import net.tsz.afinal.bitmap.core.BitmapProcess;
import net.tsz.afinal.bitmap.display.Displayer;
import net.tsz.afinal.bitmap.display.SimpleDisplayer;
import net.tsz.afinal.bitmap.download.Downloader;
import net.tsz.afinal.bitmap.download.SimpleDownloader;
import net.tsz.afinal.core.AsyncTask;
import net.tsz.afinal.utils.Utils;

public class FinalBitmap {
    private FinalBitmapConfig mConfig;
    private BitmapCache mImageCache;
    private BitmapProcess mBitmapProcess;
    private boolean mExitTasksEarly = false;
    private boolean mPauseWork = false;
    private final Object mPauseWorkLock = new Object();
    private Context mContext;
    private boolean mInit = false;
    private ExecutorService bitmapLoadAndDisplayExecutor;
    private static FinalBitmap mFinalBitmap;
    private HashMap<String, BitmapDisplayConfig> configMap = new HashMap();

    private FinalBitmap(Context context) {
        this.mContext = context;
        this.mConfig = new FinalBitmapConfig(context);
        this.configDiskCachePath(Utils.getDiskCacheDir(context, "afinalCache").getAbsolutePath());
        this.configDisplayer(new SimpleDisplayer());
        this.configDownlader(new SimpleDownloader());
    }

    public static synchronized FinalBitmap create(Context ctx) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
        }
        return mFinalBitmap;
    }

    public FinalBitmap configLoadingImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadingImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configLoadfailImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadfailImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configBitmapMaxHeight(int bitmapHeight) {
        this.mConfig.defaultDisplayConfig.setBitmapHeight(bitmapHeight);
        return this;
    }

    public FinalBitmap configBitmapMaxWidth(int bitmapWidth) {
        this.mConfig.defaultDisplayConfig.setBitmapWidth(bitmapWidth);
        return this;
    }

    public FinalBitmap configDownlader(Downloader downlader) {
        this.mConfig.downloader = downlader;
        return this;
    }

    public FinalBitmap configDisplayer(Displayer displayer) {
        this.mConfig.displayer = displayer;
        return this;
    }

    public FinalBitmap configDiskCachePath(String strPath) {
        if (!TextUtils.isEmpty((CharSequence)strPath)) {
            this.mConfig.cachePath = strPath;
        }
        return this;
    }

    public FinalBitmap configMemoryCacheSize(int size) {
        this.mConfig.memCacheSize = size;
        return this;
    }

    public FinalBitmap configMemoryCachePercent(float percent) {
        this.mConfig.memCacheSizePercent = percent;
        return this;
    }

    public FinalBitmap configDiskCacheSize(int size) {
        this.mConfig.diskCacheSize = size;
        return this;
    }

    public FinalBitmap configBitmapLoadThreadSize(int size) {
        if (size >= 1) {
            this.mConfig.poolSize = size;
        }
        return this;
    }

    public FinalBitmap configRecycleImmediately(boolean recycleImmediately) {
        this.mConfig.recycleImmediately = recycleImmediately;
        return this;
    }

    private FinalBitmap init() {
        if (!this.mInit) {
            BitmapCache.ImageCacheParams imageCacheParams = new BitmapCache.ImageCacheParams(this.mConfig.cachePath);
            if ((double)this.mConfig.memCacheSizePercent > 0.05 && (double)this.mConfig.memCacheSizePercent < 0.8) {
                imageCacheParams.setMemCacheSizePercent(this.mContext, this.mConfig.memCacheSizePercent);
            } else if (this.mConfig.memCacheSize > 0x200000) {
                imageCacheParams.setMemCacheSize(this.mConfig.memCacheSize);
            } else {
                imageCacheParams.setMemCacheSizePercent(this.mContext, 0.3f);
            }
            if (this.mConfig.diskCacheSize > 0x500000) {
                imageCacheParams.setDiskCacheSize(this.mConfig.diskCacheSize);
            }
            imageCacheParams.setRecycleImmediately(this.mConfig.recycleImmediately);
            this.mImageCache = new BitmapCache(imageCacheParams);
            this.bitmapLoadAndDisplayExecutor = Executors.newFixedThreadPool(this.mConfig.poolSize, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setPriority(4);
                    return t;
                }
            });
            this.mBitmapProcess = new BitmapProcess(this.mConfig.downloader, this.mImageCache);
            this.mInit = true;
        }
        return this;
    }

    public void display(View imageView, String uri) {
        this.doDisplay(imageView, uri, null);
    }

    public void display(View imageView, String uri, int imageWidth, int imageHeight) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(imageWidth) + "_" + imageHeight);
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setBitmapHeight(imageHeight);
            displayConfig.setBitmapWidth(imageWidth);
            this.configMap.put(String.valueOf(imageWidth) + "_" + imageHeight, displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(View imageView, String uri, Bitmap loadingBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(loadingBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setLoadingBitmap(loadingBitmap);
            this.configMap.put(String.valueOf(loadingBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(View imageView, String uri, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(String.valueOf(loadingBitmap)) + "_" + String.valueOf(laodfailBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setLoadingBitmap(loadingBitmap);
            displayConfig.setLoadfailBitmap(laodfailBitmap);
            this.configMap.put(String.valueOf(String.valueOf(loadingBitmap)) + "_" + String.valueOf(laodfailBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(View imageView, String uri, int imageWidth, int imageHeight, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(imageWidth) + "_" + imageHeight + "_" + String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setBitmapHeight(imageHeight);
            displayConfig.setBitmapWidth(imageWidth);
            displayConfig.setLoadingBitmap(loadingBitmap);
            displayConfig.setLoadfailBitmap(laodfailBitmap);
            this.configMap.put(String.valueOf(imageWidth) + "_" + imageHeight + "_" + String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(View imageView, String uri, BitmapDisplayConfig config) {
        this.doDisplay(imageView, uri, config);
    }

    private void doDisplay(View imageView, String uri, BitmapDisplayConfig displayConfig) {
        if (!this.mInit) {
            this.init();
        }
        if (TextUtils.isEmpty((CharSequence)uri) || imageView == null) {
            return;
        }
        if (displayConfig == null) {
            displayConfig = this.mConfig.defaultDisplayConfig;
        }
        Bitmap bitmap = null;
        if (this.mImageCache != null) {
            bitmap = this.mImageCache.getBitmapFromMemoryCache(uri);
        }
        if (bitmap != null) {
            if (imageView instanceof ImageView) {
                ((ImageView)imageView).setImageBitmap(bitmap);
            } else {
                imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
            }
        } else if (FinalBitmap.checkImageTask(uri, imageView)) {
            BitmapLoadAndDisplayTask task = new BitmapLoadAndDisplayTask(imageView, displayConfig);
            AsyncDrawable asyncDrawable = new AsyncDrawable(this.mContext.getResources(), displayConfig.getLoadingBitmap(), task);
            if (imageView instanceof ImageView) {
                ((ImageView)imageView).setImageDrawable((Drawable)asyncDrawable);
            } else {
                imageView.setBackgroundDrawable((Drawable)asyncDrawable);
            }
            task.executeOnExecutor(this.bitmapLoadAndDisplayExecutor, uri);
        }
    }

    private BitmapDisplayConfig getDisplayConfig() {
        BitmapDisplayConfig config = new BitmapDisplayConfig();
        config.setAnimation(this.mConfig.defaultDisplayConfig.getAnimation());
        config.setAnimationType(this.mConfig.defaultDisplayConfig.getAnimationType());
        config.setBitmapHeight(this.mConfig.defaultDisplayConfig.getBitmapHeight());
        config.setBitmapWidth(this.mConfig.defaultDisplayConfig.getBitmapWidth());
        config.setLoadfailBitmap(this.mConfig.defaultDisplayConfig.getLoadfailBitmap());
        config.setLoadingBitmap(this.mConfig.defaultDisplayConfig.getLoadingBitmap());
        return config;
    }

    private void clearCacheInternalInBackgroud() {
        if (this.mImageCache != null) {
            this.mImageCache.clearCache();
        }
    }

    private void clearDiskCacheInBackgroud() {
        if (this.mImageCache != null) {
            this.mImageCache.clearDiskCache();
        }
    }

    private void clearCacheInBackgroud(String key) {
        if (this.mImageCache != null) {
            this.mImageCache.clearCache(key);
        }
    }

    private void clearDiskCacheInBackgroud(String key) {
        if (this.mImageCache != null) {
            this.mImageCache.clearDiskCache(key);
        }
    }

    private void closeCacheInternalInBackgroud() {
        if (this.mImageCache != null) {
            this.mImageCache.close();
            this.mImageCache = null;
            mFinalBitmap = null;
        }
    }

    private Bitmap processBitmap(String uri, BitmapDisplayConfig config) {
        if (this.mBitmapProcess != null) {
            return this.mBitmapProcess.getBitmap(uri, config);
        }
        return null;
    }

    public Bitmap getBitmapFromCache(String key) {
        Bitmap bitmap = this.getBitmapFromMemoryCache(key);
        if (bitmap == null) {
            bitmap = this.getBitmapFromDiskCache(key);
        }
        return bitmap;
    }

    public Bitmap getBitmapFromMemoryCache(String key) {
        return this.mImageCache.getBitmapFromMemoryCache(key);
    }

    public Bitmap getBitmapFromDiskCache(String key) {
        return this.getBitmapFromDiskCache(key, null);
    }

    public Bitmap getBitmapFromDiskCache(String key, BitmapDisplayConfig config) {
        return this.mBitmapProcess.getFromDisk(key, config);
    }

    public void setExitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
    }

    public void onResume() {
        this.setExitTasksEarly(false);
    }

    public void onPause() {
        this.setExitTasksEarly(true);
    }

    public void onDestroy() {
        this.closeCache();
    }

    public void clearCache() {
        new CacheExecutecTask().execute(1);
    }

    public void clearCache(String key) {
        new CacheExecutecTask().execute(4, key);
    }

    public void clearMemoryCache() {
        if (this.mImageCache != null) {
            this.mImageCache.clearMemoryCache();
        }
    }

    public void clearMemoryCache(String key) {
        if (this.mImageCache != null) {
            this.mImageCache.clearMemoryCache(key);
        }
    }

    public void clearDiskCache() {
        new CacheExecutecTask().execute(3);
    }

    public void clearDiskCache(String key) {
        new CacheExecutecTask().execute(5, key);
    }

    public void closeCache() {
        new CacheExecutecTask().execute(2);
    }

    public void exitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
        if (exitTasksEarly) {
            this.pauseWork(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWork(boolean pauseWork) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pauseWork;
            if (!this.mPauseWork) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    private static BitmapLoadAndDisplayTask getBitmapTaskFromImageView(View imageView) {
        if (imageView != null) {
            Drawable drawable = null;
            drawable = imageView instanceof ImageView ? ((ImageView)imageView).getDrawable() : imageView.getBackground();
            if (drawable instanceof AsyncDrawable) {
                AsyncDrawable asyncDrawable = (AsyncDrawable)drawable;
                return asyncDrawable.getBitmapWorkerTask();
            }
        }
        return null;
    }

    public static boolean checkImageTask(Object data, View imageView) {
        BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapTaskFromImageView(imageView);
        if (bitmapWorkerTask != null) {
            Object bitmapData = bitmapWorkerTask.data;
            if (bitmapData == null || !bitmapData.equals(data)) {
                bitmapWorkerTask.cancel(true);
            } else {
                return false;
            }
        }
        return true;
    }

    private static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapLoadAndDisplayTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapLoadAndDisplayTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapLoadAndDisplayTask>(bitmapWorkerTask);
        }

        public BitmapLoadAndDisplayTask getBitmapWorkerTask() {
            return (BitmapLoadAndDisplayTask)this.bitmapWorkerTaskReference.get();
        }
    }

    private class BitmapLoadAndDisplayTask
    extends AsyncTask<Object, Void, Bitmap> {
        private Object data;
        private final WeakReference<View> imageViewReference;
        private final BitmapDisplayConfig displayConfig;

        public BitmapLoadAndDisplayTask(View imageView, BitmapDisplayConfig config) {
            this.imageViewReference = new WeakReference<View>(imageView);
            this.displayConfig = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Bitmap doInBackground(Object ... params) {
            this.data = params[0];
            String dataString = String.valueOf(this.data);
            Bitmap bitmap = null;
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                while (FinalBitmap.this.mPauseWork && !this.isCancelled()) {
                    try {
                        FinalBitmap.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (bitmap == null && !this.isCancelled() && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly) {
                bitmap = FinalBitmap.this.processBitmap(dataString, this.displayConfig);
            }
            if (bitmap != null) {
                FinalBitmap.this.mImageCache.addToMemoryCache(dataString, bitmap);
            }
            return bitmap;
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {
            if (this.isCancelled() || FinalBitmap.this.mExitTasksEarly) {
                bitmap = null;
            }
            View imageView = this.getAttachedImageView();
            if (bitmap != null && imageView != null) {
                ((FinalBitmap)FinalBitmap.this).mConfig.displayer.loadCompletedisplay(imageView, bitmap, this.displayConfig);
            } else if (bitmap == null && imageView != null) {
                ((FinalBitmap)FinalBitmap.this).mConfig.displayer.loadFailDisplay(imageView, this.displayConfig.getLoadfailBitmap());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCancelled(Bitmap bitmap) {
            super.onCancelled(bitmap);
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                FinalBitmap.this.mPauseWorkLock.notifyAll();
            }
        }

        private View getAttachedImageView() {
            View imageView = (View)this.imageViewReference.get();
            BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapTaskFromImageView(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }
    }

    private class CacheExecutecTask
    extends AsyncTask<Object, Void, Void> {
        public static final int MESSAGE_CLEAR = 1;
        public static final int MESSAGE_CLOSE = 2;
        public static final int MESSAGE_CLEAR_DISK = 3;
        public static final int MESSAGE_CLEAR_KEY = 4;
        public static final int MESSAGE_CLEAR_KEY_IN_DISK = 5;

        private CacheExecutecTask() {
        }

        @Override
        protected Void doInBackground(Object ... params) {
            switch ((Integer)params[0]) {
                case 1: {
                    FinalBitmap.this.clearCacheInternalInBackgroud();
                    break;
                }
                case 2: {
                    FinalBitmap.this.closeCacheInternalInBackgroud();
                    break;
                }
                case 3: {
                    FinalBitmap.this.clearDiskCacheInBackgroud();
                    break;
                }
                case 4: {
                    FinalBitmap.this.clearCacheInBackgroud(String.valueOf(params[1]));
                    break;
                }
                case 5: {
                    FinalBitmap.this.clearDiskCacheInBackgroud(String.valueOf(params[1]));
                }
            }
            return null;
        }
    }

    private class FinalBitmapConfig {
        public String cachePath;
        public Displayer displayer;
        public Downloader downloader;
        public BitmapDisplayConfig defaultDisplayConfig = new BitmapDisplayConfig();
        public float memCacheSizePercent;
        public int memCacheSize;
        public int diskCacheSize;
        public int poolSize = 3;
        public boolean recycleImmediately = true;

        public FinalBitmapConfig(Context context) {
            this.defaultDisplayConfig.setAnimation(null);
            this.defaultDisplayConfig.setAnimationType(1);
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int defaultWidth = (int)Math.floor(displayMetrics.widthPixels / 2);
            this.defaultDisplayConfig.setBitmapHeight(defaultWidth);
            this.defaultDisplayConfig.setBitmapWidth(defaultWidth);
        }
    }
}

