/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.tsz.afinal.db.sqlite.CursorUtils;
import net.tsz.afinal.db.sqlite.DbModel;
import net.tsz.afinal.db.sqlite.ManyToOneLazyLoader;
import net.tsz.afinal.db.sqlite.OneToManyLazyLoader;
import net.tsz.afinal.db.sqlite.SqlBuilder;
import net.tsz.afinal.db.sqlite.SqlInfo;
import net.tsz.afinal.db.table.KeyValue;
import net.tsz.afinal.db.table.ManyToOne;
import net.tsz.afinal.db.table.OneToMany;
import net.tsz.afinal.db.table.TableInfo;
import net.tsz.afinal.exception.DbException;

public class FinalDb {
    private static final String TAG = "FinalDb";
    private static HashMap<String, FinalDb> daoMap = new HashMap();
    private SQLiteDatabase db;
    private DaoConfig config;

    private FinalDb(DaoConfig config) {
        if (config == null) {
            throw new DbException("daoConfig is null");
        }
        if (config.getContext() == null) {
            throw new DbException("android context is null");
        }
        this.db = config.getTargetDirectory() != null && config.getTargetDirectory().trim().length() > 0 ? this.createDbFileOnSDCard(config.getTargetDirectory(), config.getDbName()) : new SqliteDbHelper(config.getContext().getApplicationContext(), config.getDbName(), config.getDbVersion(), config.getDbUpdateListener()).getWritableDatabase();
        this.config = config;
    }

    private static synchronized FinalDb getInstance(DaoConfig daoConfig) {
        FinalDb dao = daoMap.get(daoConfig.getDbName());
        if (dao == null) {
            dao = new FinalDb(daoConfig);
            daoMap.put(daoConfig.getDbName(), dao);
        }
        return dao;
    }

    public static FinalDb create(Context context) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDebug(isDebug);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String dbName) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String targetDirectory, String dbName) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setTargetDirectory(targetDirectory);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String targetDirectory, String dbName, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setTargetDirectory(targetDirectory);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug, int dbVersion, DbUpdateListener dbUpdateListener) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        config.setDbVersion(dbVersion);
        config.setDbUpdateListener(dbUpdateListener);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String targetDirectory, String dbName, boolean isDebug, int dbVersion, DbUpdateListener dbUpdateListener) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setTargetDirectory(targetDirectory);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        config.setDbVersion(dbVersion);
        config.setDbUpdateListener(dbUpdateListener);
        return FinalDb.create(config);
    }

    public static FinalDb create(DaoConfig daoConfig) {
        return FinalDb.getInstance(daoConfig);
    }

    public void save(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildInsertSql(entity));
    }

    public boolean saveBindId(Object entity) {
        this.checkTableExist(entity.getClass());
        List<KeyValue> entityKvList = SqlBuilder.getSaveKeyValueListByEntity(entity);
        if (entityKvList != null && entityKvList.size() > 0) {
            TableInfo tf = TableInfo.get(entity.getClass());
            ContentValues cv = new ContentValues();
            this.insertContentValues(entityKvList, cv);
            Long id = this.db.insert(tf.getTableName(), null, cv);
            if (id == -1L) {
                return false;
            }
            tf.getId().setValue(entity, id);
            return true;
        }
        return false;
    }

    private void insertContentValues(List<KeyValue> list, ContentValues cv) {
        if (list != null && cv != null) {
            for (KeyValue kv : list) {
                cv.put(kv.getKey(), kv.getValue().toString());
            }
        } else {
            Log.w((String)TAG, (String)"insertContentValues: List<KeyValue> is empty or ContentValues is empty!");
        }
    }

    public void update(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(entity));
    }

    public void update(Object entity, String strWhere) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(entity, strWhere));
    }

    public void delete(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(entity));
    }

    public void deleteById(Class<?> clazz, Object id) {
        this.checkTableExist(clazz);
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(clazz, id));
    }

    public void deleteByWhere(Class<?> clazz, String strWhere) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.buildDeleteSql(clazz, strWhere);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void deleteAll(Class<?> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.buildDeleteSql(clazz, null);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void dropTable(Class<?> clazz) {
        this.checkTableExist(clazz);
        TableInfo table = TableInfo.get(clazz);
        String sql = "DROP TABLE " + table.getTableName();
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void dropDb() {
        Cursor cursor = this.db.rawQuery("SELECT name FROM sqlite_master WHERE type ='table' AND name != 'sqlite_sequence'", null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                this.db.execSQL("DROP TABLE " + cursor.getString(0));
            }
        }
        if (cursor != null) {
            cursor.close();
            cursor = null;
        }
    }

    private void exeSqlInfo(SqlInfo sqlInfo) {
        if (sqlInfo != null) {
            this.debugSql(sqlInfo.getSql());
            this.db.execSQL(sqlInfo.getSql(), sqlInfo.getBindArgsAsArray());
        } else {
            Log.e((String)TAG, (String)"sava error:sqlInfo is null");
        }
    }

    public <T> T findById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        SqlInfo sqlInfo = SqlBuilder.getSelectSqlAsSqlInfo(clazz, id);
        if (sqlInfo != null) {
            this.debugSql(sqlInfo.getSql());
            Cursor cursor = this.db.rawQuery(sqlInfo.getSql(), sqlInfo.getBindArgsAsStringArray());
            try {
                if (cursor.moveToNext()) {
                    T t = CursorUtils.getEntity(cursor, clazz, this);
                    return t;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public <T> T findWithManyToOneById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadManyToOne(dbModel, entity, clazz, new Class[0]);
        }
        return null;
    }

    public <T> T findWithManyToOneById(Object id, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadManyToOne(dbModel, entity, clazz, findClass);
        }
        return null;
    }

    public <T> T loadManyToOne(DbModel dbModel, T entity, Class<T> clazz, Class<?> ... findClass) {
        if (entity != null) {
            try {
                Collection<ManyToOne> manys = TableInfo.get(clazz).manyToOneMap.values();
                for (ManyToOne many : manys) {
                    Object manyEntity;
                    Object id = null;
                    if (dbModel != null) {
                        id = dbModel.get(many.getColumn());
                    } else if (many.getValue(entity).getClass() == ManyToOneLazyLoader.class && many.getValue(entity) != null) {
                        id = ((ManyToOneLazyLoader)many.getValue(entity)).getFieldValue();
                    }
                    if (id == null) continue;
                    boolean isFind = false;
                    if (findClass == null || findClass.length == 0) {
                        isFind = true;
                    }
                    Class<?>[] classArray = findClass;
                    int n = findClass.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> mClass = classArray[n2];
                        if (many.getManyClass() == mClass) {
                            isFind = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!isFind || (manyEntity = this.findById(Integer.valueOf(id.toString()), many.getManyClass())) == null) continue;
                    if (many.getValue(entity).getClass() == ManyToOneLazyLoader.class) {
                        if (many.getValue(entity) == null) {
                            many.setValue(entity, new ManyToOneLazyLoader(entity, clazz, many.getManyClass(), this));
                        }
                        ((ManyToOneLazyLoader)many.getValue(entity)).set(manyEntity);
                        continue;
                    }
                    many.setValue(entity, manyEntity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entity;
    }

    public <T> T findWithOneToManyById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadOneToMany(entity, clazz, new Class[0]);
        }
        return null;
    }

    public <T> T findWithOneToManyById(Object id, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadOneToMany(entity, clazz, findClass);
        }
        return null;
    }

    public <T> T loadOneToMany(T entity, Class<T> clazz, Class<?> ... findClass) {
        if (entity != null) {
            try {
                Collection<OneToMany> ones = TableInfo.get(clazz).oneToManyMap.values();
                Object id = TableInfo.get(clazz).getId().getValue(entity);
                for (OneToMany one : ones) {
                    List<?> list;
                    boolean isFind = false;
                    if (findClass == null || findClass.length == 0) {
                        isFind = true;
                    }
                    Class<?>[] classArray = findClass;
                    int n = findClass.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> mClass = classArray[n2];
                        if (one.getOneClass() == mClass) {
                            isFind = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!isFind || (list = this.findAllByWhere(one.getOneClass(), String.valueOf(one.getColumn()) + "=" + id)) == null) continue;
                    if (one.getDataType() == OneToManyLazyLoader.class) {
                        OneToManyLazyLoader oneToManyLazyLoader = (OneToManyLazyLoader)one.getValue(entity);
                        oneToManyLazyLoader.setList(list);
                        continue;
                    }
                    one.setValue(entity, list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entity;
    }

    public <T> List<T> findAll(Class<T> clazz) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQL(clazz));
    }

    public <T> List<T> findAll(Class<T> clazz, String orderBy) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, String.valueOf(SqlBuilder.getSelectSQL(clazz)) + " ORDER BY " + orderBy);
    }

    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQLByWhere(clazz, strWhere));
    }

    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere, String orderBy) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, String.valueOf(SqlBuilder.getSelectSQLByWhere(clazz, strWhere)) + " ORDER BY " + orderBy);
    }

    private <T> List<T> findAllBySql(Class<T> clazz, String strSQL) {
        this.checkTableExist(clazz);
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            ArrayList<T> list = new ArrayList<T>();
            while (cursor.moveToNext()) {
                T t = CursorUtils.getEntity(cursor, clazz, this);
                list.add(t);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return null;
    }

    public DbModel findDbModelBySQL(String strSQL) {
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorUtils.getDbModel(cursor);
                return dbModel;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public List<DbModel> findDbModelListBySQL(String strSQL) {
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        try {
            try {
                while (cursor.moveToNext()) {
                    dbModelList.add(CursorUtils.getDbModel(cursor));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                cursor.close();
            }
        }
        finally {
            cursor.close();
        }
        return dbModelList;
    }

    private void checkTableExist(Class<?> clazz) {
        if (!this.tableIsExist(TableInfo.get(clazz))) {
            String sql = SqlBuilder.getCreatTableSQL(clazz);
            this.debugSql(sql);
            this.db.execSQL(sql);
        }
    }

    private boolean tableIsExist(TableInfo table) {
        if (table.isCheckDatabese()) {
            return true;
        }
        Cursor cursor = null;
        try {
            int count;
            String sql = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + table.getTableName() + "' ";
            this.debugSql(sql);
            cursor = this.db.rawQuery(sql, null);
            if (cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                table.setCheckDatabese(true);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return false;
    }

    private void debugSql(String sql) {
        if (this.config != null && this.config.isDebug()) {
            Log.d((String)"Debug SQL", (String)(">>>>>>  " + sql));
        }
    }

    private SQLiteDatabase createDbFileOnSDCard(String sdcardPath, String dbfilename) {
        block4: {
            File dbf = new File(sdcardPath, dbfilename);
            if (!dbf.exists()) {
                try {
                    if (dbf.createNewFile()) {
                        return SQLiteDatabase.openOrCreateDatabase((File)dbf, null);
                    }
                    break block4;
                }
                catch (IOException ioex) {
                    throw new DbException("\u6570\u636e\u5e93\u6587\u4ef6\u521b\u5efa\u5931\u8d25", ioex);
                }
            }
            return SQLiteDatabase.openOrCreateDatabase((File)dbf, null);
        }
        return null;
    }

    public static class DaoConfig {
        private Context mContext = null;
        private String mDbName = "afinal.db";
        private int dbVersion = 1;
        private boolean debug = true;
        private DbUpdateListener dbUpdateListener;
        private String targetDirectory;

        public Context getContext() {
            return this.mContext;
        }

        public void setContext(Context context) {
            this.mContext = context;
        }

        public String getDbName() {
            return this.mDbName;
        }

        public void setDbName(String dbName) {
            this.mDbName = dbName;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public void setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public DbUpdateListener getDbUpdateListener() {
            return this.dbUpdateListener;
        }

        public void setDbUpdateListener(DbUpdateListener dbUpdateListener) {
            this.dbUpdateListener = dbUpdateListener;
        }

        public String getTargetDirectory() {
            return this.targetDirectory;
        }

        public void setTargetDirectory(String targetDirectory) {
            this.targetDirectory = targetDirectory;
        }
    }

    public static interface DbUpdateListener {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);
    }

    class SqliteDbHelper
    extends SQLiteOpenHelper {
        private DbUpdateListener mDbUpdateListener;

        public SqliteDbHelper(Context context, String name, int version, DbUpdateListener dbUpdateListener) {
            super(context, name, null, version);
            this.mDbUpdateListener = dbUpdateListener;
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (this.mDbUpdateListener != null) {
                this.mDbUpdateListener.onUpgrade(db, oldVersion, newVersion);
            } else {
                FinalDb.this.dropDb();
            }
        }
    }
}

