/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import net.tsz.afinal.bitmap.core.BitmapCache;
import net.tsz.afinal.bitmap.core.BitmapDecoder;
import net.tsz.afinal.bitmap.core.BitmapDisplayConfig;
import net.tsz.afinal.bitmap.core.BytesBufferPool;
import net.tsz.afinal.bitmap.download.Downloader;

public class BitmapProcess {
    private Downloader mDownloader;
    private BitmapCache mCache;
    private static final int BYTESBUFFE_POOL_SIZE = 4;
    private static final int BYTESBUFFER_SIZE = 204800;
    private static final BytesBufferPool sMicroThumbBufferPool = new BytesBufferPool(4, 204800);

    public BitmapProcess(Downloader downloader, BitmapCache cache) {
        this.mDownloader = downloader;
        this.mCache = cache;
    }

    public Bitmap getBitmap(String url, BitmapDisplayConfig config) {
        byte[] data;
        Bitmap bitmap = this.getFromDisk(url, config);
        if (bitmap == null && (data = this.mDownloader.download(url)) != null && data.length > 0) {
            if (config == null) {
                return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
            bitmap = BitmapDecoder.decodeSampledBitmapFromByteArray(data, 0, data.length, config.getBitmapWidth(), config.getBitmapHeight());
            this.mCache.addToDiskCache(url, data);
        }
        return bitmap;
    }

    public Bitmap getFromDisk(String key, BitmapDisplayConfig config) {
        BytesBufferPool.BytesBuffer buffer = sMicroThumbBufferPool.get();
        Bitmap b = null;
        try {
            boolean found = this.mCache.getImageData(key, buffer);
            if (found && buffer.length - buffer.offset > 0) {
                b = config != null ? BitmapDecoder.decodeSampledBitmapFromByteArray(buffer.data, buffer.offset, buffer.length, config.getBitmapWidth(), config.getBitmapHeight()) : BitmapFactory.decodeByteArray((byte[])buffer.data, (int)buffer.offset, (int)buffer.length);
            }
        }
        finally {
            sMicroThumbBufferPool.recycle(buffer);
        }
        return b;
    }
}

