/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.display;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import net.tsz.afinal.bitmap.core.BitmapDisplayConfig;
import net.tsz.afinal.bitmap.display.Displayer;

public class SimpleDisplayer
implements Displayer {
    @Override
    public void loadCompletedisplay(View imageView, Bitmap bitmap, BitmapDisplayConfig config) {
        switch (config.getAnimationType()) {
            case 1: {
                this.fadeInDisplay(imageView, bitmap);
                break;
            }
            case 0: {
                this.animationDisplay(imageView, bitmap, config.getAnimation());
                break;
            }
        }
    }

    @Override
    public void loadFailDisplay(View imageView, Bitmap bitmap) {
        if (imageView instanceof ImageView) {
            ((ImageView)imageView).setImageBitmap(bitmap);
        } else {
            imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
        }
    }

    private void fadeInDisplay(View imageView, Bitmap bitmap) {
        TransitionDrawable td = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), new BitmapDrawable(imageView.getResources(), bitmap)});
        if (imageView instanceof ImageView) {
            ((ImageView)imageView).setImageDrawable((Drawable)td);
        } else {
            imageView.setBackgroundDrawable((Drawable)td);
        }
        td.startTransition(300);
    }

    private void animationDisplay(View imageView, Bitmap bitmap, Animation animation) {
        animation.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        if (imageView instanceof ImageView) {
            ((ImageView)imageView).setImageBitmap(bitmap);
        } else {
            imageView.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
        }
        imageView.startAnimation(animation);
    }
}

