/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.download;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.tsz.afinal.bitmap.download.Downloader;

public class SimpleDownloader
implements Downloader {
    private static final String TAG = SimpleDownloader.class.getSimpleName();
    private static final int IO_BUFFER_SIZE = 8192;

    @Override
    public byte[] download(String urlString) {
        if (urlString == null) {
            return null;
        }
        if (urlString.trim().toLowerCase().startsWith("http")) {
            return this.getFromHttp(urlString);
        }
        if (urlString.trim().toLowerCase().startsWith("file:")) {
            try {
                File f = new File(new URI(urlString));
                if (f.exists() && f.canRead()) {
                    return this.getFromFile(f);
                }
            }
            catch (URISyntaxException e) {
                Log.e((String)TAG, (String)("Error in read from file - " + urlString + " : " + e));
            }
        } else {
            File f = new File(urlString);
            if (f.exists() && f.canRead()) {
                return this.getFromFile(f);
            }
        }
        return null;
    }

    private byte[] getFromFile(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error in read from file - " + file + " : " + e));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private byte[] getFromHttp(String urlString) {
        HttpURLConnection urlConnection = null;
        FilterOutputStream out = null;
        FilterInputStream in = null;
        try {
            int b;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            in = new FlushedInputStream(new BufferedInputStream(urlConnection.getInputStream(), 8192));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = in.read()) != -1) {
                baos.write(b);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error in downloadBitmap - " + urlString + " : " + e));
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped = 0L;
            while (totalBytesSkipped < n) {
                long bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped == 0L) {
                    int by_te = this.read();
                    if (by_te < 0) break;
                    bytesSkipped = 1L;
                }
                totalBytesSkipped += bytesSkipped;
            }
            return totalBytesSkipped;
        }
    }
}

