/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.db.table;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import net.tsz.afinal.db.table.Id;
import net.tsz.afinal.db.table.ManyToOne;
import net.tsz.afinal.db.table.OneToMany;
import net.tsz.afinal.db.table.Property;
import net.tsz.afinal.exception.DbException;
import net.tsz.afinal.utils.ClassUtils;
import net.tsz.afinal.utils.FieldUtils;

public class TableInfo {
    private String className;
    private String tableName;
    private Id id;
    public final HashMap<String, Property> propertyMap = new HashMap();
    public final HashMap<String, OneToMany> oneToManyMap = new HashMap();
    public final HashMap<String, ManyToOne> manyToOneMap = new HashMap();
    private boolean checkDatabese;
    private static final HashMap<String, TableInfo> tableInfoMap = new HashMap();

    private TableInfo() {
    }

    public static TableInfo get(Class<?> clazz) {
        if (clazz == null) {
            throw new DbException("table info get error,because the clazz is null");
        }
        TableInfo tableInfo = tableInfoMap.get(clazz.getName());
        if (tableInfo == null) {
            List<OneToMany> oList;
            List<ManyToOne> mList;
            tableInfo = new TableInfo();
            tableInfo.setTableName(ClassUtils.getTableName(clazz));
            tableInfo.setClassName(clazz.getName());
            Field idField = ClassUtils.getPrimaryKeyField(clazz);
            if (idField == null) {
                throw new DbException("the class[" + clazz + "]'s idField is null , \n you can define _id,id property or use annotation @id to solution this exception");
            }
            Id id = new Id();
            id.setColumn(FieldUtils.getColumnByField(idField));
            id.setFieldName(idField.getName());
            id.setSet(FieldUtils.getFieldSetMethod(clazz, idField));
            id.setGet(FieldUtils.getFieldGetMethod(clazz, idField));
            id.setDataType(idField.getType());
            tableInfo.setId(id);
            List<Property> pList = ClassUtils.getPropertyList(clazz);
            if (pList != null) {
                for (Property p : pList) {
                    if (p == null) continue;
                    tableInfo.propertyMap.put(p.getColumn(), p);
                }
            }
            if ((mList = ClassUtils.getManyToOneList(clazz)) != null) {
                for (ManyToOne m : mList) {
                    if (m == null) continue;
                    tableInfo.manyToOneMap.put(m.getColumn(), m);
                }
            }
            if ((oList = ClassUtils.getOneToManyList(clazz)) != null) {
                for (OneToMany o : oList) {
                    if (o == null) continue;
                    tableInfo.oneToManyMap.put(o.getColumn(), o);
                }
            }
            tableInfoMap.put(clazz.getName(), tableInfo);
        }
        if (tableInfo == null) {
            throw new DbException("the class[" + clazz + "]'s table is null");
        }
        return tableInfo;
    }

    public static TableInfo get(String className) {
        try {
            return TableInfo.get(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public boolean isCheckDatabese() {
        return this.checkDatabese;
    }

    public void setCheckDatabese(boolean checkDatabese) {
        this.checkDatabese = checkDatabese;
    }
}

