/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.http;

import android.os.SystemClock;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import net.tsz.afinal.core.AsyncTask;
import net.tsz.afinal.http.AjaxCallBack;
import net.tsz.afinal.http.entityhandler.EntityCallBack;
import net.tsz.afinal.http.entityhandler.FileEntityHandler;
import net.tsz.afinal.http.entityhandler.StringEntityHandler;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpHandler<T>
extends AsyncTask<Object, Object, Object>
implements EntityCallBack {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private final StringEntityHandler mStrEntityHandler = new StringEntityHandler();
    private final FileEntityHandler mFileEntityHandler = new FileEntityHandler();
    private final AjaxCallBack<T> callback;
    private int executionCount = 0;
    private String targetUrl = null;
    private boolean isResume = false;
    private String charset;
    private static final int UPDATE_START = 1;
    private static final int UPDATE_LOADING = 2;
    private static final int UPDATE_FAILURE = 3;
    private static final int UPDATE_SUCCESS = 4;
    private long time;

    public HttpHandler(AbstractHttpClient client, HttpContext context, AjaxCallBack<T> callback, String charset) {
        this.client = client;
        this.context = context;
        this.callback = callback;
        this.charset = charset;
    }

    private void makeRequestWithRetries(HttpUriRequest request) throws IOException {
        if (this.isResume && this.targetUrl != null) {
            File downloadFile = new File(this.targetUrl);
            long fileLen = 0L;
            if (downloadFile.isFile() && downloadFile.exists()) {
                fileLen = downloadFile.length();
            }
            if (fileLen > 0L) {
                request.setHeader("RANGE", "bytes=" + fileLen + "-");
            }
        }
        boolean retry = true;
        IOException cause = null;
        HttpRequestRetryHandler retryHandler = this.client.getHttpRequestRetryHandler();
        while (retry) {
            try {
                if (!this.isCancelled()) {
                    HttpResponse response = this.client.execute(request, this.context);
                    if (!this.isCancelled()) {
                        this.handleResponse(response);
                    }
                }
                return;
            }
            catch (UnknownHostException e) {
                this.publishProgress(3, e, 0, "unknownHostException\uff1acan't resolve host");
                return;
            }
            catch (IOException e) {
                cause = e;
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
            catch (NullPointerException e) {
                cause = new IOException("NPE in HttpClient" + e.getMessage());
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
            catch (Exception e) {
                cause = new IOException("Exception" + e.getMessage());
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
        }
        if (cause != null) {
            throw cause;
        }
        throw new IOException("\u672a\u77e5\u7f51\u7edc\u9519\u8bef");
    }

    @Override
    protected Object doInBackground(Object ... params) {
        if (params != null && params.length == 3) {
            this.targetUrl = String.valueOf(params[1]);
            this.isResume = (Boolean)params[2];
        }
        try {
            this.publishProgress(1);
            this.makeRequestWithRetries((HttpUriRequest)params[0]);
        }
        catch (IOException e) {
            this.publishProgress(3, e, 0, e.getMessage());
        }
        return null;
    }

    @Override
    protected void onProgressUpdate(Object ... values) {
        int update = Integer.valueOf(String.valueOf(values[0]));
        switch (update) {
            case 1: {
                if (this.callback == null) break;
                this.callback.onStart();
                break;
            }
            case 2: {
                if (this.callback == null) break;
                this.callback.onLoading(Long.valueOf(String.valueOf(values[1])), Long.valueOf(String.valueOf(values[2])));
                break;
            }
            case 3: {
                if (this.callback == null) break;
                this.callback.onFailure((Throwable)values[1], (Integer)values[2], (String)values[3]);
                break;
            }
            case 4: {
                if (this.callback == null) break;
                this.callback.onSuccess(values[1]);
                break;
            }
        }
        super.onProgressUpdate(values);
    }

    public boolean isStop() {
        return this.mFileEntityHandler.isStop();
    }

    public void stop() {
        this.mFileEntityHandler.setStop(true);
    }

    private void handleResponse(HttpResponse response) {
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() >= 300) {
            String errorMsg = "response status error code:" + status.getStatusCode();
            if (status.getStatusCode() == 416 && this.isResume) {
                errorMsg = String.valueOf(errorMsg) + " \n maybe you have download complete.";
            }
            this.publishProgress(3, new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()), status.getStatusCode(), errorMsg);
        } else {
            try {
                HttpEntity entity = response.getEntity();
                Object responseBody = null;
                if (entity != null) {
                    this.time = SystemClock.uptimeMillis();
                    responseBody = this.targetUrl != null ? this.mFileEntityHandler.handleEntity(entity, this, this.targetUrl, this.isResume) : this.mStrEntityHandler.handleEntity(entity, this, this.charset);
                }
                this.publishProgress(4, responseBody);
            }
            catch (IOException e) {
                this.publishProgress(3, e, 0, e.getMessage());
            }
        }
    }

    @Override
    public void callBack(long count, long current, boolean mustNoticeUI) {
        if (this.callback != null && this.callback.isProgress()) {
            if (mustNoticeUI) {
                this.publishProgress(2, count, current);
            } else {
                long thisTime = SystemClock.uptimeMillis();
                if (thisTime - this.time >= (long)this.callback.getRate()) {
                    this.time = thisTime;
                    this.publishProgress(2, count, current);
                }
            }
        }
    }
}

