/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.http.entityhandler;

import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.tsz.afinal.http.entityhandler.EntityCallBack;
import org.apache.http.HttpEntity;

public class FileEntityHandler {
    private boolean mStop = false;

    public boolean isStop() {
        return this.mStop;
    }

    public void setStop(boolean stop) {
        this.mStop = stop;
    }

    public Object handleEntity(HttpEntity entity, EntityCallBack callback, String target, boolean isResume) throws IOException {
        if (TextUtils.isEmpty((CharSequence)target) || target.trim().length() == 0) {
            return null;
        }
        File targetFile = new File(target);
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        }
        if (this.mStop) {
            return targetFile;
        }
        long current = 0L;
        FileOutputStream os = null;
        if (isResume) {
            current = targetFile.length();
            os = new FileOutputStream(target, true);
        } else {
            os = new FileOutputStream(target);
        }
        if (this.mStop) {
            return targetFile;
        }
        InputStream input = entity.getContent();
        long count = entity.getContentLength() + current;
        if (current >= count || this.mStop) {
            return targetFile;
        }
        int readLen = 0;
        byte[] buffer = new byte[1024];
        while (!this.mStop && current < count && (readLen = input.read(buffer, 0, 1024)) > 0) {
            os.write(buffer, 0, readLen);
            callback.callBack(count, current += (long)readLen, false);
        }
        callback.callBack(count, current, true);
        if (this.mStop && current < count) {
            throw new IOException("user stop download thread");
        }
        return targetFile;
    }
}

