/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.tsz.afinal.db.sqlite.CursorUtils;
import net.tsz.afinal.db.sqlite.DbModel;
import net.tsz.afinal.db.sqlite.SqlBuilder;
import net.tsz.afinal.db.table.ManyToOne;
import net.tsz.afinal.db.table.OneToMany;
import net.tsz.afinal.db.table.TableInfo;

public class FinalDb {
    private static HashMap<String, FinalDb> daoMap = new HashMap();
    private SQLiteDatabase db;
    private DaoConfig config;

    private FinalDb(DaoConfig config) {
        if (config == null) {
            throw new RuntimeException("daoConfig is null");
        }
        if (config.getContext() == null) {
            throw new RuntimeException("android context is null");
        }
        this.db = new SqliteDbHelper(config.getContext(), config.getDbName(), config.getDbVersion()).getWritableDatabase();
        this.config = config;
    }

    private static synchronized FinalDb getInstance(DaoConfig daoConfig) {
        FinalDb dao = daoMap.get(daoConfig.getDbName());
        if (dao == null) {
            dao = new FinalDb(daoConfig);
            daoMap.put(daoConfig.getDbName(), dao);
        }
        return dao;
    }

    public static FinalDb create(Context context) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDebug(isDebug);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, String dbName) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        return FinalDb.getInstance(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        return FinalDb.getInstance(config);
    }

    public static FinalDb createSqliteDao(DaoConfig daoConfig) {
        return FinalDb.getInstance(daoConfig);
    }

    public void save(Object entity) {
        this.checkTableExist(entity.getClass());
        String saveSQL = SqlBuilder.getInsertSQL(entity);
        this.debugSql(saveSQL);
        this.db.execSQL(saveSQL);
    }

    public void update(Object entity) {
        this.checkTableExist(entity.getClass());
        String saveSQL = SqlBuilder.getUpdateSQL(entity);
        this.debugSql(saveSQL);
        this.db.execSQL(saveSQL);
    }

    public void update(Object entity, String ... strWhere) {
        this.checkTableExist(entity.getClass());
        String saveSQL = SqlBuilder.getUpdateSQL(entity, strWhere);
        this.debugSql(saveSQL);
        this.db.execSQL(saveSQL);
    }

    public void deleteById(Object entity) {
        this.checkTableExist(entity.getClass());
        String sql = SqlBuilder.getDeleteSQL(entity);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void deleteById(Class<?> clazz, Object id) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getDeleteSQL(clazz, id);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void deleteByWhere(Class<?> clazz, String ... strWhere) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getDeleteSQL(clazz, strWhere);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public <T> T findById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        Cursor cursor = this.db.rawQuery(sql, null);
        try {
            if (cursor.moveToNext()) {
                T t = CursorUtils.getEntity(cursor, clazz);
                return t;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public <T> T findObjectWihtManyToOneById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<ManyToOne> manys = TableInfo.get(clazz).manyToOneMap.values();
                    for (ManyToOne many : manys) {
                        Object manyEntity;
                        Object obj = dbModel.get(many.getColumn());
                        if (obj == null || (manyEntity = this.findById(Integer.valueOf(obj.toString()), many.getDataType())) == null) continue;
                        many.setValue(entity, manyEntity);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> T findObjectWihtManyToOneById(Object id, Class<T> clazz, Class<?> ... findClass) {
        if (findClass != null && findClass.length > 0) {
            this.checkTableExist(clazz);
            String sql = SqlBuilder.getSelectSQL(clazz, id);
            this.debugSql(sql);
            DbModel dbModel = this.findDbModelBySQL(sql);
            if (dbModel != null) {
                Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
                if (entity != null) {
                    try {
                        Collection<ManyToOne> manys = TableInfo.get(clazz).manyToOneMap.values();
                        for (ManyToOne many : manys) {
                            Object manyEntity;
                            boolean isFind = false;
                            Class<?>[] classArray = findClass;
                            int n = findClass.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Class<?> mClass = classArray[n2];
                                if (many.getManyClass() == mClass) {
                                    isFind = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!isFind || (manyEntity = this.findById(dbModel.get(many.getColumn()), many.getDataType())) == null) continue;
                            many.setValue(entity, manyEntity);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return entity;
            }
            return null;
        }
        return this.findObjectWihtManyToOneById(id, clazz);
    }

    public <T> T findObjectWihtOneToManyById(Object id, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<OneToMany> ones = TableInfo.get(clazz).oneToManyMap.values();
                    for (OneToMany one : ones) {
                        List<?> list = this.findListByWhere(one.getOneClass(), String.valueOf(one.getColumn()) + "=" + id);
                        if (list == null) continue;
                        one.setValue(entity, list);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> T findObjectWihtOneToManyById(Object id, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            if (entity != null) {
                try {
                    Collection<OneToMany> ones = TableInfo.get(clazz).oneToManyMap.values();
                    for (OneToMany one : ones) {
                        List<?> list;
                        boolean isFind = false;
                        Class<?>[] classArray = findClass;
                        int n = findClass.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?> mClass = classArray[n2];
                            if (one.getOneClass().equals(mClass.getName())) {
                                isFind = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!isFind || (list = this.findListByWhere(one.getOneClass(), String.valueOf(one.getColumn()) + "=" + id)) == null) continue;
                        one.setValue(entity, list);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return entity;
        }
        return null;
    }

    public <T> List<T> findAll(Class<T> clazz) {
        this.checkTableExist(clazz);
        return this.findList(clazz, SqlBuilder.getSelectSQL(clazz));
    }

    public <T> List<T> findAll(Class<T> clazz, String orderBy) {
        this.checkTableExist(clazz);
        return this.findList(clazz, String.valueOf(SqlBuilder.getSelectSQL(clazz)) + " ORDER BY '" + orderBy + "' DESC");
    }

    public <T> List<T> findList(Class<T> clazz, String strSQL) {
        this.checkTableExist(clazz);
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            ArrayList<T> list = new ArrayList<T>();
            while (cursor.moveToNext()) {
                T t = CursorUtils.getEntity(cursor, clazz);
                list.add(t);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return null;
    }

    public <T> List<T> findListByWhere(Class<T> clazz, String ... strWhere) {
        this.checkTableExist(clazz);
        String strSQL = SqlBuilder.getSelectSQL(clazz, strWhere);
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            ArrayList<T> list = new ArrayList<T>();
            while (cursor.moveToNext()) {
                T t = CursorUtils.getEntity(cursor, clazz);
                if (t == null) continue;
                list.add(t);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return null;
    }

    public DbModel findDbModelBySQL(String strSQL) {
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorUtils.getDbModel(cursor);
                return dbModel;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cursor.close();
        }
        return null;
    }

    private void checkTableExist(Class<?> clazz) {
        if (!this.tableIsExist(TableInfo.get(clazz))) {
            String sql = SqlBuilder.getCreatTableSQL(clazz);
            this.debugSql(sql);
            this.db.execSQL(sql);
        }
    }

    private boolean tableIsExist(TableInfo table) {
        if (table.isCheckDatabese()) {
            return true;
        }
        Cursor cursor = null;
        try {
            int count;
            String sql = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + table.getTableName() + "' ";
            this.debugSql(sql);
            cursor = this.db.rawQuery(sql, null);
            if (cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                table.setCheckDatabese(true);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return false;
    }

    private void debugSql(String sql) {
        if (this.config != null && this.config.isDebug()) {
            Log.d((String)"Debug SQL", (String)(">>>>>>  " + sql));
        }
    }

    public static class DaoConfig {
        private Context context = null;
        private String dbName = "afinal.db";
        private int dbVersion = 1;
        private boolean debug = true;

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public String getDbName() {
            return this.dbName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public void setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }
    }

    class SqliteDbHelper
    extends SQLiteOpenHelper {
        public SqliteDbHelper(Context context, String name, int version) {
            super(context, name, null, version);
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

