/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.download;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.tsz.afinal.bitmap.download.Downloader;

public class SimpleHttpDownloader
implements Downloader {
    private static final String TAG = "BitmapDownloader";
    private static final int IO_BUFFER_SIZE = 8192;

    @Override
    public boolean downloadToLocalStreamByUrl(String urlString, OutputStream outputStream) {
        HttpURLConnection urlConnection = null;
        FilterOutputStream out = null;
        FilterInputStream in = null;
        try {
            int b;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            in = new FlushedInputStream(new BufferedInputStream(urlConnection.getInputStream(), 8192));
            out = new BufferedOutputStream(outputStream, 8192);
            while ((b = in.read()) != -1) {
                ((BufferedOutputStream)out).write(b);
            }
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error in downloadBitmap - " + e));
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped = 0L;
            while (totalBytesSkipped < n) {
                long bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped == 0L) {
                    int by_te = this.read();
                    if (by_te < 0) break;
                    bytesSkipped = 1L;
                }
                totalBytesSkipped += bytesSkipped;
            }
            return totalBytesSkipped;
        }
    }
}

