/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.tsz.afinal.annotation.sqlite.Id;
import net.tsz.afinal.annotation.sqlite.ManyToOne;
import net.tsz.afinal.annotation.sqlite.OneToMany;
import net.tsz.afinal.annotation.sqlite.Property;
import net.tsz.afinal.annotation.sqlite.Transient;
import net.tsz.afinal.reflect.ClassUtils;

public class FieldUtils {
    public static Method getFieldGetMethod(Class<?> clazz, Field f) {
        String fn = f.getName();
        return FieldUtils.getFieldGetMethod(clazz, fn);
    }

    public static Method getFieldGetMethod(Class<?> clazz, String fieldName) {
        String mn = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            return clazz.getDeclaredMethod(mn, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getFieldSetMethod(Class<?> clazz, Field f) {
        String fn = f.getName();
        String mn = "set" + fn.substring(0, 1).toUpperCase() + fn.substring(1);
        try {
            return clazz.getDeclaredMethod(mn, f.getType());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getFieldSetMethod(Class<?> clazz, String fieldName) {
        try {
            return FieldUtils.getFieldSetMethod(clazz, clazz.getDeclaredField(fieldName));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getFieldValue(Object entity, Field field) {
        Method method = FieldUtils.getFieldGetMethod(entity.getClass(), field);
        return FieldUtils.invoke(entity, method);
    }

    public static Object getFieldValue(Object entity, String fieldName) {
        Method method = FieldUtils.getFieldGetMethod(entity.getClass(), fieldName);
        return FieldUtils.invoke(entity, method);
    }

    public static void setFieldValue(Object entity, Field field, Object value) {
        try {
            Method set = FieldUtils.getFieldSetMethod(entity.getClass(), field);
            if (set != null) {
                set.setAccessible(true);
                Class<?> type = field.getType();
                if (type == String.class) {
                    set.invoke(entity, value.toString());
                } else if (type == Integer.TYPE || type == Integer.class) {
                    set.invoke(entity, value == null ? null : Integer.parseInt(value.toString()));
                } else if (type == Float.TYPE || type == Float.class) {
                    set.invoke(entity, Float.valueOf(value == null ? ((Float)null).floatValue() : Float.parseFloat(value.toString())));
                } else if (type == Long.TYPE || type == Long.class) {
                    set.invoke(entity, value == null ? null : Long.parseLong(value.toString()));
                } else if (type == Date.class) {
                    set.invoke(entity, value == null ? null : FieldUtils.stringToDateTime(value.toString()));
                } else {
                    set.invoke(entity, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Field getFieldByColumnName(Class<?> clazz, String columnName) {
        Field[] fields;
        Field field = null;
        if (columnName != null && (fields = clazz.getDeclaredFields()) != null && fields.length > 0) {
            if (columnName.equals(ClassUtils.getPrimaryKeyColumn(clazz))) {
                field = ClassUtils.getPrimaryKeyField(clazz);
            }
            if (field == null) {
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    Property property = f.getAnnotation(Property.class);
                    if (property != null && columnName.equals(property.column())) {
                        field = f;
                        break;
                    }
                    ManyToOne manyToOne = f.getAnnotation(ManyToOne.class);
                    if (manyToOne != null && manyToOne.column().trim().length() != 0) {
                        field = f;
                        break;
                    }
                    ++n2;
                }
            }
            if (field == null) {
                field = FieldUtils.getFieldByName(clazz, columnName);
            }
        }
        return field;
    }

    public static Field getFieldByName(Class<?> clazz, String fieldName) {
        Field field = null;
        if (fieldName != null) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return field;
    }

    public static String getColumnByField(Field field) {
        Property property = field.getAnnotation(Property.class);
        if (property != null && property.column().trim().length() != 0) {
            return property.column();
        }
        ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
        if (manyToOne != null && manyToOne.column().trim().length() != 0) {
            return manyToOne.column();
        }
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        if (oneToMany != null && oneToMany.manyColumn() != null && oneToMany.manyColumn().trim().length() != 0) {
            return oneToMany.manyColumn();
        }
        Id id = field.getAnnotation(Id.class);
        if (id != null && id.column().trim().length() != 0) {
            return id.column();
        }
        return field.getName();
    }

    public static String getPropertyDefaultValue(Field field) {
        Property property = field.getAnnotation(Property.class);
        if (property != null && property.defaultValue().trim().length() != 0) {
            return property.defaultValue();
        }
        return null;
    }

    public static boolean isTransient(Field f) {
        return f.getAnnotation(Transient.class) != null;
    }

    private static Object invoke(Object obj, Method method) {
        if (obj == null || method == null) {
            return null;
        }
        try {
            return method.invoke(obj, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isManyToOne(Field field) {
        return field.getAnnotation(ManyToOne.class) != null;
    }

    public static boolean isOneToMany(Field field) {
        return field.getAnnotation(OneToMany.class) != null;
    }

    public static boolean isManyToOneOrOneToMany(Field field) {
        return FieldUtils.isManyToOne(field) || FieldUtils.isOneToMany(field);
    }

    public static boolean isBaseDateType(Field field) {
        Class<?> clazz = field.getType();
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Float.TYPE || clazz == Float.class || clazz == Long.TYPE || clazz == Long.class || clazz == String.class || clazz == Date.class;
    }

    private static Date stringToDateTime(String strDate) {
        if (strDate != null) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

