/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.graphics.Bitmap;
import net.tsz.afinal.bitmap.core.IMemoryCache;
import net.tsz.afinal.bitmap.core.LruMemoryCache;
import net.tsz.afinal.utils.Utils;

public class BaseMemoryCacheImpl
implements IMemoryCache {
    private final LruMemoryCache<String, Bitmap> mMemoryCache;

    public BaseMemoryCacheImpl(int size) {
        this.mMemoryCache = new LruMemoryCache<String, Bitmap>(size){

            @Override
            protected int sizeOf(String key, Bitmap bitmap) {
                return Utils.getBitmapSize(bitmap);
            }
        };
    }

    @Override
    public void put(String key, Bitmap bitmap) {
        this.mMemoryCache.put(key, bitmap);
    }

    @Override
    public Bitmap get(String key) {
        return this.mMemoryCache.get(key);
    }

    @Override
    public void evictAll() {
        this.mMemoryCache.evictAll();
    }

    @Override
    public void remove(String key) {
        this.mMemoryCache.remove(key);
    }
}

