/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.tsz.afinal.bitmap.core.BaseMemoryCacheImpl;
import net.tsz.afinal.bitmap.core.BytesBufferPool;
import net.tsz.afinal.bitmap.core.DiskCache;
import net.tsz.afinal.bitmap.core.IMemoryCache;
import net.tsz.afinal.bitmap.core.SoftMemoryCacheImpl;
import net.tsz.afinal.utils.Utils;

public class BitmapCache {
    private static final int DEFAULT_MEM_CACHE_SIZE = 0x800000;
    private static final int DEFAULT_DISK_CACHE_SIZE = 0x3200000;
    private static final int DEFAULT_DISK_CACHE_COUNT = 10000;
    private static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
    private static final boolean DEFAULT_DISK_CACHE_ENABLED = true;
    private DiskCache mDiskCache;
    private IMemoryCache mMemoryCache;
    private ImageCacheParams mCacheParams;

    public BitmapCache(ImageCacheParams cacheParams) {
        this.init(cacheParams);
    }

    private void init(ImageCacheParams cacheParams) {
        this.mCacheParams = cacheParams;
        if (this.mCacheParams.memoryCacheEnabled) {
            this.mMemoryCache = this.mCacheParams.recycleImmediately ? new SoftMemoryCacheImpl(this.mCacheParams.memCacheSize) : new BaseMemoryCacheImpl(this.mCacheParams.memCacheSize);
        }
        if (cacheParams.diskCacheEnabled) {
            try {
                String path = this.mCacheParams.diskCacheDir.getAbsolutePath();
                this.mDiskCache = new DiskCache(path, this.mCacheParams.diskCacheCount, this.mCacheParams.diskCacheSize, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addToMemoryCache(String url, Bitmap bitmap) {
        if (url == null || bitmap == null) {
            return;
        }
        this.mMemoryCache.put(url, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDiskCache(String url, byte[] data) {
        if (this.mDiskCache == null || url == null || data == null) {
            return;
        }
        byte[] key = Utils.makeKey(url);
        long cacheKey = Utils.crc64Long(key);
        ByteBuffer buffer = ByteBuffer.allocate(key.length + data.length);
        buffer.put(key);
        buffer.put(data);
        DiskCache diskCache = this.mDiskCache;
        synchronized (diskCache) {
            try {
                this.mDiskCache.insert(cacheKey, buffer.array());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getImageData(String url, BytesBufferPool.BytesBuffer buffer) {
        if (this.mDiskCache == null) {
            return false;
        }
        byte[] key = Utils.makeKey(url);
        long cacheKey = Utils.crc64Long(key);
        try {
            DiskCache.LookupRequest request = new DiskCache.LookupRequest();
            request.key = cacheKey;
            request.buffer = buffer.data;
            DiskCache diskCache = this.mDiskCache;
            synchronized (diskCache) {
                if (!this.mDiskCache.lookup(request)) {
                    return false;
                }
            }
            if (!Utils.isSameKey(key, request.buffer)) return false;
            buffer.data = request.buffer;
            buffer.offset = key.length;
            buffer.length = request.length - buffer.offset;
            return true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public Bitmap getBitmapFromMemoryCache(String data) {
        if (this.mMemoryCache != null) {
            return this.mMemoryCache.get(data);
        }
        return null;
    }

    public void clearCache() {
        this.clearMemoryCache();
        this.clearDiskCache();
    }

    public void clearDiskCache() {
        if (this.mDiskCache != null) {
            this.mDiskCache.delete();
        }
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
    }

    public void clearCache(String key) {
        this.clearMemoryCache(key);
        this.clearDiskCache(key);
    }

    public void clearDiskCache(String url) {
        this.addToDiskCache(url, new byte[0]);
    }

    public void clearMemoryCache(String key) {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.remove(key);
        }
    }

    public void close() {
        if (this.mDiskCache != null) {
            this.mDiskCache.close();
        }
    }

    public static class ImageCacheParams {
        public int memCacheSize = 0x800000;
        public int diskCacheSize = 0x3200000;
        public int diskCacheCount = 10000;
        public File diskCacheDir;
        public boolean memoryCacheEnabled = true;
        public boolean diskCacheEnabled = true;
        public boolean recycleImmediately = true;

        public ImageCacheParams(File diskCacheDir) {
            this.diskCacheDir = diskCacheDir;
        }

        public ImageCacheParams(String diskCacheDir) {
            this.diskCacheDir = new File(diskCacheDir);
        }

        public void setMemCacheSizePercent(Context context, float percent) {
            if (percent < 0.05f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.05 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.round(percent * (float)ImageCacheParams.getMemoryClass(context) * 1024.0f * 1024.0f);
        }

        public void setMemCacheSize(int memCacheSize) {
            this.memCacheSize = memCacheSize;
        }

        public void setDiskCacheSize(int diskCacheSize) {
            this.diskCacheSize = diskCacheSize;
        }

        private static int getMemoryClass(Context context) {
            return ((ActivityManager)context.getSystemService("activity")).getMemoryClass();
        }

        public void setDiskCacheCount(int diskCacheCount) {
            this.diskCacheCount = diskCacheCount;
        }

        public void setRecycleImmediately(boolean recycleImmediately) {
            this.recycleImmediately = recycleImmediately;
        }
    }
}

