/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import java.util.ArrayList;

public class BytesBufferPool {
    private final int mPoolSize;
    private final int mBufferSize;
    private final ArrayList<BytesBuffer> mList;

    public BytesBufferPool(int poolSize, int bufferSize) {
        this.mList = new ArrayList(poolSize);
        this.mPoolSize = poolSize;
        this.mBufferSize = bufferSize;
    }

    public synchronized BytesBuffer get() {
        int n = this.mList.size();
        return n > 0 ? this.mList.remove(n - 1) : new BytesBuffer(this.mBufferSize);
    }

    public synchronized void recycle(BytesBuffer buffer) {
        if (buffer.data.length != this.mBufferSize) {
            return;
        }
        if (this.mList.size() < this.mPoolSize) {
            buffer.offset = 0;
            buffer.length = 0;
            this.mList.add(buffer);
        }
    }

    public synchronized void clear() {
        this.mList.clear();
    }

    public static class BytesBuffer {
        public byte[] data;
        public int offset;
        public int length;

        private BytesBuffer(int capacity) {
            this.data = new byte[capacity];
        }
    }
}

