/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.graphics.Bitmap;
import java.lang.ref.SoftReference;
import net.tsz.afinal.bitmap.core.IMemoryCache;
import net.tsz.afinal.bitmap.core.LruMemoryCache;
import net.tsz.afinal.utils.Utils;

public class SoftMemoryCacheImpl
implements IMemoryCache {
    private final LruMemoryCache<String, SoftReference<Bitmap>> mMemoryCache;

    public SoftMemoryCacheImpl(int size) {
        this.mMemoryCache = new LruMemoryCache<String, SoftReference<Bitmap>>(size){

            @Override
            protected int sizeOf(String key, SoftReference<Bitmap> sBitmap) {
                Bitmap bitmap;
                Bitmap bitmap2 = bitmap = sBitmap == null ? null : sBitmap.get();
                if (bitmap == null) {
                    return 1;
                }
                return Utils.getBitmapSize(bitmap);
            }
        };
    }

    @Override
    public void put(String key, Bitmap bitmap) {
        this.mMemoryCache.put(key, new SoftReference<Bitmap>(bitmap));
    }

    @Override
    public Bitmap get(String key) {
        SoftReference<Bitmap> memBitmap = this.mMemoryCache.get(key);
        if (memBitmap != null) {
            return memBitmap.get();
        }
        return null;
    }

    @Override
    public void evictAll() {
        this.mMemoryCache.evictAll();
    }

    @Override
    public void remove(String key) {
        this.mMemoryCache.remove(key);
    }
}

