/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.File;

public class Utils {
    private static final String TAG = "BitmapCommonUtils";
    private static final long POLY64REV = -7661587058870466123L;
    private static final long INITIALCRC = -1L;
    private static long[] sCrcTable = new long[256];

    static {
        int i = 0;
        while (i < 256) {
            long part = i;
            int j = 0;
            while (j < 8) {
                long x = ((int)part & 1) != 0 ? -7661587058870466123L : 0L;
                part = part >> 1 ^ x;
                ++j;
            }
            Utils.sCrcTable[i] = part;
            ++i;
        }
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) ? Utils.getExternalCacheDir(context).getPath() : context.getCacheDir().getPath();
        return new File(String.valueOf(cachePath) + File.separator + uniqueName);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static File getExternalCacheDir(Context context) {
        String cacheDir = "/Android/data/" + context.getPackageName() + "/cache/";
        return new File(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + cacheDir);
    }

    public static long getUsableSpace(File path) {
        try {
            StatFs stats = new StatFs(path.getPath());
            return (long)stats.getBlockSize() * (long)stats.getAvailableBlocks();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"\u83b7\u53d6 sdcard \u7f13\u5b58\u5927\u5c0f \u51fa\u9519\uff0c\u8bf7\u67e5\u770bAndroidManifest.xml \u662f\u5426\u6dfb\u52a0\u4e86sdcard\u7684\u8bbf\u95ee\u6743\u9650");
            e.printStackTrace();
            return -1L;
        }
    }

    public static byte[] getBytes(String in) {
        byte[] result = new byte[in.length() * 2];
        int output = 0;
        char[] cArray = in.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            result[output++] = (byte)(ch & 0xFF);
            result[output++] = (byte)(ch >> 8);
            ++n2;
        }
        return result;
    }

    public static boolean isSameKey(byte[] key, byte[] buffer) {
        int n = key.length;
        if (buffer.length < n) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (key[i] != buffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] makeKey(String httpUrl) {
        return Utils.getBytes(httpUrl);
    }

    public static final long crc64Long(String in) {
        if (in == null || in.length() == 0) {
            return 0L;
        }
        return Utils.crc64Long(Utils.getBytes(in));
    }

    public static final long crc64Long(byte[] buffer) {
        long crc = -1L;
        int k = 0;
        int n = buffer.length;
        while (k < n) {
            crc = sCrcTable[((int)crc ^ buffer[k]) & 0xFF] ^ crc >> 8;
            ++k;
        }
        return crc;
    }
}

