/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.annotation.view;

import android.view.View;
import android.widget.AdapterView;
import java.lang.reflect.Method;
import net.tsz.afinal.exception.ViewException;

public class EventListener
implements View.OnClickListener,
View.OnLongClickListener,
AdapterView.OnItemClickListener,
AdapterView.OnItemSelectedListener,
AdapterView.OnItemLongClickListener {
    private Object handler;
    private String clickMethod;
    private String longClickMethod;
    private String itemClickMethod;
    private String itemSelectMethod;
    private String nothingSelectedMethod;
    private String itemLongClickMehtod;

    public EventListener(Object handler) {
        this.handler = handler;
    }

    public EventListener click(String method) {
        this.clickMethod = method;
        return this;
    }

    public EventListener longClick(String method) {
        this.longClickMethod = method;
        return this;
    }

    public EventListener itemLongClick(String method) {
        this.itemLongClickMehtod = method;
        return this;
    }

    public EventListener itemClick(String method) {
        this.itemClickMethod = method;
        return this;
    }

    public EventListener select(String method) {
        this.itemSelectMethod = method;
        return this;
    }

    public EventListener noSelect(String method) {
        this.nothingSelectedMethod = method;
        return this;
    }

    public boolean onLongClick(View v) {
        return EventListener.invokeLongClickMethod(this.handler, this.longClickMethod, v);
    }

    public boolean onItemLongClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        return EventListener.invokeItemLongClickMethod(this.handler, this.itemLongClickMehtod, arg0, arg1, arg2, arg3);
    }

    public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        EventListener.invokeItemSelectMethod(this.handler, this.itemSelectMethod, arg0, arg1, arg2, arg3);
    }

    public void onNothingSelected(AdapterView<?> arg0) {
        EventListener.invokeNoSelectMethod(this.handler, this.nothingSelectedMethod, arg0);
    }

    public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        EventListener.invokeItemClickMethod(this.handler, this.itemClickMethod, arg0, arg1, arg2, arg3);
    }

    public void onClick(View v) {
        EventListener.invokeClickMethod(this.handler, this.clickMethod, v);
    }

    private static Object invokeClickMethod(Object handler, String methodName, Object ... params) {
        if (handler == null) {
            return null;
        }
        Method method = null;
        try {
            method = handler.getClass().getDeclaredMethod(methodName, View.class);
            if (method != null) {
                return method.invoke(handler, params);
            }
            throw new ViewException("no such method:" + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean invokeLongClickMethod(Object handler, String methodName, Object ... params) {
        if (handler == null) {
            return false;
        }
        Method method = null;
        try {
            method = handler.getClass().getDeclaredMethod(methodName, View.class);
            if (method != null) {
                Object obj = method.invoke(handler, params);
                return obj == null ? false : Boolean.valueOf(obj.toString());
            }
            throw new ViewException("no such method:" + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Object invokeItemClickMethod(Object handler, String methodName, Object ... params) {
        if (handler == null) {
            return null;
        }
        Method method = null;
        try {
            method = handler.getClass().getDeclaredMethod(methodName, AdapterView.class, View.class, Integer.TYPE, Long.TYPE);
            if (method != null) {
                return method.invoke(handler, params);
            }
            throw new ViewException("no such method:" + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean invokeItemLongClickMethod(Object handler, String methodName, Object ... params) {
        if (handler == null) {
            throw new ViewException("invokeItemLongClickMethod: handler is null :");
        }
        Method method = null;
        try {
            method = handler.getClass().getDeclaredMethod(methodName, AdapterView.class, View.class, Integer.TYPE, Long.TYPE);
            if (method != null) {
                Object obj = method.invoke(handler, params);
                return obj == null ? false : Boolean.valueOf(obj.toString());
            }
            throw new ViewException("no such method:" + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Object invokeItemSelectMethod(Object handler, String methodName, Object ... params) {
        if (handler == null) {
            return null;
        }
        Method method = null;
        try {
            method = handler.getClass().getDeclaredMethod(methodName, AdapterView.class, View.class, Integer.TYPE, Long.TYPE);
            if (method != null) {
                return method.invoke(handler, params);
            }
            throw new ViewException("no such method:" + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object invokeNoSelectMethod(Object handler, String methodName, Object ... params) {
        if (handler == null) {
            return null;
        }
        Method method = null;
        try {
            method = handler.getClass().getDeclaredMethod(methodName, AdapterView.class);
            if (method != null) {
                return method.invoke(handler, params);
            }
            throw new ViewException("no such method:" + methodName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

