/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.widget.ImageView;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.tsz.afinal.bitmap.core.BitmapCache;
import net.tsz.afinal.bitmap.core.BitmapCommonUtils;
import net.tsz.afinal.bitmap.core.BitmapDisplayConfig;
import net.tsz.afinal.bitmap.core.BitmapProcess;
import net.tsz.afinal.bitmap.display.Displayer;
import net.tsz.afinal.bitmap.display.SimpleDisplayer;
import net.tsz.afinal.bitmap.download.Downloader;
import net.tsz.afinal.bitmap.download.SimpleHttpDownloader;

public class FinalBitmap {
    private FinalBitmapConfig mConfig;
    private BitmapCache mImageCache;
    private boolean mExitTasksEarly = false;
    private boolean mPauseWork = false;
    private final Object mPauseWorkLock = new Object();
    private Context mContext;
    private ExecutorService bitmapLoadAndDisplayExecutor;

    public FinalBitmap(Context context) {
        this.mContext = context;
        this.mConfig = new FinalBitmapConfig(context);
        this.configDiskCachePath(BitmapCommonUtils.getDiskCacheDir(context, "afinalCache"));
        this.configDisplayer(new SimpleDisplayer());
        this.configDownlader(new SimpleHttpDownloader());
    }

    public FinalBitmap configLoadingImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadingImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configLoadfailImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadfailImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configDiskCachePath(String strPath) {
        if (!TextUtils.isEmpty((CharSequence)strPath)) {
            this.mConfig.cachePath = strPath;
        }
        return this;
    }

    public FinalBitmap configDiskCachePath(File pathFile) {
        if (pathFile != null) {
            this.configDiskCachePath(pathFile.getAbsolutePath());
        }
        return this;
    }

    public FinalBitmap configBitmapMaxHeight(int bitmapHeight) {
        this.mConfig.defaultDisplayConfig.setBitmapHeight(bitmapHeight);
        return this;
    }

    public FinalBitmap configBitmapMaxWidth(int bitmapWidth) {
        this.mConfig.defaultDisplayConfig.setBitmapWidth(bitmapWidth);
        return this;
    }

    public FinalBitmap configDownlader(Downloader downlader) {
        this.mConfig.downloader = downlader;
        return this;
    }

    public FinalBitmap configDisplayer(Displayer displayer) {
        this.mConfig.displayer = displayer;
        return this;
    }

    public FinalBitmap configMemoryCacheSize(int size) {
        this.mConfig.memCacheSize = size;
        return this;
    }

    public FinalBitmap configMemoryCachePercent(float percent) {
        this.mConfig.memCacheSizePercent = percent;
        return this;
    }

    public FinalBitmap configDiskCacheSize(int size) {
        this.mConfig.diskCacheSize = size;
        return this;
    }

    public FinalBitmap configOriginalDiskCacheSize(int size) {
        this.mConfig.diskCacheSize = size;
        return this;
    }

    public FinalBitmap configBitmapLoadThreadSize(int size) {
        if (size >= 1) {
            this.mConfig.poolSize = size;
        }
        return this;
    }

    public FinalBitmap init() {
        this.mConfig.init();
        BitmapCache.ImageCacheParams imageCacheParams = new BitmapCache.ImageCacheParams(this.mConfig.cachePath);
        if ((double)this.mConfig.memCacheSizePercent > 0.05 && (double)this.mConfig.memCacheSizePercent < 0.8) {
            imageCacheParams.setMemCacheSizePercent(this.mContext, this.mConfig.memCacheSizePercent);
        } else if (this.mConfig.memCacheSize > 0x200000) {
            imageCacheParams.setMemCacheSize(this.mConfig.memCacheSize);
        } else {
            imageCacheParams.setMemCacheSizePercent(this.mContext, 0.3f);
        }
        if (this.mConfig.diskCacheSize > 0x500000) {
            imageCacheParams.setDiskCacheSize(this.mConfig.diskCacheSize);
        }
        this.mImageCache = new BitmapCache(imageCacheParams);
        this.bitmapLoadAndDisplayExecutor = Executors.newFixedThreadPool(this.mConfig.poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(4);
                return t;
            }
        });
        new CacheExecutecTask().execute(new Object[]{1});
        return this;
    }

    public void display(ImageView imageView, String uri) {
        this.doDisplay(imageView, uri, null);
    }

    public void display(ImageView imageView, String uri, int imageWidth, int imageHeight) {
        BitmapDisplayConfig displayConfig = this.getDisplayConfig();
        displayConfig.setBitmapHeight(imageHeight);
        displayConfig.setBitmapWidth(imageWidth);
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, Bitmap loadingBitmap) {
        BitmapDisplayConfig displayConfig = this.getDisplayConfig();
        displayConfig.setLoadingBitmap(loadingBitmap);
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.getDisplayConfig();
        displayConfig.setLoadingBitmap(loadingBitmap);
        displayConfig.setLoadfailBitmap(laodfailBitmap);
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, int imageWidth, int imageHeight, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.getDisplayConfig();
        displayConfig.setBitmapHeight(imageHeight);
        displayConfig.setBitmapWidth(imageWidth);
        displayConfig.setLoadingBitmap(loadingBitmap);
        displayConfig.setLoadfailBitmap(laodfailBitmap);
        this.doDisplay(imageView, uri, displayConfig);
    }

    public void display(ImageView imageView, String uri, BitmapDisplayConfig config) {
        this.doDisplay(imageView, uri, config);
    }

    private void doDisplay(ImageView imageView, String uri, BitmapDisplayConfig displayConfig) {
        if (TextUtils.isEmpty((CharSequence)uri) || imageView == null) {
            return;
        }
        if (displayConfig == null) {
            displayConfig = this.mConfig.defaultDisplayConfig;
        }
        Bitmap bitmap = null;
        if (this.mImageCache != null) {
            bitmap = this.mImageCache.getBitmapFromMemCache(uri);
        }
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        } else if (FinalBitmap.checkImageTask(uri, imageView)) {
            BitmapLoadAndDisplayTask task = new BitmapLoadAndDisplayTask(imageView, uri, displayConfig);
            AsyncDrawable asyncDrawable = new AsyncDrawable(this.mContext.getResources(), displayConfig.getLoadingBitmap(), task);
            imageView.setImageDrawable((Drawable)asyncDrawable);
            this.bitmapLoadAndDisplayExecutor.submit(task);
        }
    }

    private BitmapDisplayConfig getDisplayConfig() {
        BitmapDisplayConfig config = new BitmapDisplayConfig();
        config.setAnimation(this.mConfig.defaultDisplayConfig.getAnimation());
        config.setAnimationType(this.mConfig.defaultDisplayConfig.getAnimationType());
        config.setBitmapHeight(this.mConfig.defaultDisplayConfig.getBitmapHeight());
        config.setBitmapWidth(this.mConfig.defaultDisplayConfig.getBitmapWidth());
        config.setLoadfailBitmap(this.mConfig.defaultDisplayConfig.getLoadfailBitmap());
        config.setLoadingBitmap(this.mConfig.defaultDisplayConfig.getLoadingBitmap());
        return config;
    }

    private void initDiskCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.initDiskCache();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.initHttpDiskCache();
        }
    }

    private void clearCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.clearCache();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.clearCacheInternal();
        }
    }

    private void flushCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.flush();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.flushCacheInternal();
        }
    }

    private void closeCacheInternal() {
        if (this.mImageCache != null) {
            this.mImageCache.close();
            this.mImageCache = null;
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.clearCacheInternal();
        }
    }

    private Bitmap processBitmap(String uri, BitmapDisplayConfig config) {
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            return this.mConfig.bitmapProcess.processBitmap(uri, config);
        }
        return null;
    }

    public void clearCache() {
        new CacheExecutecTask().execute(new Object[]{0});
    }

    public void flushCache() {
        new CacheExecutecTask().execute(new Object[]{2});
    }

    public void closeCache() {
        new CacheExecutecTask().execute(new Object[]{3});
    }

    public void exitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
        if (exitTasksEarly) {
            this.pauseWork(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWork(boolean pauseWork) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pauseWork;
            if (!this.mPauseWork) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    private static BitmapLoadAndDisplayTask getBitmapWorkerTask(ImageView imageView) {
        Drawable drawable;
        if (imageView != null && (drawable = imageView.getDrawable()) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    public static boolean checkImageTask(String data, ImageView imageView) {
        BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapWorkerTask(imageView);
        if (bitmapWorkerTask != null) {
            String bitmapData = bitmapWorkerTask.uriData;
            return bitmapData == null || !bitmapData.equals(data);
        }
        return true;
    }

    private static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapLoadAndDisplayTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapLoadAndDisplayTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapLoadAndDisplayTask>(bitmapWorkerTask);
        }

        public BitmapLoadAndDisplayTask getBitmapWorkerTask() {
            return (BitmapLoadAndDisplayTask)this.bitmapWorkerTaskReference.get();
        }
    }

    private class BitmapLoadAndDisplayTask
    implements Runnable {
        private final String uriData;
        private final WeakReference<ImageView> imageViewReference;
        private final BitmapDisplayConfig bitmapDisplayConfig;
        private Handler mhander = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        Bitmap bm = FinalBitmap.this.mImageCache.getBitmapFromMemCache(BitmapLoadAndDisplayTask.this.uriData.toString());
                        ImageView iv = BitmapLoadAndDisplayTask.this.getAttachedImageView();
                        if (iv == null || bm == null) break;
                        ((FinalBitmap)((BitmapLoadAndDisplayTask)BitmapLoadAndDisplayTask.this).FinalBitmap.this).mConfig.displayer.loadCompletedisplay(iv, bm, BitmapLoadAndDisplayTask.this.bitmapDisplayConfig);
                        break;
                    }
                    case 1: {
                        Bitmap failBitmap = BitmapLoadAndDisplayTask.this.bitmapDisplayConfig.getLoadfailBitmap();
                        ImageView failIv = BitmapLoadAndDisplayTask.this.getAttachedImageView();
                        if (failIv == null || failBitmap == null) break;
                        ((FinalBitmap)((BitmapLoadAndDisplayTask)BitmapLoadAndDisplayTask.this).FinalBitmap.this).mConfig.displayer.loadFailDisplay(failIv, failBitmap);
                        break;
                    }
                }
            }
        };

        public BitmapLoadAndDisplayTask(ImageView imageView, String uriData, BitmapDisplayConfig displayConfig) {
            this.imageViewReference = new WeakReference<ImageView>(imageView);
            this.uriData = uriData;
            this.bitmapDisplayConfig = displayConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                while (FinalBitmap.this.mPauseWork) {
                    try {
                        FinalBitmap.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Bitmap bitmap = null;
            if (FinalBitmap.this.mImageCache != null && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly) {
                bitmap = FinalBitmap.this.mImageCache.getBitmapFromDiskCache(this.uriData);
            }
            if (bitmap == null && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly) {
                bitmap = FinalBitmap.this.processBitmap(this.uriData, this.bitmapDisplayConfig);
            }
            if (bitmap != null && FinalBitmap.this.mImageCache != null) {
                FinalBitmap.this.mImageCache.addBitmapToCache(this.uriData, bitmap);
                this.mhander.sendEmptyMessage(0);
                return;
            }
            this.mhander.sendEmptyMessage(1);
        }

        private ImageView getAttachedImageView() {
            ImageView imageView = (ImageView)this.imageViewReference.get();
            BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapWorkerTask(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }
    }

    private class CacheExecutecTask
    extends AsyncTask<Object, Void, Void> {
        public static final int MESSAGE_CLEAR = 0;
        public static final int MESSAGE_INIT_DISK_CACHE = 1;
        public static final int MESSAGE_FLUSH = 2;
        public static final int MESSAGE_CLOSE = 3;

        private CacheExecutecTask() {
        }

        protected Void doInBackground(Object ... params) {
            switch ((Integer)params[0]) {
                case 0: {
                    FinalBitmap.this.clearCacheInternal();
                    break;
                }
                case 1: {
                    FinalBitmap.this.initDiskCacheInternal();
                    break;
                }
                case 2: {
                    FinalBitmap.this.flushCacheInternal();
                    break;
                }
                case 3: {
                    FinalBitmap.this.closeCacheInternal();
                }
            }
            return null;
        }
    }

    private class FinalBitmapConfig {
        public String cachePath;
        public Displayer displayer;
        public Downloader downloader;
        public BitmapProcess bitmapProcess;
        public BitmapDisplayConfig defaultDisplayConfig = new BitmapDisplayConfig();
        public float memCacheSizePercent;
        public int memCacheSize;
        public int diskCacheSize;
        public int poolSize = 3;
        public int originalDiskCache = 0x1400000;

        public FinalBitmapConfig(Context context) {
            this.defaultDisplayConfig.setAnimation(null);
            this.defaultDisplayConfig.setAnimationType(1);
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int defaultWidth = (int)Math.floor(displayMetrics.widthPixels / 3);
            this.defaultDisplayConfig.setBitmapHeight(defaultWidth);
            this.defaultDisplayConfig.setBitmapWidth(defaultWidth);
        }

        public void init() {
            if (this.downloader == null) {
                this.downloader = new SimpleHttpDownloader();
            }
            if (this.displayer == null) {
                this.displayer = new SimpleDisplayer();
            }
            this.bitmapProcess = new BitmapProcess(this.downloader, this.cachePath, this.originalDiskCache);
        }
    }
}

