/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal;

import android.os.Handler;
import android.os.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLHandshakeException;
import net.tsz.afinal.http.AjaxCallBack;
import net.tsz.afinal.http.AjaxRequest;
import net.tsz.afinal.http.AjaxStatus;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class FinalHttp {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static HttpRequestRetryHandler requestRetryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount >= 3) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            boolean idempotent = request instanceof HttpEntityEnclosingRequest;
            return !idempotent;
        }
    };
    private static ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String charset = EntityUtils.getContentCharSet((HttpEntity)entity) == null ? FinalHttp.CHARSET_UTF8 : EntityUtils.getContentCharSet((HttpEntity)entity);
                return new String(EntityUtils.toByteArray((HttpEntity)entity), charset);
            }
            return null;
        }
    };
    private static ResponseHandler<AjaxStatus> ajaxHandler = new ResponseHandler<AjaxStatus>(){

        public AjaxStatus handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            AjaxStatus ajaxResponse = new AjaxStatus();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ajaxResponse.setContent(EntityUtils.toByteArray((HttpEntity)entity));
            }
            ajaxResponse.setStatus(response.getStatusLine().getStatusCode());
            return ajaxResponse;
        }
    };
    private static ExecutorService ajaxExecutor = Executors.newFixedThreadPool(5, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setPriority(4);
            return t;
        }
    });

    public static String get(String url) {
        return FinalHttp.get(url, null, null);
    }

    public static String get(String url, Map<String, String> params) {
        return FinalHttp.get(url, params, null);
    }

    /*
     * Exception decompiling
     */
    public static String get(String url, Map<String, String> params, String charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String post(String url, Map<String, String> params) {
        return FinalHttp.post(url, params, null);
    }

    public static String post(String url, Map<String, String> params, String charset) {
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        url = FinalHttp.patchUrl(url);
        DefaultHttpClient httpclient = FinalHttp.getDefaultHttpClient(charset);
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = charset == null || charset.trim().length() == 0 ? new UrlEncodedFormEntity(FinalHttp.getParamsList(params)) : new UrlEncodedFormEntity(FinalHttp.getParamsList(params), charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpPost hp = new HttpPost(url);
        hp.setEntity((HttpEntity)formEntity);
        try {
            String string = (String)httpclient.execute((HttpUriRequest)hp, responseHandler);
            return string;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FinalHttp.abortConnection((HttpRequestBase)hp, (HttpClient)httpclient);
        }
        return null;
    }

    public static void ajax(String url, AjaxCallBack callBack) {
        AjaxRequest request = new AjaxRequest(url);
        ajaxExecutor.submit(new AjaxTask(callBack, request));
    }

    private static AjaxStatus ajax(AjaxRequest request) {
        if (request == null) {
            return null;
        }
        String url = FinalHttp.patchUrl(request.getUrl());
        String charset = request.getCharset();
        DefaultHttpClient httpclient = FinalHttp.getDefaultHttpClient(charset);
        UrlEncodedFormEntity formEntity = null;
        try {
            List<NameValuePair> paramList = FinalHttp.getParamsList(request.getParams());
            if (paramList != null && paramList.size() > 0) {
                formEntity = charset == null || charset.trim().length() == 0 ? new UrlEncodedFormEntity(FinalHttp.getParamsList(request.getParams())) : new UrlEncodedFormEntity(FinalHttp.getParamsList(request.getParams()), charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpPost hp = new HttpPost(url);
        hp.setEntity(formEntity);
        try {
            AjaxStatus ajaxStatus = ((AjaxStatus)httpclient.execute((HttpUriRequest)hp, ajaxHandler)).setUrl(request.getUrl());
            return ajaxStatus;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FinalHttp.abortConnection((HttpRequestBase)hp, (HttpClient)httpclient);
        }
        return null;
    }

    public static String postSend(String url, String data, String charset) {
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        DefaultHttpClient httpclient = FinalHttp.getDefaultHttpClient(charset);
        StringEntity formEntity = null;
        try {
            formEntity = charset == null || charset.trim().length() == 0 ? new StringEntity(data) : new StringEntity(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpPost hp = new HttpPost(url);
        hp.setEntity((HttpEntity)formEntity);
        try {
            String string = (String)httpclient.execute((HttpUriRequest)hp, responseHandler);
            return string;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FinalHttp.abortConnection((HttpRequestBase)hp, (HttpClient)httpclient);
        }
        return null;
    }

    private static DefaultHttpClient getDefaultHttpClient(String charset) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getParams().setParameter("http.connection.timeout", (Object)5000);
        httpclient.getParams().setParameter("http.socket.timeout", (Object)5000);
        httpclient.getParams().setParameter("http.protocol.content-charset", (Object)(charset == null ? CHARSET_UTF8 : charset));
        httpclient.setHttpRequestRetryHandler(requestRetryHandler);
        return httpclient;
    }

    private static void abortConnection(HttpRequestBase hrb, HttpClient httpclient) {
        if (hrb != null) {
            hrb.abort();
        }
        if (httpclient != null) {
            httpclient.getConnectionManager().shutdown();
        }
    }

    private static List<NameValuePair> getParamsList(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.size() == 0) {
            return null;
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> map : paramsMap.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(map.getKey(), map.getValue()));
        }
        return params;
    }

    private static String patchUrl(String url) {
        return url.replaceAll(" ", "%20").replaceAll("\\|", "%7C");
    }

    static class AjaxTask
    implements Runnable {
        private final AjaxCallBack mCallBack;
        private final AjaxRequest request;
        private final Handler mHandler = new Handler(){

            public void handleMessage(Message msg) {
                AjaxTask.this.mCallBack.callBack((AjaxStatus)msg.obj);
            }
        };

        public AjaxTask(AjaxCallBack callBack, AjaxRequest request) {
            this.mCallBack = callBack;
            this.request = request;
        }

        @Override
        public void run() {
            Message msg = new Message();
            msg.obj = FinalHttp.ajax(this.request);
            this.mHandler.sendMessage(msg);
        }
    }
}

