/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.db.sqlite;

import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import net.tsz.afinal.db.table.Id;
import net.tsz.afinal.db.table.KeyValue;
import net.tsz.afinal.db.table.ManyToOne;
import net.tsz.afinal.db.table.Property;
import net.tsz.afinal.db.table.TableInfo;
import net.tsz.afinal.exception.DbException;

public class SqlBuilder {
    public static String getInsertSQL(Object entity) {
        TableInfo table = TableInfo.get(entity.getClass());
        Object idvalue = table.getId().getValue(entity);
        ArrayList<Object> keyValueList = new ArrayList<Object>();
        if (!(idvalue instanceof Integer) && idvalue instanceof String && idvalue != null) {
            KeyValue kv = new KeyValue(table.getId().getColumn(), idvalue);
            keyValueList.add(kv);
        }
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            Object kv = SqlBuilder.property2KeyValue(property, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne many : manyToOnes) {
            KeyValue kv = SqlBuilder.manyToOne2KeyValue(many, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        StringBuffer strSQL = new StringBuffer();
        if (keyValueList != null && keyValueList.size() > 0) {
            strSQL.append("INSERT INTO ");
            strSQL.append(table.getTableName());
            strSQL.append(" (");
            for (Object kv : keyValueList) {
                strSQL.append(((KeyValue)kv).getKey()).append(",");
            }
            strSQL.deleteCharAt(strSQL.length() - 1);
            strSQL.append(") VALUES ( ");
            for (Object kv : keyValueList) {
                Object value = ((KeyValue)kv).getValue();
                if (value instanceof String) {
                    strSQL.append("'").append(value).append("'").append(",");
                    continue;
                }
                if (value instanceof Date || value instanceof java.sql.Date) {
                    strSQL.append("'").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value)).append("'").append(",");
                    continue;
                }
                strSQL.append(value).append(",");
            }
            strSQL.deleteCharAt(strSQL.length() - 1);
            strSQL.append(")");
        }
        return strSQL.toString();
    }

    private static String getDeleteSqlBytableName(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public static String getDeleteSQL(Object entity) {
        TableInfo table = TableInfo.get(entity.getClass());
        Id id = table.getId();
        Object idvalue = id.getValue(entity);
        if (idvalue == null) {
            throw new DbException("getDeleteSQL:" + entity.getClass() + " id value is null");
        }
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(table.getTableName()));
        strSQL.append(" WHERE ");
        strSQL.append(SqlBuilder.getPropertyStrSql(id.getColumn(), idvalue));
        return strSQL.toString();
    }

    public static String getDeleteSQL(Class<?> clazz, Object idValue) {
        TableInfo table = TableInfo.get(clazz);
        Id id = table.getId();
        if (idValue == null) {
            throw new DbException("getDeleteSQL:idValue is null");
        }
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(table.getTableName()));
        strSQL.append(" WHERE ");
        strSQL.append(SqlBuilder.getPropertyStrSql(id.getColumn(), idValue));
        return strSQL.toString();
    }

    public static String getDeleteSQLByWhere(Class<?> clazz, String strWhere) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(table.getTableName()));
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            strSQL.append(" WHERE ");
            strSQL.append(strWhere);
        }
        return strSQL.toString();
    }

    private static String getSelectSqlByTableName(String tableName) {
        return new StringBuffer("SELECT * FROM ").append(tableName).toString();
    }

    public static String getSelectSQL(Class<?> clazz, Object idValue) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getSelectSqlByTableName(table.getTableName()));
        strSQL.append(" WHERE ");
        strSQL.append(SqlBuilder.getPropertyStrSql(table.getId().getColumn(), idValue));
        return strSQL.toString();
    }

    public static String getSelectSQL(Class<?> clazz) {
        return SqlBuilder.getSelectSqlByTableName(TableInfo.get(clazz).getTableName());
    }

    public static String getSelectSQLByWhere(Class<?> clazz, String strWhere) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getSelectSqlByTableName(table.getTableName()));
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            strSQL.append(" WHERE ").append(strWhere);
        }
        return strSQL.toString();
    }

    public static String getUpdateSQL(Object entity) {
        TableInfo table = TableInfo.get(entity.getClass());
        Object idvalue = table.getId().getValue(entity);
        if (idvalue == null) {
            throw new DbException("this entity[" + entity.getClass() + "]'s id value is null");
        }
        ArrayList<Object> keyValueList = new ArrayList<Object>();
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            Object kv = SqlBuilder.property2KeyValue(property, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne many : manyToOnes) {
            KeyValue kv = SqlBuilder.manyToOne2KeyValue(many, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        if (keyValueList == null || keyValueList.size() == 0) {
            return null;
        }
        StringBuffer strSQL = new StringBuffer("UPDATE ");
        strSQL.append(table.getTableName());
        strSQL.append(" SET ");
        for (Object kv : keyValueList) {
            strSQL.append(SqlBuilder.getPropertyStrSql((KeyValue)kv)).append(",");
        }
        strSQL.deleteCharAt(strSQL.length() - 1);
        strSQL.append(" WHERE ").append(SqlBuilder.getPropertyStrSql(table.getId().getColumn(), idvalue));
        return strSQL.toString();
    }

    public static String getUpdateSQL(Object entity, String strWhere) {
        TableInfo table = TableInfo.get(entity.getClass());
        ArrayList<Object> keyValueList = new ArrayList<Object>();
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            Object kv = SqlBuilder.property2KeyValue(property, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne many : manyToOnes) {
            KeyValue kv = SqlBuilder.manyToOne2KeyValue(many, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        if (keyValueList == null || keyValueList.size() == 0) {
            throw new DbException("this entity[" + entity.getClass() + "] has no property");
        }
        StringBuffer strSQL = new StringBuffer("UPDATE ");
        strSQL.append(table.getTableName());
        strSQL.append(" SET ");
        for (Object kv : keyValueList) {
            strSQL.append(SqlBuilder.getPropertyStrSql((KeyValue)kv)).append(",");
        }
        strSQL.deleteCharAt(strSQL.length() - 1);
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            strSQL.append(" WHERE ").append(strWhere);
        }
        return strSQL.toString();
    }

    public static String getCreatTableSQL(Class<?> clazz) {
        TableInfo table = TableInfo.get(clazz);
        Id id = table.getId();
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("CREATE TABLE IF NOT EXISTS ");
        strSQL.append(table.getTableName());
        strSQL.append(" ( ");
        Class<?> primaryClazz = id.getDataType();
        if (primaryClazz == Integer.TYPE || primaryClazz == Integer.class) {
            strSQL.append("\"").append(id.getColumn()).append("\"    ").append("INTEGER PRIMARY KEY AUTOINCREMENT,");
        } else {
            strSQL.append("\"").append(id.getColumn()).append("\"    ").append("TEXT PRIMARY KEY,");
        }
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            strSQL.append("\"").append(property.getColumn());
            strSQL.append("\",");
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne manyToOne : manyToOnes) {
            strSQL.append("\"").append(manyToOne.getColumn()).append("\",");
        }
        strSQL.deleteCharAt(strSQL.length() - 1);
        strSQL.append(" )");
        return strSQL.toString();
    }

    private static String getPropertyStrSql(KeyValue keyvalue) {
        return keyvalue == null ? null : SqlBuilder.getPropertyStrSql(keyvalue.getKey(), keyvalue.getValue());
    }

    private static String getPropertyStrSql(String key, Object value) {
        StringBuffer sbSQL = new StringBuffer(key).append("=");
        if (value instanceof String || value instanceof Date || value instanceof java.sql.Date) {
            sbSQL.append("'").append(value).append("'");
        } else {
            sbSQL.append(value);
        }
        return sbSQL.toString();
    }

    private static KeyValue property2KeyValue(Property property, Object entity) {
        KeyValue kv = null;
        String pcolumn = property.getColumn();
        Object value = property.getValue(entity);
        if (value != null) {
            kv = new KeyValue(pcolumn, value);
        } else if (property.getDefaultValue() != null && property.getDefaultValue().trim().length() != 0) {
            kv = new KeyValue(pcolumn, property.getDefaultValue());
        }
        return kv;
    }

    private static KeyValue manyToOne2KeyValue(ManyToOne many, Object entity) {
        KeyValue kv = null;
        String manycolumn = many.getColumn();
        Object manyobject = many.getValue(entity);
        if (manyobject != null) {
            Object manyvalue = TableInfo.get(manyobject.getClass()).getId().getValue(manyobject);
            if (manycolumn != null && manyvalue != null) {
                kv = new KeyValue(manycolumn, manyvalue);
            }
        }
        return kv;
    }
}

